/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.daemon;

import com.sun.jmx.snmp.SnmpEngine;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpPdu;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.ThreadContext;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.daemon.SnmpAdaptorServer;
import com.sun.jmx.snmp.daemon.SnmpSubRequestHandler;
import com.sun.jmx.snmp.internal.SnmpIncomingRequest;

class SnmpSubNextRequestHandler
extends SnmpSubRequestHandler {
    private SnmpAdaptorServer server = null;

    protected SnmpSubNextRequestHandler(SnmpAdaptorServer snmpAdaptorServer, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
    }

    protected SnmpSubNextRequestHandler(SnmpEngine snmpEngine, SnmpAdaptorServer snmpAdaptorServer, SnmpIncomingRequest snmpIncomingRequest, SnmpMibAgent snmpMibAgent, SnmpPdu snmpPdu) {
        super(snmpEngine, snmpIncomingRequest, snmpMibAgent, snmpPdu);
        this.init(snmpPdu, snmpAdaptorServer);
        if (this.isDebugOn()) {
            this.debug("SnmpSubNextRequestHandler", "Constructor :" + this);
        }
    }

    private void init(SnmpPdu snmpPdu, SnmpAdaptorServer snmpAdaptorServer) {
        this.server = snmpAdaptorServer;
        int n2 = this.translation.length;
        SnmpVarBind[] snmpVarBindArray = snmpPdu.varBindList;
        SnmpSubRequestHandler.NonSyncVector nonSyncVector = (SnmpSubRequestHandler.NonSyncVector)this.varBind;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.translation[i2] = i2;
            SnmpVarBind snmpVarBind = new SnmpVarBind(snmpVarBindArray[i2].oid, snmpVarBindArray[i2].value);
            nonSyncVector.addNonSyncElement(snmpVarBind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block10: {
            try {
                ThreadContext threadContext = ThreadContext.push("SnmpUserData", this.data);
                try {
                    if (this.isTraceOn()) {
                        this.trace("run", "[" + Thread.currentThread() + "]:getNext operation on " + this.agent.getMibName());
                    }
                    this.agent.getNext(this.createMibRequest(this.varBind, 1, this.data));
                }
                finally {
                    ThreadContext.restore(threadContext);
                }
            }
            catch (SnmpStatusException snmpStatusException) {
                this.errorStatus = snmpStatusException.getStatus();
                this.errorIndex = snmpStatusException.getErrorIndex();
                if (this.isDebugOn()) {
                    this.debug("run", "[" + Thread.currentThread() + "]:an Snmp error occured during the operation");
                    this.debug("run", snmpStatusException);
                }
            }
            catch (Exception exception) {
                this.errorStatus = 5;
                if (this.isTraceOn()) {
                    this.trace("run", "[" + Thread.currentThread() + "]:a generic error occured during the operation");
                }
                if (!this.isDebugOn()) break block10;
                this.debug("run", "Error is: " + exception);
                this.debug("run", exception);
            }
        }
        if (this.isTraceOn()) {
            this.trace("run", "[" + Thread.currentThread() + "]:operation completed");
        }
    }

    protected void updateRequest(SnmpVarBind snmpVarBind, int n2) {
        if (this.isDebugOn()) {
            this.debug("updateRequest", "Copy :" + snmpVarBind);
        }
        int n3 = this.varBind.size();
        this.translation[n3] = n2;
        SnmpVarBind snmpVarBind2 = new SnmpVarBind(snmpVarBind.oid, snmpVarBind.value);
        if (this.isDebugOn()) {
            this.debug("updateRequest", "Copied :" + snmpVarBind2);
        }
        this.varBind.addElement(snmpVarBind2);
    }

    protected void updateResult(SnmpVarBind[] snmpVarBindArray) {
        int n2 = this.varBind.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.translation[i2];
            SnmpVarBind snmpVarBind = (SnmpVarBind)((SnmpSubRequestHandler.NonSyncVector)this.varBind).elementAtNonSync(i2);
            SnmpVarBind snmpVarBind2 = snmpVarBindArray[n3];
            if (snmpVarBind2 == null) {
                snmpVarBindArray[n3] = snmpVarBind;
                continue;
            }
            SnmpValue snmpValue = snmpVarBind2.value;
            if (snmpValue == null || snmpValue == SnmpVarBind.endOfMibView) {
                if (snmpVarBind == null || snmpVarBind.value == SnmpVarBind.endOfMibView) continue;
                snmpVarBindArray[n3] = snmpVarBind;
                continue;
            }
            if (snmpVarBind == null || snmpVarBind.value == SnmpVarBind.endOfMibView) continue;
            int n4 = snmpVarBind.oid.compareTo(snmpVarBind2.oid);
            if (n4 < 0) {
                snmpVarBindArray[n3] = snmpVarBind;
                continue;
            }
            if (n4 != 0) continue;
            if (this.isDebugOn()) {
                this.trace("updateResult", " oid overlapping. Oid : " + snmpVarBind.oid + "value :" + snmpVarBind.value);
                this.trace("updateResult", "Already present varBind : " + snmpVarBind2);
            }
            SnmpOid snmpOid = snmpVarBind2.oid;
            SnmpMibAgent snmpMibAgent = this.server.getAgentMib(snmpOid);
            if (this.isDebugOn()) {
                this.trace("updateResult", "Deeper agent : " + snmpMibAgent);
            }
            if (snmpMibAgent != this.agent) continue;
            if (this.isDebugOn()) {
                this.trace("updateResult", "The current agent is the deeper one. Update the value with the current one");
            }
            snmpVarBindArray[n3].value = snmpVarBind.value;
        }
    }

    protected String makeDebugTag() {
        return "SnmpSubNextRequestHandler";
    }
}

