/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpGenericMetaServer;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class SnmpGenericObjectServer {
    protected final MBeanServer server;

    public SnmpGenericObjectServer(MBeanServer mBeanServer) {
        this.server = mBeanServer;
    }

    public void get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        int n3 = snmpMibSubRequest.getSize();
        Object object = snmpMibSubRequest.getUserData();
        String[] stringArray = new String[n3];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n3];
        long[] lArray = new long[n3];
        int n4 = 0;
        Object object2 = snmpMibSubRequest.getElements();
        while (object2.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)object2.nextElement();
            try {
                long l2 = snmpVarBind.oid.getOidArc(n2);
                stringArray[n4] = snmpGenericMetaServer.getAttributeName(l2);
                snmpVarBindArray[n4] = snmpVarBind;
                lArray[n4] = l2;
                snmpGenericMetaServer.checkGetAccess(l2, object);
                ++n4;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerGetException(snmpVarBind, snmpStatusException);
            }
        }
        object2 = null;
        int n5 = 224;
        try {
            object2 = this.server.getAttributes(objectName, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object2 = new AttributeList();
        }
        catch (ReflectionException reflectionException) {
            object2 = new AttributeList();
        }
        catch (Exception exception) {
            object2 = new AttributeList();
        }
        Iterator iterator = ((AbstractList)object2).iterator();
        for (int i2 = 0; i2 < n4; ++i2) {
            Serializable serializable;
            if (!iterator.hasNext()) {
                serializable = new SnmpStatusException(n5);
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i2], (SnmpStatusException)serializable);
                continue;
            }
            serializable = (Attribute)iterator.next();
            while (i2 < n4 && !stringArray[i2].equals(((Attribute)serializable).getName())) {
                SnmpStatusException snmpStatusException = new SnmpStatusException(n5);
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i2], snmpStatusException);
                ++i2;
            }
            if (i2 == n4) break;
            try {
                snmpVarBindArray[i2].value = snmpGenericMetaServer.buildSnmpValue(lArray[i2], ((Attribute)serializable).getValue());
                continue;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerGetException(snmpVarBindArray[i2], snmpStatusException);
            }
        }
    }

    public SnmpValue get(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, long l2, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l2);
        Object object2 = null;
        try {
            object2 = this.server.getAttribute(objectName, string);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(224);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(224);
        }
        return snmpGenericMetaServer.buildSnmpValue(l2, object2);
    }

    public void set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        Object object;
        Object object2;
        int n3 = snmpMibSubRequest.getSize();
        AttributeList attributeList = new AttributeList(n3);
        String[] stringArray = new String[n3];
        SnmpVarBind[] snmpVarBindArray = new SnmpVarBind[n3];
        long[] lArray = new long[n3];
        int n4 = 0;
        Object object3 = snmpMibSubRequest.getElements();
        while (object3.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)object3.nextElement();
            try {
                long l2 = snmpVarBind.oid.getOidArc(n2);
                object2 = snmpGenericMetaServer.getAttributeName(l2);
                object = snmpGenericMetaServer.buildAttributeValue(l2, snmpVarBind.value);
                Attribute attribute = new Attribute((String)object2, object);
                attributeList.add(attribute);
                stringArray[n4] = object2;
                snmpVarBindArray[n4] = snmpVarBind;
                lArray[n4] = l2;
                ++n4;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerSetException(snmpVarBind, snmpStatusException);
            }
        }
        object3 = null;
        int n5 = 6;
        try {
            object3 = this.server.setAttributes(objectName, attributeList);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            object3 = new AttributeList();
            n5 = 18;
        }
        catch (ReflectionException reflectionException) {
            n5 = 18;
            object3 = new AttributeList();
        }
        catch (Exception exception) {
            object3 = new AttributeList();
        }
        Iterator iterator = ((AbstractList)object3).iterator();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!iterator.hasNext()) {
                object2 = new SnmpStatusException(n5);
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i2], (SnmpStatusException)object2);
                continue;
            }
            object2 = (Attribute)iterator.next();
            while (i2 < n4 && !stringArray[i2].equals(((Attribute)object2).getName())) {
                object = new SnmpStatusException(6);
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i2], (SnmpStatusException)object);
                ++i2;
            }
            if (i2 == n4) break;
            try {
                snmpVarBindArray[i2].value = snmpGenericMetaServer.buildSnmpValue(lArray[i2], ((Attribute)object2).getValue());
                continue;
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerSetException(snmpVarBindArray[i2], snmpStatusException);
            }
        }
    }

    public SnmpValue set(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        String string = snmpGenericMetaServer.getAttributeName(l2);
        Object object2 = snmpGenericMetaServer.buildAttributeValue(l2, snmpValue);
        Attribute attribute = new Attribute(string, object2);
        Object object3 = null;
        try {
            this.server.setAttribute(objectName, attribute);
            object3 = this.server.getAttribute(objectName, string);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new SnmpStatusException(10);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
        return snmpGenericMetaServer.buildSnmpValue(l2, object3);
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        Object object = snmpMibSubRequest.getUserData();
        Enumeration enumeration = snmpMibSubRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            try {
                long l2 = snmpVarBind.oid.getOidArc(n2);
                this.check(snmpGenericMetaServer, objectName, snmpVarBind.value, l2, object);
            }
            catch (SnmpStatusException snmpStatusException) {
                snmpMibSubRequest.registerCheckException(snmpVarBind, snmpStatusException);
            }
        }
    }

    public void check(SnmpGenericMetaServer snmpGenericMetaServer, ObjectName objectName, SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        snmpGenericMetaServer.checkSetAccess(snmpValue, l2, object);
        try {
            String string = snmpGenericMetaServer.getAttributeName(l2);
            Object object2 = snmpGenericMetaServer.buildAttributeValue(l2, snmpValue);
            Object[] objectArray = new Object[1];
            String[] stringArray = new String[1];
            objectArray[0] = object2;
            stringArray[0] = object2.getClass().getName();
            this.server.invoke(objectName, "check" + string, objectArray, stringArray);
        }
        catch (SnmpStatusException snmpStatusException) {
            throw snmpStatusException;
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new SnmpStatusException(18);
        }
        catch (ReflectionException reflectionException) {
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof SnmpStatusException) {
                throw (SnmpStatusException)exception;
            }
            throw new SnmpStatusException(6);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(6);
        }
    }

    public void registerTableEntry(SnmpMibTable snmpMibTable, SnmpOid snmpOid, ObjectName objectName, Object object) throws SnmpStatusException {
        if (objectName == null) {
            throw new SnmpStatusException(18);
        }
        try {
            if (object != null && !this.server.isRegistered(objectName)) {
                this.server.registerMBean(object, objectName);
            }
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            throw new SnmpStatusException(18);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            throw new SnmpStatusException(6);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new SnmpStatusException(5);
        }
        catch (RuntimeOperationsException runtimeOperationsException) {
            throw new SnmpStatusException(5);
        }
        catch (Exception exception) {
            throw new SnmpStatusException(5);
        }
    }
}

