/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

final class LongList {
    public static int DEFAULT_CAPACITY = 10;
    public static int DEFAULT_INCREMENT = 10;
    private final int DELTA;
    private int size = 0;
    public long[] list;

    LongList() {
        this(DEFAULT_CAPACITY, DEFAULT_INCREMENT);
    }

    LongList(int n2) {
        this(n2, DEFAULT_INCREMENT);
    }

    LongList(int n2, int n3) {
        this.DELTA = n3;
        this.list = this.allocate(n2);
    }

    public final int size() {
        return this.size;
    }

    public final boolean add(long l2) {
        if (this.size >= this.list.length) {
            this.resize();
        }
        this.list[this.size++] = l2;
        return true;
    }

    public final void add(int n2, long l2) {
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 >= this.list.length) {
            this.resize();
        }
        if (n2 == this.size) {
            this.list[this.size++] = l2;
            return;
        }
        System.arraycopy(this.list, n2, this.list, n2 + 1, this.size - n2);
        this.list[n2] = l2;
        ++this.size;
    }

    public final void add(int n2, long[] lArray, int n3, int n4) {
        if (n4 <= 0) {
            return;
        }
        if (n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.ensure(this.size + n4);
        if (n2 < this.size) {
            System.arraycopy(this.list, n2, this.list, n2 + n4, this.size - n2);
        }
        System.arraycopy(lArray, n3, this.list, n2, n4);
        this.size += n4;
    }

    public final long remove(int n2, int n3) {
        if (n3 < 1 || n2 < 0) {
            return -1L;
        }
        if (n2 + n3 > this.size) {
            return -1L;
        }
        long l2 = this.list[n2];
        int n4 = this.size;
        this.size -= n3;
        if (n2 == this.size) {
            return l2;
        }
        System.arraycopy(this.list, n2 + n3, this.list, n2, this.size - n2);
        return l2;
    }

    public final long remove(int n2) {
        if (n2 >= this.size) {
            return -1L;
        }
        long l2 = this.list[n2];
        this.list[n2] = 0L;
        if (n2 == --this.size) {
            return l2;
        }
        System.arraycopy(this.list, n2 + 1, this.list, n2, this.size - n2);
        return l2;
    }

    public final long[] toArray(long[] lArray) {
        System.arraycopy(this.list, 0, lArray, 0, this.size);
        return lArray;
    }

    public final long[] toArray() {
        return this.toArray(new long[this.size]);
    }

    private final void resize() {
        long[] lArray = this.allocate(this.list.length + this.DELTA);
        System.arraycopy(this.list, 0, lArray, 0, this.size);
        this.list = lArray;
    }

    private final void ensure(int n2) {
        if (this.list.length < n2) {
            int n3 = this.list.length + this.DELTA;
            n2 = n2 < n3 ? n3 : n2;
            long[] lArray = this.allocate(n2);
            System.arraycopy(this.list, 0, lArray, 0, this.size);
            this.list = lArray;
        }
    }

    private final long[] allocate(int n2) {
        return new long[n2];
    }
}

