/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.Enumerated;
import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;

public class SnmpInt
extends SnmpValue {
    static final String name = "Integer32";
    protected long value = 0L;

    public SnmpInt(int n2) throws IllegalArgumentException {
        if (!this.isInitValueValid(n2)) {
            throw new IllegalArgumentException();
        }
        this.value = n2;
    }

    public SnmpInt(Integer n2) throws IllegalArgumentException {
        this((int)n2);
    }

    public SnmpInt(long l2) throws IllegalArgumentException {
        if (!this.isInitValueValid(l2)) {
            throw new IllegalArgumentException();
        }
        this.value = l2;
    }

    public SnmpInt(Long l2) throws IllegalArgumentException {
        this((long)l2);
    }

    public SnmpInt(Enumerated enumerated) throws IllegalArgumentException {
        this(enumerated.intValue());
    }

    public SnmpInt(boolean bl2) {
        this.value = bl2 ? 1L : 2L;
    }

    public long longValue() {
        return this.value;
    }

    public Long toLong() {
        return new Long(this.value);
    }

    public int intValue() {
        return (int)this.value;
    }

    public Integer toInteger() {
        return new Integer((int)this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public SnmpOid toOid() {
        return new SnmpOid(this.value);
    }

    public static SnmpOid toOid(long[] lArray, int n2) throws SnmpStatusException {
        try {
            return new SnmpOid(lArray[n2]);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SnmpStatusException(2);
        }
    }

    public static int nextOid(long[] lArray, int n2) throws SnmpStatusException {
        if (n2 >= lArray.length) {
            throw new SnmpStatusException(2);
        }
        return n2 + 1;
    }

    public static void appendToOid(SnmpOid snmpOid, SnmpOid snmpOid2) {
        if (snmpOid.getLength() != 1) {
            throw new IllegalArgumentException();
        }
        snmpOid2.append(snmpOid);
    }

    public final synchronized SnmpValue duplicate() {
        return (SnmpValue)this.clone();
    }

    public final synchronized Object clone() {
        SnmpInt snmpInt = null;
        try {
            snmpInt = (SnmpInt)super.clone();
            snmpInt.value = this.value;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        return snmpInt;
    }

    public String getTypeName() {
        return name;
    }

    boolean isInitValueValid(int n2) {
        return n2 >= Integer.MIN_VALUE && n2 <= Integer.MAX_VALUE;
    }

    boolean isInitValueValid(long l2) {
        return l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE;
    }
}

