/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.ObjectInputStreamWithLoader;
import com.sun.jmx.mbeanserver.StandardMetaDataImpl;
import com.sun.jmx.trace.Trace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

public class MBeanInstantiatorImpl
implements MBeanInstantiator {
    private final ModifiableClassLoaderRepository clr;
    private static final String dbgTag = "MBeanInstantiatorImpl";

    public MBeanInstantiatorImpl(ModifiableClassLoaderRepository modifiableClassLoaderRepository) {
        this.clr = modifiableClassLoaderRepository;
    }

    public void testCreation(Class clazz) throws NotCompliantMBeanException {
        Introspector.testCreation(clazz);
    }

    public Class findClassWithDefaultLoaderRepository(String string) throws ReflectionException {
        Class clazz;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            if (this.clr == null) {
                throw new ClassNotFoundException(string);
            }
            clazz = this.clr.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the default loader repository");
        }
        return clazz;
    }

    public Class findClass(String string, ClassLoader classLoader) throws ReflectionException {
        return MBeanInstantiatorImpl.loadClass(string, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class findClass(String string, ObjectName objectName) throws ReflectionException, InstanceNotFoundException {
        Object var3_3 = null;
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null loader passed in parameter");
        }
        ClassLoader classLoader = null;
        MBeanInstantiatorImpl mBeanInstantiatorImpl = this;
        synchronized (mBeanInstantiatorImpl) {
            if (this.clr != null) {
                classLoader = this.clr.getClassLoader(objectName);
            }
        }
        if (classLoader == null) {
            throw new InstanceNotFoundException("The loader named " + objectName + " is not registered in the MBeanServer");
        }
        return this.findClass(string, classLoader);
    }

    public Class[] findSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader;
        int n2 = stringArray.length;
        Class[] classArray = new Class[n2];
        if (n2 == 0) {
            return classArray;
        }
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                Class clazz = StandardMetaDataImpl.findClassForPrim(stringArray[i2]);
                classArray[i2] = clazz != null ? clazz : (classLoader2 != null ? Class.forName(stringArray[i2], false, classLoader2) : this.findClass(stringArray[i2], this.getClass().getClassLoader()));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", classNotFoundException);
            throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
        }
        catch (RuntimeException runtimeException) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", runtimeException);
            throw runtimeException;
        }
        return classArray;
    }

    public Object instantiate(Class clazz) throws ReflectionException, MBeanException {
        Object var2_2 = null;
        Constructor constructor = StandardMetaDataImpl.findConstructor(clazz, null);
        if (constructor == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            var2_2 = constructor.newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's empty constructor");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's empty constructor");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's empty constructor");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No constructor"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "Exception thrown trying to invoke the MBean's empty constructor");
        }
        return var2_2;
    }

    public Object instantiate(Class clazz, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException {
        Class[] classArray;
        Object object;
        Object var6_5 = null;
        try {
            object = clazz.getClassLoader();
            classArray = stringArray == null ? null : this.findSignatureClasses(stringArray, (ClassLoader)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectionException(illegalArgumentException, "The constructor parameter classes could not be loaded");
        }
        object = null;
        object = StandardMetaDataImpl.findConstructor(clazz, classArray);
        if (object == null) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor"));
        }
        try {
            var6_5 = ((Constructor)object).newInstance(objectArray);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ReflectionException(new NoSuchMethodException("No such constructor found"), "No such constructor");
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectionException(instantiationException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectionException(illegalAccessException, "Exception thrown trying to invoke the MBean's constructor");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in the MBean's constructor");
            }
            if (throwable instanceof Error) {
                throw new RuntimeErrorException((Error)throwable, "Error thrown in the MBean's constructor");
            }
            throw new MBeanException((Exception)throwable, "Exception thrown in the MBean's constructor");
        }
        return var6_5;
    }

    public ObjectInputStream deserialize(ClassLoader classLoader, byte[] byArray) throws OperationsException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader(byteArrayInputStream, classLoader);
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray, ClassLoader classLoader) throws InstanceNotFoundException, OperationsException, ReflectionException {
        ObjectInputStreamWithLoader objectInputStreamWithLoader;
        Object object;
        if (byArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null data passed in parameter");
        }
        if (byArray.length == 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Empty data passed in parameter");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException(), "Null className passed in parameter");
        }
        Class<?> clazz = null;
        if (objectName == null) {
            clazz = this.findClass(string, classLoader);
        } else {
            try {
                object = null;
                if (this.clr != null) {
                    object = this.clr.getClassLoader(objectName);
                }
                if (object == null) {
                    throw new ClassNotFoundException(string);
                }
                clazz = Class.forName(string, false, (ClassLoader)object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the " + objectName.toString() + " class loader");
            }
        }
        object = new ByteArrayInputStream(byArray);
        try {
            objectInputStreamWithLoader = new ObjectInputStreamWithLoader((InputStream)object, clazz.getClassLoader());
        }
        catch (IOException iOException) {
            throw new OperationsException("An IOException occured trying to de-serialize the data");
        }
        return objectInputStreamWithLoader;
    }

    public Object instantiate(String string) throws ReflectionException, MBeanException {
        return this.instantiate(string, (Object[])null, (String[])null, null);
    }

    public Object instantiate(String string, ObjectName objectName, ClassLoader classLoader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        return this.instantiate(string, objectName, null, null, classLoader);
    }

    public Object instantiate(String string, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException {
        Class clazz = this.findClassWithDefaultLoaderRepository(string);
        return this.instantiate(clazz, objectArray, stringArray, classLoader);
    }

    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray, ClassLoader classLoader) throws ReflectionException, MBeanException, InstanceNotFoundException {
        Class clazz = objectName == null ? this.findClass(string, classLoader) : this.findClass(string, objectName);
        return this.instantiate(clazz, objectArray, stringArray, classLoader);
    }

    public ModifiableClassLoaderRepository getClassLoaderRepository() {
        return this.clr;
    }

    static Class loadClass(String string, ClassLoader classLoader) throws ReflectionException {
        Class<?> clazz = null;
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("The class name cannot be null"), "Exception occured during object instantiation");
        }
        try {
            if (classLoader == null) {
                classLoader = MBeanInstantiatorImpl.class.getClassLoader();
            }
            clazz = classLoader != null ? Class.forName(string, false, classLoader) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ReflectionException(classNotFoundException, "The MBean class could not be loaded by the context classloader");
        }
        return clazz;
    }

    static Class[] loadSignatureClasses(String[] stringArray, ClassLoader classLoader) throws ReflectionException {
        if (stringArray == null) {
            return null;
        }
        ClassLoader classLoader2 = classLoader == null ? MBeanInstantiatorImpl.class.getClassLoader() : classLoader;
        int n2 = stringArray.length;
        Class[] classArray = new Class[n2];
        if (n2 == 0) {
            return classArray;
        }
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                Class clazz = StandardMetaDataImpl.findClassForPrim(stringArray[i2]);
                classArray[i2] = clazz != null ? clazz : Class.forName(stringArray[i2], false, classLoader2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", classNotFoundException);
            throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
        }
        catch (RuntimeException runtimeException) {
            MBeanInstantiatorImpl.debugX("findSignatureClasses", runtimeException);
            throw runtimeException;
        }
        return classArray;
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        MBeanInstantiatorImpl.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        MBeanInstantiatorImpl.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (MBeanInstantiatorImpl.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            MBeanInstantiatorImpl.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            MBeanInstantiatorImpl.debug(dbgTag, string, string2);
        }
    }
}

