/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.SwingUtilities2;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class MotifPopupMenuUI
extends BasicPopupMenuUI {
    private static Border border = null;
    private Font titleFont = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifPopupMenuUI();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Serializable serializable;
        LayoutManager layoutManager = jComponent.getLayout();
        Dimension dimension = layoutManager.preferredLayoutSize(jComponent);
        String string = ((JPopupMenu)jComponent).getLabel();
        if (this.titleFont == null) {
            serializable = UIManager.getLookAndFeelDefaults();
            this.titleFont = serializable.getFont("PopupMenu.font");
        }
        serializable = jComponent.getFontMetrics(this.titleFont);
        int n2 = 0;
        if (string != null) {
            n2 += SwingUtilities2.stringWidth(jComponent, (FontMetrics)serializable, string);
        }
        if (dimension.width < n2) {
            dimension.width = n2 + 8;
            Insets insets = jComponent.getInsets();
            if (insets != null) {
                dimension.width += insets.left + insets.right;
            }
            if (border != null) {
                insets = border.getBorderInsets(jComponent);
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }
        return null;
    }

    protected ChangeListener createChangeListener(JPopupMenu jPopupMenu) {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
            }
        };
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 501 && (mouseEvent.getModifiers() & 4) != 0;
    }
}

