/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.bmp;

import com.sun.imageio.plugins.bmp.BMPConstants;
import com.sun.imageio.plugins.bmp.BMPMetadata;
import com.sun.imageio.plugins.common.I18N;
import com.sun.imageio.plugins.common.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.event.IIOWriteWarningListener;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.bmp.BMPImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class BMPImageWriter
extends ImageWriter
implements BMPConstants {
    private ImageOutputStream stream = null;
    private ByteArrayOutputStream embedded_stream = null;
    private int version;
    private int compressionType;
    private boolean isTopDown;
    private int w;
    private int h;
    private int compImageSize = 0;
    private int[] bitPos;
    private byte[] bpixels;
    private short[] spixels;
    private int[] ipixels;

    public BMPImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("BMPImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.stream = null;
        }
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new BMPImageWriteParam();
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        BMPMetadata bMPMetadata = new BMPMetadata();
        bMPMetadata.bmpVersion = "BMP v. 3.x";
        bMPMetadata.compression = this.getPreferredCompressionType(imageTypeSpecifier);
        if (imageWriteParam != null && imageWriteParam.getCompressionMode() == 2) {
            bMPMetadata.compression = this.getCompressionType(imageWriteParam.getCompressionType());
        }
        bMPMetadata.bitsPerPixel = (short)imageTypeSpecifier.getColorModel().getPixelSize();
        return bMPMetadata;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        if (this.stream == null) {
            throw new IllegalStateException(I18N.getString("BMPImageWriter7"));
        }
        if (iIOImage == null) {
            throw new IllegalArgumentException(I18N.getString("BMPImageWriter8"));
        }
        this.clearAbortRequest();
        this.processImageStarted(0);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        BMPImageWriteParam bMPImageWriteParam = (BMPImageWriteParam)imageWriteParam;
        int n6 = 24;
        boolean bl2 = false;
        int n7 = 0;
        IndexColorModel indexColorModel = null;
        RenderedImage renderedImage = null;
        Raster raster = null;
        boolean bl3 = iIOImage.hasRaster();
        Object object2 = imageWriteParam.getSourceRegion();
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        this.compImageSize = 0;
        if (bl3) {
            raster = iIOImage.getRaster();
            sampleModel = raster.getSampleModel();
            colorModel = ImageUtil.createColorModel(null, sampleModel);
            object2 = object2 == null ? raster.getBounds() : ((Rectangle)object2).intersection(raster.getBounds());
        } else {
            renderedImage = iIOImage.getRenderedImage();
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
            object = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            object2 = object2 == null ? object : ((Rectangle)object2).intersection((Rectangle)object);
        }
        object = iIOImage.getMetadata();
        BMPMetadata bMPMetadata = null;
        if (object != null && object instanceof BMPMetadata) {
            bMPMetadata = (BMPMetadata)object;
        } else {
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
            bMPMetadata = (BMPMetadata)this.getDefaultImageMetadata(imageTypeSpecifier, imageWriteParam);
        }
        if (((Rectangle)object2).isEmpty()) {
            throw new RuntimeException(I18N.getString("BMPImageWrite0"));
        }
        int n8 = imageWriteParam.getSourceXSubsampling();
        int n9 = imageWriteParam.getSourceYSubsampling();
        int n10 = imageWriteParam.getSubsamplingXOffset();
        int n11 = imageWriteParam.getSubsamplingYOffset();
        int n12 = sampleModel.getDataType();
        ((Rectangle)object2).translate(n10, n11);
        ((Rectangle)object2).width -= n10;
        ((Rectangle)object2).height -= n11;
        int n13 = ((Rectangle)object2).x / n8;
        int n14 = ((Rectangle)object2).y / n9;
        this.w = (((Rectangle)object2).width + n8 - 1) / n8;
        this.h = (((Rectangle)object2).height + n9 - 1) / n9;
        n10 = ((Rectangle)object2).x % n8;
        n11 = ((Rectangle)object2).y % n9;
        Rectangle rectangle = new Rectangle(n13, n14, this.w, this.h);
        boolean bl4 = rectangle.equals(object2);
        int[] nArray = imageWriteParam.getSourceBands();
        boolean bl5 = true;
        int n15 = sampleModel.getNumBands();
        if (nArray != null) {
            sampleModel = sampleModel.createSubsetSampleModel(nArray);
            colorModel = null;
            bl5 = false;
            n15 = sampleModel.getNumBands();
        } else {
            nArray = new int[n15];
            for (int i2 = 0; i2 < n15; ++i2) {
                nArray[i2] = i2;
            }
        }
        int[] nArray2 = null;
        boolean bl6 = true;
        if (sampleModel instanceof ComponentSampleModel) {
            nArray2 = ((ComponentSampleModel)sampleModel).getBandOffsets();
            if (sampleModel instanceof BandedSampleModel) {
                bl6 = false;
            } else {
                for (n5 = 0; n5 < nArray2.length; ++n5) {
                    bl6 &= nArray2[n5] == nArray2.length - n5 - 1;
                }
            }
        } else {
            nArray2 = new int[n15];
            for (n5 = 0; n5 < n15; ++n5) {
                nArray2[n5] = n5;
            }
        }
        if (bl6 && sampleModel instanceof SinglePixelPackedSampleModel) {
            int[] nArray3 = ((SinglePixelPackedSampleModel)sampleModel).getBitOffsets();
            for (n4 = 0; n4 < nArray3.length - 1; ++n4) {
                bl6 &= nArray3[n4] > nArray3[n4 + 1];
            }
        }
        bl4 &= bl6;
        int[] nArray4 = sampleModel.getSampleSize();
        n4 = this.w * n15;
        switch (bMPImageWriteParam.getCompressionMode()) {
            case 2: {
                this.compressionType = this.getCompressionType(bMPImageWriteParam.getCompressionType());
                break;
            }
            case 3: {
                this.compressionType = bMPMetadata.compression;
                break;
            }
            case 1: {
                this.compressionType = this.getPreferredCompressionType(colorModel, sampleModel);
                break;
            }
            default: {
                this.compressionType = 0;
            }
        }
        if (!this.canEncodeImage(this.compressionType, colorModel, sampleModel)) {
            throw new IOException("Image can not be encoded with compression type " + compressionTypeNames[this.compressionType]);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (colorModel instanceof IndexColorModel) {
            bl2 = true;
            indexColorModel = (IndexColorModel)colorModel;
            n7 = indexColorModel.getMapSize();
            if (n7 <= 2) {
                n6 = 1;
                n4 = this.w + 7 >> 3;
            } else if (n7 <= 16) {
                n6 = 4;
                n4 = this.w + 1 >> 1;
            } else if (n7 <= 256) {
                n6 = 8;
            } else {
                n6 = 24;
                bl2 = false;
                n7 = 0;
                n4 = this.w * 3;
            }
            if (bl2) {
                byArray = new byte[n7];
                byArray2 = new byte[n7];
                byArray3 = new byte[n7];
                byArray4 = new byte[n7];
                indexColorModel.getAlphas(byArray4);
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
            }
        } else if (n15 == 1) {
            bl2 = true;
            n7 = 256;
            n6 = nArray4[0];
            n4 = this.w * n6 + 7 >> 3;
            byArray = new byte[256];
            byArray2 = new byte[256];
            byArray3 = new byte[256];
            byArray4 = new byte[256];
            for (n3 = 0; n3 < 256; ++n3) {
                byArray[n3] = (byte)n3;
                byArray2[n3] = (byte)n3;
                byArray3[n3] = (byte)n3;
                byArray4[n3] = -1;
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel && bl5) {
            n6 = DataBuffer.getDataTypeSize(sampleModel.getDataType());
            n4 = this.w * n6 + 7 >> 3;
            if (this.compressionType == 3) {
                bl2 = true;
                n7 = 3;
                byArray = new byte[n7];
                byArray2 = new byte[n7];
                byArray3 = new byte[n7];
                byArray4 = new byte[n7];
                if (n6 == 16) {
                    byArray3[0] = 0;
                    byArray2[0] = 0;
                    byArray[0] = -8;
                    byArray4[0] = 0;
                    byArray3[1] = 0;
                    byArray2[1] = 0;
                    byArray[1] = 7;
                    byArray4[1] = -32;
                    byArray3[2] = 0;
                    byArray2[2] = 0;
                    byArray[2] = 0;
                    byArray4[2] = 31;
                } else if (n6 == 32) {
                    byArray3[0] = 0;
                    byArray2[0] = -1;
                    byArray[0] = 0;
                    byArray4[0] = 0;
                    byArray3[1] = 0;
                    byArray2[1] = 0;
                    byArray[1] = -1;
                    byArray4[1] = 0;
                    byArray3[2] = 0;
                    byArray2[2] = 0;
                    byArray[2] = 0;
                    byArray4[2] = -1;
                } else {
                    throw new RuntimeException(I18N.getString("BMPImageWrite6"));
                }
            }
        }
        n3 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = n7;
        int n23 = n4 % 4;
        if (n23 != 0) {
            n23 = 4 - n23;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel && bl5) {
            n4 = this.w;
            this.bitPos = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            for (int i3 = 0; i3 < this.bitPos.length; ++i3) {
                this.bitPos[i3] = this.firstLowBit(this.bitPos[i3]);
            }
        }
        n16 = 54 + n7 * 4;
        n18 = (n4 + n23) * this.h;
        n3 = n18 + n16;
        n17 = 40;
        long l2 = this.stream.getStreamPosition();
        this.writeFileHeader(n3, n16);
        this.writeInfoHeader(n17, n6);
        this.stream.writeInt(this.compressionType);
        this.stream.writeInt(n18);
        this.stream.writeInt(n19);
        this.stream.writeInt(n20);
        this.stream.writeInt(n21);
        this.stream.writeInt(n22);
        if (bl2) {
            if (this.compressionType == 3) {
                for (n2 = 0; n2 < 3; ++n2) {
                    int n24 = (byArray4[n2] & 0xFF) + (byArray[n2] & 0xFF) * 256 + (byArray2[n2] & 0xFF) * 65536 + (byArray3[n2] & 0xFF) * 0x1000000;
                    this.stream.writeInt(n24);
                }
            } else {
                for (n2 = 0; n2 < n7; ++n2) {
                    this.stream.writeByte(byArray3[n2]);
                    this.stream.writeByte(byArray2[n2]);
                    this.stream.writeByte(byArray[n2]);
                    this.stream.writeByte(byArray4[n2]);
                }
            }
        }
        n2 = this.w * n15;
        int[] nArray5 = new int[n2 * n8];
        this.bpixels = new byte[n4];
        if (this.compressionType == 4 || this.compressionType == 5) {
            this.embedded_stream = new ByteArrayOutputStream();
            this.writeEmbedded(iIOImage, bMPImageWriteParam);
            this.embedded_stream.flush();
            n18 = this.embedded_stream.size();
            long l3 = this.stream.getStreamPosition();
            n3 = n16 + n18;
            this.stream.seek(l2);
            this.writeSize(n3, 2);
            this.stream.seek(l2);
            this.writeSize(n18, 34);
            this.stream.seek(l3);
            this.stream.write(this.embedded_stream.toByteArray());
            this.embedded_stream = null;
            if (this.abortRequested()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
                this.stream.flushBefore(this.stream.getStreamPosition());
            }
            return;
        }
        this.isTopDown = bMPImageWriteParam.isTopDown();
        int n25 = nArray2[0];
        for (int i4 = 1; i4 < nArray2.length; ++i4) {
            if (nArray2[i4] <= n25) continue;
            n25 = nArray2[i4];
        }
        int[] nArray6 = new int[n25 + 1];
        for (int i5 = 0; i5 < this.h && !this.abortRequested(); ++i5) {
            int n26;
            int n27;
            int n28;
            int n29 = n14 + i5;
            if (!this.isTopDown) {
                n29 = n14 + this.h - i5 - 1;
            }
            Raster raster2 = raster;
            Rectangle rectangle2 = new Rectangle(n13 * n8 + n10, n29 * n9 + n11, (this.w - 1) * n8 + 1, 1);
            if (!bl3) {
                raster2 = renderedImage.getData(rectangle2);
            }
            if (bl4 && bl5) {
                Object object3;
                SampleModel sampleModel2 = raster2.getSampleModel();
                n28 = 0;
                n27 = rectangle2.x - raster2.getSampleModelTranslateX();
                n26 = rectangle2.y - raster2.getSampleModelTranslateY();
                if (sampleModel2 instanceof ComponentSampleModel) {
                    object3 = (ComponentSampleModel)sampleModel2;
                    n28 = ((ComponentSampleModel)object3).getOffset(n27, n26, 0);
                    for (int i6 = 1; i6 < ((SampleModel)object3).getNumBands(); ++i6) {
                        if (n28 <= ((ComponentSampleModel)object3).getOffset(n27, n26, i6)) continue;
                        n28 = ((ComponentSampleModel)object3).getOffset(n27, n26, i6);
                    }
                } else if (sampleModel2 instanceof MultiPixelPackedSampleModel) {
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel2;
                    n28 = multiPixelPackedSampleModel.getOffset(n27, n26);
                } else if (sampleModel2 instanceof SinglePixelPackedSampleModel) {
                    SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel2;
                    n28 = singlePixelPackedSampleModel.getOffset(n27, n26);
                }
                if (this.compressionType == 0 || this.compressionType == 3) {
                    switch (n12) {
                        case 0: {
                            object3 = ((DataBufferByte)raster2.getDataBuffer()).getData();
                            this.stream.write((byte[])object3, n28, n4);
                            break;
                        }
                        case 2: {
                            short[] sArray = ((DataBufferShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n28, n4);
                            break;
                        }
                        case 1: {
                            short[] sArray = ((DataBufferUShort)raster2.getDataBuffer()).getData();
                            this.stream.writeShorts(sArray, n28, n4);
                            break;
                        }
                        case 3: {
                            int[] nArray7 = ((DataBufferInt)raster2.getDataBuffer()).getData();
                            this.stream.writeInts(nArray7, n28, n4);
                        }
                    }
                    for (int i7 = 0; i7 < n23; ++i7) {
                        this.stream.writeByte(0);
                    }
                } else if (this.compressionType == 2) {
                    if (this.bpixels == null || this.bpixels.length < n2) {
                        this.bpixels = new byte[n2];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                    for (int i8 = 0; i8 < n2; ++i8) {
                        this.bpixels[i8] = (byte)nArray5[i8];
                    }
                    this.encodeRLE4(this.bpixels, n2);
                } else if (this.compressionType == 1) {
                    if (this.bpixels == null || this.bpixels.length < n2) {
                        this.bpixels = new byte[n2];
                    }
                    raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                    for (int i9 = 0; i9 < n2; ++i9) {
                        this.bpixels[i9] = (byte)nArray5[i9];
                    }
                    this.encodeRLE8(this.bpixels, n2);
                }
            } else {
                raster2.getPixels(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, nArray5);
                if (n8 != 1 || n25 != n15 - 1 || bl6) {
                    int n30 = 0;
                    n28 = 0;
                    n27 = 0;
                    while (n30 < this.w) {
                        System.arraycopy(nArray5, n28, nArray6, 0, nArray6.length);
                        for (n26 = 0; n26 < n15; ++n26) {
                            nArray5[n27 + n15 - n26 - 1] = nArray6[nArray2[nArray[n26]]];
                        }
                        ++n30;
                        n28 += n8 * n15;
                        n27 += n15;
                    }
                }
                this.writePixels(0, n2, n6, nArray5, n23, n15, indexColorModel);
            }
            this.processImageProgress(100.0f * ((float)i5 / (float)this.h));
        }
        if (this.compressionType == 2 || this.compressionType == 1) {
            this.stream.writeByte(0);
            this.stream.writeByte(1);
            this.incCompImageSize(2);
            n18 = this.compImageSize;
            n3 = this.compImageSize + n16;
            long l4 = this.stream.getStreamPosition();
            this.stream.seek(l2);
            this.writeSize(n3, 2);
            this.stream.seek(l2);
            this.writeSize(n18, 34);
            this.stream.seek(l4);
        }
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
            this.stream.flushBefore(this.stream.getStreamPosition());
        }
    }

    private void writePixels(int n2, int n3, int n4, int[] nArray, int n5, int n6, IndexColorModel indexColorModel) throws IOException {
        int n7 = 0;
        int n8 = 0;
        switch (n4) {
            case 1: {
                int n9;
                for (n9 = 0; n9 < n3 / 8; ++n9) {
                    this.bpixels[n8++] = (byte)(nArray[n2++] << 7 | nArray[n2++] << 6 | nArray[n2++] << 5 | nArray[n2++] << 4 | nArray[n2++] << 3 | nArray[n2++] << 2 | nArray[n2++] << 1 | nArray[n2++]);
                }
                if (n3 % 8 > 0) {
                    n7 = 0;
                    for (n9 = 0; n9 < n3 % 8; ++n9) {
                        n7 |= nArray[n2++] << 7 - n9;
                    }
                    this.bpixels[n8++] = (byte)n7;
                }
                this.stream.write(this.bpixels, 0, (n3 + 7) / 8);
                break;
            }
            case 4: {
                if (this.compressionType == 2) {
                    byte[] byArray = new byte[n3];
                    for (int i2 = 0; i2 < n3; ++i2) {
                        byArray[i2] = (byte)nArray[n2++];
                    }
                    this.encodeRLE4(byArray, n3);
                    break;
                }
                for (int i3 = 0; i3 < n3 / 2; ++i3) {
                    n7 = nArray[n2++] << 4 | nArray[n2++];
                    this.bpixels[n8++] = (byte)n7;
                }
                if (n3 % 2 == 1) {
                    n7 = nArray[n2] << 4;
                    this.bpixels[n8++] = (byte)n7;
                }
                this.stream.write(this.bpixels, 0, (n3 + 1) / 2);
                break;
            }
            case 8: {
                if (this.compressionType == 1) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        this.bpixels[i4] = (byte)nArray[n2++];
                    }
                    this.encodeRLE8(this.bpixels, n3);
                    break;
                }
                for (int i5 = 0; i5 < n3; ++i5) {
                    this.bpixels[i5] = (byte)nArray[n2++];
                }
                this.stream.write(this.bpixels, 0, n3);
                break;
            }
            case 16: {
                if (this.spixels == null) {
                    this.spixels = new short[n3 / n6];
                }
                int n10 = 0;
                int n11 = 0;
                while (n10 < n3) {
                    this.spixels[n11] = 0;
                    int n12 = n6 - 1;
                    while (n12 >= 0) {
                        int n13 = n11;
                        this.spixels[n13] = (short)(this.spixels[n13] | nArray[n10] << this.bitPos[n12]);
                        --n12;
                        ++n10;
                    }
                    ++n11;
                }
                this.stream.writeShorts(this.spixels, 0, this.spixels.length);
                break;
            }
            case 24: {
                if (n6 == 3) {
                    for (int i6 = 0; i6 < n3; i6 += 3) {
                        this.bpixels[n8++] = (byte)nArray[n2 + 2];
                        this.bpixels[n8++] = (byte)nArray[n2 + 1];
                        this.bpixels[n8++] = (byte)nArray[n2];
                        n2 += 3;
                    }
                    this.stream.write(this.bpixels, 0, n3);
                    break;
                }
                int n14 = indexColorModel.getMapSize();
                byte[] byArray = new byte[n14];
                byte[] byArray2 = new byte[n14];
                byte[] byArray3 = new byte[n14];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
                for (int i7 = 0; i7 < n3; ++i7) {
                    int n15 = nArray[n2];
                    this.bpixels[n8++] = byArray3[n15];
                    this.bpixels[n8++] = byArray2[n15];
                    this.bpixels[n8++] = byArray3[n15];
                    ++n2;
                }
                this.stream.write(this.bpixels, 0, n3 * 3);
                break;
            }
            case 32: {
                if (this.ipixels == null) {
                    this.ipixels = new int[n3 / n6];
                }
                int n16 = 0;
                int n17 = 0;
                while (n16 < n3) {
                    this.ipixels[n17] = 0;
                    int n18 = n6 - 1;
                    while (n18 >= 0) {
                        int n19 = n17;
                        this.ipixels[n19] = this.ipixels[n19] | nArray[n16] << this.bitPos[n18];
                        --n18;
                        ++n16;
                    }
                    ++n17;
                }
                this.stream.writeInts(this.ipixels, 0, this.ipixels.length);
            }
        }
        if (this.compressionType == 0) {
            for (n8 = 0; n8 < n5; ++n8) {
                this.stream.writeByte(0);
            }
        }
    }

    private void encodeRLE8(byte[] byArray, int n2) throws IOException {
        int n3 = 1;
        int n4 = -1;
        int n5 = -1;
        byte by = 0;
        byte by2 = 0;
        by = byArray[++n5];
        byte[] byArray2 = new byte[256];
        while (n5 < n2 - 1) {
            int n6;
            if ((by2 = byArray[++n5]) == by) {
                if (n4 >= 3) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n4);
                    this.incCompImageSize(2);
                    for (n6 = 0; n6 < n4; ++n6) {
                        this.stream.writeByte(byArray2[n6]);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4)) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        this.stream.writeByte(1);
                        this.stream.writeByte(byArray2[n6]);
                        this.incCompImageSize(2);
                    }
                }
                n4 = -1;
                if (++n3 == 256) {
                    this.stream.writeByte(n3 - 1);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                    n3 = 1;
                }
            } else {
                if (n3 > 1) {
                    this.stream.writeByte(n3);
                    this.stream.writeByte(by);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                } else if (n4 < 254) {
                    byArray2[++n4] = by2;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n4 + 1);
                    this.incCompImageSize(2);
                    for (n6 = 0; n6 <= n4; ++n6) {
                        this.stream.writeByte(byArray2[n6]);
                        this.incCompImageSize(1);
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by2;
                n3 = 1;
            }
            if (n5 != n2 - 1) continue;
            if (n4 == -1) {
                this.stream.writeByte(n3);
                this.stream.writeByte(by);
                this.incCompImageSize(2);
                n3 = 1;
            } else if (n4 >= 2) {
                this.stream.writeByte(0);
                this.stream.writeByte(n4 + 1);
                this.incCompImageSize(2);
                for (n6 = 0; n6 <= n4; ++n6) {
                    this.stream.writeByte(byArray2[n6]);
                    this.incCompImageSize(1);
                }
                if (!this.isEven(n4 + 1)) {
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                }
            } else if (n4 > -1) {
                for (n6 = 0; n6 <= n4; ++n6) {
                    this.stream.writeByte(1);
                    this.stream.writeByte(byArray2[n6]);
                    this.incCompImageSize(2);
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private void encodeRLE4(byte[] byArray, int n2) throws IOException {
        int n3 = 2;
        int n4 = -1;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte[] byArray2 = new byte[256];
        by = byArray[++n5];
        by2 = byArray[++n5];
        while (n5 < n2 - 2) {
            int n8;
            by3 = byArray[++n5];
            by4 = byArray[++n5];
            if (by3 == by) {
                if (n4 >= 4) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n4 - 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4 - 2; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.stream.writeByte((byte)n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4 - 1)) {
                        n7 = byArray2[n4 - 2] << 4 | 0;
                        this.stream.writeByte(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 - 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else if (n4 > -1) {
                    this.stream.writeByte(2);
                    n6 = byArray2[0] << 4 | byArray2[1];
                    this.stream.writeByte(n6);
                    this.incCompImageSize(2);
                }
                n4 = -1;
                if (by4 == by2) {
                    if ((n3 += 2) == 256) {
                        this.stream.writeByte(n3 - 1);
                        n6 = by << 4 | by2;
                        this.stream.writeByte(n6);
                        this.incCompImageSize(2);
                        n3 = 2;
                        if (n5 < n2 - 1) {
                            by = by2;
                            by2 = byArray[++n5];
                        } else {
                            this.stream.writeByte(1);
                            n8 = by2 << 4 | 0;
                            this.stream.writeByte(n8);
                            this.incCompImageSize(2);
                            n3 = -1;
                        }
                    }
                } else {
                    n6 = by << 4 | by2;
                    this.stream.writeByte(++n3);
                    this.stream.writeByte(n6);
                    this.incCompImageSize(2);
                    n3 = 2;
                    by = by4;
                    if (n5 < n2 - 1) {
                        by2 = byArray[++n5];
                    } else {
                        this.stream.writeByte(1);
                        n8 = by4 << 4 | 0;
                        this.stream.writeByte(n8);
                        this.incCompImageSize(2);
                        n3 = -1;
                    }
                }
            } else {
                if (n3 > 2) {
                    n6 = by << 4 | by2;
                    this.stream.writeByte(n3);
                    this.stream.writeByte(n6);
                    this.incCompImageSize(2);
                } else if (n4 < 0) {
                    byArray2[++n4] = by;
                    byArray2[++n4] = by2;
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else if (n4 < 253) {
                    byArray2[++n4] = by3;
                    byArray2[++n4] = by4;
                } else {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n4 + 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.stream.writeByte((byte)n6);
                        this.incCompImageSize(1);
                    }
                    this.stream.writeByte(0);
                    this.incCompImageSize(1);
                    n4 = -1;
                }
                by = by3;
                by2 = by4;
                n3 = 2;
            }
            if (n5 < n2 - 2) continue;
            if (n4 == -1 && n3 >= 2) {
                if (n5 == n2 - 2) {
                    if (byArray[++n5] == by) {
                        n6 = by << 4 | by2;
                        this.stream.writeByte(++n3);
                        this.stream.writeByte(n6);
                        this.incCompImageSize(2);
                    } else {
                        n6 = by << 4 | by2;
                        this.stream.writeByte(n3);
                        this.stream.writeByte(n6);
                        this.stream.writeByte(1);
                        n6 = byArray[n5] << 4 | 0;
                        this.stream.writeByte(n6);
                        n8 = byArray[n5] << 4 | 0;
                        this.incCompImageSize(4);
                    }
                } else {
                    this.stream.writeByte(n3);
                    n6 = by << 4 | by2;
                    this.stream.writeByte(n6);
                    this.incCompImageSize(2);
                }
            } else if (n4 > -1) {
                if (n5 == n2 - 2) {
                    byArray2[++n4] = byArray[++n5];
                }
                if (n4 >= 2) {
                    this.stream.writeByte(0);
                    this.stream.writeByte(n4 + 1);
                    this.incCompImageSize(2);
                    for (n8 = 0; n8 < n4; n8 += 2) {
                        n6 = byArray2[n8] << 4 | byArray2[n8 + 1];
                        this.stream.writeByte((byte)n6);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven(n4 + 1)) {
                        n7 = byArray2[n4] << 4 | 0;
                        this.stream.writeByte(n7);
                        this.incCompImageSize(1);
                    }
                    if (!this.isEven((int)Math.ceil((n4 + 1) / 2))) {
                        this.stream.writeByte(0);
                        this.incCompImageSize(1);
                    }
                } else {
                    switch (n4) {
                        case 0: {
                            this.stream.writeByte(1);
                            n8 = byArray2[0] << 4 | 0;
                            this.stream.writeByte(n8);
                            this.incCompImageSize(2);
                            break;
                        }
                        case 1: {
                            this.stream.writeByte(2);
                            n6 = byArray2[0] << 4 | byArray2[1];
                            this.stream.writeByte(n6);
                            this.incCompImageSize(2);
                        }
                    }
                }
            }
            this.stream.writeByte(0);
            this.stream.writeByte(0);
            this.incCompImageSize(2);
        }
    }

    private synchronized void incCompImageSize(int n2) {
        this.compImageSize += n2;
    }

    private boolean isEven(int n2) {
        return n2 % 2 == 0;
    }

    private void writeFileHeader(int n2, int n3) throws IOException {
        this.stream.writeByte(66);
        this.stream.writeByte(77);
        this.stream.writeInt(n2);
        this.stream.writeInt(0);
        this.stream.writeInt(n3);
    }

    private void writeInfoHeader(int n2, int n3) throws IOException {
        this.stream.writeInt(n2);
        this.stream.writeInt(this.w);
        this.stream.writeInt(this.h);
        this.stream.writeShort(1);
        this.stream.writeShort(n3);
    }

    private void writeSize(int n2, int n3) throws IOException {
        this.stream.skipBytes(n3);
        this.stream.writeInt(n2);
    }

    public void reset() {
        super.reset();
        this.stream = null;
    }

    private int getCompressionType(String string) {
        for (int i2 = 0; i2 < BMPConstants.compressionTypeNames.length; ++i2) {
            if (!BMPConstants.compressionTypeNames[i2].equals(string)) continue;
            return i2;
        }
        return 0;
    }

    private void writeEmbedded(IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        String string = this.compressionType == 4 ? "jpeg" : "png";
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string);
        ImageWriter imageWriter = null;
        if (iterator.hasNext()) {
            imageWriter = iterator.next();
        }
        if (imageWriter != null) {
            if (this.embedded_stream == null) {
                throw new RuntimeException("No stream for writing embedded image!");
            }
        } else {
            throw new RuntimeException(I18N.getString("BMPImageWrite5") + " " + string);
        }
        imageWriter.addIIOWriteProgressListener(new IIOWriteProgressAdapter(){

            public void imageProgress(ImageWriter imageWriter, float f2) {
                BMPImageWriter.this.processImageProgress(f2);
            }
        });
        imageWriter.addIIOWriteWarningListener(new IIOWriteWarningListener(){

            public void warningOccurred(ImageWriter imageWriter, int n2, String string) {
                BMPImageWriter.this.processWarningOccurred(n2, string);
            }
        });
        imageWriter.setOutput(ImageIO.createImageOutputStream(this.embedded_stream));
        ImageWriteParam imageWriteParam2 = imageWriter.getDefaultWriteParam();
        imageWriteParam2.setDestinationOffset(imageWriteParam.getDestinationOffset());
        imageWriteParam2.setSourceBands(imageWriteParam.getSourceBands());
        imageWriteParam2.setSourceRegion(imageWriteParam.getSourceRegion());
        imageWriteParam2.setSourceSubsampling(imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), imageWriteParam.getSubsamplingXOffset(), imageWriteParam.getSubsamplingYOffset());
        imageWriter.write(null, iIOImage, imageWriteParam2);
    }

    private int firstLowBit(int n2) {
        int n3 = 0;
        while ((n2 & 1) == 0) {
            ++n3;
            n2 >>>= 1;
        }
        return n3;
    }

    protected int getPreferredCompressionType(ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return this.getPreferredCompressionType(imageTypeSpecifier);
    }

    protected int getPreferredCompressionType(ImageTypeSpecifier imageTypeSpecifier) {
        if (imageTypeSpecifier.getBufferedImageType() == 8) {
            return 3;
        }
        return 0;
    }

    protected boolean canEncodeImage(int n2, ColorModel colorModel, SampleModel sampleModel) {
        ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        return this.canEncodeImage(n2, imageTypeSpecifier);
    }

    protected boolean canEncodeImage(int n2, ImageTypeSpecifier imageTypeSpecifier) {
        ImageWriterSpi imageWriterSpi = this.getOriginatingProvider();
        if (!imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            return false;
        }
        int n3 = imageTypeSpecifier.getBufferedImageType();
        if (n3 == 8 && n2 != 3) {
            return false;
        }
        int n4 = imageTypeSpecifier.getColorModel().getPixelSize();
        if (this.compressionType == 2 && n4 != 4) {
            return false;
        }
        return this.compressionType != 1 || n4 == 8;
    }

    private class IIOWriteProgressAdapter
    implements IIOWriteProgressListener {
        private IIOWriteProgressAdapter() {
        }

        public void imageComplete(ImageWriter imageWriter) {
        }

        public void imageProgress(ImageWriter imageWriter, float f2) {
        }

        public void imageStarted(ImageWriter imageWriter, int n2) {
        }

        public void thumbnailComplete(ImageWriter imageWriter) {
        }

        public void thumbnailProgress(ImageWriter imageWriter, float f2) {
        }

        public void thumbnailStarted(ImageWriter imageWriter, int n2, int n3) {
        }

        public void writeAborted(ImageWriter imageWriter) {
        }
    }
}

