/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Comparator;

public final class ObjectStreamClassUtil_1_3 {
    private static Comparator compareClassByName = new CompareClassByName();
    private static Comparator compareMemberByName = new CompareMemberByName();
    private static Method hasStaticInitializerMethod = null;

    public static long computeSerialVersionUID(Class clazz) {
        long l2 = com.sun.corba.se.impl.io.ObjectStreamClass.getSerialVersionUID(clazz);
        if (l2 == 0L) {
            return l2;
        }
        l2 = ObjectStreamClassUtil_1_3.getSerialVersion(l2, clazz);
        return l2;
    }

    private static Long getSerialVersion(final long l2, final Class clazz) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                long l22;
                try {
                    Field field = clazz.getDeclaredField("serialVersionUID");
                    int n2 = field.getModifiers();
                    l22 = Modifier.isStatic(n2) && Modifier.isFinal(n2) && Modifier.isPrivate(n2) ? l2 : ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    l22 = ObjectStreamClassUtil_1_3._computeSerialVersionUID(clazz);
                }
                return new Long(l22);
            }
        });
    }

    public static long computeStructuralUID(boolean bl2, Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            int n2;
            int n3;
            AccessibleObject accessibleObject;
            if (!Serializable.class.isAssignableFrom(clazz) || clazz.isInterface()) {
                return 0L;
            }
            if (Externalizable.class.isAssignableFrom(clazz)) {
                return 1L;
            }
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 != null && clazz2 != Object.class) {
                boolean bl3 = false;
                Class[] classArray = new Class[]{ObjectOutputStream.class};
                accessibleObject = ObjectStreamClassUtil_1_3.getDeclaredMethod(clazz2, "writeObject", classArray, 2, 8);
                if (accessibleObject != null) {
                    bl3 = true;
                }
                dataOutputStream.writeLong(ObjectStreamClassUtil_1_3.computeStructuralUID(bl3, clazz2));
            }
            if (bl2) {
                dataOutputStream.writeInt(2);
            } else {
                dataOutputStream.writeInt(1);
            }
            Field[] fieldArray = ObjectStreamClassUtil_1_3.getDeclaredFields(clazz);
            Arrays.sort(fieldArray, compareMemberByName);
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                accessibleObject = fieldArray[i2];
                n3 = ((Field)accessibleObject).getModifiers();
                if (Modifier.isTransient(n3) || Modifier.isStatic(n3)) continue;
                dataOutputStream.writeUTF(((Field)accessibleObject).getName());
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)accessibleObject).getType()));
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (n3 = n2 = Math.min(8, byArray.length); n3 > 0; --n3) {
                l2 += (long)(byArray[n3] & 0xFF) << n3 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static long _computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l2 = 0L;
        try {
            String string;
            Object object;
            int n2;
            AnnotatedElement[] annotatedElementArray;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n3 = clazz.getModifiers();
            Member[] memberArray = clazz.getDeclaredMethods();
            if (((n3 &= 0x611) & 0x200) != 0) {
                n3 &= 0xFFFFFBFF;
                if (memberArray.length > 0) {
                    n3 |= 0x400;
                }
            }
            dataOutputStream.writeInt(n3);
            if (!clazz.isArray()) {
                annotatedElementArray = clazz.getInterfaces();
                Arrays.sort(annotatedElementArray, compareClassByName);
                for (n2 = 0; n2 < annotatedElementArray.length; ++n2) {
                    dataOutputStream.writeUTF(((Class)annotatedElementArray[n2]).getName());
                }
            }
            annotatedElementArray = clazz.getDeclaredFields();
            Arrays.sort(annotatedElementArray, compareMemberByName);
            for (n2 = 0; n2 < annotatedElementArray.length; ++n2) {
                AnnotatedElement annotatedElement = annotatedElementArray[n2];
                int n4 = ((Field)annotatedElement).getModifiers();
                if (Modifier.isPrivate(n4) && (Modifier.isTransient(n4) || Modifier.isStatic(n4))) continue;
                dataOutputStream.writeUTF(((Field)annotatedElement).getName());
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeUTF(ObjectStreamClassUtil_1_3.getSignature(((Field)annotatedElement).getType()));
            }
            if (ObjectStreamClassUtil_1_3.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            MethodSignature[] methodSignatureArray = MethodSignature.removePrivateAndSort(clazz.getDeclaredConstructors());
            for (int i2 = 0; i2 < methodSignatureArray.length; ++i2) {
                MethodSignature methodSignature = methodSignatureArray[i2];
                object = "<init>";
                string = methodSignature.signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF((String)object);
                dataOutputStream.writeInt(methodSignature.member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            MethodSignature[] methodSignatureArray2 = MethodSignature.removePrivateAndSort(memberArray);
            for (int i3 = 0; i3 < methodSignatureArray2.length; ++i3) {
                object = methodSignatureArray2[i3];
                string = ((MethodSignature)object).signature;
                string = string.replace('/', '.');
                dataOutputStream.writeUTF(((MethodSignature)object).member.getName());
                dataOutputStream.writeInt(((MethodSignature)object).member.getModifiers());
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            for (int i4 = 0; i4 < Math.min(8, byArray.length); ++i4) {
                l2 += (long)(byArray[i4] & 0xFF) << i4 * 8;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static String getSignature(Class clazz) {
        String string = null;
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz;
            int n2 = 0;
            while (clazz2.isArray()) {
                ++n2;
                clazz2 = clazz2.getComponentType();
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuffer.append("[");
            }
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(clazz2));
            string = stringBuffer.toString();
        } else if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                string = "I";
            } else if (clazz == Byte.TYPE) {
                string = "B";
            } else if (clazz == Long.TYPE) {
                string = "J";
            } else if (clazz == Float.TYPE) {
                string = "F";
            } else if (clazz == Double.TYPE) {
                string = "D";
            } else if (clazz == Short.TYPE) {
                string = "S";
            } else if (clazz == Character.TYPE) {
                string = "C";
            } else if (clazz == Boolean.TYPE) {
                string = "Z";
            } else if (clazz == Void.TYPE) {
                string = "V";
            }
        } else {
            string = "L" + clazz.getName().replace('.', '/') + ";";
        }
        return string;
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = method.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i2]));
        }
        stringBuffer.append(")");
        stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String getSignature(Constructor constructor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        Class<?>[] classArray = constructor.getParameterTypes();
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ObjectStreamClassUtil_1_3.getSignature(classArray[i2]));
        }
        stringBuffer.append(")V");
        return stringBuffer.toString();
    }

    private static Field[] getDeclaredFields(final Class clazz) {
        return (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredFields();
            }
        });
    }

    private static boolean hasStaticInitializer(Class clazz) {
        Object object;
        if (hasStaticInitializerMethod == null) {
            object = null;
            try {
                try {
                    object = Class.forName("sun.misc.ClassReflector");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (object == null) {
                    object = ObjectStreamClass.class;
                }
                hasStaticInitializerMethod = ((Class)object).getDeclaredMethod("hasStaticInitializer", Class.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (hasStaticInitializerMethod == null) {
                throw new InternalError("Can't find hasStaticInitializer method on " + ((Class)object).getName());
            }
            hasStaticInitializerMethod.setAccessible(true);
        }
        try {
            object = (Boolean)hasStaticInitializerMethod.invoke(null, clazz);
            return (Boolean)object;
        }
        catch (Exception exception) {
            throw new InternalError("Error invoking hasStaticInitializer: " + exception);
        }
    }

    private static Method getDeclaredMethod(final Class clazz, final String string, final Class[] classArray, final int n2, final int n3) {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method method = null;
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                    int n22 = method.getModifiers();
                    if ((n22 & n3) != 0 || (n22 & n2) != n2) {
                        method = null;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                return method;
            }
        });
    }

    private static class CompareClassByName
    implements Comparator {
        private CompareClassByName() {
        }

        public int compare(Object object, Object object2) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            return clazz.getName().compareTo(clazz2.getName());
        }
    }

    private static class CompareMemberByName
    implements Comparator {
        private CompareMemberByName() {
        }

        public int compare(Object object, Object object2) {
            String string = ((Member)object).getName();
            String string2 = ((Member)object2).getName();
            if (object instanceof Method) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Method)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Method)object2);
            } else if (object instanceof Constructor) {
                string = string + ObjectStreamClassUtil_1_3.getSignature((Constructor)object);
                string2 = string2 + ObjectStreamClassUtil_1_3.getSignature((Constructor)object2);
            }
            return string.compareTo(string2);
        }
    }

    private static class MethodSignature
    implements Comparator {
        Member member;
        String signature;

        static MethodSignature[] removePrivateAndSort(Member[] memberArray) {
            int n2 = 0;
            for (int i2 = 0; i2 < memberArray.length; ++i2) {
                if (Modifier.isPrivate(memberArray[i2].getModifiers())) continue;
                ++n2;
            }
            MethodSignature[] methodSignatureArray = new MethodSignature[n2];
            int n3 = 0;
            for (int i3 = 0; i3 < memberArray.length; ++i3) {
                if (Modifier.isPrivate(memberArray[i3].getModifiers())) continue;
                methodSignatureArray[n3] = new MethodSignature(memberArray[i3]);
                ++n3;
            }
            if (n3 > 0) {
                Arrays.sort(methodSignatureArray, methodSignatureArray[0]);
            }
            return methodSignatureArray;
        }

        public int compare(Object object, Object object2) {
            int n2;
            if (object == object2) {
                return 0;
            }
            MethodSignature methodSignature = (MethodSignature)object;
            MethodSignature methodSignature2 = (MethodSignature)object2;
            if (this.isConstructor()) {
                n2 = methodSignature.signature.compareTo(methodSignature2.signature);
            } else {
                n2 = methodSignature.member.getName().compareTo(methodSignature2.member.getName());
                if (n2 == 0) {
                    n2 = methodSignature.signature.compareTo(methodSignature2.signature);
                }
            }
            return n2;
        }

        private final boolean isConstructor() {
            return this.member instanceof Constructor;
        }

        private MethodSignature(Member member) {
            this.member = member;
            this.signature = this.isConstructor() ? ObjectStreamClassUtil_1_3.getSignature((Constructor)member) : ObjectStreamClassUtil_1_3.getSignature((Method)member);
        }
    }
}

