/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.pept.transport.ByteBufferPool;
import java.nio.ByteBuffer;
import org.omg.CORBA.ORB;

public class ByteBufferWithInfo {
    private com.sun.corba.se.spi.orb.ORB orb;
    private boolean debug;
    private int index;
    public ByteBuffer byteBuffer;
    public int buflen;
    public int needed;
    public boolean fragmented;

    public ByteBufferWithInfo(ORB oRB, ByteBuffer byteBuffer, int n2) {
        this.orb = (com.sun.corba.se.spi.orb.ORB)oRB;
        this.debug = this.orb.transportDebugFlag;
        this.byteBuffer = byteBuffer;
        if (byteBuffer != null) {
            this.buflen = byteBuffer.limit();
        }
        this.position(n2);
        this.needed = 0;
        this.fragmented = false;
    }

    public ByteBufferWithInfo(ORB oRB, ByteBuffer byteBuffer) {
        this(oRB, byteBuffer, 0);
    }

    public ByteBufferWithInfo(ORB oRB, BufferManagerWrite bufferManagerWrite) {
        this(oRB, bufferManagerWrite, true);
    }

    public ByteBufferWithInfo(ORB oRB, BufferManagerWrite bufferManagerWrite, boolean bl2) {
        this.orb = (com.sun.corba.se.spi.orb.ORB)oRB;
        this.debug = this.orb.transportDebugFlag;
        int n2 = bufferManagerWrite.getBufferSize();
        if (bl2) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            this.byteBuffer = byteBufferPool.getByteBuffer(n2);
            if (this.debug) {
                int n3 = System.identityHashCode(this.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append("constructor (ORB, BufferManagerWrite) - got ").append("ByteBuffer id (").append(n3).append(") from ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
        } else {
            this.byteBuffer = ByteBuffer.allocate(n2);
        }
        this.position(0);
        this.buflen = n2;
        this.byteBuffer.limit(this.buflen);
        this.needed = 0;
        this.fragmented = false;
    }

    public ByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.orb = byteBufferWithInfo.orb;
        this.debug = byteBufferWithInfo.debug;
        this.byteBuffer = byteBufferWithInfo.byteBuffer;
        this.buflen = byteBufferWithInfo.buflen;
        this.byteBuffer.limit(this.buflen);
        this.position(byteBufferWithInfo.position());
        this.needed = byteBufferWithInfo.needed;
        this.fragmented = byteBufferWithInfo.fragmented;
    }

    public int getSize() {
        return this.position();
    }

    public int getLength() {
        return this.buflen;
    }

    public int position() {
        return this.index;
    }

    public void position(int n2) {
        this.byteBuffer.position(n2);
        this.index = n2;
    }

    public void setLength(int n2) {
        this.buflen = n2;
        this.byteBuffer.limit(this.buflen);
    }

    public void growBuffer(com.sun.corba.se.spi.orb.ORB oRB) {
        String string;
        StringBuffer stringBuffer;
        int n2;
        int n3;
        for (n3 = this.byteBuffer.limit() * 2; this.position() + this.needed >= n3; n3 *= 2) {
        }
        ByteBufferPool byteBufferPool = oRB.getByteBufferPool();
        ByteBuffer byteBuffer = byteBufferPool.getByteBuffer(n3);
        if (this.debug) {
            n2 = System.identityHashCode(byteBuffer);
            stringBuffer = new StringBuffer(80);
            stringBuffer.append("growBuffer() - got ByteBuffer id (");
            stringBuffer.append(n2).append(") from ByteBufferPool.");
            string = stringBuffer.toString();
            this.dprint(string);
        }
        this.byteBuffer.position(0);
        byteBuffer.put(this.byteBuffer);
        if (this.debug) {
            n2 = System.identityHashCode(this.byteBuffer);
            stringBuffer = new StringBuffer(80);
            stringBuffer.append("growBuffer() - releasing ByteBuffer id (");
            stringBuffer.append(n2).append(") to ByteBufferPool.");
            string = stringBuffer.toString();
            this.dprint(string);
        }
        byteBufferPool.releaseByteBuffer(this.byteBuffer);
        this.byteBuffer = byteBuffer;
        this.buflen = n3;
        this.byteBuffer.limit(this.buflen);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ByteBufferWithInfo:");
        stringBuffer.append(" buflen = " + this.buflen);
        stringBuffer.append(" byteBuffer.limit = " + this.byteBuffer.limit());
        stringBuffer.append(" index = " + this.index);
        stringBuffer.append(" position = " + this.position());
        stringBuffer.append(" needed = " + this.needed);
        stringBuffer.append(" byteBuffer = " + (this.byteBuffer == null ? "null" : "not null"));
        stringBuffer.append(" fragmented = " + this.fragmented);
        return stringBuffer.toString();
    }

    protected void dprint(String string) {
        ORBUtility.dprint("ByteBufferWithInfo", string);
    }
}

