/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.util.PublicCloneable;

public final class ObjectUtilities {
    private ObjectUtilities() {
    }

    public static boolean equal(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 != null) {
            return o1.equals(o2);
        }
        return false;
    }

    public static int hashCode(Object object) {
        int result = 0;
        if (object != null) {
            result = object.hashCode();
        }
        return result;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        if (object instanceof PublicCloneable) {
            PublicCloneable pc = (PublicCloneable)object;
            return pc.clone();
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, null);
            }
        }
        catch (NoSuchMethodException e) {
            Log.warn("Object without clone() method is impossible.");
        }
        catch (IllegalAccessException e) {
            Log.warn("Object.clone(): unable to call method.");
        }
        catch (InvocationTargetException e) {
            Log.warn("Object without clone() method is impossible.");
        }
        throw new CloneNotSupportedException("Failed to clone.");
    }

    public static Collection deepClone(Collection collection) throws CloneNotSupportedException {
        if (collection == null) {
            throw new IllegalArgumentException("Null 'collection' argument.");
        }
        Collection result = (Collection)ObjectUtilities.clone(collection);
        result.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object item = iterator.next();
            if (item != null) {
                result.add(ObjectUtilities.clone(item));
                continue;
            }
            result.add(null);
        }
        return result;
    }

    public static ClassLoader getClassLoader(Class c) {
        ClassLoader applicationCL = c.getClassLoader();
        if (applicationCL == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return applicationCL;
    }

    public static Object loadAndInstantiate(String className, Class source) {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(source);
            Class<?> c = loader.loadClass(className);
            return c.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }
}

