/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.impl;

import com.liveperf.common.F.C;
import com.liveperf.common.app.exception.StartableError;
import com.liveperf.rms.D;
import com.liveperf.rms.EntityConfiguration;
import com.liveperf.rms.EntityDescriptorTree;
import com.liveperf.rms.EntityId;
import com.liveperf.rms.J;
import com.liveperf.rms.X;
import com.liveperf.rms.Y;
import com.liveperf.rms.agents.Agent;
import com.liveperf.rms.agents.AgentConfiguration;
import com.liveperf.rms.agents.AgentId;
import com.liveperf.rms.agents.F;
import com.liveperf.rms.agents.impl.A;
import com.liveperf.rms.agents.impl.B;
import com.liveperf.rms.exception.InvalidConfiguration;
import com.liveperf.rms.exception.InvalidEntity;
import com.liveperf.rms.f;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractAgent
implements Agent {
    protected AgentId fAgentId;
    protected A fRootEntity;
    protected AgentConfiguration fConfiguration;
    protected _A fContext;
    protected boolean fIsRunning;
    protected Agent._A fListener;
    protected J fCollector;
    protected boolean fSendAgentDescriptor;

    protected AbstractAgent(AgentId agentId, Agent._A _A2) {
        this.fAgentId = agentId;
        this.fListener = _A2;
        this.fSendAgentDescriptor = true;
        this.replaceContext(new _A());
    }

    protected AbstractAgent(AgentId agentId, Agent._A _A2, boolean bl) {
        this(agentId, _A2);
        if (bl) {
            this.fCollector = this.createCollector();
        }
    }

    protected J createCollector() {
        return new J("Collector for agent " + this.getClass().getName()){

            protected void E() throws Throwable {
                AbstractAgent.this.collectData();
            }
        };
    }

    protected D extractDescriptor() {
        return new Y(this.fConfiguration, this.fAgentId);
    }

    protected final void replaceContext(_A _A2) {
        this.fContext = _A2;
        this.fRootEntity = new A(_A2);
    }

    public void setListener(Agent._A _A2) {
        if (_A2 == null) {
            throw new IllegalArgumentException("null listener");
        }
        this.fListener = _A2;
    }

    public synchronized EntityDescriptorTree configureEntity(EntityId entityId, EntityConfiguration entityConfiguration) throws InvalidEntity, InvalidConfiguration, Throwable {
        B b2 = this.fRootEntity.findEntity(entityId, true);
        if (b2 == null) {
            throw new InvalidEntity(entityId);
        }
        b2.configure(entityConfiguration);
        boolean bl = b2.getConfiguration().hasRecursiveSettings();
        return b2.extractDescriptorTree(bl);
    }

    public synchronized EntityDescriptorTree getEntities(EntityId entityId, boolean bl) throws InvalidEntity, Throwable {
        B b2 = entityId == null || entityId.equals(this.fRootEntity.getId()) ? this.fRootEntity : this.fRootEntity.findEntity(entityId, true);
        if (b2 == null) {
            return null;
        }
        ((B)b2).updateChildrenEntities(bl);
        return b2.extractDescriptorTree(bl);
    }

    protected EntityDescriptorTree getExistingEntities(EntityId entityId, boolean bl) throws Throwable {
        B b2 = entityId == null || entityId.equals(this.fRootEntity.getId()) ? this.fRootEntity : this.fRootEntity.findEntity(entityId, false);
        if (b2 == null) {
            return null;
        }
        return b2.extractDescriptorTree(bl);
    }

    public synchronized EntityDescriptorTree configure(AgentConfiguration agentConfiguration) throws InvalidConfiguration, Throwable {
        Cloneable cloneable;
        this.fSendAgentDescriptor = true;
        Boolean bl = agentConfiguration.getEnableAllCounters();
        if (this.fConfiguration == null) {
            this.fConfiguration = agentConfiguration;
            if (this.fConfiguration.usePrivateCollector() && this.fCollector == null) {
                this.fCollector = this.createCollector();
            }
            this.configValidateCustom();
            this.configCustomChanged();
            this.configMonitoringLevelChanged();
            this.configSamplingIntervalChanged();
        } else {
            cloneable = this.fConfiguration.applyDelta(agentConfiguration);
            if (((BitSet)cloneable).get(3)) {
                this.configValidateCustom();
                this.configCustomChanged();
            }
            if (((BitSet)cloneable).get(0)) {
                this.configMonitoringLevelChanged();
            }
            if (((BitSet)cloneable).get(1)) {
                this.configSamplingIntervalChanged();
            }
        }
        if (bl != null) {
            cloneable = new EntityConfiguration();
            ((f)cloneable).setEnableAllCounters(bl);
            ((f)cloneable).setRecursiveEnableAllCounters(true);
            this.fRootEntity.configure((EntityConfiguration)cloneable);
        }
        if (this.fCollector != null) {
            this.fCollector.B(1000 * this.fConfiguration.getSamplingInterval());
        }
        boolean bl2 = bl != null || agentConfiguration.getMonitoringLevel() != null;
        return this.getExistingEntities(null, bl2);
    }

    public synchronized AgentConfiguration getConfiguration() {
        return this.fConfiguration;
    }

    public synchronized void collectData() throws Throwable {
        if (this.fCollector != null && !this.fCollector.A(Thread.currentThread())) {
            return;
        }
        com.liveperf.rms.agents.D d = new com.liveperf.rms.agents.D();
        this.fRootEntity.beginCycle();
        this.prepareBuffer(d);
        this.fRootEntity.endCycle();
        this.fListener.A(d);
    }

    public synchronized void start() throws StartableError {
        this.fIsRunning = true;
        if (this.fCollector != null) {
            this.fCollector.F();
        }
    }

    public synchronized void stop() throws StartableError {
        this.fIsRunning = false;
        if (this.fCollector != null) {
            this.fCollector.D();
        }
    }

    public synchronized void deactivate() throws Throwable {
    }

    public boolean requiresExternalCollector() {
        return this.fCollector == null;
    }

    public void setId(AgentId agentId) {
        this.fAgentId = agentId;
    }

    protected void configMonitoringLevelChanged() throws Throwable {
    }

    protected void configSamplingIntervalChanged() throws Throwable {
    }

    protected void configCustomChanged() throws InvalidConfiguration, Throwable {
    }

    protected void configValidateCustom() throws InvalidConfiguration {
    }

    protected void prepareBuffer(com.liveperf.rms.agents.D d) throws Throwable {
        d.setHost(this.fConfiguration.getMonitoredHost());
        d.setAgent(this.fAgentId);
        LinkedList linkedList = new LinkedList();
        Iterator iterator = this.fRootEntity.getChildrenEntities().iterator();
        while (iterator.hasNext()) {
            B b2 = (B)iterator.next();
            b2.prepareEntityDataBuffers(linkedList);
        }
        if (linkedList.size() > 0) {
            d.setBuffers(linkedList.toArray(new X[linkedList.size()]));
        } else {
            d.setBuffers(null);
        }
        if (this.fSendAgentDescriptor) {
            d.setAgentDescriptor(this.extractDescriptor());
            if (!C.A((Object[])d.getBuffers())) {
                this.fSendAgentDescriptor = false;
            }
        }
    }

    protected class _A
    implements F {
        protected _A() {
        }

        public void A(Throwable throwable) {
            AbstractAgent.this.fListener.B(AbstractAgent.this.fConfiguration.getMonitoredHost(), AbstractAgent.this.fAgentId, throwable);
        }

        public AgentConfiguration B() {
            return AbstractAgent.this.getConfiguration();
        }

        public void A(EntityDescriptorTree entityDescriptorTree) {
            AbstractAgent.this.fListener.entitiesChanged(AbstractAgent.this.fConfiguration.getMonitoredHost(), AbstractAgent.this.fAgentId, entityDescriptorTree);
        }

        public AgentId A() {
            return AbstractAgent.this.fAgentId;
        }

        public boolean C() {
            return AbstractAgent.this.fIsRunning;
        }
    }
}

