/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.dom;

import com.sun.deploy.services.ServiceManager;
import sun.plugin.dom.DOMObject;
import sun.plugin.dom.core.Text;
import sun.plugin.services.BrowserService;

final class DOMObjectTypeHelper {
    private static final String HTML_IMPLEMENTATION_PACKAGE = "sun.plugin.dom.html";
    private static final String SSL_IMPLEMENTATION_PACKAGE = "sun.plugin.dom.stylesheets";
    private static final String CSS_IMPLEMENTATION_PACKAGE = "sun.plugin.dom.css";
    private static final String DOM_IMPLEMENTATION_PACKAGE = "sun.plugin.dom.core";

    DOMObjectTypeHelper() {
    }

    static Class getDOMCoreClass(DOMObject dOMObject) {
        Class clazz = DOMObjectTypeHelper.getObjectClass(dOMObject, DOM_IMPLEMENTATION_PACKAGE);
        if (clazz == null) {
            clazz = Text.class;
        }
        return clazz;
    }

    static Class getHTMLElementClass(DOMObject dOMObject) {
        return DOMObjectTypeHelper.getObjectClass(dOMObject, HTML_IMPLEMENTATION_PACKAGE);
    }

    static Class getCSSRuleClass(DOMObject dOMObject) {
        return DOMObjectTypeHelper.getObjectClass(dOMObject, CSS_IMPLEMENTATION_PACKAGE);
    }

    static Class getStyleSheetClass(DOMObject dOMObject) {
        Class clazz = DOMObjectTypeHelper.getObjectClass(dOMObject, CSS_IMPLEMENTATION_PACKAGE);
        if (null != clazz) {
            return clazz;
        }
        return DOMObjectTypeHelper.getObjectClass(dOMObject, SSL_IMPLEMENTATION_PACKAGE);
    }

    private static Class getObjectClass(DOMObject dOMObject, String string) {
        BrowserService browserService;
        String string2 = dOMObject.toString();
        String string3 = DOMObjectTypeHelper.getObjectType(string2);
        if (string3 == null) {
            string3 = string2;
        }
        if ((string3 = (browserService = (BrowserService)ServiceManager.getService()).mapBrowserElement(string3)) != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append('.');
            stringBuffer.append(string3);
            try {
                return Class.forName(stringBuffer.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String getObjectType(String string) {
        if (!(string = string.trim()).endsWith("]")) {
            return null;
        }
        int n = string.lastIndexOf(32);
        if (n == -1) {
            return null;
        }
        return string.substring(n + 1, string.length() - 1);
    }
}

