/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.websphere.v50.proxy;

import com.ibm.websphere.pmi.PmiException;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.client.CpdCollection;
import com.ibm.websphere.pmi.client.PerfDescriptorList;
import com.ibm.websphere.pmi.client.PerfLevelSpec;
import com.ibm.websphere.pmi.client.PmiClient;
import com.liveperf.rms.agents.websphere.v50.proxy.PerfDescriptor;
import com.liveperf.rms.agents.websphere.v50.proxy.PmiClientProxy;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Properties;

public class PmiClientProxyImpl
extends UnicastRemoteObject
implements PmiClientProxy {
    protected PmiClient client;
    protected long id;

    public PmiClientProxyImpl(long l) throws RemoteException {
        this.id = l;
    }

    public long getId() throws RemoteException {
        return this.id;
    }

    public void configure(Properties properties) throws RemoteException {
        this.client = new PmiClient(properties, "WAS50");
    }

    public String getNLSValue(String string, String string2) throws RemoteException {
        return PmiClient.getNLSValue((String)string, (String)string2);
    }

    public PerfDescriptor[] listNodes() throws RemoteException, PmiException {
        PerfDescriptor[] perfDescriptorArray = this.convertWASPerfDescriptorArray(this.client.listNodes());
        return perfDescriptorArray;
    }

    public PerfDescriptor[] listServers(PerfDescriptor perfDescriptor) throws RemoteException, PmiException {
        PerfDescriptor[] perfDescriptorArray = this.convertWASPerfDescriptorArray(this.client.listServers((com.ibm.websphere.pmi.client.PerfDescriptor)perfDescriptor));
        return perfDescriptorArray;
    }

    public PerfDescriptor[] listMembers(PerfDescriptor perfDescriptor, boolean bl) throws RemoteException, PmiException {
        PerfDescriptor[] perfDescriptorArray = this._listMembers(perfDescriptor, bl);
        return perfDescriptorArray;
    }

    protected PerfDescriptor[] _listMembers(PerfDescriptor perfDescriptor, boolean bl) throws PmiException {
        PerfDescriptor[] perfDescriptorArray = this.convertWASPerfDescriptorArray(this.client.listMembers((com.ibm.websphere.pmi.client.PerfDescriptor)perfDescriptor));
        if (bl && perfDescriptorArray != null && perfDescriptorArray.length > 0) {
            int n = 0;
            while (n < perfDescriptorArray.length) {
                PerfDescriptor perfDescriptor2 = perfDescriptorArray[n];
                PerfDescriptor[] perfDescriptorArray2 = this._listMembers(perfDescriptor2, true);
                perfDescriptor2.setChildren(perfDescriptorArray2);
                ++n;
            }
        }
        return perfDescriptorArray;
    }

    public PerfLevelSpec[] getInstrumentationLevel(String string, String string2) throws RemoteException, PmiException {
        PerfLevelSpec[] perfLevelSpecArray = this.client.getInstrumentationLevel(string, string2);
        return perfLevelSpecArray;
    }

    public PmiModuleConfig[] getConfigs() throws RemoteException {
        PmiModuleConfig[] pmiModuleConfigArray = this.client.getConfigs();
        return pmiModuleConfigArray;
    }

    public CpdCollection[] gets(PerfDescriptor[] perfDescriptorArray, boolean bl) throws RemoteException, PmiException {
        if (perfDescriptorArray == null || perfDescriptorArray.length == 0) {
            return null;
        }
        return this.client.gets(new PerfDescriptorList((com.ibm.websphere.pmi.client.PerfDescriptor[])perfDescriptorArray), bl);
    }

    public int getErrorCode() throws RemoteException {
        return this.client.getErrorCode();
    }

    public String getErrorMessage() throws RemoteException {
        return this.client.getErrorMessage();
    }

    public int getErrorCode(String string) throws RemoteException {
        return this.client.getErrorCode(string);
    }

    public String getErrorMessage(String string) throws RemoteException {
        return this.client.getErrorMessage(string);
    }

    public void setInstrumentationLevel(String string, String string2, String[] stringArray, int n, boolean bl) throws RemoteException, PmiException {
        PerfLevelSpec[] perfLevelSpecArray = new PerfLevelSpec[]{stringArray != null ? this.client.createPerfLevelSpec(stringArray, n) : this.client.createPerfLevelSpec(n)};
        this.client.setInstrumentationLevel(string, string2, perfLevelSpecArray, bl);
    }

    public void end() throws RemoteException {
        this.client.end();
    }

    protected PerfDescriptor[] convertWASPerfDescriptorArray(com.ibm.websphere.pmi.client.PerfDescriptor[] perfDescriptorArray) {
        if (perfDescriptorArray == null) {
            return null;
        }
        PerfDescriptor[] perfDescriptorArray2 = new PerfDescriptor[perfDescriptorArray.length];
        int n = 0;
        while (n < perfDescriptorArray2.length) {
            perfDescriptorArray2[n] = new PerfDescriptor(perfDescriptorArray[n]);
            ++n;
        }
        return perfDescriptorArray2;
    }

    protected void checkForErrors() throws RemoteException {
        if (this.client.getErrorCode() > 0) {
            throw new RemoteException(this.client.getErrorMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray == null || stringArray.length != 3) {
                System.err.println("Parameters are missing");
                return;
            }
            String string = stringArray[0].trim();
            int n = Integer.parseInt(stringArray[1].trim());
            long l = Long.parseLong(stringArray[2].trim());
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new RMISecurityManager());
            }
            Registry registry = LocateRegistry.createRegistry(n);
            System.out.println("Started rmi registry on port " + n);
            registry.rebind("PmiClientProxy", new PmiClientProxyImpl(l));
            System.out.println("Rebinded to //" + string + ":" + n + "/PmiClientProxy");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

