/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.windows;

import com.liveperf.rms.EntityId;
import com.liveperf.rms.agents.F;
import com.liveperf.rms.agents.impl.A;
import com.liveperf.rms.agents.windows.B;
import com.liveperf.rms.agents.windows.Configuration;
import com.liveperf.rms.agents.windows.WinPerfException;
import com.liveperf.rms.agents.windows.WinPerfNotSupportedException;
import com.liveperf.rms.data.CounterValue;
import com.liveperf.rms.i;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WinPerfRootEntity
extends A {
    protected String machine = null;

    protected static native NativeObject[] EnumEntities(String var0, String var1, String var2, String var3) throws WinPerfException;

    protected static native CounterValue[] CollectQueryData(int var0, int[] var1, int[] var2) throws WinPerfException;

    protected static native int[] SetCounters(String var0, int var1, String[] var2) throws WinPerfException;

    protected static native int ResetQuery(int[] var0, int var1) throws WinPerfException;

    public String makeNativePath(String string, String string2, int n, String string3) {
        String string4 = "";
        if (this.machine != null) {
            string4 = String.valueOf(string4) + this.machine;
        }
        string4 = String.valueOf(string4) + "\\" + string;
        if (string2 != null && string2.length() > 0) {
            string4 = String.valueOf(string4) + "(" + string2;
            string4 = String.valueOf(string4) + ")";
        }
        string4 = String.valueOf(string4) + "\\" + string3;
        return string4;
    }

    public WinPerfRootEntity(F f) throws WinPerfNotSupportedException {
        super(f);
        try {
            System.loadLibrary("winperf");
        }
        catch (Throwable throwable) {
            throw new WinPerfNotSupportedException(throwable);
        }
    }

    private boolean j(String string) {
        try {
            if (string.equalsIgnoreCase("localhost") || string.equals("127.0.0.1")) {
                return true;
            }
            String string2 = InetAddress.getByName(string).getHostAddress();
            String string3 = InetAddress.getLocalHost().getHostAddress();
            if (string3 != null && string3.equalsIgnoreCase(string2)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public void updateChildrenEntities(boolean bl) throws Throwable {
        String string = this.fContext.B().getMonitoredHost();
        this.machine = !this.j(string) ? "\\\\" + string : null;
        Configuration configuration = (Configuration)this.fContext.B().getAgentCustomConfiguration();
        String string2 = configuration.getString("config.username");
        String string3 = configuration.getString("config.password");
        String string4 = configuration.getString("config.domain");
        try {
            NativeObject[] nativeObjectArray = WinPerfRootEntity.EnumEntities(this.machine, string2, string4, string3);
            int n = 0;
            while (n < nativeObjectArray.length) {
                NativeObject nativeObject = nativeObjectArray[n];
                if (nativeObject != null) {
                    WinPerfEntity winPerfEntity = (WinPerfEntity)((Object)this.fChildrenEntities.get(WinPerfRootEntity.A(this.fEntityId, nativeObject)));
                    if (winPerfEntity == null) {
                        this.addChildEntity(new WinPerfEntity(this.fEntityId, nativeObjectArray[n], this.fContext));
                    } else {
                        winPerfEntity.updateObject(nativeObject);
                    }
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.fContext.A(throwable);
        }
    }

    protected void retrieveCounterValues() throws Throwable {
    }

    protected boolean testForChildren() {
        return true;
    }

    private static EntityId A(EntityId entityId, NativeObject nativeObject) {
        return new EntityId(entityId, nativeObject.A);
    }

    public static final class NativeObject {
        String A;
        String C;
        String E;
        NativeInstance[] D;
        NativeCounter[] B;

        public NativeObject(String string, String string2, String string3, NativeInstance[] nativeInstanceArray, NativeCounter[] nativeCounterArray) {
            this.A = string;
            this.C = string2;
            this.E = string3;
            this.D = nativeInstanceArray;
            this.B = nativeCounterArray;
        }
    }

    public static final class NativeInstance {
        int B;
        String A;

        public NativeInstance(int n, String string) {
            this.B = n;
            this.A = string;
            if (n != -1) {
                this.A = String.valueOf(this.A) + "#" + n;
            }
        }
    }

    public static final class NativeCounter {
        String A;
        String C;
        int B;

        public NativeCounter(String string, String string2, int n) {
            this.A = string;
            this.C = string2;
            this.B = n;
        }
    }

    private class WinPerfEntity
    extends com.liveperf.rms.agents.impl.B {
        private int \u01d0;
        private int[] \u01d3;
        private int[] \u01d1;
        private List \u01d2;

        public WinPerfEntity(EntityId entityId, NativeObject nativeObject, F f) throws Throwable {
            super(new EntityId(entityId, nativeObject.A), nativeObject.C, f);
            this.\u01d0 = 0;
            this.\u01d3 = null;
            this.\u01d1 = null;
            this.\u01d2 = new ArrayList();
            this.updateObject(nativeObject);
        }

        private void A(NativeObject nativeObject, NativeInstance nativeInstance) {
            int n = 0;
            while (n < nativeObject.B.length) {
                NativeCounter nativeCounter = nativeObject.B[n];
                if (nativeCounter != null && (nativeCounter.B & 0x40000000) != 0x40000000) {
                    String string = WinPerfRootEntity.this.makeNativePath(nativeObject.A, nativeInstance != null ? nativeInstance.A : nativeObject.E, nativeInstance != null ? nativeInstance.B : -1, nativeCounter.A);
                    if (this.getCounter(new i(nativeCounter.A)) == null) {
                        this.addCounter(new B(nativeCounter, string));
                    }
                }
                ++n;
            }
        }

        public void updateObject(NativeObject nativeObject) throws Throwable {
            if (nativeObject.E != null) {
                this.A(nativeObject, null);
            }
            if (nativeObject.D != null && nativeObject.D.length > 0) {
                int n = 0;
                while (n < nativeObject.D.length) {
                    NativeInstance nativeInstance = nativeObject.D[n];
                    WinPerfEntity winPerfEntity = (WinPerfEntity)((Object)this.fChildrenEntities.get(new EntityId(this.getId(), nativeInstance.A)));
                    if (winPerfEntity == null) {
                        this.addChildEntity(new WinPerfEntity(this.fEntityId, nativeObject, nativeInstance, this.fContext));
                    } else {
                        this.updateInstance(nativeObject, nativeInstance);
                    }
                    ++n;
                }
            }
        }

        public WinPerfEntity(EntityId entityId, NativeObject nativeObject, NativeInstance nativeInstance, F f) {
            super(new EntityId(entityId, nativeInstance.A), f);
            this.\u01d0 = 0;
            this.\u01d3 = null;
            this.\u01d1 = null;
            this.\u01d2 = new ArrayList();
            this.updateInstance(nativeObject, nativeInstance);
        }

        public void updateInstance(NativeObject nativeObject, NativeInstance nativeInstance) {
            this.A(nativeObject, nativeInstance);
        }

        protected void retrieveCounterValues() throws Throwable {
            CounterValue[] counterValueArray = WinPerfRootEntity.CollectQueryData(this.\u01d0, this.\u01d3, this.\u01d1);
            if (counterValueArray != null) {
                int n = 0;
                while (n < counterValueArray.length) {
                    B b = (B)((Object)this.\u01d2.get(n));
                    b.dataReceived(counterValueArray[n]);
                    ++n;
                }
            }
        }

        protected boolean testForChildren() throws Throwable {
            return this.fChildrenEntities.size() > 0;
        }

        protected void enableCounters(Set set) throws Throwable {
            super.enableCounters(set);
            this.\u01d0 = WinPerfRootEntity.ResetQuery(this.\u01d3, this.\u01d0);
            this.\u01d2.clear();
            boolean bl = true;
            String[] stringArray = this.fCounters.values().iterator();
            while (stringArray.hasNext()) {
                B b = (B)((Object)stringArray.next());
                if (b.isEnabled()) {
                    this.\u01d2.add(b);
                    continue;
                }
                bl = false;
            }
            if (this.\u01d2.size() < 1) {
                return;
            }
            stringArray = null;
            stringArray = new String[this.\u01d2.size()];
            this.\u01d1 = new int[this.\u01d2.size()];
            int n = 0;
            Iterator iterator = this.\u01d2.iterator();
            while (iterator.hasNext()) {
                B b = (B)((Object)iterator.next());
                stringArray[n] = b.\u0153();
                this.\u01d1[n] = b.\u0154();
                ++n;
            }
            this.\u01d3 = WinPerfRootEntity.SetCounters(WinPerfRootEntity.this.machine, this.\u01d0, stringArray);
        }
    }
}

