/*
 * Decompiled with CFR 0.152.
 */
package com.liveperf.rms.agents.websphere;

import com.liveperf.common.app.exception.StartableError;
import com.liveperf.rms.EntityConfiguration;
import com.liveperf.rms.EntityDescriptorTree;
import com.liveperf.rms.EntityId;
import com.liveperf.rms.agents.Agent;
import com.liveperf.rms.agents.AgentConfiguration;
import com.liveperf.rms.agents.AgentId;
import com.liveperf.rms.agents.websphere.A;
import com.liveperf.rms.agents.websphere.exception.WebSphereNotInstalledOnHost;
import com.liveperf.rms.exception.InvalidConfiguration;
import com.liveperf.rms.exception.InvalidEntity;
import java.io.File;

public final class WebSphereAgent
implements Agent,
A {
    private Agent \u02a1;
    private Agent._A \u02a2;
    private AgentId \u02a3;

    public WebSphereAgent(AgentId agentId, Agent._A _A2) {
        this.\u02a3 = agentId;
        this.\u02a2 = _A2;
    }

    public EntityDescriptorTree configure(AgentConfiguration agentConfiguration) throws InvalidConfiguration, Throwable {
        try {
            if (this.\u02a1 == null) {
                String string = agentConfiguration.getAgentCustomConfiguration().getString("websphereagent.was_home");
                File file = new File(string);
                if (!file.exists()) {
                    throw new WebSphereNotInstalledOnHost(agentConfiguration.getDeploymentHost());
                }
                String string2 = agentConfiguration.getSystemUnderObservationVersion();
                if (string2.equals("6.0.*")) {
                    this.\u02a1 = new com.liveperf.rms.agents.websphere.v60.WebSphereAgent(this.\u02a3, this.\u02a2);
                } else if (string2.equals("5.1.*")) {
                    this.\u02a1 = new com.liveperf.rms.agents.websphere.v50.WebSphereAgent(this.\u02a3, this.\u02a2);
                } else if (string2.equals("5.0.*")) {
                    this.\u02a1 = new com.liveperf.rms.agents.websphere.v50.WebSphereAgent(this.\u02a3, this.\u02a2);
                } else {
                    throw new InvalidConfiguration("Unknown agent version: " + string2);
                }
            }
            return this.\u02a1.configure(agentConfiguration);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new WebSphereNotInstalledOnHost(agentConfiguration.getDeploymentHost());
        }
    }

    public void setListener(Agent._A _A2) {
        this.\u02a2 = _A2;
    }

    public EntityDescriptorTree configureEntity(EntityId entityId, EntityConfiguration entityConfiguration) throws InvalidEntity, InvalidConfiguration, Throwable {
        return this.\u02a1.configureEntity(entityId, entityConfiguration);
    }

    public EntityDescriptorTree getEntities(EntityId entityId, boolean bl) throws InvalidEntity, Throwable {
        return this.\u02a1.getEntities(entityId, bl);
    }

    public void collectData() throws Throwable {
        this.\u02a1.collectData();
    }

    public AgentConfiguration getConfiguration() {
        return this.\u02a1.getConfiguration();
    }

    public void start() throws StartableError {
        this.\u02a1.start();
    }

    public void stop() throws StartableError {
        this.\u02a1.stop();
    }

    public void setId(AgentId agentId) {
        this.\u02a3 = agentId;
    }

    public void deactivate() throws Throwable {
        if (this.\u02a1 != null) {
            this.\u02a1.deactivate();
        }
    }

    public boolean requiresExternalCollector() {
        return true;
    }
}

