/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.NodeSet;
import org.apache.xpath.VariableStack;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ContextNodeList;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNodeSet;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class LocPathIterator
extends PredicatedNodeTest
implements Cloneable,
NodeIterator,
ContextNodeList,
NodeList,
Serializable {
    transient int m_waitingBottom = 0;
    transient int m_varStackPos = -1;
    transient int m_varStackContext;
    private boolean m_isTopLevel = false;
    private transient int m_last = 0;
    public transient Node m_lastFetched;
    transient NodeSet m_cachedNodes;
    protected AxesWalker m_lastUsedWalker;
    protected AxesWalker m_firstWalker;
    protected transient boolean m_foundLast = false;
    protected transient DOMHelper m_dhelper;
    protected transient Node m_context;
    protected transient Node m_currentContextNode;
    protected PrefixResolver m_prefixResolver;
    protected transient XPathContext m_execContext;
    protected transient int m_next = 0;
    private transient Vector m_waiting = null;
    protected int m_analysis = 0;

    public LocPathIterator(PrefixResolver prefixResolver) {
        this.setLocPathIterator(this);
        this.m_prefixResolver = prefixResolver;
    }

    public LocPathIterator(Compiler compiler, int n, int n2) throws TransformerException {
        this(compiler, n, n2, true);
    }

    public LocPathIterator(Compiler compiler, int n, int n2, boolean bl) throws TransformerException {
        this.m_analysis = n2;
        this.setLocPathIterator(this);
        int n3 = OpMap.getFirstChildPos(n);
        if (bl) {
            this.m_lastUsedWalker = this.m_firstWalker = WalkerFactory.loadWalkers(this, compiler, n3, 0);
        }
    }

    public final void addToWaitList(AxesWalker axesWalker) {
        if (this.m_waiting == null) {
            this.m_waiting = new Vector();
        }
        this.m_waiting.addElement(axesWalker);
    }

    public boolean canTraverseOutsideSubtree() {
        if ((this.m_analysis & 0xDF86000) != 0) {
            return true;
        }
        if (this.m_firstWalker != null && this.m_firstWalker.canTraverseOutsideSubtree()) {
            return true;
        }
        return super.canTraverseOutsideSubtree();
    }

    public Object clone() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)super.clone();
        if (this.m_firstWalker != null) {
            Vector vector = this.m_waiting != null ? new Vector() : null;
            locPathIterator.m_firstWalker = this.m_firstWalker.cloneDeep(locPathIterator, vector);
            if (this.m_waiting != null) {
                locPathIterator.m_waiting = (Vector)this.m_waiting.clone();
                int n = this.m_waiting.size();
                int n2 = 0;
                while (n2 < n) {
                    AxesWalker axesWalker = (AxesWalker)this.m_waiting.elementAt(n2);
                    locPathIterator.m_waiting.setElementAt(axesWalker.cloneDeep(locPathIterator, vector), n2);
                    ++n2;
                }
            }
        }
        return locPathIterator;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        LocPathIterator locPathIterator = (LocPathIterator)this.clone();
        locPathIterator.reset();
        return locPathIterator;
    }

    public void detach() {
        this.m_context = null;
        this.m_execContext = null;
        this.m_prefixResolver = null;
        this.m_dhelper = null;
        this.m_varStackPos = -1;
        this.m_varStackContext = 0;
    }

    public XObject execute(XPathContext xPathContext) throws TransformerException {
        try {
            LocPathIterator locPathIterator = (LocPathIterator)this.clone();
            locPathIterator.initContext(xPathContext);
            return new XNodeSet(locPathIterator);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TransformerException(cloneNotSupportedException);
        }
    }

    int getAnalysis() {
        return this.m_analysis;
    }

    public NodeSet getCachedNodes() {
        return this.m_cachedNodes;
    }

    public final Node getContext() {
        return this.m_context;
    }

    public final Node getCurrentContextNode() {
        return this.m_currentContextNode;
    }

    public Node getCurrentNode() {
        return this.m_lastFetched;
    }

    public final int getCurrentPos() {
        return this.m_next;
    }

    public final DOMHelper getDOMHelper() {
        return this.m_dhelper;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public final AxesWalker getFirstWalker() {
        return this.m_firstWalker;
    }

    public final boolean getFoundLast() {
        return this.m_foundLast;
    }

    public boolean getIsTopLevel() {
        return this.m_isTopLevel;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLastPos(XPathContext xPathContext) {
        Node node;
        LocPathIterator locPathIterator;
        int n = this.getProximityPosition();
        try {
            locPathIterator = (LocPathIterator)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return -1;
        }
        locPathIterator.setPredicateCount(locPathIterator.getPredicateCount() - 1);
        while ((node = locPathIterator.nextNode()) != null) {
            ++n;
        }
        return n;
    }

    public final AxesWalker getLastUsedWalker() {
        return this.m_lastUsedWalker;
    }

    public int getLength() {
        this.resetToCachedList();
        return this.m_cachedNodes.getLength();
    }

    public final PrefixResolver getPrefixResolver() {
        return this.m_prefixResolver;
    }

    public Node getRoot() {
        return this.m_context;
    }

    AxesWalker getWaiting(int n) {
        return (AxesWalker)this.m_waiting.elementAt(n);
    }

    int getWaitingCount() {
        if (this.m_waiting == null) {
            return 0;
        }
        return this.m_waiting.size() - this.m_waitingBottom;
    }

    public int getWhatToShow() {
        return -17;
    }

    public final XPathContext getXPathContext() {
        return this.m_execContext;
    }

    void incrementNextPosition() {
        ++this.m_next;
    }

    public void initContext(XPathContext xPathContext) {
        this.m_context = xPathContext.getCurrentNode();
        this.m_currentContextNode = xPathContext.getCurrentExpressionNode();
        this.m_execContext = xPathContext;
        this.m_prefixResolver = xPathContext.getNamespaceContext();
        this.m_dhelper = xPathContext.getDOMHelper();
        if (this.m_isTopLevel) {
            VariableStack variableStack = xPathContext.getVarStack();
            this.m_varStackPos = variableStack.getSearchStartOrTop();
            this.m_varStackContext = variableStack.getContextPos();
        }
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public Node item(int n) {
        this.resetToCachedList();
        return this.m_cachedNodes.item(n);
    }

    public Node nextNode() throws DOMException {
        if (this.m_cachedNodes != null && this.m_cachedNodes.getCurrentPos() < this.m_cachedNodes.size()) {
            Node node = this.m_cachedNodes.nextNode();
            this.setCurrentPos(this.m_cachedNodes.getCurrentPos());
            return node;
        }
        if (this.m_varStackPos == -1) {
            if (this.m_firstWalker.getRoot() == null) {
                this.setNextPosition(0);
                this.m_firstWalker.setRoot(this.m_context);
                this.m_lastUsedWalker = this.m_firstWalker;
            }
            return this.returnNextNode(this.m_firstWalker.nextNode());
        }
        VariableStack variableStack = this.m_execContext.getVarStack();
        int n = variableStack.getSearchStart();
        variableStack.setSearchStart(this.m_varStackPos);
        variableStack.pushContextPosition(this.m_varStackContext);
        if (this.m_firstWalker.getRoot() == null) {
            this.setNextPosition(0);
            this.m_firstWalker.setRoot(this.m_context);
            this.m_lastUsedWalker = this.m_firstWalker;
        }
        Node node = this.returnNextNode(this.m_firstWalker.nextNode());
        variableStack.setSearchStart(n);
        variableStack.popContextPosition();
        return node;
    }

    public Node previousNode() throws DOMException {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not iterate to a previous node!");
        }
        return this.m_cachedNodes.previousNode();
    }

    public final void removeFromWaitList(AxesWalker axesWalker) {
        if (this.m_waiting != null) {
            this.m_waiting.removeElement(axesWalker);
        }
    }

    public void reset() {
        this.m_foundLast = false;
        this.m_lastFetched = null;
        this.m_next = 0;
        this.m_last = 0;
        this.m_waitingBottom = 0;
        if (this.m_firstWalker != null) {
            this.m_lastUsedWalker = this.m_firstWalker;
            this.m_firstWalker.setRoot(this.m_context);
            if (this.m_waiting != null) {
                this.m_waiting.removeAllElements();
            }
        }
    }

    private void resetToCachedList() {
        int n = this.getCurrentPos();
        if (this.m_cachedNodes == null || n != 0) {
            this.setShouldCacheNodes(true);
        }
        this.runTo(-1);
        this.setCurrentPos(n);
    }

    protected Node returnNextNode(Node node) {
        if (node != null) {
            if (this.m_cachedNodes != null) {
                this.m_cachedNodes.addElement(node);
            }
            this.incrementNextPosition();
        }
        this.m_lastFetched = node;
        if (node == null) {
            this.m_foundLast = true;
        }
        return node;
    }

    /*
     * Unable to fully structure code
     */
    public void runTo(int var1_1) {
        block3: {
            if (this.m_foundLast || var1_1 >= 0 && var1_1 <= this.getCurrentPos()) {
                return;
            }
            if (var1_1 != -1) ** GOTO lbl-1000
            while ((var2_2 = this.nextNode()) != null) {
            }
            break block3;
            while (this.getCurrentPos() < var1_1) lbl-1000:
            // 2 sources

            {
                if ((var2_3 = this.nextNode()) != null) continue;
            }
        }
    }

    void setAnalysis(int n) {
        this.m_analysis = n;
    }

    public final void setCurrentContextNode(Node node) {
        this.m_currentContextNode = node;
    }

    public void setCurrentPos(int n) {
        if (this.m_cachedNodes == null) {
            throw new RuntimeException("This NodeSet can not do indexing or counting functions!");
        }
        this.setNextPosition(n);
        this.m_cachedNodes.setCurrentPos(n);
    }

    public void setIsTopLevel(boolean bl) {
        this.m_isTopLevel = bl;
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    public final void setLastUsedWalker(AxesWalker axesWalker) {
        this.m_lastUsedWalker = axesWalker;
    }

    protected void setNextPosition(int n) {
        this.m_next = n;
    }

    public void setShouldCacheNodes(boolean bl) {
        this.m_cachedNodes = bl ? new NodeSet() : null;
    }

    public int size() {
        if (this.m_cachedNodes == null) {
            return 0;
        }
        return this.m_cachedNodes.size();
    }
}

