/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import org.apache.xalan.stree.CommentImpl;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.ElementImpl;
import org.apache.xalan.stree.Parent;
import org.apache.xalan.stree.TextImpl;
import org.apache.xml.utils.DOMBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StreeDOMBuilder
extends DOMBuilder {
    TextImpl m_text_buffer = null;
    protected DocumentImpl m_docImpl;
    private boolean m_previousIsText = false;
    private static final boolean DEBUG = false;

    public StreeDOMBuilder(Document document) {
        super(document);
        this.m_docImpl = (DocumentImpl)document;
    }

    public StreeDOMBuilder(Document document, DocumentFragment documentFragment) {
        super(document, documentFragment);
        this.m_docImpl = (DocumentImpl)document;
    }

    public StreeDOMBuilder(Document document, Node node) {
        super(document, node);
        this.m_docImpl = (DocumentImpl)document;
    }

    void appendAccumulatedText(Node node, char[] cArray, int n, int n2) throws SAXException {
        if (this.m_text_buffer == null) {
            this.m_text_buffer = new TextImpl(this.m_docImpl, cArray, n, n2);
            this.setPreviousIsText(true);
        } else {
            this.m_text_buffer.appendText(cArray, n, n2);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, cArray, n, n2);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, cArray, n, n2);
            this.setPreviousIsText(true);
        }
    }

    public void charactersRaw(char[] cArray, int n, int n2) throws SAXException {
        this.setPreviousIsText(false);
        this.append(this.m_doc.createProcessingInstruction("xslt-next-is-raw", "formatter-to-dom"));
        this.append(new TextImpl(this.m_docImpl, cArray, n, n2));
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        this.setPreviousIsText(false);
        this.append(new CommentImpl(this.m_docImpl, cArray, n, n2));
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.setPreviousIsText(false);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.setPreviousIsText(false);
        super.endElement(string, string2, string3);
    }

    boolean getPreviousIsText() {
        return this.m_previousIsText;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.getPreviousIsText()) {
            this.appendAccumulatedText(this.m_text_buffer, cArray, n, n2);
        } else {
            this.m_text_buffer = new TextImpl(this.m_docImpl, cArray, n, n2);
        }
        this.setPreviousIsText(true);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.setPreviousIsText(false);
        super.processingInstruction(string, string2);
    }

    public void setIDAttribute(String string, Element element) {
        this.m_docImpl.setIDAttribute(string, element);
    }

    public void setPreviousIsText(boolean bl) throws SAXException {
        if (this.m_previousIsText && !bl) {
            if (!this.m_docImpl.m_sourceTreeHandler.getShouldStripWhitespace() || !this.m_text_buffer.isWhitespace()) {
                this.append(this.m_text_buffer);
            }
            this.m_text_buffer = null;
        }
        this.m_previousIsText = bl;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.setPreviousIsText(false);
        ElementImpl elementImpl = string == null || string.length() == 0 ? (ElementImpl)this.m_doc.createElement(string3) : (ElementImpl)this.m_doc.createElementNS(string, string3);
        elementImpl.m_uid = ++((DocImpl)this.m_doc).m_docOrderCount;
        elementImpl.m_level = (short)(((Parent)(this.m_currentNode == null ? this.m_doc : this.m_currentNode)).m_level + 1);
        int n = attributes.getLength();
        if (n != 0) {
            int n2 = 0;
            while (n2 < n) {
                String string4;
                if (attributes.getType(n2).equalsIgnoreCase("ID")) {
                    this.setIDAttribute(attributes.getValue(n2), elementImpl);
                }
                if ((string4 = attributes.getURI(n2)) == null) {
                    string4 = "";
                }
                if (string4.length() == 0 || attributes.getQName(n2).startsWith("xmlns:")) {
                    elementImpl.setAttribute(attributes.getQName(n2), attributes.getValue(n2));
                } else {
                    elementImpl.setAttributeNS(string4, attributes.getQName(n2), attributes.getValue(n2));
                }
                ++n2;
            }
        }
        this.append(elementImpl);
        this.m_elemStack.push(elementImpl);
        this.m_currentNode = elementImpl;
    }
}

