/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.enum;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.janino.util.enum.EnumeratorFormatException;

public abstract class Enumerator {
    private final int value;
    private static final Map mappings = new HashMap();

    protected Enumerator(int n) {
        this.value = n;
    }

    protected Enumerator(String string) throws EnumeratorFormatException {
        Integer n = (Integer)this.getMapping().get(string);
        if (n == null) {
            throw new EnumeratorFormatException(string);
        }
        this.value = n;
    }

    public boolean equals(Object object) {
        return object.getClass() == this.getClass() && this.value == ((Enumerator)object).value;
    }

    private Map getMapping() {
        Class<?> clazz = this.getClass();
        Map map = (Map)mappings.get(clazz);
        if (map != null) {
            return map;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            Field field = fieldArray[n];
            if (field.getType() == clazz && (field.getModifiers() & 0x18) == 24) {
                try {
                    Enumerator enumerator = (Enumerator)field.get(null);
                    hashMap.put(field.getName(), new Integer(enumerator.value));
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("SNO: Field \"" + field + "\" is inaccessible");
                }
            }
            ++n;
        }
        mappings.put(this.getClass(), hashMap);
        return hashMap;
    }

    public String toString() {
        Iterator iterator = this.getMapping().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.value != (Integer)entry.getValue()) continue;
            return (String)entry.getKey();
        }
        return Integer.toString(this.value);
    }
}

