/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.Location;
import org.codehaus.janino.UnicodeUnescapeReader;
import org.codehaus.janino.util.TeeReader;

public class Scanner {
    public static final Integer MAGIC_INTEGER = new Integer(Integer.MIN_VALUE);
    public static final Long MAGIC_LONG = new Long(Long.MIN_VALUE);
    private static final boolean DEBUG = false;
    private String optionalFileName;
    private Reader in;
    private int nextChar = -1;
    private boolean crLfPending = false;
    private short nextCharLineNumber;
    private short nextCharColumnNumber;
    private Token nextToken;
    private Token nextButOneToken;
    private short tokenLineNumber;
    private short tokenColumnNumber;
    private static final Map JAVA_KEYWORDS = new HashMap();
    private static final Map JAVA_OPERATORS;

    static {
        String[] stringArray = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};
        int n = 0;
        while (n < stringArray.length) {
            JAVA_KEYWORDS.put(stringArray[n], stringArray[n]);
            ++n;
        }
        JAVA_OPERATORS = new HashMap();
        stringArray = new String[]{"(", ")", "{", "}", "[", "]", ";", ",", ".", "=", ">", "<", "!", "~", "?", ":", "==", "<=", ">=", "!=", "&&", "||", "++", "--", "+", "-", "*", "/", "&", "|", "^", "%", "<<", ">>", ">>>", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="};
        n = 0;
        while (n < stringArray.length) {
            JAVA_OPERATORS.put(stringArray[n], stringArray[n]);
            ++n;
        }
    }

    public Scanner(File file) throws ScanException, IOException {
        this(file.getAbsolutePath(), new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(file)))), true, 1, 0);
    }

    public Scanner(File file, String string) throws ScanException, IOException {
        this(file.getAbsolutePath(), new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), string)), true, 1, 0);
    }

    public Scanner(String string) throws ScanException, IOException {
        this(string, new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(string)))), true, 1, 0);
    }

    public Scanner(String string, InputStream inputStream) throws ScanException, IOException {
        this(string, new BufferedReader(new InputStreamReader(inputStream)), false, 1, 0);
    }

    public Scanner(String string, InputStream inputStream, String string2) throws ScanException, IOException {
        this(string, new BufferedReader(string2 == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string2)), false, 1, 0);
    }

    public Scanner(String string, Reader reader) throws ScanException, IOException {
        this(string, reader, false, 1, 0);
    }

    public Scanner(String string, Reader reader, short s, short s2) throws ScanException, IOException {
        this(string, reader, false, s, s2);
    }

    private Scanner(String string, Reader reader, boolean bl, short s, short s2) throws ScanException, IOException {
        try {
            if (string == null && Boolean.getBoolean("org.codehaus.janino.source_debugging.enable")) {
                String string2 = System.getProperty("org.codehaus.janino.source_debugging.dir");
                File file = string2 == null ? null : new File(string2);
                File file2 = File.createTempFile("janino", ".java", file);
                file2.deleteOnExit();
                reader = new TeeReader(reader, new FileWriter(file2), true);
                string = file2.getAbsolutePath();
            }
            this.optionalFileName = string;
            this.in = new UnicodeUnescapeReader(reader);
            this.nextCharLineNumber = s;
            this.nextCharColumnNumber = s2;
            this.readNextChar();
            this.nextToken = this.internalRead();
            this.nextButOneToken = this.internalRead();
        }
        catch (ScanException scanException) {
            if (bl) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            throw scanException;
        }
        catch (IOException iOException) {
            if (bl) {
                try {
                    reader.close();
                }
                catch (IOException iOException2) {}
            }
            throw iOException;
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    private static void escapeCharacter(char c, StringBuffer stringBuffer) {
        int n = "\b\t\n\f\r\\".indexOf(c);
        if (n != -1) {
            stringBuffer.append('\\').append("btnfr\\".charAt(n));
        } else if (c >= ' ' && c < '\u00ff' && c != '\u007f') {
            stringBuffer.append(c);
        } else {
            stringBuffer.append("\\u");
            String string = Integer.toHexString(0xFFFF & c);
            int n2 = string.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string);
        }
    }

    /*
     * Exception decompiling
     */
    private Token internalRead() throws ScanException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 8[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String literalValueToString(Object object) {
        if (object instanceof String) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            String string = (String)object;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (c == '\"') {
                    stringBuffer.append("\\\"");
                } else {
                    Scanner.escapeCharacter(c, stringBuffer);
                }
                ++n;
            }
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        if (object instanceof Character) {
            char c = ((Character)object).charValue();
            if (c == '\'') {
                return "'\\''";
            }
            StringBuffer stringBuffer = new StringBuffer("'");
            Scanner.escapeCharacter(c, stringBuffer);
            return stringBuffer.append('\'').toString();
        }
        if (object instanceof Integer) {
            if (object == MAGIC_INTEGER) {
                return "2147483648";
            }
            return object.toString();
        }
        if (object instanceof Long) {
            if (object == MAGIC_LONG) {
                return "9223372036854775808L";
            }
            return String.valueOf(object.toString()) + 'L';
        }
        if (object instanceof Float) {
            return String.valueOf(object.toString()) + 'F';
        }
        if (object instanceof Double) {
            return String.valueOf(object.toString()) + 'D';
        }
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object == null) {
            return "null";
        }
        throw new RuntimeException("Unexpected value type \"" + object.getClass().getName() + "\"");
    }

    public Token peek() {
        return this.nextToken;
    }

    public Token peekNextButOne() {
        return this.nextButOneToken;
    }

    public Token read() throws ScanException, IOException {
        Token token = this.nextToken;
        this.nextToken = this.nextButOneToken;
        this.nextButOneToken = this.internalRead();
        return token;
    }

    private void readNextChar() throws IOException {
        this.nextChar = this.in.read();
        if (this.nextChar == 13) {
            this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
            this.nextCharColumnNumber = 0;
            this.crLfPending = true;
        } else if (this.nextChar == 10) {
            if (this.crLfPending) {
                this.crLfPending = false;
            } else {
                this.nextCharLineNumber = (short)(this.nextCharLineNumber + 1);
                this.nextCharColumnNumber = 0;
            }
        } else {
            this.nextCharColumnNumber = (short)(this.nextCharColumnNumber + 1);
        }
    }

    private Token scanNumericLiteral(int n) throws ScanException, IOException {
        StringBuffer stringBuffer = n == 2 ? new StringBuffer("0.") : new StringBuffer();
        int n2 = n;
        while (true) {
            switch (n2) {
                case 0: {
                    if (this.nextChar == 48) {
                        n2 = 6;
                        break;
                    }
                    stringBuffer.append((char)this.nextChar);
                    n2 = 1;
                    break;
                }
                case 1: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 46) {
                        stringBuffer.append('.');
                        n2 = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 10);
                }
                case 2: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 101 || this.nextChar == 69) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    return this.stringToDoubleLiteralToken(stringBuffer.toString());
                }
                case 3: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 5;
                        break;
                    }
                    if (this.nextChar == 45 || this.nextChar == 43) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 4;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\"");
                }
                case 4: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 5;
                        break;
                    }
                    throw new ScanException("Exponent missing after \"E\" and sign");
                }
                case 5: {
                    if (Character.isDigit((char)this.nextChar)) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken(stringBuffer.toString());
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken(stringBuffer.toString());
                    }
                    return this.stringToDoubleLiteralToken(stringBuffer.toString());
                }
                case 6: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 7;
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken("0", 10);
                    }
                    if (this.nextChar == 102 || this.nextChar == 70) {
                        this.readNextChar();
                        return this.stringToFloatLiteralToken("0");
                    }
                    if (this.nextChar == 100 || this.nextChar == 68) {
                        this.readNextChar();
                        return this.stringToDoubleLiteralToken("0");
                    }
                    if (this.nextChar == 46) {
                        stringBuffer.append("0.");
                        n2 = 2;
                        break;
                    }
                    if (this.nextChar == 69 || this.nextChar == 101) {
                        stringBuffer.append('E');
                        n2 = 3;
                        break;
                    }
                    if (this.nextChar == 120 || this.nextChar == 88) {
                        n2 = 8;
                        break;
                    }
                    return this.stringToIntegerLiteralToken("0", 10);
                }
                case 7: {
                    if ("01234567".indexOf(this.nextChar) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 8);
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 8);
                }
                case 8: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        n2 = 9;
                        break;
                    }
                    throw new ScanException("Hex digit expected after \"0x\"");
                }
                case 9: {
                    if (Character.digit((char)this.nextChar, 16) != -1) {
                        stringBuffer.append((char)this.nextChar);
                        break;
                    }
                    if (this.nextChar == 108 || this.nextChar == 76) {
                        this.readNextChar();
                        return this.stringToLongLiteralToken(stringBuffer.toString(), 16);
                    }
                    return this.stringToIntegerLiteralToken(stringBuffer.toString(), 16);
                }
            }
            this.readNextChar();
        }
    }

    private LiteralToken stringToDoubleLiteralToken(String string) throws ScanException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanException("Value of double literal \"" + string + "\" is out of range");
        }
        return new LiteralToken(new Double(d));
    }

    private LiteralToken stringToFloatLiteralToken(String string) throws ScanException {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanException("Value of float literal \"" + string + "\" is out of range");
        }
        return new LiteralToken(new Float(f));
    }

    private LiteralToken stringToIntegerLiteralToken(String string, int n) throws ScanException {
        int n2;
        switch (n) {
            case 10: {
                if (string.equals("2147483648")) {
                    return new LiteralToken(MAGIC_INTEGER);
                }
                try {
                    n2 = Integer.parseInt(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScanException("Value of decimal integer literal \"" + string + "\" is out of range");
                }
            }
            case 8: {
                n2 = 0;
                int n3 = 0;
                while (n3 < string.length()) {
                    if ((n2 & 0xE0000000) != 0) {
                        throw new ScanException("Value of octal integer literal \"" + string + "\" is out of range");
                    }
                    n2 = (n2 << 3) + Character.digit(string.charAt(n3), 8);
                    ++n3;
                }
                break;
            }
            case 16: {
                n2 = 0;
                int n4 = 0;
                while (n4 < string.length()) {
                    if ((n2 & 0xF0000000) != 0) {
                        throw new ScanException("Value of hexadecimal integer literal \"" + string + "\" is out of range");
                    }
                    n2 = (n2 << 4) + Character.digit(string.charAt(n4), 16);
                    ++n4;
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + n);
            }
        }
        return new LiteralToken(new Integer(n2));
    }

    private LiteralToken stringToLongLiteralToken(String string, int n) throws ScanException {
        long l;
        switch (n) {
            case 10: {
                if (string.equals("9223372036854775808")) {
                    return new LiteralToken(MAGIC_LONG);
                }
                try {
                    l = Long.parseLong(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScanException("Value of decimal long literal \"" + string + "\" is out of range");
                }
            }
            case 8: {
                l = 0L;
                int n2 = 0;
                while (n2 < string.length()) {
                    if ((l & 0xE000000000000000L) != 0L) {
                        throw new ScanException("Value of octal long literal \"" + string + "\" is out of range");
                    }
                    l = (l << 3) + (long)Character.digit(string.charAt(n2), 8);
                    ++n2;
                }
                break;
            }
            case 16: {
                l = 0L;
                int n3 = 0;
                while (n3 < string.length()) {
                    if ((l & 0xF000000000000000L) != 0L) {
                        throw new ScanException("Value of hexadecimal long literal \"" + string + "\" is out of range");
                    }
                    l = (l << 4) + (long)Character.digit(string.charAt(n3), 16);
                    ++n3;
                }
                break;
            }
            default: {
                throw new RuntimeException("Illegal radix " + n);
            }
        }
        return new LiteralToken(new Long(l));
    }

    private char unescapeCharacterLiteral() throws ScanException, IOException {
        if (this.nextChar == -1) {
            throw new ScanException("EOF in character literal");
        }
        if (this.nextChar != 92) {
            char c = (char)this.nextChar;
            this.readNextChar();
            return c;
        }
        this.readNextChar();
        int n = "btnfr".indexOf(this.nextChar);
        if (n != -1) {
            char c = "\b\t\n\f\r".charAt(n);
            this.readNextChar();
            return c;
        }
        n = "01234567".indexOf(this.nextChar);
        if (n != -1) {
            int n2 = n;
            this.readNextChar();
            n = "01234567".indexOf(this.nextChar);
            if (n == -1) {
                return (char)n2;
            }
            n2 = 8 * n2 + n;
            this.readNextChar();
            n = "01234567".indexOf(this.nextChar);
            if (n == -1) {
                return (char)n2;
            }
            if ((n2 = 8 * n2 + n) > 255) {
                throw new ScanException("Invalid octal escape");
            }
            this.readNextChar();
            return (char)n2;
        }
        char c = (char)this.nextChar;
        this.readNextChar();
        return c;
    }

    public abstract class Token {
        private String optionalFileName;
        private short lineNumber;
        private short columnNumber;
        private Location location = null;

        private Token() {
            this.optionalFileName = Scanner.this.optionalFileName;
            this.lineNumber = Scanner.this.tokenLineNumber;
            this.columnNumber = Scanner.this.tokenColumnNumber;
        }

        public String getIdentifier() throws ScanException {
            throw new ScanException("Not an identifier token");
        }

        public String getKeyword() throws ScanException {
            throw new ScanException("Not a keyword token");
        }

        public Object getLiteralValue() throws ScanException {
            throw new ScanException("Not a literal token");
        }

        public Location getLocation() {
            if (this.location == null) {
                this.location = new Location(this.optionalFileName, this.lineNumber, this.columnNumber);
            }
            return this.location;
        }

        public String getOperator() throws ScanException {
            throw new ScanException("Not an operator token");
        }

        public boolean isEOF() {
            return false;
        }

        public boolean isIdentifier() {
            return false;
        }

        public boolean isIdentifier(String string) {
            return false;
        }

        public boolean isKeyword() {
            return false;
        }

        public boolean isKeyword(String string) {
            return false;
        }

        public boolean isKeyword(String[] stringArray) {
            return false;
        }

        public boolean isLiteral() {
            return false;
        }

        public boolean isOperator() {
            return false;
        }

        public boolean isOperator(String string) {
            return false;
        }

        public boolean isOperator(String[] stringArray) {
            return false;
        }
    }

    public class KeywordToken
    extends Token {
        private final String keyword;

        private KeywordToken(String string) {
            class Org_codehaus_janino_Scanner$1 {
                /* synthetic */ Org_codehaus_janino_Scanner$1() {
                }
            }
            this.keyword = string;
        }

        /* synthetic */ KeywordToken(1 var2_2, String string) {
            this(string);
        }

        public String getKeyword() {
            return this.keyword;
        }

        public boolean isKeyword() {
            return true;
        }

        public boolean isKeyword(String string) {
            return this.keyword == string;
        }

        public boolean isKeyword(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.keyword == stringArray[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String toString() {
            return this.keyword;
        }
    }

    public class IdentifierToken
    extends Token {
        private final String identifier;

        private IdentifierToken(String string) {
            this.identifier = string;
        }

        /* synthetic */ IdentifierToken(1 var2_2, String string) {
            this(string);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean isIdentifier() {
            return true;
        }

        public boolean isIdentifier(String string) {
            return this.identifier.equals(string);
        }

        public String toString() {
            return this.identifier;
        }
    }

    public final class LiteralToken
    extends Token {
        private final Object value;

        public LiteralToken(Object object) {
            this.value = object;
        }

        public Object getLiteralValue() {
            return this.value;
        }

        public final boolean isLiteral() {
            return true;
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }
    }

    public class OperatorToken
    extends Token {
        private final String operator;

        private OperatorToken(String string) {
            this.operator = string;
        }

        /* synthetic */ OperatorToken(1 var2_2, String string) {
            this(string);
        }

        public String getOperator() {
            return this.operator;
        }

        public boolean isOperator() {
            return true;
        }

        public boolean isOperator(String string) {
            return this.operator == string;
        }

        public boolean isOperator(String[] stringArray) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.operator == stringArray[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public String toString() {
            return this.operator;
        }
    }

    public class EOFToken
    extends Token {
        public EOFToken() {
        }

        public boolean isEOF() {
            return true;
        }

        public String toString() {
            return "End-Of-File";
        }
    }

    public class ScanException
    extends LocatedException {
        public ScanException(String string) {
            super(string, new Location(Scanner.this.optionalFileName, Scanner.this.nextCharLineNumber, Scanner.this.nextCharColumnNumber));
        }
    }

    public static class LocatedException
    extends Exception {
        private final Location optionalLocation;

        LocatedException(String string, Location location) {
            super(string);
            this.optionalLocation = location;
        }

        public Location getLocation() {
            return this.optionalLocation;
        }

        public String getMessage() {
            return this.optionalLocation == null ? super.getMessage() : String.valueOf(this.optionalLocation.toString()) + ": " + super.getMessage();
        }
    }
}

