/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Scanner;

public class Parser {
    private static final short[] MUTUALS = new short[]{7};
    private final Scanner scanner;

    public Parser(Scanner scanner) {
        this.scanner = scanner;
    }

    private static String join(String[] stringArray, String string) {
        if (stringArray == null) {
            return "(null)";
        }
        if (stringArray.length == 0) {
            return "(zero length array)";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string).append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Java.Atom parseAdditiveExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseMultiplicativeExpression(scope);
        while (this.scanner.peek().isOperator(new String[]{"+", "-"})) {
            atom = new Java.BinaryOperation(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), this.scanner.read().getOperator(), this.parseMultiplicativeExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseAndExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseEqualityExpression(scope);
        while (this.scanner.peek().isOperator("&")) {
            atom = new Java.BinaryOperation(this.scanner.read().getLocation(), atom.toRvalueOrPE(), "&", this.parseEqualityExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Rvalue[] parseArgumentList(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        while (true) {
            arrayList.add(this.parseExpression(scope).toRvalueOrPE());
            if (!this.scanner.peek().isOperator(",")) break;
            this.scanner.read();
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Rvalue[] parseArguments(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected");
        }
        if (this.scanner.peek().isOperator(")")) {
            this.scanner.read();
            return new Java.Rvalue[0];
        }
        Java.Rvalue[] rvalueArray = this.parseArgumentList(scope);
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis after argument list expected");
        }
        return rvalueArray;
    }

    public Java.Rvalue parseArrayInitializer(Java.Scope scope, Java.ArrayType arrayType) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isOperator("{")) {
            this.throwParseException("\"{\" expected");
        }
        Location location = this.scanner.read().getLocation();
        Java.Type type = arrayType.getComponentType();
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        while (!this.scanner.peek().isOperator("}")) {
            arrayList.add(this.parseVariableInitializer(scope, type));
            if (this.scanner.peek().isOperator("}")) break;
            if (!this.scanner.peek().isOperator(",")) {
                this.throwParseException("\",\" or \"}\" expected");
            }
            this.scanner.read();
        }
        this.scanner.read();
        return new Java.ArrayInitializer(location, arrayType, arrayList.toArray(new Java.Rvalue[arrayList.size()]));
    }

    public Java.Atom parseAssignmentExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalExpression(scope);
        if (this.scanner.peek().isOperator(new String[]{"=", "+=", "-=", "*=", "/=", "&=", "|=", "^=", "%=", "<<=", ">>=", ">>>="})) {
            String string = this.scanner.peek().getOperator();
            Location location = this.scanner.read().getLocation();
            Java.Lvalue lvalue = atom.toLvalueOrPE();
            Java.Rvalue rvalue = this.parseAssignmentExpression(scope).toRvalueOrPE();
            return new Java.Assignment(location, lvalue, string, rvalue);
        }
        return atom;
    }

    public Java.Block parseBlock(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isOperator("{")) {
            this.throwParseException("\"{\" expected");
        }
        Java.Block block = new Java.Block(this.scanner.read().getLocation(), scope);
        block.addStatements(this.parseBlockStatements(block));
        if (!this.scanner.read().isOperator("}")) {
            this.throwParseException("\"}\" expected");
        }
        return block;
    }

    public Java.BlockStatement parseBlockStatement(Java.Block block) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":") || this.scanner.peek().isKeyword(new String[]{"if", "for", "while", "do", "try", "switch", "synchronized", "return", "throw", "break", "continue"}) || this.scanner.peek().isOperator(new String[]{"{", ";"})) {
            return this.parseStatement(block);
        }
        if (this.scanner.peek().isKeyword("class")) {
            this.scanner.read();
            Java.LocalClassDeclaration localClassDeclaration = (Java.LocalClassDeclaration)this.parseClassDeclarationRest(block, (short)18);
            return new Java.LocalClassDeclarationStatement(block, localClassDeclaration);
        }
        if (this.scanner.peek().isKeyword("final")) {
            Location location = this.scanner.read().getLocation();
            Java.Type type = this.parseType(block);
            Java.LocalVariableDeclarationStatement localVariableDeclarationStatement = new Java.LocalVariableDeclarationStatement(location, block, 16, type, this.parseLocalVariableDeclarators(block, type));
            if (!this.scanner.read().isOperator(";")) {
                this.throwParseException("Semicolon expected after local variable declarator");
            }
            return localVariableDeclarationStatement;
        }
        Java.Atom atom = this.parseExpression(block);
        if (this.scanner.peek().isOperator(";")) {
            this.scanner.read();
            return new Java.ExpressionStatement(atom.toRvalueOrPE(), (Java.Scope)block);
        }
        Java.Type type = atom.toTypeOrPE();
        Java.LocalVariableDeclarationStatement localVariableDeclarationStatement = new Java.LocalVariableDeclarationStatement(atom.getLocation(), block, 0, type, this.parseLocalVariableDeclarators(block, type));
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected after local variable declarator");
        }
        return localVariableDeclarationStatement;
    }

    public List parseBlockStatements(Java.Block block) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.BlockStatement> arrayList = new ArrayList<Java.BlockStatement>();
        while (!(this.scanner.peek().isOperator("}") || this.scanner.peek().isKeyword("case") || this.scanner.peek().isKeyword("default"))) {
            arrayList.add(this.parseBlockStatement(block));
        }
        return arrayList;
    }

    int parseBracketsOpt() throws ParseException, Scanner.ScanException, IOException {
        int n = 0;
        while (this.scanner.peek().isOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
            this.scanner.read();
            this.scanner.read();
            ++n;
        }
        return n;
    }

    public Java.Statement parseBreakStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("break")) {
            this.throwParseException("\"break\" expected");
        }
        Location location = this.scanner.read().getLocation();
        String string = null;
        if (this.scanner.peek().isIdentifier()) {
            string = this.scanner.read().getIdentifier();
        }
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected at end of \"break\" statement");
        }
        return new Java.BreakStatement(location, scope, string);
    }

    public void parseClassBody(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isOperator("{")) {
            this.throwParseException("\"{\" expected at start of class body");
        }
        this.scanner.read();
        while (true) {
            if (this.scanner.peek().isOperator("}")) {
                this.scanner.read();
                return;
            }
            this.parseClassBodyDeclaration(classDeclaration);
        }
    }

    public void parseClassBodyDeclaration(Java.ClassDeclaration classDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isOperator(";")) {
            this.scanner.read();
            return;
        }
        short s = this.parseModifiersOpt();
        if (this.scanner.peek().isOperator("{")) {
            if ((s & 0xFFFFFFF7) != 0) {
                this.throwParseException("Only modifier \"static\" allowed on initializer");
            }
            Java.Initializer initializer = new Java.Initializer(this.scanner.peek().getLocation(), classDeclaration, (s & 8) != 0);
            initializer.setBlock(this.parseBlock(initializer));
            classDeclaration.addVariableDeclaratorOrInitializer(initializer);
            return;
        }
        if (this.scanner.peek().isKeyword("void")) {
            Location location = this.scanner.read().getLocation();
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Method name expected after \"void\"");
            }
            String string = this.scanner.read().getIdentifier();
            classDeclaration.declaredMethods.add(this.parseMethodDeclaratorRest(classDeclaration, s, new Java.BasicType(location, 0), string));
            return;
        }
        if (this.scanner.peek().isKeyword("class")) {
            this.scanner.read();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(classDeclaration, s)));
            return;
        }
        if (this.scanner.peek().isKeyword("interface")) {
            this.scanner.read();
            classDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(classDeclaration, (short)(s | 8))));
            return;
        }
        if (classDeclaration instanceof Java.NamedClassDeclaration && this.scanner.peek().isIdentifier(((Java.NamedClassDeclaration)classDeclaration).getName()) && this.scanner.peekNextButOne().isOperator("(")) {
            classDeclaration.addConstructor(this.parseConstructorDeclarator(classDeclaration, s));
            return;
        }
        Java.Type type = this.parseType(classDeclaration);
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Identifier expected in member declaration");
        }
        Location location = this.scanner.peek().getLocation();
        String string = this.scanner.read().getIdentifier();
        if (this.scanner.peek().isOperator("(")) {
            classDeclaration.declaredMethods.add(this.parseMethodDeclaratorRest(classDeclaration, s, type, string));
            return;
        }
        Java.FieldDeclarator fieldDeclarator = new Java.FieldDeclarator(location, classDeclaration, s, type);
        Java.VariableDeclarator[] variableDeclaratorArray = this.parseFieldDeclaratorsRest(fieldDeclarator, type, string);
        fieldDeclarator.setVariableDeclarators(variableDeclaratorArray);
        classDeclaration.addVariableDeclaratorOrInitializer(fieldDeclarator);
    }

    public Java.NamedClassDeclaration parseClassDeclarationRest(Java.Scope scope, short s) throws ParseException, Scanner.ScanException, IOException {
        Java.NamedClassDeclaration namedClassDeclaration;
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Class name expected after \"class\"");
        }
        Location location = this.scanner.peek().getLocation();
        String string = this.scanner.read().getIdentifier();
        Parser.verifyIdentifierIsConventionalClassOrInterfaceName(string, location);
        Java.ReferenceType referenceType = null;
        if (this.scanner.peek().isKeyword("extends")) {
            this.scanner.read();
            referenceType = this.parseReferenceType(scope);
        }
        Java.Type[] typeArray = new Java.ReferenceType[]{};
        if (this.scanner.peek().isKeyword("implements")) {
            this.scanner.read();
            typeArray = this.parseReferenceTypeList(scope);
        }
        if (scope instanceof Java.CompilationUnit) {
            namedClassDeclaration = new Java.PackageMemberClassDeclaration(location, (Java.CompilationUnit)scope, s, string, (Java.Type)referenceType, typeArray);
        } else if (scope instanceof Java.NamedTypeDeclaration) {
            namedClassDeclaration = new Java.MemberClassDeclaration(location, (Java.NamedTypeDeclaration)scope, s, string, (Java.Type)referenceType, typeArray);
        } else if (scope instanceof Java.Block) {
            namedClassDeclaration = new Java.LocalClassDeclaration(location, (Java.Block)scope, s, string, (Java.Type)referenceType, typeArray);
        } else {
            throw new RuntimeException("SNO: Class declaration in unexpected scope " + scope.getClass().getName());
        }
        this.parseClassBody(namedClassDeclaration);
        return namedClassDeclaration;
    }

    public Java.NamedTypeDeclaration parseClassOrInterfaceDeclaration(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.AbstractTypeDeclaration abstractTypeDeclaration;
        short s = this.parseModifiersOpt();
        if (this.scanner.peek().isKeyword("class")) {
            this.scanner.read();
            abstractTypeDeclaration = this.parseClassDeclarationRest(scope, s);
        } else if (this.scanner.peek().isKeyword("interface")) {
            this.scanner.read();
            abstractTypeDeclaration = this.parseInterfaceDeclarationRest(scope, s);
        } else {
            this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in class or interface declaration");
            return null;
        }
        return abstractTypeDeclaration;
    }

    public Java.CompilationUnit parseCompilationUnit() throws ParseException, Scanner.ScanException, IOException {
        Object object;
        Java.CompilationUnit compilationUnit = new Java.CompilationUnit(this.scanner.peek().getLocation().getFileName());
        if (this.scanner.peek().isKeyword("package")) {
            this.scanner.read();
            object = this.scanner.peek().getLocation();
            String string = Parser.join(this.parseQualifiedIdentifier(), ".");
            Parser.verifyStringIsConventionalPackageName(string, (Location)object);
            compilationUnit.setPackageDeclaration(new Java.PackageDeclaration((Location)object, string));
            if (!this.scanner.read().isOperator(";")) {
                this.throwParseException("Semicolon expected after \"package\" directive");
            }
        }
        while (this.scanner.peek().isKeyword("import")) {
            compilationUnit.addImportDeclaration(this.parseImportDeclaration());
        }
        while (!this.scanner.peek().isEOF()) {
            object = (Java.PackageMemberTypeDeclaration)this.parseTypeDeclaration(compilationUnit);
            if (object == null) continue;
            compilationUnit.addPackageMemberTypeDeclaration((Java.PackageMemberTypeDeclaration)object);
        }
        return compilationUnit;
    }

    public Java.Atom parseConditionalAndExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseInclusiveOrExpression(scope);
        while (this.scanner.peek().isOperator("&&")) {
            atom = new Java.BinaryOperation(this.scanner.read().getLocation(), atom.toRvalueOrPE(), "&&", this.parseInclusiveOrExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseConditionalExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalOrExpression(scope);
        if (!this.scanner.peek().isOperator("?")) {
            return atom;
        }
        Location location = this.scanner.read().getLocation();
        Java.Rvalue rvalue = atom.toRvalueOrPE();
        Java.Rvalue rvalue2 = this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator(":")) {
            this.throwParseException("\":\" expected");
        }
        Java.Rvalue rvalue3 = this.parseConditionalExpression(scope).toRvalueOrPE();
        return new Java.ConditionalExpression(location, rvalue, rvalue2, rvalue3);
    }

    public Java.Atom parseConditionalOrExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseConditionalAndExpression(scope);
        while (this.scanner.peek().isOperator("||")) {
            atom = new Java.BinaryOperation(this.scanner.read().getLocation(), atom.toRvalueOrPE(), "||", this.parseConditionalAndExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.ConstructorDeclarator parseConstructorDeclarator(Java.ClassDeclaration classDeclaration, short s) throws ParseException, Scanner.ScanException, IOException {
        Java.Type[] typeArray;
        Location location = this.scanner.read().getLocation();
        Java.FormalParameter[] formalParameterArray = this.parseFormalParameters(classDeclaration);
        if (this.scanner.peek().isKeyword("throws")) {
            this.scanner.read();
            typeArray = this.parseReferenceTypeList(classDeclaration);
        } else {
            typeArray = new Java.ReferenceType[]{};
        }
        Java.ConstructorDeclarator constructorDeclarator = new Java.ConstructorDeclarator(location, classDeclaration, s, formalParameterArray, typeArray);
        location = this.scanner.peek().getLocation();
        if (!this.scanner.read().isOperator("{")) {
            this.throwParseException("\"{\" expected");
        }
        Java.Block block = new Java.Block(location, constructorDeclarator);
        constructorDeclarator.setBody(block);
        if (this.scanner.peek().isKeyword(new String[]{"this", "super", "new", "void", "byte", "char", "short", "int", "long", "float", "double", "boolean"}) || this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier()) {
            Java.Atom atom = this.parseExpression(block);
            if (atom instanceof Java.ConstructorInvocation) {
                if (!this.scanner.read().isOperator(";")) {
                    this.throwParseException("Semicolon at end of constructor invocation expected");
                }
                constructorDeclarator.setExplicitConstructorInvocation((Java.ConstructorInvocation)atom);
            } else {
                Java.Statement statement;
                if (this.scanner.peek().isIdentifier()) {
                    Java.Type type = atom.toTypeOrPE();
                    statement = new Java.LocalVariableDeclarationStatement(atom.getLocation(), block, 0, type, this.parseLocalVariableDeclarators(block, type));
                    if (!this.scanner.read().isOperator(";")) {
                        this.throwParseException("Semicolon expected after local variable declarator");
                    }
                } else {
                    statement = new Java.ExpressionStatement(atom.toRvalueOrPE(), (Java.Scope)block);
                    if (!this.scanner.read().isOperator(";")) {
                        this.throwParseException("Semicolon at end of expression statement expected");
                    }
                }
                block.addStatement(statement);
            }
        }
        block.addStatements(this.parseBlockStatements(block));
        if (!this.scanner.read().isOperator("}")) {
            this.throwParseException("\"}\" expected");
        }
        return constructorDeclarator;
    }

    public Java.Statement parseContinueStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("continue")) {
            this.throwParseException("\"continue\" expected");
        }
        Location location = this.scanner.read().getLocation();
        String string = null;
        if (this.scanner.peek().isIdentifier()) {
            string = this.scanner.read().getIdentifier();
        }
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected at end of \"continue\" statement");
        }
        return new Java.ContinueStatement(location, scope, string);
    }

    public Java.Rvalue parseDimExpr(Java.Scope scope) throws Scanner.ScanException, ParseException, IOException {
        if (!this.scanner.read().isOperator("[")) {
            this.throwParseException("Dimension expression (\"[...]\") expected");
        }
        Java.Rvalue rvalue = this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator("]")) {
            this.throwParseException("\"]\" expected");
        }
        return rvalue;
    }

    public Java.Rvalue[] parseDimExprs(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        arrayList.add(this.parseDimExpr(scope));
        while (this.scanner.peek().isOperator("[") && !this.scanner.peekNextButOne().isOperator("]")) {
            arrayList.add(this.parseDimExpr(scope));
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Statement parseDoStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("do")) {
            this.throwParseException("\"do\" expected");
        }
        Java.DoStatement doStatement = new Java.DoStatement(this.scanner.read().getLocation(), scope);
        doStatement.setBody(this.parseStatement(doStatement));
        if (!this.scanner.read().isKeyword("while")) {
            this.throwParseException("\"while\" expected after body of \"do\" statement");
        }
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected after \"while\"");
        }
        doStatement.setCondition(this.parseExpression(scope).toRvalueOrPE());
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected after \"while\" condition");
        }
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected at end of \"do\" statement");
        }
        return doStatement;
    }

    public Java.Statement parseEmptyStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token token = this.scanner.read();
        if (!token.isOperator(";")) {
            this.throwParseException("Semicolon expected");
        }
        return new Java.EmptyStatement(token.getLocation(), scope);
    }

    public Java.Atom parseEqualityExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseRelationalExpression(scope);
        while (this.scanner.peek().isOperator(new String[]{"==", "!="})) {
            atom = new Java.BinaryOperation(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), this.scanner.read().getOperator(), this.parseRelationalExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseExclusiveOrExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseAndExpression(scope);
        while (this.scanner.peek().isOperator("^")) {
            atom = new Java.BinaryOperation(this.scanner.read().getLocation(), atom.toRvalueOrPE(), "^", this.parseAndExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parseExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        return this.parseAssignmentExpression(scope);
    }

    public Java.Rvalue[] parseExpressionList(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.Rvalue> arrayList = new ArrayList<Java.Rvalue>();
        while (true) {
            arrayList.add(this.parseExpression(scope).toRvalueOrPE());
            if (!this.scanner.peek().isOperator(",")) break;
            this.scanner.read();
        }
        return arrayList.toArray(new Java.Rvalue[arrayList.size()]);
    }

    public Java.Statement parseExpressionStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Rvalue rvalue = this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon at and of expression statement expected");
        }
        return new Java.ExpressionStatement(rvalue, scope);
    }

    public Java.VariableDeclarator[] parseFieldDeclaratorsRest(Java.Scope scope, Java.Type type, String string) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> arrayList = new ArrayList<Java.VariableDeclarator>();
        Java.VariableDeclarator variableDeclarator = this.parseVariableDeclaratorRest(scope, type, string);
        Parser.verifyIdentifierIsConventionalFieldName(variableDeclarator.getName(), variableDeclarator.getLocation());
        arrayList.add(variableDeclarator);
        while (this.scanner.peek().isOperator(",")) {
            this.scanner.read();
            variableDeclarator = this.parseVariableDeclarator(scope, type);
            Parser.verifyIdentifierIsConventionalFieldName(variableDeclarator.getName(), variableDeclarator.getLocation());
            arrayList.add(variableDeclarator);
        }
        return arrayList.toArray(new Java.VariableDeclarator[arrayList.size()]);
    }

    private Java.BlockStatement parseForInit(Java.Block block) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isKeyword(new String[]{"final", "byte", "short", "char", "int", "long", "float", "double", "boolean"})) {
            short s = this.parseModifiersOpt();
            Java.Type type = this.parseType(block);
            return new Java.LocalVariableDeclarationStatement(this.scanner.peek().getLocation(), block, s, type, this.parseLocalVariableDeclarators(block, type));
        }
        Java.Atom atom = this.parseExpression(block);
        if (this.scanner.peek().isIdentifier()) {
            Java.Type type = atom.toTypeOrPE();
            return new Java.LocalVariableDeclarationStatement(atom.getLocation(), block, 0, type, this.parseLocalVariableDeclarators(block, type));
        }
        if (!this.scanner.peek().isOperator(",")) {
            return new Java.ExpressionStatement(atom.toRvalueOrPE(), (Java.Scope)block);
        }
        this.scanner.read();
        ArrayList<Java.ExpressionStatement> arrayList = new ArrayList<Java.ExpressionStatement>();
        arrayList.add(new Java.ExpressionStatement(atom.toRvalueOrPE(), (Java.Scope)block));
        while (true) {
            arrayList.add(new Java.ExpressionStatement(this.parseExpression(block).toRvalueOrPE(), (Java.Scope)block));
            if (!this.scanner.peek().isOperator(",")) break;
            this.scanner.read();
        }
        Java.Block block2 = new Java.Block(atom.getLocation(), block);
        block2.addStatements(arrayList);
        return block2;
    }

    public Java.Statement parseForStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("for")) {
            this.throwParseException("\"for\" expected");
        }
        Location location = this.scanner.read().getLocation();
        Java.ForStatement forStatement = new Java.ForStatement(location, scope);
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected after \"for\"");
        }
        Java.BlockStatement blockStatement = null;
        if (!this.scanner.peek().isOperator(";")) {
            blockStatement = this.parseForInit(forStatement.implicitBlock);
        }
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected after \"for\" initializer");
        }
        Java.Rvalue rvalue = null;
        if (!this.scanner.peek().isOperator(";")) {
            rvalue = this.parseExpression(forStatement).toRvalueOrPE();
        }
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected after \"for\" condition");
        }
        Java.Rvalue[] rvalueArray = null;
        if (!this.scanner.peek().isOperator(")")) {
            rvalueArray = this.parseExpressionList(forStatement);
        }
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected after \"for\" update");
        }
        forStatement.set(blockStatement, rvalue, rvalueArray, this.parseStatement(forStatement));
        return forStatement;
    }

    public Java.FormalParameter parseFormalParameter(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        boolean bl = this.scanner.peek().isKeyword("final");
        if (bl) {
            this.scanner.read();
        }
        Java.Type type = this.parseType(scope);
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Formal parameter name expected");
        }
        Location location = this.scanner.peek().getLocation();
        String string = this.scanner.read().getIdentifier();
        Parser.verifyIdentifierIsConventionalLocalVariableOrParameterName(string, location);
        int n = this.parseBracketsOpt();
        while (n > 0) {
            type = new Java.ArrayType(type);
            --n;
        }
        return new Java.FormalParameter(bl, type, string);
    }

    public Java.FormalParameter[] parseFormalParameters(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("\"(\" expected in formal parameter list");
        }
        if (this.scanner.peek().isOperator(")")) {
            this.scanner.read();
            return new Java.FormalParameter[0];
        }
        ArrayList<Java.FormalParameter> arrayList = new ArrayList<Java.FormalParameter>();
        while (true) {
            arrayList.add(this.parseFormalParameter(scope));
            if (!this.scanner.peek().isOperator(",")) break;
            this.scanner.read();
        }
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("\")\" expected at end of formal parameter list");
        }
        return arrayList.toArray(new Java.FormalParameter[arrayList.size()]);
    }

    public Java.Statement parseIfStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("if")) {
            this.throwParseException("\"if\" expected");
        }
        Location location = this.scanner.read().getLocation();
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected after \"if\"");
        }
        Java.Rvalue rvalue = this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected after \"if\" condition");
        }
        Java.Statement statement = this.parseStatement(scope);
        Java.Statement statement2 = null;
        if (this.scanner.peek().isKeyword("else")) {
            this.scanner.read();
            statement2 = this.parseStatement(scope);
        }
        return new Java.IfStatement(location, scope, rvalue, statement, statement2);
    }

    public Java.ImportDeclaration parseImportDeclaration() throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("import")) {
            this.throwParseException("\"import\" expected");
        }
        Location location = this.scanner.read().getLocation();
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Identifier expected after \"import\"");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.scanner.read().getIdentifier());
        while (true) {
            if (this.scanner.peek().isOperator(";")) {
                this.scanner.read();
                return new Java.SingleTypeImportDeclaration(location, arrayList.toArray(new String[arrayList.size()]));
            }
            if (!this.scanner.read().isOperator(".")) {
                this.throwParseException("\";\" or \".\" expected after identifier in \"import\" directive");
            }
            if (this.scanner.peek().isOperator("*")) {
                this.scanner.read();
                if (!this.scanner.read().isOperator(";")) {
                    this.throwParseException("Semicolon expected at end of type-import-on-demoand declaration");
                }
                return new Java.TypeImportOnDemandDeclaration(location, arrayList.toArray(new String[arrayList.size()]));
            }
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Identifier or \"*\" expected after \".\" in \"import\" directive");
            }
            arrayList.add(this.scanner.read().getIdentifier());
        }
    }

    public Java.Atom parseInclusiveOrExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseExclusiveOrExpression(scope);
        while (this.scanner.peek().isOperator("|")) {
            atom = new Java.BinaryOperation(this.scanner.read().getLocation(), atom.toRvalueOrPE(), "|", this.parseExclusiveOrExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public void parseInterfaceBody(Java.InterfaceDeclaration interfaceDeclaration) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.read().isOperator("{")) {
            this.throwParseException("\"{\" expected at start of interface body");
        }
        while (true) {
            String string;
            Object object;
            if (this.scanner.peek().isOperator("}")) break;
            if (this.scanner.peek().isOperator(";")) {
                this.scanner.read();
                continue;
            }
            short s = this.parseModifiersOpt();
            if (this.scanner.peek().isKeyword("void")) {
                object = this.scanner.read().getLocation();
                if (!this.scanner.peek().isIdentifier()) {
                    this.throwParseException("Method name expected after \"void\"");
                }
                string = this.scanner.read().getIdentifier();
                interfaceDeclaration.declaredMethods.add(this.parseMethodDeclaratorRest(interfaceDeclaration, (short)(s | 0x400 | 1), new Java.BasicType((Location)object, 0), string));
                continue;
            }
            if (this.scanner.peek().isKeyword("class")) {
                this.scanner.read();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseClassDeclarationRest(interfaceDeclaration, (short)(s | 8 | 1))));
                continue;
            }
            if (this.scanner.peek().isKeyword("interface")) {
                this.scanner.read();
                interfaceDeclaration.addMemberTypeDeclaration((Java.MemberTypeDeclaration)((Object)this.parseInterfaceDeclarationRest(interfaceDeclaration, (short)(s | 8 | 1))));
                continue;
            }
            object = this.parseType(interfaceDeclaration);
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Identifier expected in member declaration");
            }
            string = this.scanner.peek().getIdentifier();
            Location location = this.scanner.read().getLocation();
            if (this.scanner.peek().isOperator("(")) {
                interfaceDeclaration.declaredMethods.add(this.parseMethodDeclaratorRest(interfaceDeclaration, (short)(s | 0x400 | 1), (Java.Type)object, string));
                continue;
            }
            Java.FieldDeclarator fieldDeclarator = new Java.FieldDeclarator(location, interfaceDeclaration, (short)(s | 1 | 8 | 0x10), (Java.Type)object);
            Java.VariableDeclarator[] variableDeclaratorArray = this.parseFieldDeclaratorsRest(fieldDeclarator, (Java.Type)object, string);
            fieldDeclarator.setVariableDeclarators(variableDeclaratorArray);
            interfaceDeclaration.addConstantDeclaration(fieldDeclarator);
        }
        this.scanner.read();
    }

    public Java.InterfaceDeclaration parseInterfaceDeclarationRest(Java.Scope scope, short s) throws ParseException, Scanner.ScanException, IOException {
        Java.InterfaceDeclaration interfaceDeclaration;
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Interface name expected after \"interface\"");
        }
        Location location = this.scanner.peek().getLocation();
        String string = this.scanner.read().getIdentifier();
        Parser.verifyIdentifierIsConventionalClassOrInterfaceName(string, location);
        Java.Type[] typeArray = new Java.ReferenceType[]{};
        if (this.scanner.peek().isKeyword("extends")) {
            this.scanner.read();
            typeArray = this.parseReferenceTypeList(scope);
        }
        if (scope instanceof Java.CompilationUnit) {
            interfaceDeclaration = new Java.PackageMemberInterfaceDeclaration(location, (Java.CompilationUnit)scope, s, string, typeArray);
        } else if (scope instanceof Java.NamedTypeDeclaration) {
            interfaceDeclaration = new Java.MemberInterfaceDeclaration(location, (Java.NamedTypeDeclaration)scope, s, string, typeArray);
        } else {
            throw new RuntimeException("SNO: Interface declaration in unexpected scope " + scope.getClass().getName());
        }
        this.parseInterfaceBody(interfaceDeclaration);
        return interfaceDeclaration;
    }

    public Java.Statement parseLabeledStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.LabeledStatement labeledStatement = new Java.LabeledStatement(this.scanner.peek().getLocation(), scope, this.scanner.read().getIdentifier());
        if (!this.scanner.read().isOperator(":")) {
            this.throwParseException("Colon expected");
        }
        labeledStatement.setBody(this.parseStatement(labeledStatement));
        return labeledStatement;
    }

    public Java.Atom parseLiteral() throws ParseException, Scanner.ScanException, IOException {
        Scanner.Token token = this.scanner.read();
        if (!token.isLiteral()) {
            this.throwParseException("Literal expected");
        }
        return new Java.Literal(token.getLocation(), token.getLiteralValue());
    }

    public Java.VariableDeclarator[] parseLocalVariableDeclarators(Java.Scope scope, Java.Type type) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.VariableDeclarator> arrayList = new ArrayList<Java.VariableDeclarator>();
        while (true) {
            Java.VariableDeclarator variableDeclarator = this.parseVariableDeclarator(scope, type);
            Parser.verifyIdentifierIsConventionalLocalVariableOrParameterName(variableDeclarator.getName(), variableDeclarator.getLocation());
            arrayList.add(variableDeclarator);
            if (!this.scanner.peek().isOperator(",")) break;
            this.scanner.read();
        }
        return arrayList.toArray(new Java.VariableDeclarator[arrayList.size()]);
    }

    public Java.Block parseMethodBody(Java.FunctionDeclarator functionDeclarator) throws ParseException, Scanner.ScanException, IOException {
        return this.parseBlock(functionDeclarator);
    }

    public Java.MethodDeclarator parseMethodDeclaratorRest(Java.AbstractTypeDeclaration abstractTypeDeclaration, short s, Java.Type type, String string) throws ParseException, Scanner.ScanException, IOException {
        Java.Type[] typeArray;
        Location location = this.scanner.peek().getLocation();
        Parser.verifyIdentifierIsConventionalMethodName(string, location);
        Java.FormalParameter[] formalParameterArray = this.parseFormalParameters(abstractTypeDeclaration);
        int n = this.parseBracketsOpt();
        while (n > 0) {
            type = new Java.ArrayType(type);
            --n;
        }
        if (this.scanner.peek().isKeyword("throws")) {
            this.scanner.read();
            typeArray = this.parseReferenceTypeList(abstractTypeDeclaration);
        } else {
            typeArray = new Java.ReferenceType[]{};
        }
        Java.MethodDeclarator methodDeclarator = new Java.MethodDeclarator(location, abstractTypeDeclaration, s, type, string, formalParameterArray, typeArray);
        if (this.scanner.peek().isOperator(";")) {
            if ((s & 0x500) == 0) {
                this.throwParseException("Non-abstract, non-native method must have a body");
            }
            this.scanner.read();
        } else {
            if ((s & 0x500) != 0) {
                this.throwParseException("Abstract or native method must not have a body");
            }
            methodDeclarator.setBody(this.parseMethodBody(methodDeclarator));
        }
        return methodDeclarator;
    }

    public short parseModifiersOpt() throws ParseException, Scanner.ScanException, IOException {
        short s = 0;
        while (this.scanner.peek().isKeyword()) {
            int n;
            String string = this.scanner.peek().getKeyword();
            int n2 = string == "public" ? 1 : (string == "protected" ? 4 : (string == "private" ? 2 : (string == "static" ? 8 : (string == "abstract" ? 1024 : (string == "final" ? 16 : (string == "native" ? 256 : (string == "synchronized" ? 32 : (string == "transient" ? 128 : (string == "volatile" ? 64 : (n = string == "strictfp" ? 2048 : -1))))))))));
            if (n == -1) break;
            this.scanner.read();
            if ((s & n) != 0) {
                this.throwParseException("Duplicate modifier \"" + string + "\"");
            }
            int n3 = 0;
            while (n3 < MUTUALS.length) {
                short s2 = MUTUALS[n3];
                if ((n & s2) != 0 && (s & s2) != 0) {
                    this.throwParseException("Only one of \"" + Mod.shortToString(s2) + "\" allowed");
                }
                ++n3;
            }
            s = (short)(s | n);
        }
        return s;
    }

    public Java.Atom parseMultiplicativeExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseUnaryExpression(scope);
        while (this.scanner.peek().isOperator(new String[]{"*", "/", "%"})) {
            atom = new Java.BinaryOperation(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), this.scanner.read().getOperator(), this.parseUnaryExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Atom parsePrimary(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Object object;
        if (this.scanner.peek().isOperator("(")) {
            this.scanner.read();
            if (this.scanner.peek().isKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
                Java.Type type = this.parseType(scope);
                int n = this.parseBracketsOpt();
                if (!this.scanner.read().isOperator(")")) {
                    this.throwParseException("Closing parenthesis expected");
                }
                int n2 = 0;
                while (n2 < n) {
                    type = new Java.ArrayType(type);
                    ++n2;
                }
                return new Java.Cast(this.scanner.peek().getLocation(), type, this.parseUnaryExpression(scope).toRvalueOrPE());
            }
            Java.Atom atom = this.parseExpression(scope);
            if (!this.scanner.read().isOperator(")")) {
                this.throwParseException("Closing parenthesis expected");
            }
            if (this.scanner.peek().isLiteral() || this.scanner.peek().isIdentifier() || this.scanner.peek().isOperator(new String[]{"(", "~", "!"}) || this.scanner.peek().isKeyword(new String[]{"this", "super", "new"})) {
                return new Java.Cast(this.scanner.peek().getLocation(), atom.toTypeOrPE(), this.parseUnaryExpression(scope).toRvalueOrPE());
            }
            return new Java.ParenthesizedExpression(atom.getLocation(), atom.toRvalueOrPE());
        }
        if (this.scanner.peek().isLiteral()) {
            return this.parseLiteral();
        }
        if (this.scanner.peek().isIdentifier()) {
            Location location = this.scanner.peek().getLocation();
            String[] stringArray = this.parseQualifiedIdentifier();
            if (this.scanner.peek().isOperator("(")) {
                return new Java.MethodInvocation(this.scanner.peek().getLocation(), scope, stringArray.length == 1 ? null : new Java.AmbiguousName(location, scope, stringArray, stringArray.length - 1), stringArray[stringArray.length - 1], this.parseArguments(scope));
            }
            if (this.scanner.peek().isOperator("[") && this.scanner.peekNextButOne().isOperator("]")) {
                Java.Type type = new Java.ReferenceType(location, scope, stringArray);
                int n = this.parseBracketsOpt();
                int n3 = 0;
                while (n3 < n) {
                    type = new Java.ArrayType(type);
                    ++n3;
                }
                if (this.scanner.peek().isOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                    this.scanner.read();
                    return new Java.ClassLiteral(this.scanner.read().getLocation(), scope, type);
                }
                return type;
            }
            return new Java.AmbiguousName(this.scanner.peek().getLocation(), scope, stringArray);
        }
        if (this.scanner.peek().isKeyword("this")) {
            Location location = this.scanner.read().getLocation();
            if (this.scanner.peek().isOperator("(")) {
                Java.Scope scope2 = scope;
                while (!(scope2 instanceof Java.FunctionDeclarator)) {
                    scope2 = scope2.getEnclosingScope();
                }
                if (!(scope2 instanceof Java.ConstructorDeclarator)) {
                    this.throwParseException("Alternate constructor invocation only allowed in constructor context");
                }
                Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scope2;
                Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)constructorDeclarator.getDeclaringType();
                return new Java.AlternateConstructorInvocation(location, classDeclaration, constructorDeclarator, this.parseArguments(constructorDeclarator));
            }
            return new Java.ThisReference(location, scope);
        }
        if (this.scanner.peek().isKeyword("super")) {
            this.scanner.read();
            if (this.scanner.peek().isOperator("(")) {
                Java.Scope scope3 = scope;
                while (!(scope3 instanceof Java.FunctionDeclarator)) {
                    scope3 = scope3.getEnclosingScope();
                }
                if (!(scope3 instanceof Java.ConstructorDeclarator)) {
                    this.throwParseException("Unqualified superclass constructor invocation only allowed in constructor context");
                }
                Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scope3;
                Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)constructorDeclarator.getDeclaringType();
                return new Java.SuperConstructorInvocation(this.scanner.peek().getLocation(), classDeclaration, constructorDeclarator, null, this.parseArguments(constructorDeclarator));
            }
            if (!this.scanner.read().isOperator(".")) {
                this.throwParseException("\".\" expected after \"super\"");
            }
            if (!this.scanner.peek().isIdentifier()) {
                this.throwParseException("Identifier expected after \"super\"");
            }
            object = this.scanner.read().getIdentifier();
            if (this.scanner.peek().isOperator("(")) {
                return new Java.SuperclassMethodInvocation(this.scanner.peek().getLocation(), scope, (String)object, this.parseArguments(scope));
            }
            this.throwParseException("Superclass field access NYI");
        }
        if (this.scanner.peek().isKeyword("new")) {
            object = this.scanner.read().getLocation();
            Java.Type type = this.parseType(scope);
            if (type instanceof Java.ArrayType) {
                return this.parseArrayInitializer(scope, (Java.ArrayType)type);
            }
            if (type instanceof Java.ReferenceType && this.scanner.peek().isOperator("(")) {
                Java.Rvalue[] rvalueArray = this.parseArguments(scope);
                if (this.scanner.peek().isOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.scanner.peek().getLocation(), scope, type);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance((Location)object, scope, null, anonymousClassDeclaration, rvalueArray);
                }
                return new Java.NewClassInstance((Location)object, scope, null, type, rvalueArray);
            }
            return new Java.NewArray((Location)object, type, this.parseDimExprs(scope), this.parseBracketsOpt());
        }
        if (this.scanner.peek().isKeyword(new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double"})) {
            object = this.parseType(scope);
            int n = this.parseBracketsOpt();
            int n4 = 0;
            while (n4 < n) {
                object = new Java.ArrayType((Java.Type)object);
                ++n4;
            }
            if (this.scanner.peek().isOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.scanner.read();
                return new Java.ClassLiteral(this.scanner.read().getLocation(), scope, (Java.Type)object);
            }
            return object;
        }
        if (this.scanner.peek().isKeyword("void")) {
            this.scanner.read();
            if (this.scanner.peek().isOperator(".") && this.scanner.peekNextButOne().isKeyword("class")) {
                this.scanner.read();
                object = this.scanner.read().getLocation();
                return new Java.ClassLiteral((Location)object, scope, new Java.BasicType((Location)object, 0));
            }
            this.throwParseException("\"void\" encountered in wrong context");
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in primary");
        return null;
    }

    public String[] parseQualifiedIdentifier() throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Identifier expected");
        }
        String string = this.scanner.read().getIdentifier();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        while (this.scanner.peek().isOperator(".") && this.scanner.peekNextButOne().isIdentifier()) {
            this.scanner.read();
            arrayList.add(this.scanner.read().getIdentifier());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Java.ReferenceType parseReferenceType(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        return new Java.ReferenceType(this.scanner.peek().getLocation(), scope, this.parseQualifiedIdentifier());
    }

    public Java.ReferenceType[] parseReferenceTypeList(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        ArrayList<Java.ReferenceType> arrayList = new ArrayList<Java.ReferenceType>();
        arrayList.add(this.parseReferenceType(scope));
        while (this.scanner.peek().isOperator(",")) {
            this.scanner.read();
            arrayList.add(this.parseReferenceType(scope));
        }
        return arrayList.toArray(new Java.ReferenceType[arrayList.size()]);
    }

    public Java.Atom parseRelationalExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseShiftExpression(scope);
        while (true) {
            if (this.scanner.peek().isKeyword("instanceof")) {
                atom = new Java.Instanceof(this.scanner.read().getLocation(), atom.toRvalueOrPE(), this.parseType(scope));
                continue;
            }
            if (!this.scanner.peek().isOperator(new String[]{"<", ">", "<=", ">="})) break;
            atom = new Java.BinaryOperation(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), this.scanner.read().getOperator(), this.parseShiftExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Statement parseReturnStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Rvalue rvalue;
        if (!this.scanner.peek().isKeyword("return")) {
            this.throwParseException("\"return\" expected");
        }
        Location location = this.scanner.read().getLocation();
        Java.Rvalue rvalue2 = rvalue = this.scanner.peek().isOperator(";") ? null : this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected at end of \"return\" statement");
        }
        return new Java.ReturnStatement(location, scope, rvalue);
    }

    public Java.Atom parseSelector(Java.Scope scope, Java.Atom atom) throws ParseException, Scanner.ScanException, IOException {
        Object object;
        if (this.scanner.peek().isOperator(".")) {
            this.scanner.read();
            if (this.scanner.peek().isIdentifier()) {
                String string = this.scanner.read().getIdentifier();
                if (this.scanner.peek().isOperator("(")) {
                    return new Java.MethodInvocation(this.scanner.peek().getLocation(), scope, atom.toRvalueOrPE(), string, this.parseArguments(scope));
                }
                return new Java.FieldAccessExpression(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), string);
            }
            if (this.scanner.peek().isKeyword("this")) {
                return new Java.QualifiedThisReference(this.scanner.read().getLocation(), scope, atom.toTypeOrPE());
            }
            if (this.scanner.peek().isKeyword("super")) {
                object = this.scanner.read().getLocation();
                if (this.scanner.peek().isOperator("(")) {
                    Java.Scope scope2 = scope.getEnclosingScope();
                    if (!(scope2 instanceof Java.ConstructorDeclarator)) {
                        this.throwParseException("Qualified superclass constructor does not appear in constructor scope");
                    }
                    Java.ConstructorDeclarator constructorDeclarator = (Java.ConstructorDeclarator)scope2;
                    Java.ClassDeclaration classDeclaration = (Java.ClassDeclaration)scope2.getEnclosingScope();
                    return new Java.SuperConstructorInvocation((Location)object, classDeclaration, constructorDeclarator, atom.toRvalueOrPE(), this.parseArguments(scope));
                }
                if (!this.scanner.read().isOperator(".")) {
                    this.throwParseException("\"(\" or \".\" expected after \"super\"");
                }
                this.scanner.read().getIdentifier();
                if (this.scanner.peek().isOperator("(")) {
                    this.throwParseException("Qualified superclass method invocation NYI");
                } else {
                    this.throwParseException("Qualified superclass field access NYI");
                }
            }
            if (this.scanner.peek().isKeyword("new")) {
                object = atom.toRvalue();
                Location location = this.scanner.read().getLocation();
                String string = this.scanner.read().getIdentifier();
                Java.RvalueMemberType rvalueMemberType = new Java.RvalueMemberType(location, (Java.Rvalue)object, string);
                Java.Rvalue[] rvalueArray = this.parseArguments(scope);
                if (this.scanner.peek().isOperator("{")) {
                    Java.AnonymousClassDeclaration anonymousClassDeclaration = new Java.AnonymousClassDeclaration(this.scanner.peek().getLocation(), scope, rvalueMemberType);
                    this.parseClassBody(anonymousClassDeclaration);
                    return new Java.NewAnonymousClassInstance(location, scope, (Java.Rvalue)object, anonymousClassDeclaration, rvalueArray);
                }
                return new Java.NewClassInstance(location, scope, (Java.Rvalue)object, rvalueMemberType, rvalueArray);
            }
            if (this.scanner.peek().isKeyword("class")) {
                return new Java.ClassLiteral(this.scanner.read().getLocation(), scope, atom.toTypeOrPE());
            }
            this.throwParseException("Unexpected selector \"" + this.scanner.peek() + "\" after \".\"");
        }
        if (this.scanner.peek().isOperator("[")) {
            object = this.scanner.read().getLocation();
            Java.Rvalue rvalue = this.parseExpression(scope).toRvalueOrPE();
            if (!this.scanner.read().isOperator("]")) {
                this.throwParseException("\"]\" expected");
            }
            return new Java.ArrayAccessExpression((Location)object, atom.toRvalueOrPE(), rvalue);
        }
        this.throwParseException("Unexpected token \"" + this.scanner.peek() + "\" in selector");
        return null;
    }

    public Java.Atom parseShiftExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Atom atom = this.parseAdditiveExpression(scope);
        while (this.scanner.peek().isOperator(new String[]{"<<", ">>", ">>>"})) {
            atom = new Java.BinaryOperation(this.scanner.peek().getLocation(), atom.toRvalueOrPE(), this.scanner.read().getOperator(), this.parseAdditiveExpression(scope).toRvalueOrPE());
        }
        return atom;
    }

    public Java.Statement parseStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Block block;
        if (this.scanner.peek().isIdentifier() && this.scanner.peekNextButOne().isOperator(":")) {
            return this.parseLabeledStatement(scope);
        }
        Scanner.Token token = this.scanner.peek();
        Java.Statement statement = token.isOperator("{") ? this.parseBlock(scope) : (token.isKeyword("if") ? this.parseIfStatement(scope) : (token.isKeyword("for") ? this.parseForStatement(scope) : (token.isKeyword("while") ? this.parseWhileStatement(scope) : (token.isKeyword("do") ? this.parseDoStatement(scope) : (token.isKeyword("try") ? this.parseTryStatement(scope) : (token.isKeyword("switch") ? this.parseSwitchStatement(scope) : (token.isKeyword("synchronized") ? this.parseSynchronizedStatement(scope) : (token.isKeyword("return") ? this.parseReturnStatement(scope) : (token.isKeyword("throw") ? this.parseThrowStatement(scope) : (token.isKeyword("break") ? this.parseBreakStatement(scope) : (token.isKeyword("continue") ? this.parseContinueStatement(scope) : (block = token.isOperator(";") ? this.parseEmptyStatement(scope) : this.parseExpressionStatement(scope)))))))))))));
        if (block == null) {
            this.throwParseException("\"" + token.getKeyword() + "\" NYI");
        }
        return block;
    }

    public Java.Statement parseSwitchStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("switch")) {
            this.throwParseException("\"switch\" expected");
        }
        Java.SwitchStatement switchStatement = new Java.SwitchStatement(this.scanner.read().getLocation(), scope);
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected");
        }
        switchStatement.setCondition(this.parseExpression(switchStatement).toRvalueOrPE());
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected");
        }
        if (!this.scanner.read().isOperator("{")) {
            this.throwParseException("\"{\" expected");
        }
        Java.Block block = new Java.Block(this.scanner.peek().getLocation(), switchStatement);
        while (!this.scanner.peek().isOperator("}")) {
            Java.SwitchBlockStatementGroup switchBlockStatementGroup = new Java.SwitchBlockStatementGroup(this.scanner.peek().getLocation());
            do {
                if (this.scanner.peek().isKeyword("case")) {
                    this.scanner.read();
                    switchBlockStatementGroup.addSwitchLabel(this.parseExpression(block).toRvalueOrPE());
                } else if (this.scanner.peek().isKeyword("default")) {
                    this.scanner.read();
                    switchBlockStatementGroup.addDefaultSwitchLabel();
                } else {
                    this.throwParseException("\"case\" or \"default\" expected");
                }
                if (this.scanner.read().isOperator(":")) continue;
                this.throwParseException("Colon expected");
            } while (this.scanner.peek().isKeyword(new String[]{"case", "default"}));
            switchBlockStatementGroup.setBlockStatements(this.parseBlockStatements(block));
            switchStatement.addSwitchBlockStatementGroup(switchBlockStatementGroup);
        }
        this.scanner.read();
        return switchStatement;
    }

    public Java.Statement parseSynchronizedStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("synchronized")) {
            this.throwParseException("\"synchronized\" expected");
        }
        Location location = this.scanner.read().getLocation();
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected");
        }
        Java.SynchronizedStatement synchronizedStatement = new Java.SynchronizedStatement(location, scope, this.parseExpression(scope).toRvalueOrPE());
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected");
        }
        synchronizedStatement.setBody(this.parseBlock(synchronizedStatement));
        return synchronizedStatement;
    }

    public Java.Statement parseThrowStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("throw")) {
            this.throwParseException("\"throw\" expected");
        }
        Location location = this.scanner.read().getLocation();
        Java.Rvalue rvalue = this.parseExpression(scope).toRvalueOrPE();
        if (!this.scanner.read().isOperator(";")) {
            this.throwParseException("Semicolon expected");
        }
        return new Java.ThrowStatement(location, scope, rvalue);
    }

    public Java.Statement parseTryStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("try")) {
            this.throwParseException("\"try\" expected");
        }
        Java.TryStatement tryStatement = new Java.TryStatement(this.scanner.read().getLocation(), scope);
        tryStatement.setBody(this.parseBlock(tryStatement));
        while (this.scanner.peek().isKeyword("catch")) {
            this.scanner.read();
            if (!this.scanner.read().isOperator("(")) {
                this.throwParseException("Opening parenthesis expected");
            }
            Java.FormalParameter formalParameter = this.parseFormalParameter(tryStatement);
            if (!this.scanner.read().isOperator(")")) {
                this.throwParseException("Closing parenthesis expected");
            }
            tryStatement.addCatchClause(new Java.CatchClause(formalParameter, this.parseBlock(tryStatement)));
        }
        if (this.scanner.peek().isKeyword("finally")) {
            this.scanner.read();
            tryStatement.setFinally(this.parseBlock(tryStatement));
        }
        if (tryStatement.getCatchClauses().size() == 0 && tryStatement.getFinally() == null) {
            this.throwParseException("\"try\" statement must have at least one \"catch\" clause or a \"finally\" clause");
        }
        return tryStatement;
    }

    public Java.Type parseType(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        Java.Type type;
        Scanner.Token token = this.scanner.peek();
        int n = -1;
        if (token.isKeyword("byte")) {
            n = 1;
        } else if (token.isKeyword("short")) {
            n = 2;
        } else if (token.isKeyword("char")) {
            n = 3;
        } else if (token.isKeyword("int")) {
            n = 4;
        } else if (token.isKeyword("long")) {
            n = 5;
        } else if (token.isKeyword("float")) {
            n = 6;
        } else if (token.isKeyword("double")) {
            n = 7;
        } else if (token.isKeyword("boolean")) {
            n = 8;
        }
        if (n != -1) {
            type = new Java.BasicType(token.getLocation(), n);
            this.scanner.read();
        } else {
            type = this.parseReferenceType(scope);
        }
        int n2 = this.parseBracketsOpt();
        while (n2 > 0) {
            type = new Java.ArrayType(type);
            --n2;
        }
        return type;
    }

    public Java.NamedTypeDeclaration parseTypeDeclaration(Java.CompilationUnit compilationUnit) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isOperator(";")) {
            this.scanner.read();
            return null;
        }
        return this.parseClassOrInterfaceDeclaration(compilationUnit);
    }

    public Java.Atom parseUnaryExpression(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isOperator(new String[]{"++", "--"})) {
            return new Java.Crement(this.scanner.peek().getLocation(), this.scanner.read().getOperator(), this.parseUnaryExpression(scope).toLvalueOrPE());
        }
        if (this.scanner.peek().isOperator(new String[]{"+", "-", "~", "!"})) {
            return new Java.UnaryOperation(this.scanner.peek().getLocation(), this.scanner.read().getOperator(), this.parseUnaryExpression(scope).toRvalueOrPE());
        }
        Java.Atom atom = this.parsePrimary(scope);
        while (this.scanner.peek().isOperator(new String[]{".", "["})) {
            atom = this.parseSelector(scope, atom);
        }
        while (this.scanner.peek().isOperator(new String[]{"++", "--"})) {
            atom = new Java.Crement(this.scanner.peek().getLocation(), atom.toLvalueOrPE(), this.scanner.read().getOperator());
        }
        return atom;
    }

    public Java.VariableDeclarator parseVariableDeclarator(Java.Scope scope, Java.Type type) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isIdentifier()) {
            this.throwParseException("Variable name expected");
        }
        String string = this.scanner.read().getIdentifier();
        return this.parseVariableDeclaratorRest(scope, type, string);
    }

    public Java.VariableDeclarator parseVariableDeclaratorRest(Java.Scope scope, Java.Type type, String string) throws ParseException, Scanner.ScanException, IOException {
        Location location = this.scanner.peek().getLocation();
        int n = this.parseBracketsOpt();
        int n2 = 0;
        while (n2 < n) {
            type = new Java.ArrayType(type);
            ++n2;
        }
        Java.Rvalue rvalue = null;
        if (this.scanner.peek().isOperator("=")) {
            this.scanner.read();
            rvalue = this.parseVariableInitializer(scope, type);
        }
        return new Java.VariableDeclarator(location, string, n, rvalue);
    }

    public Java.Rvalue parseVariableInitializer(Java.Scope scope, Java.Type type) throws ParseException, Scanner.ScanException, IOException {
        if (this.scanner.peek().isOperator("{")) {
            if (!(type instanceof Java.ArrayType)) {
                this.throwParseException("Cannot initialize non-array type \"" + type + "\" with an array");
            }
            return this.parseArrayInitializer(scope, (Java.ArrayType)type);
        }
        return this.parseExpression(scope).toRvalueOrPE();
    }

    public Java.Statement parseWhileStatement(Java.Scope scope) throws ParseException, Scanner.ScanException, IOException {
        if (!this.scanner.peek().isKeyword("while")) {
            this.throwParseException("\"while\" expected");
        }
        Location location = this.scanner.read().getLocation();
        if (!this.scanner.read().isOperator("(")) {
            this.throwParseException("Opening parenthesis expected after \"while\"");
        }
        Java.WhileStatement whileStatement = new Java.WhileStatement(location, scope, this.parseExpression(scope).toRvalueOrPE());
        if (!this.scanner.read().isOperator(")")) {
            this.throwParseException("Closing parenthesis expected after \"while\" condition");
        }
        whileStatement.setBody(this.parseStatement(whileStatement));
        return whileStatement;
    }

    private final void throwParseException(String string) throws ParseException {
        throw new ParseException(string, this.scanner.peek().getLocation());
    }

    private static void verifyIdentifierIsConventionalClassOrInterfaceName(String string, Location location) {
        if (!Character.isUpperCase(string.charAt(0))) {
            Java.warning("UCOIN1", "Class or interface name \"" + string + "\" does not begin with an upper-case letter (see JLS2 6.8.2)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                Java.warning("UCOIN", "Class or interface name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.2)", location);
                return;
            }
            ++n;
        }
    }

    private static void verifyIdentifierIsConventionalFieldName(String string, Location location) {
        if (Character.isUpperCase(string.charAt(0))) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isUpperCase(c) && !Character.isDigit(c) && c != '_') {
                    Java.warning("UCN", "Constant name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.5)", location);
                    return;
                }
                ++n;
            }
        } else if (Character.isLowerCase(string.charAt(0))) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!Character.isLetter(c) && !Character.isDigit(c)) {
                    Java.warning("UFN", "Field name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.4)", location);
                    return;
                }
                ++n;
            }
        } else {
            Java.warning("UFN1", "\"" + string + "\" is neither a conventional field name (JLS2 6.8.4) nor a conventional constant name (JLS2 6.8.5)", location);
        }
    }

    private static void verifyIdentifierIsConventionalLocalVariableOrParameterName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            Java.warning("ULVN1", "Local variable name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.6)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                Java.warning("ULVN", "Local variable name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.6)", location);
                return;
            }
            ++n;
        }
    }

    private static void verifyIdentifierIsConventionalMethodName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            Java.warning("UMN1", "Method name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.3)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                Java.warning("UMN", "Method name \"" + string + "\" contains unconventional character \"" + c + "\" (see JLS2 6.8.3)", location);
                return;
            }
            ++n;
        }
    }

    private static void verifyStringIsConventionalPackageName(String string, Location location) {
        if (!Character.isLowerCase(string.charAt(0))) {
            Java.warning("UPN", "Package name \"" + string + "\" does not begin with a lower-case letter (see JLS2 6.8.1)", location);
            return;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (!Character.isLowerCase(c) && c != '_' && c != '.') {
                Java.warning("PPN", "Poorly chosen package name \"" + string + "\" contains bad character '" + c + "'", location);
                return;
            }
            ++n;
        }
    }

    public static class ParseException
    extends Scanner.LocatedException {
        ParseException(String string, Location location) {
            super(string, location);
        }
    }
}

