/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.codehaus.janino.CodeContext;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Location;
import org.codehaus.janino.MethodDescriptor;
import org.codehaus.janino.Mod;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.Visitor;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.iterator.ReverseListIterator;

public class Java {
    private static final boolean DEBUG = false;
    private static final HashMap PRIMITIVE_WIDENING_CONVERSIONS = new HashMap();
    private static final HashMap PRIMITIVE_NARROWING_CONVERSIONS;
    private static final ThreadLocal generatedClassFiles;
    private static final ThreadLocal iClassLoader;
    private static final ThreadLocal codeContext;
    private static final ThreadLocal debuggingInformation;
    private static final ThreadLocal compileErrorHandler;
    private static final ThreadLocal warningHandler;
    private static final ThreadLocal optionalWarningHandlePatterns;

    static {
        Java.fillConversionMap(new Object[]{new byte[0], "BS", "BI", "SI", "CI", new byte[]{-123}, "BJ", "SJ", "CJ", "IJ", new byte[]{-122}, "BF", "SF", "CF", "IF", new byte[]{-119}, "JF", new byte[]{-121}, "BD", "SD", "CD", "ID", new byte[]{-118}, "JD", new byte[]{-115}, "FD"}, PRIMITIVE_WIDENING_CONVERSIONS);
        PRIMITIVE_NARROWING_CONVERSIONS = new HashMap();
        Java.fillConversionMap(new Object[]{new byte[0], "BC", "SC", "CS", new byte[]{-111}, "SB", "CB", "IB", new byte[]{-109}, "IS", "IC", new byte[]{-120, -111}, "JB", new byte[]{-120, -109}, "JS", "JC", new byte[]{-120}, "JI", new byte[]{-117, -111}, "FB", new byte[]{-117, -109}, "FS", "FC", new byte[]{-117}, "FI", new byte[]{-116}, "FJ", new byte[]{-114, -111}, "DB", new byte[]{-114, -109}, "DS", "DC", new byte[]{-114}, "DI", new byte[]{-113}, "DJ", new byte[]{-112}, "DF"}, PRIMITIVE_NARROWING_CONVERSIONS);
        generatedClassFiles = new ThreadLocal();
        iClassLoader = new ThreadLocal();
        codeContext = new ThreadLocal();
        debuggingInformation = new ThreadLocal();
        compileErrorHandler = new ThreadLocal();
        warningHandler = new ThreadLocal();
        optionalWarningHandlePatterns = new ThreadLocal();
    }

    private Java() {
    }

    private static void assignmentConversion(Located located, IClass iClass, IClass iClass2, Object object) throws CompileException {
        if (Java.tryIdentityConversion(iClass, iClass2)) {
            return;
        }
        if (Java.tryWideningPrimitiveConversion(located, iClass, iClass2)) {
            return;
        }
        if (Java.isWideningReferenceConvertible(iClass, iClass2)) {
            return;
        }
        if (object != null && Java.isConstantPrimitiveAssignmentConvertible(object, iClass2)) {
            return;
        }
        located.compileError("Assignment conversion not possible from type \"" + iClass + "\" to type \"" + iClass2 + "\"");
    }

    private static IClass binaryNumericPromotion(Located located, IClass iClass, CodeContext.Inserter inserter, IClass iClass2) throws CompileException {
        IClass iClass3 = Java.binaryNumericPromotionType(located, iClass, iClass2);
        if (inserter != null) {
            located.pushInserter(inserter);
            try {
                if (!Java.tryIdentityConversion(iClass, iClass3) && !Java.tryWideningPrimitiveConversion(located, iClass, iClass3)) {
                    throw new RuntimeException();
                }
                Object var6_5 = null;
                located.popInserter();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                located.popInserter();
                throw throwable;
            }
        }
        if (!Java.tryIdentityConversion(iClass2, iClass3) && !Java.tryWideningPrimitiveConversion(located, iClass2, iClass3)) {
            throw new RuntimeException();
        }
        return iClass3;
    }

    private static IClass binaryNumericPromotionType(Locatable locatable, IClass iClass, IClass iClass2) throws CompileException {
        if (!iClass.isPrimitiveNumeric() || !iClass2.isPrimitiveNumeric()) {
            locatable.compileError("Binary numeric promotion not possible on types \"" + iClass + "\" and \"" + iClass2 + "\"");
        }
        return iClass == IClass.DOUBLE || iClass2 == IClass.DOUBLE ? IClass.DOUBLE : (iClass == IClass.FLOAT || iClass2 == IClass.FLOAT ? IClass.FLOAT : (iClass == IClass.LONG || iClass2 == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void checkThrownException(Located var0, IClass var1_1, Scope var2_2) throws CompileException {
        if (!Java.getIClassLoader().THROWABLE.isAssignableFrom(var1_1)) {
            var0.compileError("Thrown object of type \"" + var1_1 + "\" is not assignable to \"Throwable\"");
        }
        if (!Java.getIClassLoader().RUNTIME_EXCEPTION.isAssignableFrom(var1_1) && !Java.getIClassLoader().ERROR.isAssignableFrom(var1_1)) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            if (var2_2 instanceof TryStatement) {
                var3_3 /* !! */  = (TryStatement)var2_2;
                var4_4 = 0;
                while (var4_4 < var3_3 /* !! */ .catchClauses.size()) {
                    var5_5 = (CatchClause)var3_3 /* !! */ .catchClauses.get(var4_4);
                    var6_6 = var5_5.caughtException.type.getType();
                    if (var6_6.isAssignableFrom(var1_1)) {
                        return;
                    }
                    ++var4_4;
                }
            }
            var2_2 = var2_2.getEnclosingScope();
lbl16:
            // 2 sources

            ** while (var2_2 instanceof Statement)
        }
lbl17:
        // 1 sources

        if (var2_2 instanceof FunctionDeclarator) {
            var3_3 /* !! */  = (FunctionDeclarator)var2_2;
            var4_4 = 0;
            while (var4_4 < var3_3 /* !! */ .thrownExceptions.length) {
                var5_5 = var3_3 /* !! */ .thrownExceptions[var4_4].getType();
                if (var5_5.isAssignableFrom(var1_1)) {
                    return;
                }
                ++var4_4;
            }
        }
        var0.compileError("Thrown exception of type \"" + var1_1 + "\" is neither caught by a \"try...catch\" block nor declared in the \"throws\" clause of the declaring function");
    }

    private static IClass compileArithmeticBinaryOperation(Located located, IClass iClass, String string, Rvalue rvalue) throws CompileException {
        return Java.compileArithmeticOperation(located, iClass, Arrays.asList(rvalue).iterator(), string);
    }

    private static IClass compileArithmeticOperation(Located located, IClass iClass, Iterator iterator, String string) throws CompileException {
        if (string == "|" || string == "^" || string == "&") {
            int n = string == "&" ? 126 : (string == "|" ? -128 : (string == "^" ? -126 : Integer.MAX_VALUE));
            do {
                Rvalue rvalue = (Rvalue)iterator.next();
                if (iClass == null) {
                    iClass = rvalue.compileGetValue();
                    continue;
                }
                CodeContext.Inserter inserter = located.newInserter();
                IClass iClass2 = rvalue.compileGetValue();
                if (iClass.isPrimitiveNumeric() && iClass2.isPrimitiveNumeric()) {
                    IClass iClass3 = Java.binaryNumericPromotion(located, iClass, inserter, iClass2);
                    if (iClass3 == IClass.INT) {
                        located.writeOpcode(n);
                    } else if (iClass3 == IClass.LONG) {
                        located.writeOpcode(n + 1);
                    } else {
                        located.compileError("Operator \"" + string + "\" not defined on types \"" + iClass + "\" and \"" + iClass2 + "\"");
                    }
                    iClass = iClass3;
                    continue;
                }
                if (iClass == IClass.BOOLEAN && iClass2 == IClass.BOOLEAN) {
                    located.writeOpcode(n);
                    iClass = IClass.BOOLEAN;
                    continue;
                }
                located.compileError("Operator \"" + string + "\" not defined on types \"" + iClass + "\" and \"" + iClass2 + "\"");
                iClass = IClass.INT;
            } while (iterator.hasNext());
            return iClass;
        }
        if (string == "*" || string == "/" || string == "%" || string == "+" || string == "-") {
            int n = string == "*" ? 104 : (string == "/" ? 108 : (string == "%" ? 112 : (string == "+" ? 96 : (string == "-" ? 100 : Integer.MAX_VALUE))));
            do {
                int n2;
                Object object;
                Object object2;
                Rvalue rvalue = (Rvalue)iterator.next();
                IClass iClass4 = rvalue.getType();
                IClassLoader iClassLoader = Java.getIClassLoader();
                if (string == "+" && (iClass == iClassLoader.STRING || iClass4 == iClassLoader.STRING)) {
                    if (iClass != null) {
                        Java.stringConversion(located, iClass);
                    }
                    do {
                        if ((object2 = rvalue.getConstantValue()) == null) {
                            Java.stringConversion(located, rvalue.compileGetValue());
                            rvalue = iterator.hasNext() ? (Rvalue)iterator.next() : null;
                        } else {
                            if (iterator.hasNext()) {
                                rvalue = (Rvalue)iterator.next();
                                object = rvalue.getConstantValue();
                                if (object != null) {
                                    StringBuffer stringBuffer = new StringBuffer(object2.toString()).append(object);
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            rvalue = null;
                                            break;
                                        }
                                        rvalue = (Rvalue)iterator.next();
                                        Object object3 = rvalue.getConstantValue();
                                        if (object3 == null) break;
                                        stringBuffer.append(object3);
                                    }
                                    object2 = stringBuffer.toString();
                                }
                            } else {
                                rvalue = null;
                            }
                            Java.pushConstant(located, object2.toString());
                        }
                        if (iClass != null) {
                            located.writeOpcode(-74);
                            located.writeConstantMethodrefInfo("Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                        }
                        iClass = Java.getIClassLoader().STRING;
                    } while (rvalue != null);
                    return iClass;
                }
                if (iClass == null) {
                    iClass = rvalue.compileGetValue();
                    continue;
                }
                object2 = located.newInserter();
                if ((iClass = Java.binaryNumericPromotion(located, iClass, (CodeContext.Inserter)object2, (IClass)(object = rvalue.compileGetValue()))) == IClass.INT) {
                    n2 = n;
                } else if (iClass == IClass.LONG) {
                    n2 = n + 1;
                } else if (iClass == IClass.FLOAT) {
                    n2 = n + 2;
                } else if (iClass == IClass.DOUBLE) {
                    n2 = n + 3;
                } else {
                    located.compileError("Unexpected promoted type \"" + iClass + "\"");
                    n2 = n;
                }
                located.writeOpcode(n2);
            } while (iterator.hasNext());
            return iClass;
        }
        if (string == "<<" || string == ">>" || string == ">>>") {
            int n = string == "<<" ? 120 : (string == ">>" ? 122 : (string == ">>>" ? 124 : Integer.MAX_VALUE));
            do {
                IClass iClass5;
                IClass iClass6;
                Rvalue rvalue = (Rvalue)iterator.next();
                if (iClass == null) {
                    iClass = rvalue.compileGetValue();
                    continue;
                }
                CodeContext.Inserter inserter = located.newInserter();
                IClass iClass7 = rvalue.compileGetValue();
                located.pushInserter(inserter);
                try {
                    iClass6 = Java.unaryNumericPromotion(located, iClass);
                }
                finally {
                    Object var10_24 = null;
                    located.popInserter();
                }
                if (iClass6 != IClass.INT && iClass6 != IClass.LONG) {
                    located.compileError("Shift operation not allowed on operand type \"" + iClass + "\"");
                }
                if ((iClass5 = Java.unaryNumericPromotion(located, iClass7)) != IClass.INT && iClass5 != IClass.LONG) {
                    located.compileError("Shift distance of type \"" + iClass7 + "\" is not allowed");
                }
                if (iClass5 == IClass.LONG) {
                    located.writeOpcode(-120);
                }
                located.writeOpcode(iClass6 == IClass.LONG ? n + 1 : n);
                iClass = iClass6;
            } while (iterator.hasNext());
            return iClass;
        }
        throw new RuntimeException("Unexpected operator \"" + string + "\"");
    }

    public static void compileError(String string) throws CompileException {
        Java.compileError(string, null);
    }

    public static void compileError(String string, Location location) throws CompileException {
        ErrorHandler errorHandler = (ErrorHandler)compileErrorHandler.get();
        if (errorHandler == null) {
            throw new CompileException(string, location);
        }
        errorHandler.handleError(string, location);
    }

    static void dup(Located located, int n) {
        switch (n) {
            case 1: {
                located.writeOpcode(89);
                break;
            }
            case 2: {
                located.writeOpcode(92);
                break;
            }
            default: {
                throw new RuntimeException("dup(" + n + ")");
            }
            case 0: 
        }
    }

    static void dupx(Located located, IClass iClass, int n) {
        if (n < 0 || n > 2) {
            throw new RuntimeException();
        }
        int n2 = 89 + n;
        int n3 = 92 + n;
        located.writeOpcode(iClass == IClass.LONG || iClass == IClass.DOUBLE ? n3 : n2);
    }

    private static void fillConversionMap(Object[] objectArray, HashMap hashMap) {
        byte[] byArray = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else {
                hashMap.put(object, byArray);
            }
            ++n;
        }
    }

    static IClass.IField findIField(IClass iClass, String string, Location location) throws CompileException {
        IClass.IField iField;
        IClass.IField[] iFieldArray = iClass.getDeclaredIFields();
        int n = 0;
        while (n < iFieldArray.length) {
            iField = iFieldArray[n];
            if (string.equals(iField.getName())) {
                return iField;
            }
            ++n;
        }
        iField = null;
        IClass iClass2 = iClass.getSuperclass();
        if (iClass2 != null) {
            iField = Java.findIField(iClass2, string, location);
        }
        IClass[] iClassArray = iClass.getInterfaces();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            IClass.IField iField2 = Java.findIField(iClassArray[n2], string, location);
            if (iField2 != null) {
                if (iField != null) {
                    throw new CompileException("Access to field \"" + string + "\" is ambiguous - both \"" + iField.getDeclaringIClass() + "\" and \"" + iField2.getDeclaringIClass() + "\" declare it", location);
                }
                iField = iField2;
            }
            ++n2;
        }
        return iField;
    }

    private static IClass.IMethod findIMethod(Located located, IClass iClass, final String string, Rvalue[] rvalueArray) throws CompileException {
        IClass iClass2 = iClass;
        while (iClass2 != null) {
            ArrayList arrayList = new ArrayList();
            Java.getIMethods(iClass2, string, arrayList);
            if (arrayList.size() > 0) {
                IClass.IMethod iMethod = (IClass.IMethod)Java.findMostSpecificIInvocable(located, arrayList.toArray(new IClass.IMethod[arrayList.size()]), rvalueArray);
                return iMethod;
            }
            iClass2 = iClass2.getDeclaringIClass();
        }
        located.compileError("Class \"" + iClass + "\" has no method named \"" + string + "\"");
        return new IClass.IMethod(iClass){

            public int getAccess() {
                return 3;
            }

            public String getName() {
                return string;
            }

            public IClass[] getParameterTypes() throws CompileException {
                return new IClass[0];
            }

            public IClass getReturnType() throws CompileException {
                return IClass.INT;
            }

            public IClass[] getThrownExceptions() throws CompileException {
                return new IClass[0];
            }

            public boolean isAbstract() {
                return false;
            }

            public boolean isStatic() {
                return false;
            }
        };
    }

    static IClass findMemberType(IClass iClass, String string, Location location) throws CompileException {
        IClass[] iClassArray = iClass.findMemberType(string);
        if (iClassArray.length == 0) {
            return null;
        }
        if (iClassArray.length == 1) {
            return iClassArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer("Type \"" + string + "\" is ambiguous: " + iClassArray[0].toString());
        int n = 1;
        while (n < iClassArray.length) {
            stringBuffer.append(" vs. ").append(iClassArray[n].toString());
            ++n;
        }
        Java.compileError(stringBuffer.toString(), location);
        return iClassArray[0];
    }

    /*
     * Unable to fully structure code
     */
    private static IClass.IInvocable findMostSpecificIInvocable(Located var0, final IClass.IInvocable[] var1_1, Rvalue[] var2_2) throws CompileException {
        block40: {
            if (var1_1.length == 0) {
                throw new RuntimeException();
            }
            var3_3 = new IClass[var2_2.length];
            var4_4 = 0;
            while (var4_4 < var2_2.length) {
                var3_3[var4_4] = var2_2[var4_4].getType();
                ++var4_4;
            }
            var5_5 = new ArrayList<ArrayList<E>>();
            var6_6 = 0;
            while (var6_6 < var1_1.length) {
                block39: {
                    var7_7 = var1_1[var6_6];
                    var8_8 = var7_7.getParameterTypes();
                    if (((IClass[])var8_8).length == var2_2.length) {
                        var9_11 = 0;
                        while (var9_11 < var2_2.length) {
                            if (Java.isMethodInvocationConvertible(var3_3[var9_11], var8_8[var9_11])) {
                                ++var9_11;
                                continue;
                            }
                            break block39;
                        }
                        var5_5.add(var7_7);
                    }
                }
                ++var6_6;
            }
            if (var5_5.size() == 0) {
                var7_7 = new StringBuffer();
                if (var3_3.length == 0) {
                    var7_7.append("zero actual parameters");
                } else {
                    var7_7.append("actual parameters \"").append(var3_3[0]);
                    var8_9 = 1;
                    while (var8_9 < var3_3.length) {
                        var7_7.append(", ").append(var3_3[var8_9]);
                        ++var8_9;
                    }
                    var7_7.append("\"");
                }
                var8_8 = new StringBuffer(String.valueOf('\"') + var1_1[0].toString() + '\"');
                var9_11 = 1;
                while (var9_11 < var1_1.length) {
                    var8_8.append(", ").append(String.valueOf('\"') + var1_1[var9_11].toString() + '\"');
                    ++var9_11;
                }
                var0.compileError("No applicable constructor/method found for " + var7_7.toString() + "; candidates are: " + var8_8.toString());
                if (var1_1[0] instanceof IClass.IConstructor) {
                    return new IClass.IConstructor(var1_1[0].getDeclaringIClass()){

                        public int getAccess() {
                            return 3;
                        }

                        public IClass[] getParameterTypes() {
                            return var3_3;
                        }

                        public IClass[] getThrownExceptions() {
                            return new IClass[0];
                        }
                    };
                }
                if (var1_1[0] instanceof IClass.IMethod) {
                    return new IClass.IMethod(var1_1[0].getDeclaringIClass()){

                        public int getAccess() {
                            return 3;
                        }

                        public String getName() {
                            return ((IClass.IMethod)var1_1[0]).getName();
                        }

                        public IClass[] getParameterTypes() {
                            return var3_3;
                        }

                        public IClass getReturnType() {
                            return IClass.INT;
                        }

                        public IClass[] getThrownExceptions() {
                            return new IClass[0];
                        }

                        public boolean isAbstract() {
                            return false;
                        }

                        public boolean isStatic() {
                            return true;
                        }
                    };
                }
                return var1_1[0];
            }
            if (var5_5.size() == 1) {
                return (IClass.IInvocable)var5_5.get(0);
            }
            var7_7 = new ArrayList<IClass.IInvocable>();
            var8_10 = 0;
            while (var8_10 < var5_5.size()) {
                var9_13 = (IClass.IInvocable)var5_5.get(var8_10);
                var10_16 = 0;
                var11_19 = 0;
                var12_22 = 0;
                while (var12_22 < var7_7.size()) {
                    var13_25 = (IClass[])var7_7.get(var12_22);
                    if (var9_13.isMoreSpecificThan((IClass.IInvocable)var13_25)) {
                        ++var10_16;
                    } else if (var9_13.isLessSpecificThan((IClass.IInvocable)var13_25)) {
                        ++var11_19;
                    }
                    ++var12_22;
                }
                if (var10_16 == var7_7.size()) {
                    var7_7.clear();
                    var7_7.add(var9_13);
                } else if (var11_19 < var7_7.size()) {
                    var7_7.add(var9_13);
                }
                ++var8_10;
            }
            if (var7_7.size() == 1) {
                return (IClass.IInvocable)var7_7.get(0);
            }
            if (var7_7.size() <= 1 || !(var1_1[0] instanceof IClass.IMethod)) break block40;
            var9_14 = (IClass.IMethod)var7_7.get(0);
            var10_17 = null;
            var11_20 = var7_7.iterator();
            var12_23 = (IClass.IMethod)var11_20.next();
            var13_25 = var12_23.getParameterTypes();
            block7: while (true) {
                if (!var12_23.isAbstract()) {
                    if (var10_17 != null) {
                        throw new RuntimeException("SNO: More than one non-abstract method with same signature and same declaring class!?");
                    }
                    var10_17 = var12_23;
                }
                if (!var11_20.hasNext()) break;
                var12_23 = (IClass.IMethod)var11_20.next();
                var14_26 = var12_23.getParameterTypes();
                var15_27 = 0;
                while (true) {
                    if (var15_27 >= var14_26.length) continue block7;
                    if (var14_26[var15_27] == var13_25[var15_27]) {
                        ++var15_27;
                        continue;
                    }
                    break block40;
                    break;
                }
                break;
            }
            if (var10_17 != null) {
                return var10_17;
            }
            var14_26 = new HashSet();
            var15_28 = new IClass[var7_7.size()][];
            var16_29 = var7_7.iterator();
            var17_30 = 0;
            while (var17_30 < var15_28.length) {
                var15_28[var17_30] = ((IClass.IMethod)var16_29.next()).getThrownExceptions();
                ++var17_30;
            }
            var18_31 = 0;
            while (var18_31 < var15_28.length) {
                var19_32 = 0;
                while (var19_32 < var15_28[var18_31].length) {
                    block41: {
                        var20_34 = var15_28[var18_31][var19_32];
                        var21_35 = 0;
                        block12: while (var21_35 < var15_28.length) {
                            if (var21_35 == var18_31) ** GOTO lbl136
                            var22_36 = 0;
                            while (var22_36 < var15_28[var21_35].length) {
                                var23_37 = var15_28[var21_35][var22_36];
                                if (!var23_37.isAssignableFrom(var20_34)) {
                                    ++var22_36;
                                    continue;
                                }
lbl136:
                                // 3 sources

                                ++var21_35;
                                continue block12;
                            }
                            break block41;
                        }
                        var14_26.add(var20_34);
                    }
                    ++var19_32;
                }
                ++var18_31;
            }
            var19_33 = var14_26.toArray(new IClass[var14_26.size()]);
            return new IClass.IMethod(var9_14.getDeclaringIClass()){

                public int getAccess() {
                    return var9_14.getAccess();
                }

                public String getName() {
                    return var9_14.getName();
                }

                public IClass[] getParameterTypes() throws CompileException {
                    return var9_14.getParameterTypes();
                }

                public IClass getReturnType() throws CompileException {
                    return var9_14.getReturnType();
                }

                public IClass[] getThrownExceptions() {
                    return var19_33;
                }

                public boolean isAbstract() {
                    return true;
                }

                public boolean isStatic() {
                    return false;
                }
            };
        }
        var9_15 = new StringBuffer("Invocation of constructor/method with actual parameter type(s) \"");
        var10_18 = 0;
        while (var10_18 < var2_2.length) {
            if (var10_18 > 0) {
                var9_15.append(", ");
            }
            var9_15.append(Descriptor.toString(var3_3[var10_18].getDescriptor()));
            ++var10_18;
        }
        var9_15.append("\" is ambiguous: ");
        var11_21 = 0;
        while (var11_21 < var7_7.size()) {
            if (var11_21 > 0) {
                var9_15.append(" vs. ");
            }
            var9_15.append("\"" + var7_7.get(var11_21) + "\"");
            ++var11_21;
        }
        var0.compileError(var9_15.toString());
        return (IClass.IMethod)var1_1[0];
    }

    private static IClass getArrayType(IClass iClass) {
        return Java.getIClassLoader().loadArrayIClass(iClass);
    }

    private static IClass getArrayType(IClass iClass, int n) {
        if (n == 0) {
            return iClass;
        }
        IClassLoader iClassLoader = Java.getIClassLoader();
        int n2 = 0;
        while (n2 < n) {
            iClass = iClassLoader.loadArrayIClass(iClass);
            ++n2;
        }
        return iClass;
    }

    private static CodeContext getCodeContext() {
        CodeContext codeContext = (CodeContext)Java.codeContext.get();
        if (codeContext == null) {
            throw new RuntimeException("S.N.O.: Null CodeContext");
        }
        return codeContext;
    }

    private static DebuggingInformation getDebuggingInformation() {
        DebuggingInformation debuggingInformation = (DebuggingInformation)Java.debuggingInformation.get();
        if (debuggingInformation == null) {
            throw new RuntimeException("S.N.O.: Null DebuggingInformation");
        }
        return debuggingInformation;
    }

    private static List getGeneratedClassFiles() {
        List list = (List)generatedClassFiles.get();
        if (list == null) {
            throw new RuntimeException("S.N.O.: Null generatedClassFiles");
        }
        return list;
    }

    public static IClassLoader getIClassLoader() {
        IClassLoader iClassLoader = (IClassLoader)Java.iClassLoader.get();
        if (iClassLoader == null) {
            throw new RuntimeException("S.N.O.: Null IClassLoader");
        }
        return iClassLoader;
    }

    private static void getIMethods(IClass iClass, String string, List list) throws CompileException {
        Object object;
        IClass.IMethod[] iMethodArray = iClass.getDeclaredIMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            object = iMethodArray[n];
            if (((IClass.IMethod)object).getName().equals(string)) {
                list.add(object);
            }
            ++n;
        }
        object = iClass.getSuperclass();
        if (object != null) {
            Java.getIMethods((IClass)object, string, list);
        }
        IClass[] iClassArray = iClass.getInterfaces();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            Java.getIMethods(iClassArray[n2], string, list);
            ++n2;
        }
        if (object == null && iClassArray.length == 0 && iClass.isInterface()) {
            IClass.IMethod[] iMethodArray2 = Java.getIClassLoader().OBJECT.getDeclaredIMethods();
            int n3 = 0;
            while (n3 < iMethodArray2.length) {
                IClass.IMethod iMethod = iMethodArray2[n3];
                if (iMethod.getName().equals(string) && !iMethod.isStatic() && iMethod.getAccess() == 3) {
                    list.add(iMethod);
                }
                ++n3;
            }
        }
    }

    private static StringPattern[] getOptionalWarningHandlePatterns() {
        return (StringPattern[])optionalWarningHandlePatterns.get();
    }

    private static List getOuterClasses(IClass iClass) throws CompileException {
        ArrayList<IClass> arrayList = new ArrayList<IClass>();
        IClass iClass2 = iClass;
        while (iClass2 != null) {
            arrayList.add(iClass2);
            iClass2 = iClass2.getOuterIClass();
        }
        return arrayList;
    }

    private static int ilfd(IClass iClass) {
        if (iClass == IClass.BYTE || iClass == IClass.CHAR || iClass == IClass.INT || iClass == IClass.SHORT || iClass == IClass.BOOLEAN) {
            return 0;
        }
        if (iClass == IClass.LONG) {
            return 1;
        }
        if (iClass == IClass.FLOAT) {
            return 2;
        }
        if (iClass == IClass.DOUBLE) {
            return 3;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    private static int ilfd(IClass iClass, int n, int n2, int n3, int n4) {
        if (iClass == IClass.BYTE || iClass == IClass.CHAR || iClass == IClass.INT || iClass == IClass.SHORT || iClass == IClass.BOOLEAN) {
            return n;
        }
        if (iClass == IClass.LONG) {
            return n2;
        }
        if (iClass == IClass.FLOAT) {
            return n3;
        }
        if (iClass == IClass.DOUBLE) {
            return n4;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    private static int ilfda(IClass iClass) {
        return !iClass.isPrimitive() ? 4 : Java.ilfd(iClass);
    }

    private static int ilfdabcs(IClass iClass) {
        if (iClass == IClass.INT) {
            return 0;
        }
        if (iClass == IClass.LONG) {
            return 1;
        }
        if (iClass == IClass.FLOAT) {
            return 2;
        }
        if (iClass == IClass.DOUBLE) {
            return 3;
        }
        if (!iClass.isPrimitive()) {
            return 4;
        }
        if (iClass == IClass.BOOLEAN || iClass == IClass.BYTE) {
            return 5;
        }
        if (iClass == IClass.CHAR) {
            return 6;
        }
        if (iClass == IClass.SHORT) {
            return 7;
        }
        throw new RuntimeException("Unexpected type \"" + iClass + "\"");
    }

    private static void invokeConstructor(Located located, Scope scope, Rvalue rvalue, IClass iClass, Rvalue[] rvalueArray) throws CompileException {
        IClass[] iClassArray;
        IClass.IInvocable[] iInvocableArray = iClass.getDeclaredIConstructors();
        if (iInvocableArray.length == 0) {
            throw new RuntimeException();
        }
        IClass.IConstructor iConstructor = (IClass.IConstructor)Java.findMostSpecificIInvocable(located, iInvocableArray, rvalueArray);
        IClass[] iClassArray2 = iConstructor.getThrownExceptions();
        int n = 0;
        while (n < iClassArray2.length) {
            Java.checkThrownException(located, iClassArray2[n], scope);
            ++n;
        }
        IClass iClass2 = iClass.getOuterIClass();
        if (iClass2 != null) {
            if (rvalue == null) {
                located.compileError("Enclosing instance for initialization of inner class \"" + iClass + "\" missing");
            }
            if (!iClass2.isAssignableFrom((IClass)(iClassArray = rvalue.compileGetValue()))) {
                located.compileError("Type of enclosing instance (\"" + iClassArray + "\") is not assignable to \"" + iClass2 + "\"");
            }
        }
        if (iClass instanceof ClassDeclaration) {
            iClassArray = (ClassDeclaration)iClass;
            Scope scope2 = scope;
            while (!(scope2 instanceof TypeBodyDeclaration)) {
                scope2 = scope2.getEnclosingScope();
            }
            TypeBodyDeclaration typeBodyDeclaration = (TypeBodyDeclaration)scope2;
            TypeDeclaration typeDeclaration = typeBodyDeclaration.getDeclaringType();
            if (!(typeDeclaration instanceof ClassDeclaration)) {
                if (!((ClassDeclaration)iClassArray).syntheticFields.isEmpty()) {
                    throw new RuntimeException();
                }
            } else {
                ClassDeclaration classDeclaration = (ClassDeclaration)typeDeclaration;
                Iterator iterator = ((ClassDeclaration)iClassArray).syntheticFields.values().iterator();
                while (iterator.hasNext()) {
                    LocalVariable localVariable;
                    Object object;
                    IClass.IField iField = (IClass.IField)iterator.next();
                    if (!iField.getName().startsWith("val$")) continue;
                    IClass.IField iField2 = (IClass.IField)classDeclaration.syntheticFields.get(iField.getName());
                    if (iField2 != null) {
                        if (typeBodyDeclaration instanceof MethodDeclarator) {
                            Java.load(located, classDeclaration, 0);
                            located.writeOpcode(-76);
                            located.writeConstantFieldrefInfo(classDeclaration.getDescriptor(), iField.getName(), iField.getDescriptor());
                            continue;
                        }
                        if (typeBodyDeclaration instanceof ConstructorDeclarator) {
                            object = (ConstructorDeclarator)typeBodyDeclaration;
                            localVariable = (LocalVariable)((ConstructorDeclarator)object).syntheticParameters.get(iField.getName());
                            if (localVariable == null) {
                                located.compileError("Compiler limitation: Constructor cannot access local variable \"" + iField.getName().substring(4) + "\" declared in an enclosing block because none of the methods accesses it. As a workaround, declare a dummy method that accesses the local variable.");
                                located.writeOpcode(1);
                                continue;
                            }
                            Java.load(located, localVariable);
                            continue;
                        }
                        located.compileError("Compiler limitation: Initializers cannot access local variables declared in an enclosing block.");
                        located.writeOpcode(1);
                        continue;
                    }
                    object = iField.getName().substring(4);
                    localVariable = null;
                    Scope scope3 = scope;
                    while (scope3 instanceof Block) {
                        localVariable = (LocalVariable)((Block)scope3).localVariables.get(object);
                        if (localVariable != null) break;
                        scope3 = scope3.getEnclosingScope();
                    }
                    if (localVariable == null) {
                        while (!(scope3 instanceof FunctionDeclarator)) {
                            scope3 = scope3.getEnclosingScope();
                        }
                        FunctionDeclarator functionDeclarator = (FunctionDeclarator)scope3;
                        localVariable = (LocalVariable)functionDeclarator.parameters.get(object);
                    }
                    if (localVariable == null) {
                        throw new RuntimeException("SNO: Synthetic field \"" + iField.getName() + "\" neither maps a synthetic field of an enclosing instance nor a local variable");
                    }
                    Java.load(located, localVariable);
                }
            }
        }
        iClassArray = iConstructor.getParameterTypes();
        int n2 = 0;
        while (n2 < rvalueArray.length) {
            Java.assignmentConversion(located, rvalueArray[n2].compileGetValue(), iClassArray[n2], rvalueArray[n2].getConstantValue());
            ++n2;
        }
        located.writeOpcode(-73);
        located.writeConstantMethodrefInfo(iClass.getDescriptor(), "<init>", iConstructor.getDescriptor());
    }

    private static boolean isConstantPrimitiveAssignmentConvertible(Object object, IClass iClass) {
        int n;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer) {
            n = ((Number)object).intValue();
        } else if (object instanceof Character) {
            n = ((Character)object).charValue();
        } else {
            return false;
        }
        if (iClass == IClass.BYTE) {
            return n >= -128 && n <= 127;
        }
        if (iClass == IClass.SHORT) {
            return n >= Short.MIN_VALUE && n <= Short.MAX_VALUE;
        }
        if (iClass == IClass.CHAR) {
            return n >= 0 && n <= 65535;
        }
        return false;
    }

    private static boolean isMethodInvocationConvertible(IClass iClass, IClass iClass2) throws CompileException {
        if (iClass == iClass2) {
            return true;
        }
        if (Java.isWideningPrimitiveConvertible(iClass, iClass2)) {
            return true;
        }
        return Java.isWideningReferenceConvertible(iClass, iClass2);
    }

    private static boolean isNarrowingPrimitiveConvertible(IClass iClass, IClass iClass2) throws CompileException {
        return PRIMITIVE_NARROWING_CONVERSIONS.containsKey(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
    }

    private static boolean isNarrowingReferenceConvertible(IClass iClass, IClass iClass2) throws CompileException {
        IClass iClass3;
        IClass iClass4;
        if (iClass.isPrimitive()) {
            return false;
        }
        if (iClass == iClass2) {
            return false;
        }
        if (iClass.isAssignableFrom(iClass2)) {
            return true;
        }
        if (iClass2.isInterface() && !iClass.isFinal() && !iClass2.isAssignableFrom(iClass)) {
            return true;
        }
        if (iClass == Java.getIClassLoader().OBJECT && iClass2.isArray()) {
            return true;
        }
        if (iClass == Java.getIClassLoader().OBJECT && iClass2.isInterface()) {
            return true;
        }
        if (iClass.isInterface() && !iClass2.isFinal()) {
            return true;
        }
        if (iClass.isInterface() && iClass2.isFinal() && iClass.isAssignableFrom(iClass2)) {
            return true;
        }
        if (iClass.isInterface() && iClass2.isInterface() && !iClass2.isAssignableFrom(iClass)) {
            return true;
        }
        return iClass.isArray() && iClass2.isArray() && (Java.isNarrowingPrimitiveConvertible(iClass4 = iClass.getComponentType(), iClass3 = iClass2.getComponentType()) || Java.isNarrowingReferenceConvertible(iClass4, iClass3));
    }

    public static boolean isWideningPrimitiveConvertible(IClass iClass, IClass iClass2) {
        return PRIMITIVE_WIDENING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor()) != null;
    }

    public static boolean isWideningReferenceConvertible(IClass iClass, IClass iClass2) throws CompileException {
        if (iClass2.isPrimitive() || iClass == iClass2) {
            return false;
        }
        if (iClass.isSubclassOf(iClass2)) {
            return true;
        }
        if (iClass.implementsInterface(iClass2)) {
            return true;
        }
        IClassLoader iClassLoader = Java.getIClassLoader();
        if (iClass == IClass.VOID && !iClass2.isPrimitive()) {
            return true;
        }
        if (iClass.isInterface() && iClass2 == iClassLoader.OBJECT) {
            return true;
        }
        if (iClass.isArray()) {
            if (iClass2 == iClassLoader.OBJECT) {
                return true;
            }
            if (iClass2 == iClassLoader.CLONEABLE) {
                return true;
            }
            if (iClass2 == iClassLoader.SERIALIZABLE) {
                return true;
            }
            if (iClass2.isArray() && Java.isWideningReferenceConvertible(iClass.getComponentType(), iClass2.getComponentType())) {
                return true;
            }
        }
        return false;
    }

    public static String join(Object[] objectArray, String string) {
        return Java.join(objectArray, string, 0, objectArray.length);
    }

    public static String join(Object[] objectArray, String string, int n, int n2) {
        if (objectArray == null) {
            return "(null)";
        }
        if (n >= n2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(objectArray[n].toString());
        ++n;
        while (n < n2) {
            stringBuffer.append(string);
            stringBuffer.append(objectArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String join(String[] stringArray, String string, int n, String string2) {
        if (stringArray == null) {
            return "(null)";
        }
        if (stringArray.length == 0) {
            return "(zero length array)";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n2 = 1;
        while (n2 < stringArray.length) {
            stringBuffer.append(n2 < n ? string : string2);
            stringBuffer.append(stringArray[n2]);
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static void leaveStatements(Scope scope, Scope scope2, IClass iClass) {
        Scope scope3 = scope;
        while (scope3 != scope2) {
            if (scope3 instanceof BlockStatement) {
                ((BlockStatement)scope3).leave(iClass);
            }
            scope3 = scope3.getEnclosingScope();
        }
    }

    private static void load(Located located, IClass iClass, int n) {
        if (n <= 3) {
            located.writeOpcode(26 + 4 * Java.ilfda(iClass) + n);
        } else if (n <= 255) {
            located.writeOpcode(21 + Java.ilfda(iClass));
            located.writeByte(n);
        } else {
            located.writeOpcode(-60);
            located.writeOpcode(21 + Java.ilfda(iClass));
            located.writeShort(n);
        }
    }

    private static IClass load(Located located, LocalVariable localVariable) {
        Java.load(located, localVariable.type, localVariable.localVariableArrayIndex);
        return localVariable.type;
    }

    public static IClass loadFullyQualifiedClass(String[] stringArray) {
        IClassLoader iClassLoader = Java.getIClassLoader();
        int[] nArray = new int[stringArray.length - 1];
        StringBuffer stringBuffer = new StringBuffer("L");
        int n = 0;
        while (true) {
            stringBuffer.append(stringArray[n]);
            if (n == stringArray.length - 1) break;
            nArray[n] = stringBuffer.length();
            stringBuffer.append('/');
            ++n;
        }
        stringBuffer.append(';');
        int n2 = nArray.length - 1;
        while (true) {
            IClass iClass;
            if ((iClass = iClassLoader.loadIClass(stringBuffer.toString())) != null) {
                return iClass;
            }
            if (n2 < 0) break;
            stringBuffer.setCharAt(nArray[n2], '$');
            --n2;
        }
        return null;
    }

    private static IClass newArray(Located located, int n, int n2, IClass iClass) {
        if (n == 1 && n2 == 0 && iClass.isPrimitive()) {
            located.writeOpcode(-68);
            located.writeByte(iClass == IClass.BOOLEAN ? 4 : (iClass == IClass.CHAR ? 5 : (iClass == IClass.FLOAT ? 6 : (iClass == IClass.DOUBLE ? 7 : (iClass == IClass.BYTE ? 8 : (iClass == IClass.SHORT ? 9 : (iClass == IClass.INT ? 10 : (iClass == IClass.LONG ? 11 : -1))))))));
            return Java.getArrayType(iClass);
        }
        if (n == 1) {
            IClass iClass2 = Java.getArrayType(iClass, n2);
            located.writeOpcode(-67);
            located.writeConstantClassInfo(iClass2.getDescriptor());
            return Java.getArrayType(iClass2, 1);
        }
        IClass iClass3 = Java.getArrayType(iClass, n + n2);
        located.writeOpcode(-59);
        located.writeConstantClassInfo(iClass3.getDescriptor());
        located.writeByte(n);
        return iClass3;
    }

    private static void pop(Located located, IClass iClass) {
        if (iClass == IClass.VOID) {
            return;
        }
        located.writeOpcode(iClass == IClass.LONG || iClass == IClass.DOUBLE ? 88 : 87);
    }

    private static IClass pushConstant(Located located, Object object) {
        if (object instanceof Integer || object instanceof Short || object instanceof Character || object instanceof Byte) {
            int n;
            int n2 = n = object instanceof Character ? ((Character)object).charValue() : ((Number)object).intValue();
            if (n >= -1 && n <= 5) {
                located.writeOpcode(3 + n);
            } else if (n >= -128 && n <= 127) {
                located.writeOpcode(16);
                located.writeByte((byte)n);
            } else {
                Java.writeLDC(located, located.addConstantIntegerInfo(n));
            }
            return IClass.INT;
        }
        if (object instanceof Long) {
            long l = (Long)object;
            if (l >= 0L && l <= 1L) {
                located.writeOpcode(9 + (int)l);
            } else {
                located.writeOpcode(20);
                located.writeConstantLongInfo(l);
            }
            return IClass.LONG;
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            if (f == 0.0f || f == 1.0f || f == 2.0f) {
                located.writeOpcode(11 + (int)f);
            } else {
                Java.writeLDC(located, located.addConstantFloatInfo(f));
            }
            return IClass.FLOAT;
        }
        if (object instanceof Double) {
            double d = (Double)object;
            if (d == 0.0 || d == 1.0) {
                located.writeOpcode(14 + (int)d);
            } else {
                located.writeOpcode(20);
                located.writeConstantDoubleInfo(d);
            }
            return IClass.DOUBLE;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() < 21845) {
                Java.writeLDC(located, located.addConstantStringInfo((String)object));
                return Java.getIClassLoader().STRING;
            }
            int n = string.length();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                char c;
                if (n5 == n || n3 >= 65532) {
                    Java.writeLDC(located, located.addConstantStringInfo(string.substring(n4, n5)));
                    if (n4 != 0) {
                        located.writeOpcode(-74);
                        located.writeConstantMethodrefInfo("Ljava/lang/String;", "concat", "(Ljava/lang/String;)Ljava/lang/String;");
                    }
                    if (n5 == n) break;
                    n4 = n5;
                    n3 = 0;
                }
                n3 = (c = string.charAt(n5)) >= '\u0001' && c <= '\u007f' ? ++n3 : (c > '\u07ff' ? (n3 += 3) : (n3 += 2));
                ++n5;
            }
            return Java.getIClassLoader().STRING;
        }
        if (object instanceof Boolean) {
            located.writeOpcode((Boolean)object != false ? 4 : 3);
            return IClass.BOOLEAN;
        }
        if (object == Rvalue.CONSTANT_VALUE_NULL) {
            located.writeOpcode(1);
            return IClass.VOID;
        }
        throw new RuntimeException("Unknown literal type \"" + object.getClass().getName() + "\"");
    }

    private static Atom reclassifyName(Location location, Scope scope, final String string) throws CompileException {
        IClass iClass;
        Object object;
        Object object2;
        Object object3;
        TypeBodyDeclaration typeBodyDeclaration = null;
        TypeDeclaration typeDeclaration = null;
        Scope scope2 = scope;
        while (scope2 instanceof Statement && !(scope2 instanceof TypeBodyDeclaration)) {
            scope2 = scope2.getEnclosingScope();
        }
        if (scope2 instanceof TypeBodyDeclaration) {
            typeBodyDeclaration = (TypeBodyDeclaration)scope2;
            scope2 = scope2.getEnclosingScope();
        }
        if (scope2 instanceof TypeDeclaration) {
            typeDeclaration = (TypeDeclaration)scope2;
            scope2 = scope2.getEnclosingScope();
        }
        while (!(scope2 instanceof CompilationUnit)) {
            scope2 = scope2.getEnclosingScope();
        }
        CompilationUnit compilationUnit = (CompilationUnit)scope2;
        InnerClassDeclaration innerClassDeclaration = null;
        Scope scope3 = scope;
        while (!(scope3 instanceof CompilationUnit)) {
            if (scope3 instanceof InnerClassDeclaration) {
                innerClassDeclaration = (InnerClassDeclaration)((Object)scope3);
            } else {
                object3 = null;
                if (scope3 instanceof Block) {
                    object2 = (Block)scope3;
                    object3 = (LocalVariable)((Block)object2).localVariables.get(string);
                } else if (scope3 instanceof FunctionDeclarator) {
                    object2 = (FunctionDeclarator)scope3;
                    object3 = (LocalVariable)((FunctionDeclarator)object2).parameters.get(string);
                }
                if (object3 != null) {
                    if (innerClassDeclaration == null) {
                        return new LocalVariableAccess(location, (LocalVariable)object3);
                    }
                    if (!((LocalVariable)object3).finaL) {
                        Java.compileError("Cannot access non-final local variable \"" + string + "\" from inner class");
                    }
                    object2 = ((LocalVariable)object3).type;
                    IClass.IField iField = new IClass.IField((IClass)object2, (IClass)((Object)innerClassDeclaration)){
                        private final /* synthetic */ IClass val$lvType;
                        {
                            this.val$lvType = iClass;
                        }

                        public int getAccess() {
                            return 2;
                        }

                        public Object getConstantValue() {
                            return null;
                        }

                        public String getName() {
                            return "val$" + string;
                        }

                        public IClass getType() {
                            return this.val$lvType;
                        }

                        public boolean isStatic() {
                            return false;
                        }
                    };
                    innerClassDeclaration.defineSyntheticField(iField);
                    return new FieldAccess(location, new QualifiedThisReference(location, typeBodyDeclaration, new SimpleType(location, (IClass)((Object)innerClassDeclaration))), iField);
                }
            }
            scope3 = scope3.getEnclosingScope();
        }
        object3 = scope;
        while (!(object3 instanceof CompilationUnit)) {
            if (object3 instanceof TypeDeclaration && (object = Java.findIField((IClass)(object2 = (TypeDeclaration)object3), string, location)) != null) {
                if (((IClass.IField)object).isStatic()) {
                    Java.warning("IASF", "Implicit access to static field \"" + string + "\" of declaring class (better write \"" + ((IClass.IField)object).getDeclaringIClass() + '.' + ((IClass.IField)object).getName() + "\")", location);
                } else if (((IClass.IField)object).getDeclaringIClass() == object2) {
                    Java.warning("IANSF", "Implicit access to non-static field \"" + string + "\" of declaring class (better write \"this." + ((IClass.IField)object).getName() + "\")", location);
                } else {
                    Java.warning("IANSFEI", "Implicit access to non-static field \"" + string + "\" of enclosing instance (better write \"" + ((IClass.IField)object).getDeclaringIClass() + ".this." + ((IClass.IField)object).getName() + "\")", location);
                }
                SimpleType simpleType = new SimpleType(typeDeclaration.getLocation(), (IClass)object2);
                Atom atom = typeBodyDeclaration.isStatic() ? simpleType : (((IClass.IField)object).isStatic() ? simpleType : new QualifiedThisReference(location, typeBodyDeclaration, simpleType));
                return new FieldAccess(location, atom, (IClass.IField)object);
            }
            object3 = object3.getEnclosingScope();
        }
        if (string.equals("java")) {
            return new Package(location, string);
        }
        object2 = scope;
        while (object2 instanceof Block) {
            object = object2;
            iClass = ((Block)object).getLocalClassDeclaration(string);
            if (iClass != null) {
                return new SimpleType(location, iClass);
            }
            object2 = object2.getEnclosingScope();
        }
        if (typeDeclaration != null && (object = Java.findMemberType((IClass)((Object)typeDeclaration), string, location)) != null) {
            return new SimpleType(location, (IClass)object);
        }
        if (compilationUnit != null && (object = compilationUnit.importSingleType(string, location)) != null) {
            return new SimpleType(location, (IClass)object);
        }
        if (compilationUnit != null && (object = compilationUnit.getPackageMemberTypeDeclaration(string)) != null) {
            return new SimpleType(location, (IClass)object);
        }
        if (compilationUnit != null) {
            object = compilationUnit.optionalPackageDeclaration == null ? string : String.valueOf(compilationUnit.optionalPackageDeclaration.getPackageName()) + '.' + string;
            iClass = Java.getIClassLoader().loadIClass(Descriptor.fromClassName((String)object));
            if (iClass != null) {
                return new SimpleType(location, iClass);
            }
        }
        if (compilationUnit != null && (object = compilationUnit.importTypeOnDemand(string, location)) != null) {
            return new SimpleType(location, (IClass)object);
        }
        return new Package(location, string);
    }

    private static Atom reclassifyName(Location location, Scope scope, final String[] stringArray, int n) throws CompileException {
        if (n == 1) {
            return Java.reclassifyName(location, scope, stringArray[0]);
        }
        Atom atom = Java.reclassifyName(location, scope, stringArray, n - 1);
        String string = stringArray[n - 1];
        if (atom instanceof Package) {
            String string2 = String.valueOf(((Package)atom).getName()) + '.' + string;
            IClass iClass = Java.getIClassLoader().loadIClass(Descriptor.fromClassName(string2));
            if (iClass != null) {
                return new SimpleType(location, iClass);
            }
            return new Package(location, string2);
        }
        if (string.equals("length") && atom.getType().isArray()) {
            return new ArrayLength(location, atom.toRvalueOrCE());
        }
        IClass iClass = atom.getType();
        IClass.IField iField = Java.findIField(iClass, string, location);
        if (iField != null) {
            return new FieldAccess(location, atom, iField);
        }
        IClass[] iClassArray = iClass.getDeclaredIClasses();
        int n2 = 0;
        while (n2 < iClassArray.length) {
            IClass iClass2 = iClassArray[n2];
            String string3 = Descriptor.toClassName(iClass2.getDescriptor());
            if ((string3 = string3.substring(string3.lastIndexOf(36) + 1)).equals(string)) {
                return new SimpleType(location, iClass2);
            }
            ++n2;
        }
        Java.compileError("\"" + string + "\" is neither a method, a field, nor a member class of \"" + iClass + "\"", location);
        return new Atom(location){

            public IClass getType() {
                return Java.getIClassLoader().OBJECT;
            }

            public String toString() {
                return Java.join(stringArray, ".");
            }

            public final void visit(Visitor visitor) {
            }
        };
    }

    static void referenceThis(Located located) {
        located.writeOpcode(42);
    }

    static void referenceThis(Located located, ClassDeclaration classDeclaration, TypeBodyDeclaration typeBodyDeclaration, IClass iClass) throws CompileException {
        int n;
        Object object;
        Object object2;
        int n2;
        List list;
        block8: {
            list = Java.getOuterClasses(classDeclaration);
            if (typeBodyDeclaration.isStatic()) {
                located.compileError("No current instance available instatic context");
            }
            n2 = 0;
            while (n2 < list.size()) {
                if (!iClass.isAssignableFrom((IClass)list.get(n2))) {
                    ++n2;
                    continue;
                }
                break block8;
            }
            located.compileError("\"" + classDeclaration + "\" is not enclosed by \"" + iClass + "\"");
        }
        if (typeBodyDeclaration instanceof ConstructorDeclarator) {
            if (n2 == 0) {
                located.writeOpcode(42);
                return;
            }
            object2 = (ConstructorDeclarator)typeBodyDeclaration;
            object = (LocalVariable)((ConstructorDeclarator)object2).syntheticParameters.get("this$" + (list.size() - 2));
            if (object == null) {
                throw new RuntimeException();
            }
            Java.load(located, (LocalVariable)object);
            n = 1;
        } else {
            located.writeOpcode(42);
            n = 0;
        }
        while (n < n2) {
            object2 = "this$" + (list.size() - n - 2);
            object = (IClass)list.get(n);
            IClass iClass2 = (IClass)list.get(n + 1);
            ((InnerClassDeclaration)object).defineSyntheticField(new IClass.IField((String)object2, iClass2, (IClass)object){
                private final /* synthetic */ IClass val$outer;
                private final /* synthetic */ String val$fieldName;
                {
                    this.val$fieldName = string;
                    this.val$outer = iClass;
                }

                public int getAccess() {
                    return 2;
                }

                public Object getConstantValue() {
                    return null;
                }

                public String getName() {
                    return this.val$fieldName;
                }

                public IClass getType() {
                    return this.val$outer;
                }

                public boolean isStatic() {
                    return false;
                }
            });
            located.writeOpcode(-76);
            located.writeConstantFieldrefInfo(((IClass)object).getDescriptor(), (String)object2, iClass2.getDescriptor());
            ++n;
        }
    }

    private static CodeContext replaceCodeContext(CodeContext codeContext) {
        CodeContext codeContext2 = (CodeContext)Java.codeContext.get();
        Java.codeContext.set(codeContext);
        return codeContext2;
    }

    private static DebuggingInformation replaceDebuggingInformation(DebuggingInformation debuggingInformation) {
        DebuggingInformation debuggingInformation2 = (DebuggingInformation)Java.debuggingInformation.get();
        Java.debuggingInformation.set(debuggingInformation);
        return debuggingInformation2;
    }

    private static List replaceGeneratedClassFiles(List list) {
        List list2 = (List)generatedClassFiles.get();
        generatedClassFiles.set(list);
        return list2;
    }

    public static IClassLoader replaceIClassLoader(IClassLoader iClassLoader) {
        IClassLoader iClassLoader2 = (IClassLoader)Java.iClassLoader.get();
        Java.iClassLoader.set(iClassLoader);
        return iClassLoader2;
    }

    public static void setCompileErrorHandler(ErrorHandler errorHandler) {
        compileErrorHandler.set(errorHandler);
    }

    public static void setWarningHandlePatterns(StringPattern[] stringPatternArray) {
        optionalWarningHandlePatterns.set(stringPatternArray);
    }

    public static void setWarningHandler(WarningHandler warningHandler) {
        Java.warningHandler.set(warningHandler);
    }

    private static void store(Located located, IClass iClass, LocalVariable localVariable) throws CompileException {
        Java.store(located, localVariable.type, localVariable.localVariableArrayIndex);
    }

    private static void store(Located located, IClass iClass, short s) {
        if (s <= 3) {
            located.writeOpcode(59 + 4 * Java.ilfda(iClass) + s);
        } else if (s <= 255) {
            located.writeOpcode(54 + Java.ilfda(iClass));
            located.writeByte(s);
        } else {
            located.writeOpcode(-60);
            located.writeOpcode(54 + Java.ilfda(iClass));
            located.writeShort(s);
        }
    }

    private static void stringConversion(Located located, IClass iClass) {
        located.writeOpcode(-72);
        located.writeConstantMethodrefInfo("Ljava/lang/String;", "valueOf", "(" + (iClass == IClass.BOOLEAN || iClass == IClass.CHAR || iClass == IClass.LONG || iClass == IClass.FLOAT || iClass == IClass.DOUBLE ? iClass.getDescriptor() : (iClass == IClass.BYTE || iClass == IClass.SHORT || iClass == IClass.INT ? "I" : "Ljava/lang/Object;")) + ")" + "Ljava/lang/String;");
    }

    public static boolean tryIdentityConversion(IClass iClass, IClass iClass2) throws CompileException {
        return iClass == iClass2;
    }

    private static boolean tryNarrowingPrimitiveConversion(Located located, IClass iClass, IClass iClass2) throws CompileException {
        byte[] byArray = (byte[])PRIMITIVE_NARROWING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
        if (byArray != null) {
            located.write(byArray);
            return true;
        }
        return false;
    }

    private static boolean tryNarrowingReferenceConversion(Located located, IClass iClass, IClass iClass2) throws CompileException {
        if (!Java.isNarrowingReferenceConvertible(iClass, iClass2)) {
            return false;
        }
        located.writeOpcode(-64);
        located.writeConstantClassInfo(iClass2.getDescriptor());
        return true;
    }

    public static boolean tryWideningPrimitiveConversion(Located located, IClass iClass, IClass iClass2) throws CompileException {
        byte[] byArray = (byte[])PRIMITIVE_WIDENING_CONVERSIONS.get(String.valueOf(iClass.getDescriptor()) + iClass2.getDescriptor());
        if (byArray != null) {
            located.write(byArray);
            return true;
        }
        return false;
    }

    private static IClass unaryNumericPromotion(Located located, IClass iClass) throws CompileException {
        IClass iClass2 = Java.unaryNumericPromotionType(located, iClass);
        if (!Java.tryIdentityConversion(iClass, iClass2) && !Java.tryWideningPrimitiveConversion(located, iClass, iClass2)) {
            throw new RuntimeException();
        }
        return iClass2;
    }

    private static IClass unaryNumericPromotionType(Located located, IClass iClass) throws CompileException {
        if (!iClass.isPrimitiveNumeric()) {
            located.compileError("Unary numeric promotion not possible on non-numeric-primitive type \"" + iClass + "\"");
        }
        return iClass == IClass.DOUBLE ? IClass.DOUBLE : (iClass == IClass.FLOAT ? IClass.FLOAT : (iClass == IClass.LONG ? IClass.LONG : IClass.INT));
    }

    public static void warning(String string, String string2, Location location) {
        WarningHandler warningHandler = (WarningHandler)Java.warningHandler.get();
        if (warningHandler != null && StringPattern.matches(Java.getOptionalWarningHandlePatterns(), string)) {
            warningHandler.handleWarning(string, string2, location);
        }
    }

    private static void writeLDC(Located located, short s) {
        if (s <= 255) {
            located.writeOpcode(18);
            located.writeByte((byte)s);
        } else {
            located.writeOpcode(19);
            located.writeShort(s);
        }
    }

    public static interface Scope {
        public Scope getEnclosingScope();
    }

    public static interface Locatable {
        public void compileError(String var1) throws CompileException;

        public Location getLocation();

        public void throwParseException(String var1) throws Parser.ParseException;
    }

    private static abstract class Located
    implements Locatable {
        private final Location location;

        protected Located(Location location) {
            this.location = location;
        }

        public short addConstantFloatInfo(float f) {
            return Java.getCodeContext().getClassFile().addConstantFloatInfo(f);
        }

        public short addConstantIntegerInfo(int n) {
            return Java.getCodeContext().getClassFile().addConstantIntegerInfo(n);
        }

        public short addConstantStringInfo(String string) {
            return Java.getCodeContext().getClassFile().addConstantStringInfo(string);
        }

        public short allocateLocalVariable(short s) {
            return Java.getCodeContext().allocateLocalVariable(s);
        }

        public void compileError(String string) throws CompileException {
            Java.compileError(string, this.location);
        }

        public CodeContext createDummyCodeContext() {
            return new CodeContext(Java.getCodeContext().getClassFile());
        }

        public Location getLocation() {
            return this.location;
        }

        public CodeContext.Inserter newInserter() {
            return Java.getCodeContext().newInserter();
        }

        public CodeContext.Offset newOffset() {
            return Java.getCodeContext().newOffset();
        }

        public CodeContext.Offset newUnsetOffset() {
            return Java.getCodeContext().new CodeContext.Offset();
        }

        public void popInserter() {
            Java.getCodeContext().popInserter();
        }

        public void pushInserter(CodeContext.Inserter inserter) {
            Java.getCodeContext().pushInserter(inserter);
        }

        public void restoreLocalVariables() {
            Java.getCodeContext().restoreLocalVariables();
        }

        public void saveLocalVariables() {
            Java.getCodeContext().saveLocalVariables();
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }

        public void write(byte[] byArray) {
            Java.getCodeContext().write(this.getLocation().getLineNumber(), byArray);
        }

        public void writeBranch(int n, CodeContext.Offset offset) {
            Java.getCodeContext().writeBranch(this.getLocation().getLineNumber(), n, offset);
        }

        public void writeByte(int n) {
            Java.getCodeContext().write(this.getLocation().getLineNumber(), new byte[]{(byte)n});
        }

        public void writeConstantClassInfo(String string) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantClassInfo(string));
        }

        public void writeConstantDoubleInfo(double d) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantDoubleInfo(d));
        }

        public void writeConstantFieldrefInfo(String string, String string2, String string3) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantFieldrefInfo(string, string2, string3));
        }

        public void writeConstantFloatInfo(float f) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantFloatInfo(f));
        }

        public void writeConstantIntegerInfo(int n) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantIntegerInfo(n));
        }

        public void writeConstantInterfaceMethodrefInfo(String string, String string2, String string3) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantInterfaceMethodrefInfo(string, string2, string3));
        }

        public void writeConstantLongInfo(long l) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantLongInfo(l));
        }

        public void writeConstantMethodrefInfo(String string, String string2, String string3) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantMethodrefInfo(string, string2, string3));
        }

        public void writeConstantStringInfo(String string) {
            CodeContext codeContext = Java.getCodeContext();
            codeContext.writeShort(this.getLocation().getLineNumber(), codeContext.getClassFile().addConstantStringInfo(string));
        }

        public void writeInt(int n) {
            Java.getCodeContext().write(this.getLocation().getLineNumber(), new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n});
        }

        public void writeOffset(CodeContext.Offset offset, CodeContext.Offset offset2) {
            Java.getCodeContext().writeOffset(this.getLocation().getLineNumber(), offset, offset2);
        }

        public void writeOpcode(int n) {
            this.writeByte(n);
        }

        public void writeShort(int n) {
            Java.getCodeContext().write(this.getLocation().getLineNumber(), new byte[]{(byte)(n >> 8), (byte)n});
        }
    }

    public static final class CompilationUnit
    implements Scope {
        private String optionalFileName;
        private final Map onDemandImportableTypes = new HashMap();
        PackageDeclaration optionalPackageDeclaration = null;
        final List importDeclarations = new ArrayList();
        final List packageMemberTypeDeclarations = new ArrayList();

        public CompilationUnit(String string) {
            this.optionalFileName = string;
        }

        public void addImportDeclaration(ImportDeclaration importDeclaration) throws Parser.ParseException {
            if (importDeclaration instanceof SingleTypeImportDeclaration) {
                Object[] objectArray = ((SingleTypeImportDeclaration)importDeclaration).getIdentifiers();
                String string = objectArray[objectArray.length - 1];
                Iterator iterator = this.importDeclarations.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray2;
                    ImportDeclaration importDeclaration2 = (ImportDeclaration)iterator.next();
                    if (!(importDeclaration2 instanceof SingleTypeImportDeclaration) || !(objectArray2 = ((SingleTypeImportDeclaration)importDeclaration2).getIdentifiers())[objectArray2.length - 1].equals(string) || Java.join(objectArray, ".").equals(Java.join(objectArray2, "."))) continue;
                    importDeclaration.throwParseException("Class \"" + string + "\" was first imported from \"" + Java.join(objectArray, ".") + "\", now again from \"" + Java.join(objectArray2, ".") + "\"");
                }
            }
            this.importDeclarations.add(importDeclaration);
        }

        public void addPackageMemberTypeDeclaration(PackageMemberTypeDeclaration packageMemberTypeDeclaration) {
            this.packageMemberTypeDeclarations.add(packageMemberTypeDeclaration);
        }

        private void compile() throws CompileException {
            Iterator iterator = this.packageMemberTypeDeclarations.iterator();
            while (iterator.hasNext()) {
                ((PackageMemberTypeDeclaration)iterator.next()).compile();
            }
        }

        public ClassFile[] compile(IClassLoader iClassLoader, DebuggingInformation debuggingInformation) throws CompileException {
            ClassFile[] classFileArray;
            if (iClassLoader == null) {
                throw new RuntimeException();
            }
            List list = Java.replaceGeneratedClassFiles(new ArrayList());
            IClassLoader iClassLoader2 = Java.replaceIClassLoader(iClassLoader);
            DebuggingInformation debuggingInformation2 = Java.replaceDebuggingInformation(debuggingInformation);
            try {
                this.compile();
                List list2 = Java.getGeneratedClassFiles();
                classFileArray = list2.toArray(new ClassFile[list2.size()]);
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                Java.replaceGeneratedClassFiles(list);
                Java.replaceIClassLoader(iClassLoader2);
                Java.replaceDebuggingInformation(debuggingInformation2);
                throw throwable;
            }
            Java.replaceGeneratedClassFiles(list);
            Java.replaceIClassLoader(iClassLoader2);
            Java.replaceDebuggingInformation(debuggingInformation2);
            return classFileArray;
        }

        public IClass findClass(String string) {
            String string2;
            String string3 = string2 = this.optionalPackageDeclaration == null ? null : this.optionalPackageDeclaration.getPackageName();
            if (string2 != null) {
                if (!string.startsWith(String.valueOf(string2) + '.')) {
                    return null;
                }
                string = string.substring(string2.length() + 1);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "$");
            NamedTypeDeclaration namedTypeDeclaration = this.getPackageMemberTypeDeclaration(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                if (namedTypeDeclaration == null) {
                    return null;
                }
                namedTypeDeclaration = namedTypeDeclaration.getMemberTypeDeclaration(stringTokenizer.nextToken());
            }
            return (IClass)((Object)namedTypeDeclaration);
        }

        public Scope getEnclosingScope() {
            return null;
        }

        public String getFileName() {
            return this.optionalFileName;
        }

        public PackageMemberTypeDeclaration getPackageMemberTypeDeclaration(String string) {
            Iterator iterator = this.packageMemberTypeDeclarations.iterator();
            while (iterator.hasNext()) {
                PackageMemberTypeDeclaration packageMemberTypeDeclaration = (PackageMemberTypeDeclaration)iterator.next();
                if (!packageMemberTypeDeclaration.getName().equals(string)) continue;
                return packageMemberTypeDeclaration;
            }
            return null;
        }

        public PackageMemberTypeDeclaration[] getPackageMemberTypeDeclarations() {
            return this.packageMemberTypeDeclarations.toArray(new PackageMemberTypeDeclaration[this.packageMemberTypeDeclarations.size()]);
        }

        public String[] getSingleTypeImport(String string) {
            Iterator iterator = this.importDeclarations.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                ImportDeclaration importDeclaration = (ImportDeclaration)iterator.next();
                if (!(importDeclaration instanceof SingleTypeImportDeclaration) || !(stringArray = ((SingleTypeImportDeclaration)importDeclaration).getIdentifiers())[stringArray.length - 1].equals(string)) continue;
                return stringArray;
            }
            return null;
        }

        public IClass importSingleType(String string, Location location) throws CompileException {
            Object[] objectArray = this.getSingleTypeImport(string);
            if (objectArray == null) {
                return null;
            }
            IClass iClass = Java.loadFullyQualifiedClass((String[])objectArray);
            if (iClass == null) {
                Java.compileError("Imported class \"" + Java.join(objectArray, ".") + "\" could not be loaded", location);
                return Java.getIClassLoader().OBJECT;
            }
            return iClass;
        }

        public IClass importTypeOnDemand(String string, Location location) throws CompileException {
            Object object;
            IClass iClass = (IClass)this.onDemandImportableTypes.get(string);
            if (iClass != null) {
                return iClass;
            }
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            arrayList.add(new String[]{"java", "lang"});
            Iterator iterator = this.importDeclarations.iterator();
            while (iterator.hasNext()) {
                object = (ImportDeclaration)iterator.next();
                if (!(object instanceof TypeImportOnDemandDeclaration)) continue;
                arrayList.add(((TypeImportOnDemandDeclaration)object).getIdentifiers());
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                String[] stringArray = (String[])object.next();
                String[] stringArray2 = new String[stringArray.length + 1];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                stringArray2[stringArray.length] = string;
                IClass iClass2 = Java.loadFullyQualifiedClass(stringArray2);
                if (iClass2 == null) continue;
                if (iClass != null && iClass != iClass2) {
                    Java.compileError("Ambiguous class name: \"" + iClass + "\" vs. \"" + iClass2 + "\"", location);
                }
                iClass = iClass2;
            }
            if (iClass == null) {
                return null;
            }
            this.onDemandImportableTypes.put(string, iClass);
            return iClass;
        }

        public void setPackageDeclaration(PackageDeclaration packageDeclaration) {
            if (this.optionalPackageDeclaration != null) {
                throw new RuntimeException("Re-setting package declaration");
            }
            this.optionalPackageDeclaration = packageDeclaration;
        }

        public final void visit(Visitor visitor) {
            visitor.visitCompilationUnit(this);
        }
    }

    public static class PackageDeclaration
    extends Located {
        private final String packageName;

        public PackageDeclaration(Location location, String string) {
            super(location);
            this.packageName = string;
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    public static abstract class ImportDeclaration
    extends Located {
        public ImportDeclaration(Location location) {
            super(location);
        }

        public abstract void visit(Visitor var1);
    }

    public static class SingleTypeImportDeclaration
    extends ImportDeclaration {
        private final String[] identifiers;

        public SingleTypeImportDeclaration(Location location, String[] stringArray) {
            super(location);
            this.identifiers = stringArray;
        }

        public String[] getIdentifiers() {
            return this.identifiers;
        }

        public final void visit(Visitor visitor) {
            visitor.visitSingleTypeImportDeclaration(this);
        }
    }

    public static class TypeImportOnDemandDeclaration
    extends ImportDeclaration {
        private final String[] identifiers;

        public TypeImportOnDemandDeclaration(Location location, String[] stringArray) {
            super(location);
            this.identifiers = stringArray;
        }

        public String[] getIdentifiers() {
            return this.identifiers;
        }

        public final void visit(Visitor visitor) {
            visitor.visitTypeImportOnDemandDeclaration(this);
        }
    }

    public static interface TypeDeclaration
    extends Locatable,
    Scope {
        public void compile() throws CompileException;

        public String createAnonymousClassName();

        public String createLocalTypeName(String var1);

        public String getClassName();

        public MemberTypeDeclaration getMemberTypeDeclaration(String var1);

        public void visit(Visitor var1);
    }

    static interface PackageMemberTypeDeclaration
    extends NamedTypeDeclaration {
    }

    static interface MemberTypeDeclaration
    extends NamedTypeDeclaration,
    TypeBodyDeclaration {
    }

    static interface NamedTypeDeclaration
    extends TypeDeclaration {
        public String getName();
    }

    static interface InnerClassDeclaration {
        public void defineSyntheticField(IClass.IField var1) throws CompileException;
    }

    public static abstract class AbstractTypeDeclaration
    extends IClass
    implements TypeDeclaration {
        private final Location location;
        protected final Scope enclosingScope;
        protected final short modifiers;
        final List declaredMethods = new ArrayList();
        final Map declaredClassesAndInterfaces = new HashMap();
        public int anonymousClassCount = 0;
        public int localClassCount = 0;

        public AbstractTypeDeclaration(Location location, Scope scope, short s) {
            this.location = location;
            this.enclosingScope = scope;
            this.modifiers = s;
        }

        public void addDeclaredMethod(MethodDeclarator methodDeclarator) {
            this.declaredMethods.add(methodDeclarator);
        }

        public void addMemberTypeDeclaration(MemberTypeDeclaration memberTypeDeclaration) {
            this.declaredClassesAndInterfaces.put(memberTypeDeclaration.getName(), memberTypeDeclaration);
        }

        public abstract void compile() throws CompileException;

        public void compileError(String string) throws CompileException {
            Java.compileError(string, this.location);
        }

        public String createAnonymousClassName() {
            return String.valueOf(this.getClassName()) + '$' + ++this.anonymousClassCount;
        }

        public String createLocalTypeName(String string) {
            return String.valueOf(this.getClassName()) + '$' + ++this.localClassCount + '$' + string;
        }

        public abstract String getClassName();

        protected IClass getComponentType2() {
            return null;
        }

        protected IClass[] getDeclaredIClasses2() {
            Collection collection = this.declaredClassesAndInterfaces.values();
            return collection.toArray(new IClass[collection.size()]);
        }

        protected IClass.IMethod[] getDeclaredIMethods2() {
            IClass.IMethod[] iMethodArray = new IClass.IMethod[this.declaredMethods.size()];
            int n = 0;
            Iterator iterator = this.declaredMethods.iterator();
            while (iterator.hasNext()) {
                iMethodArray[n++] = ((MethodDeclarator)iterator.next()).toIMethod();
            }
            return iMethodArray;
        }

        protected IClass getDeclaringIClass2() {
            return null;
        }

        protected final String getDescriptor2() {
            return Descriptor.fromClassName(this.getClassName());
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public Location getLocation() {
            return this.location;
        }

        public MemberTypeDeclaration getMemberTypeDeclaration(String string) {
            return (MemberTypeDeclaration)this.declaredClassesAndInterfaces.get(string);
        }

        public Collection getMemberTypeDeclarations() {
            return this.declaredClassesAndInterfaces.values();
        }

        protected IClass getOuterIClass2() throws CompileException {
            return null;
        }

        public boolean isArray() {
            return false;
        }

        public boolean isPrimitive() {
            return false;
        }

        public boolean isPrimitiveNumeric() {
            return false;
        }

        public void throwParseException(String string) throws Parser.ParseException {
            throw new Parser.ParseException(string, this.location);
        }

        public abstract String toString();

        public abstract void visit(Visitor var1);
    }

    public static abstract class ClassDeclaration
    extends AbstractTypeDeclaration {
        final List constructors = new ArrayList();
        final List variableDeclaratorsAndInitializers = new ArrayList();
        private final SortedMap syntheticFields = new TreeMap();

        public ClassDeclaration(Location location, Scope scope, short s) throws Parser.ParseException {
            super(location, scope, s);
        }

        public void addConstructor(ConstructorDeclarator constructorDeclarator) {
            this.constructors.add(constructorDeclarator);
        }

        public void addVariableDeclaratorOrInitializer(TypeBodyDeclaration typeBodyDeclaration) {
            this.variableDeclaratorsAndInitializers.add(typeBodyDeclaration);
        }

        public void compile() throws CompileException {
            short s;
            Object object;
            Object object2;
            IClass[] iClassArray = this.getInterfaces();
            String[] stringArray = new String[iClassArray.length];
            int n = 0;
            while (n < iClassArray.length) {
                stringArray[n] = iClassArray[n].getDescriptor();
                ++n;
            }
            ClassFile classFile = new ClassFile((short)(this.modifiers | 0x20), this.getDescriptor(), this.getSuperclass().getDescriptor(), stringArray);
            if (!(this.enclosingScope instanceof CompilationUnit)) {
                short s2;
                short s3;
                if (this.enclosingScope instanceof Block) {
                    s3 = classFile.addConstantClassInfo(this.getDescriptor());
                    s2 = this instanceof NamedTypeDeclaration ? classFile.addConstantUtf8Info(((NamedTypeDeclaration)((Object)this)).getName()) : (short)0;
                    classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s3, 0, s2, this.modifiers));
                } else if (this.enclosingScope instanceof AbstractTypeDeclaration) {
                    s3 = classFile.addConstantClassInfo(this.getDescriptor());
                    s2 = classFile.addConstantClassInfo(((AbstractTypeDeclaration)this.enclosingScope).getDescriptor());
                    short s4 = classFile.addConstantUtf8Info(((MemberTypeDeclaration)((Object)this)).getName());
                    classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s3, s2, s4, this.modifiers));
                }
            }
            if (Java.getDebuggingInformation().contains(DebuggingInformation.SOURCE)) {
                String string = this.getLocation().getFileName();
                String string2 = string != null ? new File(string).getName() : (this instanceof NamedTypeDeclaration ? String.valueOf(((NamedTypeDeclaration)((Object)this)).getName()) + ".java" : "ANONYMOUS.java");
                classFile.addSourceFileAttribute(string2);
            }
            MethodDeclarator methodDeclarator = new MethodDeclarator(this.getLocation(), this, 9, (Type)new BasicType(this.getLocation(), 0), "<clinit>", new FormalParameter[0], (Type[])new ReferenceType[0]);
            Block block = new Block(this.getLocation(), methodDeclarator);
            Iterator iterator = this.variableDeclaratorsAndInitializers.iterator();
            while (iterator.hasNext()) {
                TypeBodyDeclaration typeBodyDeclaration = (TypeBodyDeclaration)iterator.next();
                if (!typeBodyDeclaration.isStatic()) continue;
                block.addStatement((BlockStatement)((Object)typeBodyDeclaration));
            }
            methodDeclarator.setBody(block);
            if (block.generatesCode()) {
                methodDeclarator.compile(classFile);
            }
            int n2 = 0;
            while (n2 < this.declaredMethods.size()) {
                ((MethodDeclarator)this.declaredMethods.get(n2)).compile(classFile);
                ++n2;
            }
            int n3 = this.declaredMethods.size();
            int n4 = this.syntheticFields.size();
            ConstructorDeclarator[] constructorDeclaratorArray = this.getConstructors();
            int n5 = 0;
            while (n5 < constructorDeclaratorArray.length) {
                constructorDeclaratorArray[n5].compile(classFile);
                if (n4 != this.syntheticFields.size()) {
                    throw new RuntimeException("SNO: Compilation of constructor \"" + constructorDeclaratorArray[n5] + "\" (" + constructorDeclaratorArray[n5].getLocation() + ") added synthetic fields!?");
                }
                ++n5;
            }
            int n6 = n3;
            while (n6 < this.declaredMethods.size()) {
                ((MethodDeclarator)this.declaredMethods.get(n6)).compile(classFile);
                ++n6;
            }
            Iterator iterator2 = this.variableDeclaratorsAndInitializers.iterator();
            while (iterator2.hasNext()) {
                object2 = (TypeBodyDeclaration)iterator2.next();
                if (!(object2 instanceof FieldDeclarator)) continue;
                object = (FieldDeclarator)object2;
                int n7 = 0;
                while (n7 < ((FieldDeclarator)object).variableDeclarators.length) {
                    VariableDeclarator variableDeclarator = ((FieldDeclarator)object).variableDeclarators[n7];
                    Type type = ((FieldDeclarator)object).type;
                    s = 0;
                    while (s < variableDeclarator.brackets) {
                        type = new ArrayType(type);
                        ++s;
                    }
                    Object object3 = null;
                    if ((((FieldDeclarator)object).modifiers & 0x18) == 24 && variableDeclarator.optionalInitializer != null && (object3 = variableDeclarator.optionalInitializer.getConstantValue()) == Rvalue.CONSTANT_VALUE_NULL) {
                        object3 = null;
                    }
                    classFile.addFieldInfo(((FieldDeclarator)object).modifiers, variableDeclarator.name, type.getType().getDescriptor(), object3);
                    ++n7;
                }
            }
            object2 = this.syntheticFields.values().iterator();
            while (object2.hasNext()) {
                object = (IClass.IField)object2.next();
                classFile.addFieldInfo((short)0, ((IClass.IField)object).getName(), ((IClass.IField)object).getType().getDescriptor(), null);
            }
            object = this.getMemberTypeDeclarations().iterator();
            while (object.hasNext()) {
                AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)object.next();
                abstractTypeDeclaration.compile();
                short s5 = classFile.addConstantClassInfo(abstractTypeDeclaration.getDescriptor());
                short s6 = classFile.addConstantClassInfo(this.getDescriptor());
                s = classFile.addConstantUtf8Info(((MemberTypeDeclaration)((Object)abstractTypeDeclaration)).getName());
                classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry(s5, s6, s, this.modifiers));
            }
            Java.getGeneratedClassFiles().add(classFile);
        }

        public void defineSyntheticField(IClass.IField iField) throws CompileException {
            if (!(this instanceof InnerClassDeclaration)) {
                throw new RuntimeException();
            }
            IClass.IField iField2 = (IClass.IField)this.syntheticFields.get(iField.getName());
            if (iField2 != null) {
                if (iField.getType() != iField2.getType()) {
                    throw new RuntimeException();
                }
                return;
            }
            this.syntheticFields.put(iField.getName(), iField);
        }

        private ConstructorDeclarator[] getConstructors() {
            if (this.constructors.isEmpty()) {
                ConstructorDeclarator constructorDeclarator = new ConstructorDeclarator(this.getLocation(), this, 1, new FormalParameter[0], new Type[0]);
                constructorDeclarator.setBody(new Block(this.getLocation(), this));
                return new ConstructorDeclarator[]{constructorDeclarator};
            }
            return this.constructors.toArray(new ConstructorDeclarator[this.constructors.size()]);
        }

        protected IClass.IConstructor[] getDeclaredIConstructors2() {
            ConstructorDeclarator[] constructorDeclaratorArray = this.getConstructors();
            IClass.IConstructor[] iConstructorArray = new IClass.IConstructor[constructorDeclaratorArray.length];
            int n = 0;
            while (n < constructorDeclaratorArray.length) {
                iConstructorArray[n] = constructorDeclaratorArray[n].toIConstructor();
                ++n;
            }
            return iConstructorArray;
        }

        protected IClass.IField[] getDeclaredIFields2() {
            ArrayList<IClass.IField> arrayList = new ArrayList<IClass.IField>();
            int n = 0;
            while (n < this.variableDeclaratorsAndInitializers.size()) {
                BlockStatement blockStatement = (BlockStatement)this.variableDeclaratorsAndInitializers.get(n);
                if (blockStatement instanceof FieldDeclarator) {
                    FieldDeclarator fieldDeclarator = (FieldDeclarator)blockStatement;
                    IClass.IField[] iFieldArray = fieldDeclarator.getIFields();
                    int n2 = 0;
                    while (n2 < iFieldArray.length) {
                        arrayList.add(iFieldArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            return arrayList.toArray(new IClass.IField[arrayList.size()]);
        }

        public boolean isAbstract() {
            return (this.modifiers & 0x400) != 0;
        }

        public boolean isFinal() {
            return (this.modifiers & 0x10) != 0;
        }

        public boolean isInterface() {
            return false;
        }

        public boolean isPublic() {
            return (this.modifiers & 1) != 0;
        }
    }

    public static final class AnonymousClassDeclaration
    extends ClassDeclaration
    implements InnerClassDeclaration {
        Type baseType;
        private String className;

        public AnonymousClassDeclaration(Location location, Scope scope, Type type) throws Parser.ParseException {
            super(location, scope, (short)18);
            this.baseType = type;
            Scope scope2 = this.getEnclosingScope();
            while (!(scope2 instanceof TypeDeclaration)) {
                scope2 = scope2.getEnclosingScope();
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)scope2;
            this.className = typeDeclaration.createAnonymousClassName();
        }

        public void compile() throws CompileException {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            TypeBodyDeclaration typeBodyDeclaration = (TypeBodyDeclaration)scope;
            if (!typeBodyDeclaration.isStatic()) {
                int n = Java.getOuterClasses(this).size();
                this.defineSyntheticField(new IClass.IField(n, typeBodyDeclaration, this){
                    private final /* synthetic */ TypeBodyDeclaration val$tbd;
                    private final /* synthetic */ int val$nesting;
                    {
                        this.val$nesting = n;
                        this.val$tbd = typeBodyDeclaration;
                    }

                    public int getAccess() {
                        return 2;
                    }

                    public Object getConstantValue() {
                        return null;
                    }

                    public String getName() {
                        return "this$" + (this.val$nesting - 2);
                    }

                    public IClass getType() {
                        return (IClass)((Object)this.val$tbd.getDeclaringType());
                    }

                    public boolean isStatic() {
                        return false;
                    }
                });
            }
            super.compile();
        }

        public String getClassName() {
            return this.className;
        }

        protected IClass getDeclaringIClass2() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            return (IClass)((Object)scope.getEnclosingScope());
        }

        protected IClass[] getInterfaces2() throws CompileException {
            IClass[] iClassArray;
            IClass iClass = this.baseType.getType();
            if (iClass.isInterface()) {
                IClass[] iClassArray2 = new IClass[1];
                iClassArray = iClassArray2;
                iClassArray2[0] = iClass;
            } else {
                iClassArray = new IClass[]{};
            }
            return iClassArray;
        }

        protected IClass getOuterIClass2() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof TypeBodyDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            if (((TypeBodyDeclaration)scope).isStatic()) {
                return null;
            }
            return (IClass)((Object)scope.getEnclosingScope());
        }

        protected IClass getSuperclass2() throws CompileException {
            IClass iClass = this.baseType.getType();
            return iClass.isInterface() ? Java.getIClassLoader().OBJECT : iClass;
        }

        public String toString() {
            return "ANONYMOUS";
        }

        public final void visit(Visitor visitor) {
            visitor.visitAnonymousClassDeclaration(this);
        }
    }

    public static abstract class NamedClassDeclaration
    extends ClassDeclaration
    implements NamedTypeDeclaration {
        protected final String name;
        final Type optionalExtendedType;
        final Type[] implementedTypes;

        public NamedClassDeclaration(Location location, Scope scope, short s, String string, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, scope, s);
            this.name = string;
            this.optionalExtendedType = type;
            this.implementedTypes = typeArray;
        }

        protected IClass[] getInterfaces2() throws CompileException {
            IClass[] iClassArray = new IClass[this.implementedTypes.length];
            int n = 0;
            while (n < iClassArray.length) {
                iClassArray[n] = this.implementedTypes[n].getType();
                ++n;
            }
            return iClassArray;
        }

        public String getName() {
            return this.name;
        }

        protected IClass getSuperclass2() throws CompileException {
            return this.optionalExtendedType == null ? Java.getIClassLoader().OBJECT : this.optionalExtendedType.getType();
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemberClassDeclaration
    extends NamedClassDeclaration
    implements MemberTypeDeclaration,
    InnerClassDeclaration {
        public MemberClassDeclaration(Location location, NamedTypeDeclaration namedTypeDeclaration, short s, String string, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, namedTypeDeclaration, s, string, type, typeArray);
            MemberTypeDeclaration memberTypeDeclaration = namedTypeDeclaration.getMemberTypeDeclaration(string);
            if (memberTypeDeclaration != null) {
                this.throwParseException("Redeclaration of class \"" + string + "\", previously declared in " + memberTypeDeclaration.getLocation());
            }
        }

        public void compile() throws CompileException {
            if ((this.modifiers & 8) == 0) {
                int n = Java.getOuterClasses(this).size();
                this.defineSyntheticField(new IClass.IField(n, this, this){
                    private final /* synthetic */ MemberClassDeclaration this$0;
                    private final /* synthetic */ int val$nesting;
                    {
                        this.val$nesting = n;
                        this.this$0 = memberClassDeclaration;
                    }

                    public int getAccess() {
                        return 2;
                    }

                    public Object getConstantValue() {
                        return null;
                    }

                    public String getName() {
                        return "this$" + (this.val$nesting - 2);
                    }

                    public IClass getType() {
                        return (IClass)((Object)this.this$0.getDeclaringType());
                    }

                    public boolean isStatic() {
                        return false;
                    }
                });
            }
            super.compile();
        }

        public String getClassName() {
            return String.valueOf(this.getDeclaringType().getClassName()) + '$' + this.getName();
        }

        protected IClass getDeclaringIClass2() {
            return (IClass)((Object)this.getDeclaringType());
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        protected IClass getOuterIClass2() throws CompileException {
            return this.getDeclaringType() instanceof ClassDeclaration && (this.modifiers & 8) == 0 ? this.getDeclaringIClass() : null;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void visit(Visitor visitor) {
            visitor.visitMemberClassDeclaration(this);
        }
    }

    public static final class LocalClassDeclaration
    extends NamedClassDeclaration
    implements InnerClassDeclaration {
        private final String className;

        public LocalClassDeclaration(Location location, Block block, short s, String string, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, block, s, string, type, typeArray);
            TypeDeclaration typeDeclaration;
            Scope scope;
            Scope scope2 = block;
            while (scope2 instanceof Block) {
                scope = scope2;
                typeDeclaration = ((Block)scope).getLocalClassDeclaration(string);
                if (typeDeclaration != null) {
                    this.throwParseException("Redeclaration of local class \"" + string + "\"; previously declared in " + ((AbstractTypeDeclaration)typeDeclaration).getLocation());
                }
                scope2 = scope2.getEnclosingScope();
            }
            scope = this.getEnclosingScope();
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            typeDeclaration = (TypeDeclaration)scope;
            this.className = typeDeclaration.createLocalTypeName(string);
        }

        public void compile() throws CompileException {
            ((Block)this.getEnclosingScope()).declaredLocalClasses.put(this.getName(), this);
            List list = Java.getOuterClasses(this);
            int n = list.size();
            if (n >= 2) {
                IClass iClass = (IClass)list.get(1);
                this.defineSyntheticField(new IClass.IField(iClass, n, this){
                    private final /* synthetic */ IClass val$enclosingInstanceType;
                    private final /* synthetic */ int val$nesting;
                    {
                        this.val$enclosingInstanceType = iClass;
                        this.val$nesting = n;
                    }

                    public int getAccess() {
                        return 2;
                    }

                    public Object getConstantValue() {
                        return null;
                    }

                    public String getName() {
                        return "this$" + (this.val$nesting - 2);
                    }

                    public IClass getType() throws CompileException {
                        return this.val$enclosingInstanceType;
                    }

                    public boolean isStatic() {
                        return false;
                    }
                });
            }
            super.compile();
        }

        public String getClassName() {
            return this.className;
        }

        protected IClass getOuterIClass2() {
            Scope scope = this.getEnclosingScope();
            while (!(scope instanceof FunctionDeclarator)) {
                scope = scope.getEnclosingScope();
            }
            boolean bl = scope instanceof MethodDeclarator && (((FunctionDeclarator)scope).modifiers & 8) != 0;
            while (!(scope instanceof TypeDeclaration)) {
                scope = scope.getEnclosingScope();
            }
            TypeDeclaration typeDeclaration = (TypeDeclaration)scope;
            return typeDeclaration instanceof ClassDeclaration && !bl ? (IClass)((Object)typeDeclaration) : null;
        }

        public final void visit(Visitor visitor) {
            visitor.visitLocalClassDeclaration(this);
        }
    }

    public static final class PackageMemberClassDeclaration
    extends NamedClassDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberClassDeclaration(Location location, CompilationUnit compilationUnit, short s, String string, Type type, Type[] typeArray) throws Parser.ParseException {
            super(location, compilationUnit, s, string, type, typeArray);
            PackageMemberTypeDeclaration packageMemberTypeDeclaration;
            Object[] objectArray;
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member class declaration");
            }
            if ((objectArray = compilationUnit.getSingleTypeImport(string)) != null) {
                this.throwParseException("Package member class declaration \"" + string + "\" conflicts with single-type-import \"" + Java.join(objectArray, ".") + "\"");
            }
            if ((packageMemberTypeDeclaration = compilationUnit.getPackageMemberTypeDeclaration(string)) != null) {
                this.throwParseException("Redeclaration of class \"" + string + "\", previously declared in " + packageMemberTypeDeclaration.getLocation());
            }
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.getPackageName()) + '.' + string;
            }
            return string;
        }

        protected IClass getOuterIClass2() {
            return null;
        }

        public final void visit(Visitor visitor) {
            visitor.visitPackageMemberClassDeclaration(this);
        }
    }

    public static abstract class InterfaceDeclaration
    extends AbstractTypeDeclaration
    implements NamedTypeDeclaration {
        protected String name;
        Type[] extendedTypes;
        final List constantDeclarations = new ArrayList();
        private IClass[] interfaces = null;

        protected InterfaceDeclaration(Location location, Scope scope, short s, String string, Type[] typeArray) throws Parser.ParseException {
            super(location, scope, s);
            this.name = string;
            this.extendedTypes = typeArray;
        }

        public void addConstantDeclaration(FieldDeclarator fieldDeclarator) {
            this.constantDeclarations.add(fieldDeclarator);
        }

        public void compile() throws CompileException {
            int n;
            Locatable locatable;
            Object object;
            Object object2;
            Object object3;
            this.interfaces = new IClass[this.extendedTypes.length];
            String[] stringArray = new String[this.interfaces.length];
            int n2 = 0;
            while (n2 < this.extendedTypes.length) {
                this.interfaces[n2] = this.extendedTypes[n2].getType();
                stringArray[n2] = this.interfaces[n2].getDescriptor();
                ++n2;
            }
            ClassFile classFile = new ClassFile((short)(this.modifiers | 0x20 | 0x200 | 0x400), this.getDescriptor(), "Ljava/lang/Object;", stringArray);
            if (Java.getDebuggingInformation().contains(DebuggingInformation.SOURCE)) {
                object3 = this.getLocation().getFileName();
                object2 = object3 != null ? new File((String)object3).getName() : String.valueOf(this.getName()) + ".java";
                classFile.addSourceFileAttribute((String)object2);
            }
            if (!this.constantDeclarations.isEmpty()) {
                object2 = new MethodDeclarator(this.getLocation(), this, 9, (Type)new BasicType(this.getLocation(), 0), "<clinit>", new FormalParameter[0], (Type[])new ReferenceType[0]);
                object3 = new Block(this.getLocation(), (Scope)object2);
                ((Block)object3).addStatements(this.constantDeclarations);
                ((FunctionDeclarator)object2).setBody((Block)object3);
                if (((Block)object3).generatesCode()) {
                    ((FunctionDeclarator)object2).compile(classFile);
                }
            }
            int n3 = 0;
            while (n3 < this.declaredMethods.size()) {
                ((MethodDeclarator)this.declaredMethods.get(n3)).compile(classFile);
                ++n3;
            }
            int n4 = 0;
            while (n4 < this.constantDeclarations.size()) {
                object = (BlockStatement)this.constantDeclarations.get(n4);
                if (object instanceof FieldDeclarator) {
                    locatable = (FieldDeclarator)object;
                    n = 0;
                    while (n < ((FieldDeclarator)locatable).variableDeclarators.length) {
                        VariableDeclarator variableDeclarator = ((FieldDeclarator)locatable).variableDeclarators[n];
                        Type type = ((FieldDeclarator)locatable).type;
                        int n5 = 0;
                        while (n5 < variableDeclarator.brackets) {
                            type = new ArrayType(type);
                            ++n5;
                        }
                        classFile.addFieldInfo(((FieldDeclarator)locatable).modifiers, variableDeclarator.name, type.getType().getDescriptor(), (((FieldDeclarator)locatable).modifiers & 0x10) != 0 && variableDeclarator.optionalInitializer != null ? variableDeclarator.optionalInitializer.getConstantValue() : null);
                        ++n;
                    }
                }
                ++n4;
            }
            object = this.getMemberTypeDeclarations().iterator();
            while (object.hasNext()) {
                locatable = (AbstractTypeDeclaration)object.next();
                ((AbstractTypeDeclaration)locatable).compile();
                n = classFile.addConstantClassInfo(((IClass)((Object)locatable)).getDescriptor());
                short s = classFile.addConstantClassInfo(this.getDescriptor());
                short s2 = classFile.addConstantUtf8Info(((MemberTypeDeclaration)locatable).getName());
                classFile.addInnerClassesAttributeEntry(new ClassFile.InnerClassesAttribute.Entry((short)n, s, s2, this.modifiers));
            }
            Java.getGeneratedClassFiles().add(classFile);
        }

        protected IClass.IConstructor[] getDeclaredIConstructors2() {
            return new IClass.IConstructor[0];
        }

        protected IClass.IField[] getDeclaredIFields2() {
            ArrayList<IClass.IField> arrayList = new ArrayList<IClass.IField>();
            int n = 0;
            while (n < this.constantDeclarations.size()) {
                BlockStatement blockStatement = (BlockStatement)this.constantDeclarations.get(n);
                if (blockStatement instanceof FieldDeclarator) {
                    FieldDeclarator fieldDeclarator = (FieldDeclarator)blockStatement;
                    IClass.IField[] iFieldArray = fieldDeclarator.getIFields();
                    int n2 = 0;
                    while (n2 < iFieldArray.length) {
                        arrayList.add(iFieldArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
            return arrayList.toArray(new IClass.IField[arrayList.size()]);
        }

        protected IClass[] getInterfaces2() throws CompileException {
            IClass[] iClassArray = new IClass[this.extendedTypes.length];
            int n = 0;
            while (n < iClassArray.length) {
                iClassArray[n] = this.extendedTypes[n].getType();
                ++n;
            }
            return iClassArray;
        }

        public String getName() {
            return this.name;
        }

        protected IClass getSuperclass2() {
            return null;
        }

        public boolean isAbstract() {
            return true;
        }

        public boolean isFinal() {
            return false;
        }

        public boolean isInterface() {
            return true;
        }

        public boolean isPublic() {
            return (this.modifiers & 1) != 0;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class MemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements MemberTypeDeclaration {
        public MemberInterfaceDeclaration(Location location, NamedTypeDeclaration namedTypeDeclaration, short s, String string, Type[] typeArray) throws Parser.ParseException {
            super(location, namedTypeDeclaration, s, string, typeArray);
            MemberTypeDeclaration memberTypeDeclaration = namedTypeDeclaration.getMemberTypeDeclaration(string);
            if (memberTypeDeclaration != null) {
                this.throwParseException("Redeclaration of interface \"" + string + "\", previously declared in " + memberTypeDeclaration.getLocation());
            }
        }

        public String getClassName() {
            NamedTypeDeclaration namedTypeDeclaration = (NamedTypeDeclaration)this.getEnclosingScope();
            return String.valueOf(namedTypeDeclaration.getClassName()) + '$' + this.getName();
        }

        protected IClass getDeclaringIClass2() {
            return (IClass)((Object)this.getEnclosingScope());
        }

        public TypeDeclaration getDeclaringType() {
            return (TypeDeclaration)this.getEnclosingScope();
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public final void visit(Visitor visitor) {
            visitor.visitMemberInterfaceDeclaration(this);
        }
    }

    public static final class PackageMemberInterfaceDeclaration
    extends InterfaceDeclaration
    implements PackageMemberTypeDeclaration {
        public PackageMemberInterfaceDeclaration(Location location, CompilationUnit compilationUnit, short s, String string, Type[] typeArray) throws Parser.ParseException {
            super(location, compilationUnit, s, string, typeArray);
            PackageMemberTypeDeclaration packageMemberTypeDeclaration;
            Object[] objectArray;
            if ((s & 0xE) != 0) {
                this.throwParseException("Modifiers \"protected\", \"private\" and \"static\" not allowed in package member interface declaration");
            }
            if ((objectArray = compilationUnit.getSingleTypeImport(string)) != null) {
                this.throwParseException("Package member interface declaration \"" + string + "\" conflicts with single-type-import \"" + Java.join(objectArray, ".") + "\"");
            }
            if ((packageMemberTypeDeclaration = compilationUnit.getPackageMemberTypeDeclaration(string)) != null) {
                this.throwParseException("Redeclaration of interface \"" + string + "\", previously declared in " + packageMemberTypeDeclaration.getLocation());
            }
        }

        public String getClassName() {
            String string = this.getName();
            CompilationUnit compilationUnit = (CompilationUnit)this.getEnclosingScope();
            if (compilationUnit.optionalPackageDeclaration != null) {
                string = String.valueOf(compilationUnit.optionalPackageDeclaration.getPackageName()) + '.' + string;
            }
            return string;
        }

        public final void visit(Visitor visitor) {
            visitor.visitPackageMemberInterfaceDeclaration(this);
        }
    }

    public static interface TypeBodyDeclaration
    extends Locatable,
    Scope {
        public TypeDeclaration getDeclaringType();

        public boolean isStatic();

        public void visit(Visitor var1);
    }

    public static abstract class AbstractTypeBodyDeclaration
    extends Located
    implements TypeBodyDeclaration {
        final TypeDeclaration declaringType;
        final boolean statiC;

        protected AbstractTypeBodyDeclaration(Location location, TypeDeclaration typeDeclaration, boolean bl) {
            super(location);
            this.declaringType = typeDeclaration;
            this.statiC = bl;
        }

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public Scope getEnclosingScope() {
            return this.declaringType;
        }

        public boolean isStatic() {
            return this.statiC;
        }

        public abstract void visit(Visitor var1);
    }

    public static final class Initializer
    extends AbstractTypeBodyDeclaration
    implements BlockStatement {
        Block block = null;

        public Initializer(Location location, TypeDeclaration typeDeclaration, boolean bl) {
            super(location, typeDeclaration, bl);
        }

        public boolean compile() throws CompileException {
            return this.block.compile();
        }

        public boolean generatesCode() throws CompileException {
            return this.block.generatesCode();
        }

        public void leave(IClass iClass) {
        }

        public void setBlock(Block block) {
            if (this.block != null) {
                throw new RuntimeException();
            }
            this.block = block;
        }

        public final void visit(Visitor visitor) {
            visitor.visitInitializer(this);
        }
    }

    public static abstract class FunctionDeclarator
    extends AbstractTypeBodyDeclaration {
        protected final short modifiers;
        final Type type;
        final String name;
        final FormalParameter[] formalParameters;
        protected final Type[] thrownExceptions;
        Block optionalBody = null;
        private IClass returnType = null;
        final HashMap parameters = new HashMap();

        public FunctionDeclarator(Location location, TypeDeclaration typeDeclaration, short s, Type type, String string, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, typeDeclaration, (s & 8) != 0);
            this.modifiers = s;
            this.type = type;
            this.name = string;
            this.formalParameters = formalParameterArray;
            this.thrownExceptions = typeArray;
        }

        public void compile(ClassFile classFile) throws CompileException {
            int n;
            CodeContext codeContext;
            CodeContext codeContext2;
            ClassFile.MethodInfo methodInfo;
            block10: {
                methodInfo = classFile.addMethodInfo(this.modifiers, this.name, this.toIInvocable().getDescriptor());
                if ((this.modifiers & 0x500) != 0) {
                    return;
                }
                codeContext2 = new CodeContext(methodInfo.getClassFile());
                codeContext = Java.replaceCodeContext(codeContext2);
                try {
                    Object object;
                    Object object2;
                    if ((this.modifiers & 8) == 0) {
                        this.allocateLocalVariable((short)1);
                    }
                    if (this instanceof ConstructorDeclarator) {
                        ConstructorDeclarator constructorDeclarator = (ConstructorDeclarator)this;
                        object2 = constructorDeclarator.declaringClass.syntheticFields.values().iterator();
                        while (object2.hasNext()) {
                            object = (IClass.IField)object2.next();
                            constructorDeclarator.syntheticParameters.put(((IClass.IField)object).getName(), new LocalVariable(true, ((IClass.IField)object).getType(), this.allocateLocalVariable(Descriptor.size(((IClass.IField)object).getDescriptor()))));
                        }
                    }
                    int n2 = 0;
                    while (n2 < this.formalParameters.length) {
                        object2 = this.formalParameters[n2];
                        if (this.parameters.containsKey(((FormalParameter)object2).name)) {
                            this.compileError("Redefinition of formal parameter \"" + ((FormalParameter)object2).name + "\"");
                        }
                        object = ((FormalParameter)object2).type.getType();
                        this.parameters.put(((FormalParameter)object2).name, new LocalVariable(((FormalParameter)object2).finaL, (IClass)object, this.allocateLocalVariable(Descriptor.size(((IClass)object).getDescriptor()))));
                        ++n2;
                    }
                    this.compilePreamble();
                    n = this.optionalBody.compile();
                    if (n == 0) break block10;
                    if (this.getReturnType() != IClass.VOID) {
                        this.compileError("Method must return a value");
                    }
                    this.writeOpcode(-79);
                }
                catch (Throwable throwable) {
                    Object var6_12 = null;
                    Java.replaceCodeContext(codeContext);
                    throw throwable;
                }
            }
            Object var6_11 = null;
            Java.replaceCodeContext(codeContext);
            codeContext2.fixUp();
            codeContext2.relocate();
            codeContext2.flowAnalysis(this.toString());
            short s = Java.getDebuggingInformation().contains(DebuggingInformation.LINES) ? classFile.addConstantUtf8Info("LineNumberTable") : (short)0;
            methodInfo.addAttribute(new ClassFile.AttributeInfo(codeContext2, s, classFile.addConstantUtf8Info("Code")){
                private final /* synthetic */ short val$lntani;
                private final /* synthetic */ CodeContext val$codeContext;
                {
                    this.val$codeContext = codeContext;
                    this.val$lntani = s;
                }

                protected void storeBody(DataOutputStream dataOutputStream) throws IOException {
                    this.val$codeContext.storeCodeAttributeBody(dataOutputStream, this.val$lntani);
                }
            });
            short s2 = classFile.addConstantUtf8Info("Exceptions");
            short[] sArray = new short[this.thrownExceptions.length];
            n = 0;
            while (n < this.thrownExceptions.length) {
                sArray[n] = classFile.addConstantClassInfo(this.thrownExceptions[n].getType().getDescriptor());
                ++n;
            }
            methodInfo.addAttribute(new ClassFile.ExceptionsAttribute(s2, sArray));
        }

        protected abstract void compilePreamble() throws CompileException;

        public Scope getEnclosingScope() {
            return this.getDeclaringType();
        }

        public FormalParameter[] getFormalParameters() {
            return this.formalParameters;
        }

        public short getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.name;
        }

        public IClass getReturnType() throws CompileException {
            if (this.returnType == null) {
                this.returnType = this.type.getType();
            }
            return this.returnType;
        }

        public void setBody(Block block) {
            if (this.optionalBody != null) {
                throw new RuntimeException("Body must be set exactly once");
            }
            this.optionalBody = block;
        }

        protected abstract IClass.IInvocable toIInvocable();
    }

    public static final class ConstructorDeclarator
    extends FunctionDeclarator {
        private final ClassDeclaration declaringClass;
        private final IClass.IConstructor iConstructor;
        ConstructorInvocation optionalExplicitConstructorInvocation = null;
        private Map syntheticParameters = new HashMap();

        public ConstructorDeclarator(Location location, ClassDeclaration classDeclaration, short s, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, classDeclaration, s, new BasicType(location, 0), "<init>", formalParameterArray, typeArray);
            this.declaringClass = classDeclaration;
            this.iConstructor = new IClass.IConstructor(this, classDeclaration){
                private final /* synthetic */ ConstructorDeclarator this$0;
                {
                    this.this$0 = constructorDeclarator;
                }

                public int getAccess() {
                    switch (this.this$0.modifiers & 7) {
                        case 2: {
                            return 0;
                        }
                        case 4: {
                            return 1;
                        }
                        case 0: {
                            return 2;
                        }
                        case 1: {
                            return 3;
                        }
                    }
                    throw new RuntimeException("Invalid access");
                }

                public String getDescriptor() throws CompileException {
                    Object object;
                    if (!(ConstructorDeclarator.access$1(this.this$0) instanceof InnerClassDeclaration)) {
                        return super.getDescriptor();
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    IClass iClass = ConstructorDeclarator.access$1(this.this$0).getOuterIClass();
                    if (iClass != null) {
                        arrayList.add(iClass.getDescriptor());
                    }
                    Iterator<V> iterator = ClassDeclaration.access$0(ConstructorDeclarator.access$1(this.this$0)).values().iterator();
                    while (iterator.hasNext()) {
                        object = (IClass.IField)iterator.next();
                        if (!((IClass.IField)object).getName().startsWith("val$")) continue;
                        arrayList.add(((IClass.IField)object).getType().getDescriptor());
                    }
                    object = this.this$0.getFormalParameters();
                    int n = 0;
                    while (n < ((Object)object).length) {
                        arrayList.add(((FormalParameter)object[n]).type.getType().getDescriptor());
                        ++n;
                    }
                    String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
                    return new MethodDescriptor(stringArray, "V").toString();
                }

                public IClass[] getParameterTypes() throws CompileException {
                    FormalParameter[] formalParameterArray = this.this$0.getFormalParameters();
                    IClass[] iClassArray = new IClass[formalParameterArray.length];
                    int n = 0;
                    while (n < formalParameterArray.length) {
                        iClassArray[n] = formalParameterArray[n].type.getType();
                        ++n;
                    }
                    return iClassArray;
                }

                public IClass[] getThrownExceptions() throws CompileException {
                    IClass[] iClassArray = new IClass[this.this$0.thrownExceptions.length];
                    int n = 0;
                    while (n < iClassArray.length) {
                        iClassArray[n] = this.this$0.thrownExceptions[n].getType();
                        ++n;
                    }
                    return iClassArray;
                }

                public String toString() {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.this$0.getDeclaringType().getClassName());
                    stringBuffer.append('(');
                    FormalParameter[] formalParameterArray = this.this$0.getFormalParameters();
                    int n = 0;
                    while (n < formalParameterArray.length) {
                        if (n != 0) {
                            stringBuffer.append(", ");
                        }
                        try {
                            stringBuffer.append(formalParameterArray[n].type.getType().toString());
                        }
                        catch (CompileException compileException) {
                            stringBuffer.append("???");
                        }
                        ++n;
                    }
                    return stringBuffer.append(')').toString();
                }
            };
        }

        private void assignSyntheticParametersToSyntheticFields() throws CompileException {
            Iterator iterator = this.declaringClass.syntheticFields.values().iterator();
            while (iterator.hasNext()) {
                IClass.IField iField = (IClass.IField)iterator.next();
                LocalVariable localVariable = (LocalVariable)this.syntheticParameters.get(iField.getName());
                if (localVariable == null) {
                    throw new RuntimeException("SNO: Synthetic parameter for synthetic field \"" + iField.getName() + "\" not found");
                }
                new ExpressionStatement(new Assignment(this.getLocation(), new FieldAccess(this.getLocation(), new ThisReference(this.getLocation(), this.declaringClass), iField), "=", new LocalVariableAccess(this.getLocation(), localVariable)), (Scope)this).compile();
            }
        }

        protected void compilePreamble() throws CompileException {
            if (this.optionalExplicitConstructorInvocation != null) {
                this.optionalExplicitConstructorInvocation.compile();
                if (this.optionalExplicitConstructorInvocation instanceof SuperConstructorInvocation) {
                    this.assignSyntheticParametersToSyntheticFields();
                    this.initializeInstanceVariablesAndInvokeInstanceInitializers();
                }
            } else {
                QualifiedThisReference qualifiedThisReference = null;
                IClass iClass = this.declaringClass.getSuperclass().getOuterIClass();
                if (iClass != null) {
                    qualifiedThisReference = new QualifiedThisReference(this.getLocation(), this.declaringClass, this, iClass);
                }
                new SuperConstructorInvocation(this.getLocation(), this.declaringClass, this, qualifiedThisReference, new Rvalue[0]).compile();
                this.assignSyntheticParametersToSyntheticFields();
                this.initializeInstanceVariablesAndInvokeInstanceInitializers();
            }
        }

        private void initializeInstanceVariablesAndInvokeInstanceInitializers() throws CompileException {
            Iterator iterator = this.declaringClass.variableDeclaratorsAndInitializers.iterator();
            while (iterator.hasNext()) {
                BlockStatement blockStatement;
                TypeBodyDeclaration typeBodyDeclaration = (TypeBodyDeclaration)iterator.next();
                if (typeBodyDeclaration.isStatic() || (blockStatement = (BlockStatement)((Object)typeBodyDeclaration)).compile()) continue;
                blockStatement.compileError("Instance variable declarator or instance initializer does not complete normally");
            }
        }

        public void setExplicitConstructorInvocation(ConstructorInvocation constructorInvocation) {
            this.optionalExplicitConstructorInvocation = constructorInvocation;
        }

        public IClass.IConstructor toIConstructor() {
            return this.iConstructor;
        }

        protected IClass.IInvocable toIInvocable() {
            return this.toIConstructor();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.declaringClass.getClassName());
            stringBuffer.append('(');
            FormalParameter[] formalParameterArray = this.getFormalParameters();
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitConstructorDeclarator(this);
        }
    }

    public static final class MethodDeclarator
    extends FunctionDeclarator {
        private final IClass.IMethod iMethod;

        public MethodDeclarator(Location location, AbstractTypeDeclaration abstractTypeDeclaration, short s, Type type, String string, FormalParameter[] formalParameterArray, Type[] typeArray) {
            super(location, abstractTypeDeclaration, s, type, string, formalParameterArray, typeArray);
            this.iMethod = new IClass.IMethod(abstractTypeDeclaration, this, abstractTypeDeclaration){
                private final /* synthetic */ AbstractTypeDeclaration val$declaringType;
                private final /* synthetic */ MethodDeclarator this$0;
                {
                    this.val$declaringType = abstractTypeDeclaration;
                    this.this$0 = methodDeclarator;
                }

                public int getAccess() {
                    switch (this.this$0.modifiers & 7) {
                        case 2: {
                            return 0;
                        }
                        case 4: {
                            return 1;
                        }
                        case 0: {
                            return 2;
                        }
                        case 1: {
                            return 3;
                        }
                    }
                    throw new RuntimeException("Invalid access");
                }

                public String getName() {
                    return this.this$0.getName();
                }

                public IClass[] getParameterTypes() throws CompileException {
                    FormalParameter[] formalParameterArray = this.this$0.getFormalParameters();
                    IClass[] iClassArray = new IClass[formalParameterArray.length];
                    int n = 0;
                    while (n < formalParameterArray.length) {
                        iClassArray[n] = formalParameterArray[n].type.getType();
                        ++n;
                    }
                    return iClassArray;
                }

                public IClass getReturnType() throws CompileException {
                    return this.this$0.getReturnType();
                }

                public IClass[] getThrownExceptions() throws CompileException {
                    IClass[] iClassArray = new IClass[this.this$0.thrownExceptions.length];
                    int n = 0;
                    while (n < iClassArray.length) {
                        iClassArray[n] = this.this$0.thrownExceptions[n].getType();
                        ++n;
                    }
                    return iClassArray;
                }

                public boolean isAbstract() {
                    return this.val$declaringType.isInterface() || (this.this$0.getModifiers() & 0x400) != 0;
                }

                public boolean isStatic() {
                    return (this.this$0.getModifiers() & 8) != 0;
                }
            };
        }

        protected void compilePreamble() {
        }

        protected IClass.IInvocable toIInvocable() {
            return this.toIMethod();
        }

        public IClass.IMethod toIMethod() {
            return this.iMethod;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getName());
            stringBuffer.append('(');
            FormalParameter[] formalParameterArray = this.getFormalParameters();
            int n = 0;
            while (n < formalParameterArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(formalParameterArray[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitMethodDeclarator(this);
        }
    }

    public static final class FieldDeclarator
    extends Statement
    implements TypeBodyDeclaration {
        private final AbstractTypeDeclaration declaringType;
        final short modifiers;
        final Type type;
        VariableDeclarator[] variableDeclarators = null;

        public FieldDeclarator(Location location, AbstractTypeDeclaration abstractTypeDeclaration, short s, Type type) {
            super(location, abstractTypeDeclaration);
            this.modifiers = s;
            this.declaringType = abstractTypeDeclaration;
            this.type = type;
        }

        public boolean compile() throws CompileException {
            int n = 0;
            while (n < this.variableDeclarators.length) {
                VariableDeclarator variableDeclarator = this.variableDeclarators[n];
                Rvalue rvalue = this.getNonConstantFinalInitializer(variableDeclarator);
                if (rvalue != null) {
                    if ((this.modifiers & 8) == 0) {
                        this.writeOpcode(42);
                    }
                    IClass iClass = rvalue.compileGetValue();
                    IClass iClass2 = this.type.getType();
                    iClass2 = Java.getArrayType(iClass2, variableDeclarator.brackets);
                    Java.assignmentConversion(this, iClass, iClass2, rvalue.getConstantValue());
                    if ((this.modifiers & 8) != 0) {
                        this.writeOpcode(-77);
                    } else {
                        this.writeOpcode(-75);
                    }
                    this.writeConstantFieldrefInfo(this.declaringType.getDescriptor(), variableDeclarator.name, iClass2.getDescriptor());
                }
                ++n;
            }
            return true;
        }

        public boolean generatesCode() throws CompileException {
            int n = 0;
            while (n < this.variableDeclarators.length) {
                VariableDeclarator variableDeclarator = this.variableDeclarators[n];
                if (this.getNonConstantFinalInitializer(variableDeclarator) != null) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public TypeDeclaration getDeclaringType() {
            return this.declaringType;
        }

        public IClass.IField[] getIFields() {
            IClass.IField[] iFieldArray = new IClass.IField[this.variableDeclarators.length];
            int n = 0;
            while (n < iFieldArray.length) {
                VariableDeclarator variableDeclarator = this.variableDeclarators[n];
                iFieldArray[n] = new IClass.IField(this, variableDeclarator, this.declaringType){
                    private final /* synthetic */ VariableDeclarator val$vd;
                    private final /* synthetic */ FieldDeclarator this$0;
                    {
                        this.this$0 = fieldDeclarator;
                        this.val$vd = variableDeclarator;
                    }

                    public int getAccess() {
                        switch (this.this$0.modifiers & 7) {
                            case 2: {
                                return 0;
                            }
                            case 4: {
                                return 1;
                            }
                            case 0: {
                                return 2;
                            }
                            case 1: {
                                return 3;
                            }
                        }
                        throw new RuntimeException("Invalid access");
                    }

                    public Object getConstantValue() throws CompileException {
                        if ((this.this$0.modifiers & 0x10) != 0 && this.val$vd.optionalInitializer != null) {
                            return this.val$vd.optionalInitializer.getConstantValue();
                        }
                        return null;
                    }

                    public String getName() {
                        return this.val$vd.name;
                    }

                    public IClass getType() throws CompileException {
                        IClass iClass = this.this$0.type.getType();
                        return Java.access$7(iClass, this.val$vd.brackets);
                    }

                    public boolean isStatic() {
                        return (this.this$0.modifiers & 8) != 0;
                    }
                };
                ++n;
            }
            return iFieldArray;
        }

        private Rvalue getNonConstantFinalInitializer(VariableDeclarator variableDeclarator) throws CompileException {
            if (variableDeclarator.optionalInitializer == null) {
                return null;
            }
            if ((this.modifiers & 8) != 0 && (this.modifiers & 0x10) != 0 && variableDeclarator.optionalInitializer.getConstantValue() != null) {
                return null;
            }
            return variableDeclarator.optionalInitializer;
        }

        public boolean isStatic() {
            return (this.modifiers & 8) != 0;
        }

        public void setVariableDeclarators(VariableDeclarator[] variableDeclaratorArray) {
            this.variableDeclarators = variableDeclaratorArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Mod.shortToString(this.modifiers)).append(' ').append(this.type).append(' ').append(this.variableDeclarators[0]);
            int n = 1;
            while (n < this.variableDeclarators.length) {
                stringBuffer.append(", ").append(this.variableDeclarators[n]);
                ++n;
            }
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitFieldDeclarator(this);
        }
    }

    public static final class VariableDeclarator
    extends Located {
        final String name;
        final int brackets;
        Rvalue optionalInitializer = null;

        public VariableDeclarator(Location location, String string, int n, Rvalue rvalue) {
            super(location);
            this.name = string;
            this.brackets = n;
            this.optionalInitializer = rvalue;
        }

        public String getName() {
            return this.name;
        }

        public final void visit(Visitor visitor) {
            visitor.visitVariableDeclarator(this);
        }
    }

    public static final class FormalParameter {
        final boolean finaL;
        final Type type;
        final String name;

        public FormalParameter(boolean bl, Type type, String string) {
            this.finaL = bl;
            this.type = type;
            this.name = string;
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + ' ' + this.name;
        }

        public void visit(Visitor visitor) {
            visitor.visitFormalParameter(this);
        }
    }

    public static interface BlockStatement
    extends Locatable,
    Scope {
        public boolean compile() throws CompileException;

        public boolean generatesCode() throws CompileException;

        public void leave(IClass var1);

        public void visit(Visitor var1);
    }

    public static abstract class Statement
    extends Located
    implements BlockStatement {
        protected final Scope enclosingScope;

        protected Statement(Location location, Scope scope) {
            super(location);
            this.enclosingScope = scope;
        }

        public abstract boolean compile() throws CompileException;

        public boolean generatesCode() throws CompileException {
            return true;
        }

        public Scope getEnclosingScope() {
            return this.enclosingScope;
        }

        public void leave(IClass iClass) {
        }

        public abstract void visit(Visitor var1);
    }

    public static final class LabeledStatement
    extends BreakableStatement {
        String label;
        Statement body = null;

        public LabeledStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.label = string;
        }

        public final boolean compile2() throws CompileException {
            return this.body.compile();
        }

        public void setBody(Statement statement) {
            this.body = statement;
        }

        public final void visit(Visitor visitor) {
            visitor.visitLabeledStatement(this);
        }
    }

    public static final class Block
    extends Statement {
        final List statements = new ArrayList();
        private final Map declaredLocalClasses = new HashMap();
        private HashMap localVariables = new HashMap();
        private boolean keepCompiling;

        public Block(Location location, Scope scope) {
            super(location, scope);
        }

        public void addStatement(BlockStatement blockStatement) {
            this.statements.add(blockStatement);
        }

        public void addStatements(List list) {
            this.statements.addAll(list);
        }

        public boolean compile() throws CompileException {
            this.saveLocalVariables();
            try {
                boolean bl = true;
                this.keepCompiling = true;
                int n = 0;
                while (this.keepCompiling && n < this.statements.size()) {
                    BlockStatement blockStatement = (BlockStatement)this.statements.get(n);
                    if (!bl) {
                        blockStatement.compileError("Statement is unreachable");
                        break;
                    }
                    bl = blockStatement.compile();
                    ++n;
                }
                boolean bl2 = bl;
                Object var3_5 = null;
                this.restoreLocalVariables();
                return bl2;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.restoreLocalVariables();
                throw throwable;
            }
        }

        public LocalVariable defineLocalVariable(Located located, boolean bl, IClass iClass, String string) throws CompileException {
            Scope scope = this;
            while (scope instanceof Statement) {
                if (scope instanceof Block && scope.localVariables.containsKey(string)) {
                    located.compileError("Redefinition of local variable \"" + string + "\"");
                }
                scope = scope.getEnclosingScope();
            }
            LocalVariable localVariable = new LocalVariable(bl, iClass, this.allocateLocalVariable(Descriptor.size(iClass.getDescriptor())));
            this.localVariables.put(string, localVariable);
            return localVariable;
        }

        void followingStatementsAreDead() {
            this.keepCompiling = false;
        }

        public boolean generatesCode() throws CompileException {
            int n = 0;
            while (n < this.statements.size()) {
                if (((BlockStatement)this.statements.get(n)).generatesCode()) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public LocalClassDeclaration getLocalClassDeclaration(String string) {
            return (LocalClassDeclaration)this.declaredLocalClasses.get(string);
        }

        public BlockStatement[] getStatements() {
            return this.statements.toArray(new BlockStatement[this.statements.size()]);
        }

        public final void visit(Visitor visitor) {
            visitor.visitBlock(this);
        }
    }

    public static abstract class BreakableStatement
    extends Statement {
        private CodeContext.Offset whereToBreak = null;

        protected BreakableStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public final boolean compile() throws CompileException {
            boolean bl = this.compile2();
            if (this.whereToBreak != null) {
                this.whereToBreak.set();
                bl = true;
            }
            return bl;
        }

        public abstract boolean compile2() throws CompileException;

        public CodeContext.Offset getWhereToBreak() {
            if (this.whereToBreak == null) {
                this.whereToBreak = this.newUnsetOffset();
            }
            return this.whereToBreak;
        }
    }

    public static abstract class ContinuableStatement
    extends BreakableStatement {
        protected CodeContext.Offset whereToContinue = null;
        protected boolean bodyHasContinue = false;

        protected ContinuableStatement(Location location, Scope scope) {
            super(location, scope);
        }
    }

    public static final class ExpressionStatement
    extends Statement {
        final Rvalue rvalue;

        public ExpressionStatement(Rvalue rvalue, Scope scope) {
            super(rvalue.getLocation(), scope);
            this.rvalue = rvalue;
        }

        public boolean compile() throws CompileException {
            this.rvalue.compile();
            return true;
        }

        public final void visit(Visitor visitor) {
            visitor.visitExpressionStatement(this);
        }
    }

    public static final class LocalClassDeclarationStatement
    extends Statement {
        final LocalClassDeclaration lcd;

        public LocalClassDeclarationStatement(Scope scope, LocalClassDeclaration localClassDeclaration) {
            super(localClassDeclaration.getLocation(), scope);
            this.lcd = localClassDeclaration;
        }

        public boolean compile() throws CompileException {
            this.lcd.compile();
            return true;
        }

        public boolean generatesCode() throws CompileException {
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitLocalClassDeclarationStatement(this);
        }
    }

    public static final class IfStatement
    extends Statement {
        final Rvalue condition;
        final BlockStatement thenStatement;
        final BlockStatement optionalElseStatement;

        public IfStatement(Location location, Scope scope, Rvalue rvalue, BlockStatement blockStatement, BlockStatement blockStatement2) {
            super(location, scope);
            this.condition = rvalue;
            this.thenStatement = blockStatement;
            this.optionalElseStatement = blockStatement2;
        }

        public boolean compile() throws CompileException {
            BlockStatement blockStatement;
            Object object = this.condition.getConstantValue();
            BlockStatement blockStatement2 = blockStatement = this.optionalElseStatement != null ? this.optionalElseStatement : new EmptyStatement(this.thenStatement.getLocation(), this.thenStatement.getEnclosingScope());
            if (object instanceof Boolean) {
                boolean bl;
                BlockStatement blockStatement3;
                BlockStatement blockStatement4;
                if (((Boolean)object).booleanValue()) {
                    blockStatement4 = this.thenStatement;
                    blockStatement3 = blockStatement;
                } else {
                    blockStatement4 = blockStatement;
                    blockStatement3 = this.thenStatement;
                }
                boolean bl2 = blockStatement4.compile();
                if (bl2) {
                    return true;
                }
                CodeContext codeContext = Java.replaceCodeContext(this.createDummyCodeContext());
                try {
                    bl = blockStatement3.compile();
                }
                finally {
                    Object var11_13 = null;
                    Java.replaceCodeContext(codeContext);
                }
                if (!bl) {
                    return false;
                }
                Scope scope = this.getEnclosingScope();
                if (scope instanceof Block) {
                    ((Block)scope).followingStatementsAreDead();
                }
                return false;
            }
            if (this.thenStatement.generatesCode()) {
                if (blockStatement.generatesCode()) {
                    CodeContext.Offset offset = this.newUnsetOffset();
                    CodeContext.Offset offset2 = this.newUnsetOffset();
                    this.condition.compileBoolean(offset, false);
                    boolean bl = this.thenStatement.compile();
                    if (bl) {
                        this.writeBranch(-89, offset2);
                    }
                    offset.set();
                    boolean bl3 = blockStatement.compile();
                    offset2.set();
                    return bl || bl3;
                }
                CodeContext.Offset offset = this.newUnsetOffset();
                this.condition.compileBoolean(offset, false);
                boolean bl = this.thenStatement.compile();
                offset.set();
                return true;
            }
            if (blockStatement.generatesCode()) {
                CodeContext.Offset offset = this.newUnsetOffset();
                this.condition.compileBoolean(offset, true);
                boolean bl = blockStatement.compile();
                offset.set();
                return true;
            }
            IClass iClass = this.condition.compileGetValue();
            if (iClass != IClass.BOOLEAN) {
                this.compileError("Not a boolean expression");
            }
            Java.pop(this, iClass);
            return true;
        }

        public final void visit(Visitor visitor) {
            visitor.visitIfStatement(this);
        }
    }

    public static final class ForStatement
    extends ContinuableStatement {
        public final Block implicitBlock = (Block)this.enclosingScope;
        BlockStatement optionalInit = null;
        Rvalue optionalCondition = null;
        Rvalue[] optionalUpdate = null;
        BlockStatement body;

        public ForStatement(Location location, Scope scope) {
            super(location, new Block(location, scope));
            this.body = new Block(location, this);
        }

        public boolean compile2() throws CompileException {
            boolean bl;
            block12: {
                this.whereToContinue = this.newUnsetOffset();
                this.bodyHasContinue = false;
                bl = false;
                this.saveLocalVariables();
                try {
                    Object object;
                    if (this.optionalInit != null) {
                        this.optionalInit.compile();
                    }
                    if (this.optionalCondition == null) {
                        bl = true;
                    } else {
                        object = this.optionalCondition.getConstantValue();
                        if (object instanceof Boolean) {
                            if (!((Boolean)object).booleanValue()) {
                                this.compileError("Body of \"for\" statement is unreachable");
                            }
                            bl = true;
                        }
                    }
                    object = this.newUnsetOffset();
                    if (!bl) {
                        this.writeBranch(-89, (CodeContext.Offset)object);
                    }
                    CodeContext.Offset offset = this.newOffset();
                    if (!this.body.compile() && !this.bodyHasContinue && this.optionalUpdate != null) {
                        this.compileError("For update is unreachable");
                    }
                    this.whereToContinue.set();
                    if (this.optionalUpdate != null) {
                        int n = 0;
                        while (n < this.optionalUpdate.length) {
                            this.optionalUpdate[n].compile();
                            ++n;
                        }
                    }
                    ((CodeContext.Offset)object).set();
                    if (bl) {
                        this.writeBranch(-89, offset);
                        break block12;
                    }
                    this.optionalCondition.compileBoolean(offset, true);
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.restoreLocalVariables();
                    throw throwable;
                }
            }
            Object var3_5 = null;
            this.restoreLocalVariables();
            return bl ^ true;
        }

        public void set(BlockStatement blockStatement, Rvalue rvalue, Rvalue[] rvalueArray, BlockStatement blockStatement2) {
            this.optionalInit = blockStatement;
            this.optionalCondition = rvalue;
            this.optionalUpdate = rvalueArray;
            this.body = blockStatement2;
        }

        public final void visit(Visitor visitor) {
            visitor.visitForStatement(this);
        }
    }

    public static final class WhileStatement
    extends ContinuableStatement {
        final Rvalue condition;
        BlockStatement body = null;

        public WhileStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.condition = rvalue;
        }

        public boolean compile2() throws CompileException {
            this.whereToContinue = this.newUnsetOffset();
            this.bodyHasContinue = false;
            boolean bl = false;
            Object object = this.condition.getConstantValue();
            if (object != null && object instanceof Boolean) {
                if (!((Boolean)object).booleanValue()) {
                    this.compileError("Body of \"while\" statement is unreachable");
                }
                bl = true;
            }
            if (!bl) {
                this.writeBranch(-89, this.whereToContinue);
            }
            CodeContext.Offset offset = this.newOffset();
            boolean bl2 = this.body.compile();
            if (!bl || bl2 || this.bodyHasContinue) {
                this.whereToContinue.set();
                this.condition.compileBoolean(offset, true);
            }
            return bl ^ true;
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public final void visit(Visitor visitor) {
            visitor.visitWhileStatement(this);
        }
    }

    public static final class TryStatement
    extends Statement {
        BlockStatement body = null;
        final List catchClauses = new ArrayList();
        Block optionalFinally = null;
        private short stackValueLvIndex;
        private CodeContext.Offset finallyOffset = null;

        public TryStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public void addCatchClause(CatchClause catchClause) {
            this.catchClauses.add(catchClause);
        }

        public boolean compile() throws CompileException {
            boolean bl;
            block9: {
                if (this.optionalFinally != null) {
                    this.finallyOffset = this.newUnsetOffset();
                }
                CodeContext.Offset offset = this.newOffset();
                CodeContext.Offset offset2 = this.newUnsetOffset();
                this.saveLocalVariables();
                this.stackValueLvIndex = this.allocateLocalVariable((short)2);
                this.restoreLocalVariables();
                bl = this.body.compile();
                CodeContext.Offset offset3 = this.newOffset();
                if (bl) {
                    this.writeBranch(-89, offset2);
                }
                this.saveLocalVariables();
                try {
                    Object object;
                    short s = this.allocateLocalVariable((short)2);
                    int n = 0;
                    while (n < this.catchClauses.size()) {
                        object = (CatchClause)this.catchClauses.get(n);
                        IClass iClass = ((CatchClause)object).caughtException.type.getType();
                        Java.getCodeContext().addExceptionTableEntry(offset, offset3, this.newOffset(), iClass.getDescriptor());
                        Java.store(this, iClass, s);
                        ((CatchClause)object).body.localVariables.put(((CatchClause)object).caughtException.name, new LocalVariable(false, iClass, s));
                        if (((CatchClause)object).body.compile()) {
                            bl = true;
                            if (n < this.catchClauses.size() - 1 || this.optionalFinally != null) {
                                this.writeBranch(-89, offset2);
                            }
                        }
                        ++n;
                    }
                    if (this.optionalFinally != null) {
                        object = this.newOffset();
                        Java.getCodeContext().addExceptionTableEntry(offset, (CodeContext.Offset)object, (CodeContext.Offset)object, null);
                        Java.store(this, Java.getIClassLoader().OBJECT, s);
                        this.writeBranch(-88, this.finallyOffset);
                        Java.load(this, Java.getIClassLoader().OBJECT, s);
                        this.writeOpcode(-65);
                        this.finallyOffset.set();
                        short s2 = this.allocateLocalVariable((short)1);
                        Java.store(this, Java.getIClassLoader().OBJECT, s2);
                        if (this.optionalFinally.compile()) {
                            this.writeOpcode(-87);
                            this.writeByte(s2);
                        }
                    }
                    offset2.set();
                    if (!bl) break block9;
                    this.leave(null);
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    this.restoreLocalVariables();
                    throw throwable;
                }
            }
            Object var6_10 = null;
            this.restoreLocalVariables();
            return bl;
        }

        public List getCatchClauses() {
            return this.catchClauses;
        }

        public Block getFinally() {
            return this.optionalFinally;
        }

        public void leave(IClass iClass) {
            if (this.finallyOffset != null) {
                if (iClass != null) {
                    Java.store(this, iClass, this.stackValueLvIndex);
                }
                this.writeBranch(-88, this.finallyOffset);
                if (iClass != null) {
                    Java.load(this, iClass, this.stackValueLvIndex);
                }
            }
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public void setFinally(Block block) {
            this.optionalFinally = block;
        }

        public final void visit(Visitor visitor) {
            visitor.visitTryStatement(this);
        }
    }

    public static class CatchClause {
        final FormalParameter caughtException;
        final Block body;

        public CatchClause(FormalParameter formalParameter, Block block) {
            this.caughtException = formalParameter;
            this.body = block;
        }
    }

    public static final class SwitchStatement
    extends BreakableStatement {
        Rvalue condition = null;
        final List sbsgs = new ArrayList();

        public SwitchStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public void addSwitchBlockStatementGroup(SwitchBlockStatementGroup switchBlockStatementGroup) {
            this.sbsgs.add(switchBlockStatementGroup);
        }

        public boolean compile2() throws CompileException {
            Object object;
            Iterator iterator;
            Object object2;
            int n;
            Object object3;
            IClass iClass = this.condition.compileGetValue();
            Java.assignmentConversion(this, iClass, IClass.INT, null);
            TreeMap<Object, CodeContext.Offset> treeMap = new TreeMap<Object, CodeContext.Offset>();
            CodeContext.Offset offset = null;
            CodeContext.Offset[] offsetArray = new CodeContext.Offset[this.sbsgs.size()];
            int n2 = 0;
            while (n2 < this.sbsgs.size()) {
                object3 = (SwitchBlockStatementGroup)this.sbsgs.get(n2);
                offsetArray[n2] = this.newUnsetOffset();
                n = 0;
                while (n < ((SwitchBlockStatementGroup)object3).caseLabels.size()) {
                    object2 = (Rvalue)((SwitchBlockStatementGroup)object3).caseLabels.get(n);
                    iterator = ((Rvalue)object2).getConstantValue();
                    if (iterator == null) {
                        ((Located)object2).compileError("Value of \"case\" label does not pose a constant value");
                        iterator = new Integer(99);
                    }
                    IClass iClass2 = ((Atom)object2).getType();
                    Java.assignmentConversion(this, iClass2, iClass, iterator);
                    if (iterator instanceof Integer) {
                        object = (Integer)((Object)iterator);
                    } else if (iterator instanceof Number) {
                        object = new Integer(((Number)((Object)iterator)).intValue());
                    } else if (iterator instanceof Character) {
                        object = new Integer(((Character)((Object)iterator)).charValue());
                    } else {
                        throw new RuntimeException();
                    }
                    if (treeMap.containsKey(object)) {
                        ((Located)object2).compileError("Duplicate \"case\" switch label value");
                    }
                    treeMap.put(object, offsetArray[n2]);
                    ++n;
                }
                if (((SwitchBlockStatementGroup)object3).hasDefaultLabel) {
                    if (offset != null) {
                        ((Located)object3).compileError("Duplicate \"default\" switch label");
                    }
                    offset = offsetArray[n2];
                }
                ++n2;
            }
            if (offset == null) {
                offset = this.getWhereToBreak();
            }
            object3 = this.newOffset();
            if (treeMap.isEmpty() || 2 * treeMap.size() >= (Integer)treeMap.lastKey() - (Integer)treeMap.firstKey()) {
                n = (Integer)treeMap.firstKey();
                int n3 = (Integer)treeMap.lastKey();
                this.writeOpcode(-86);
                new Padder(Java.getCodeContext()).set();
                this.writeOffset((CodeContext.Offset)object3, offset);
                this.writeInt(n);
                this.writeInt(n3);
                iterator = treeMap.entrySet().iterator();
                int n4 = n;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    int n5 = (Integer)object.getKey();
                    while (n4 < n5) {
                        this.writeOffset((CodeContext.Offset)object3, offset);
                        ++n4;
                    }
                    this.writeOffset((CodeContext.Offset)object3, (CodeContext.Offset)object.getValue());
                    ++n4;
                }
            } else {
                this.writeOpcode(-85);
                new Padder(Java.getCodeContext()).set();
                this.writeOffset((CodeContext.Offset)object3, offset);
                this.writeInt(treeMap.size());
                Iterator iterator2 = treeMap.entrySet().iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    this.writeInt((Integer)object2.getKey());
                    this.writeOffset((CodeContext.Offset)object3, (CodeContext.Offset)object2.getValue());
                }
            }
            boolean bl = true;
            int n6 = 0;
            while (n6 < this.sbsgs.size()) {
                iterator = (SwitchBlockStatementGroup)this.sbsgs.get(n6);
                offsetArray[n6].set();
                bl = true;
                int n7 = 0;
                while (n7 < ((SwitchBlockStatementGroup)((Object)iterator)).blockStatements.size()) {
                    object = (BlockStatement)((SwitchBlockStatementGroup)((Object)iterator)).blockStatements.get(n7);
                    if (!bl) {
                        object.compileError("Statement is unreachable");
                        break;
                    }
                    bl = object.compile();
                    ++n7;
                }
                ++n6;
            }
            return bl;
        }

        public void setCondition(Rvalue rvalue) {
            this.condition = rvalue;
        }

        public final void visit(Visitor visitor) {
            visitor.visitSwitchStatement(this);
        }
    }

    private static class Padder
    extends CodeContext.Inserter
    implements CodeContext.FixUp {
        public Padder(CodeContext codeContext) {
        }

        public void fixUp() {
            int n = this.offset % 4;
            if (n != 0) {
                CodeContext codeContext = this.getCodeContext();
                codeContext.pushInserter(this);
                codeContext.write((short)-1, new byte[4 - n]);
                codeContext.popInserter();
            }
        }
    }

    public static class SwitchBlockStatementGroup
    extends Located {
        final List caseLabels = new ArrayList();
        boolean hasDefaultLabel = false;
        List blockStatements;

        public SwitchBlockStatementGroup(Location location) {
            super(location);
        }

        public void addDefaultSwitchLabel() throws Parser.ParseException {
            if (this.hasDefaultLabel) {
                this.throwParseException("Duplicate \"default\" switch label");
            }
            this.hasDefaultLabel = true;
        }

        public void addSwitchLabel(Rvalue rvalue) {
            this.caseLabels.add(rvalue);
        }

        public void setBlockStatements(List list) {
            this.blockStatements = list;
        }
    }

    public static final class SynchronizedStatement
    extends Statement {
        final Rvalue expression;
        BlockStatement body = null;
        private short monitorLvIndex = (short)-1;

        public SynchronizedStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.expression = rvalue;
        }

        public boolean compile() throws CompileException {
            boolean bl;
            block4: {
                if (!Java.getIClassLoader().OBJECT.isAssignableFrom(this.expression.compileGetValue())) {
                    this.compileError("Monitor object of \"synchronized\" statement is not a subclass of \"Object\"");
                }
                this.saveLocalVariables();
                bl = false;
                try {
                    this.monitorLvIndex = this.allocateLocalVariable((short)1);
                    this.writeOpcode(89);
                    Java.store(this, Java.getIClassLoader().OBJECT, this.monitorLvIndex);
                    this.writeOpcode(-62);
                    CodeContext.Offset offset = this.newUnsetOffset();
                    CodeContext.Offset offset2 = this.newOffset();
                    bl = this.body.compile();
                    if (bl) {
                        this.writeBranch(-89, offset);
                    }
                    CodeContext.Offset offset3 = this.newOffset();
                    Java.getCodeContext().addExceptionTableEntry(offset2, offset3, offset3, null);
                    this.leave(Java.getIClassLoader().THROWABLE);
                    this.writeOpcode(-65);
                    if (!bl) break block4;
                    offset.set();
                    this.leave(null);
                }
                catch (Throwable throwable) {
                    Object var3_6 = null;
                    this.restoreLocalVariables();
                    throw throwable;
                }
            }
            Object var3_5 = null;
            this.restoreLocalVariables();
            return bl;
        }

        public void leave(IClass iClass) {
            Java.load(this, Java.getIClassLoader().OBJECT, this.monitorLvIndex);
            this.writeOpcode(-61);
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public final void visit(Visitor visitor) {
            visitor.visitSynchronizedStatement(this);
        }
    }

    public static final class DoStatement
    extends ContinuableStatement {
        BlockStatement body = null;
        Rvalue condition = null;

        public DoStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public boolean compile2() throws CompileException {
            this.whereToContinue = this.newUnsetOffset();
            this.bodyHasContinue = false;
            CodeContext.Offset offset = this.newOffset();
            if (!this.body.compile() && !this.bodyHasContinue) {
                this.compileError("\"do\" statement never tests its condition");
            }
            this.whereToContinue.set();
            this.condition.compileBoolean(offset, true);
            boolean bl = false;
            Object object = this.condition.getConstantValue();
            if (object != null && object instanceof Boolean) {
                bl = (Boolean)object;
            }
            return bl ^ true;
        }

        public void setBody(BlockStatement blockStatement) {
            this.body = blockStatement;
        }

        public void setCondition(Rvalue rvalue) {
            this.condition = rvalue;
        }

        public final void visit(Visitor visitor) {
            visitor.visitDoStatement(this);
        }
    }

    public static final class LocalVariableDeclarationStatement
    extends Statement {
        private final Block declaringBlock;
        final short modifiers;
        final Type type;
        final VariableDeclarator[] variableDeclarators;

        public LocalVariableDeclarationStatement(Location location, Block block, short s, Type type, VariableDeclarator[] variableDeclaratorArray) {
            super(location, block);
            this.declaringBlock = block;
            this.modifiers = s;
            this.type = type;
            this.variableDeclarators = variableDeclaratorArray;
        }

        public boolean compile() throws CompileException {
            if ((this.modifiers & 0xFFFFFFEF) != 0) {
                this.compileError("The only allowed modifier in local variable declarations is \"final\"");
            }
            int n = 0;
            while (n < this.variableDeclarators.length) {
                VariableDeclarator variableDeclarator = this.variableDeclarators[n];
                Type type = this.type;
                int n2 = 0;
                while (n2 < variableDeclarator.brackets) {
                    type = new ArrayType(type);
                    ++n2;
                }
                IClass iClass = type.getType();
                LocalVariable localVariable = this.declaringBlock.defineLocalVariable(this, (this.modifiers & 0x10) != 0, iClass, variableDeclarator.name);
                if (variableDeclarator.optionalInitializer != null) {
                    Rvalue rvalue = variableDeclarator.optionalInitializer;
                    Java.assignmentConversion(this, rvalue.compileGetValue(), iClass, rvalue.getConstantValue());
                    Java.store(this, iClass, localVariable);
                }
                ++n;
            }
            return true;
        }

        public final void visit(Visitor visitor) {
            visitor.visitLocalVariableDeclarationStatement(this);
        }
    }

    public static final class ReturnStatement
    extends Statement {
        final Rvalue optionalReturnValue;

        public ReturnStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.optionalReturnValue = rvalue;
        }

        public boolean compile() throws CompileException {
            FunctionDeclarator functionDeclarator = null;
            Scope scope = this.enclosingScope;
            scope = scope.getEnclosingScope();
            while (scope instanceof Statement) {
                scope = scope.getEnclosingScope();
            }
            functionDeclarator = (FunctionDeclarator)scope;
            IClass iClass = functionDeclarator.getReturnType();
            if (iClass == IClass.VOID) {
                if (this.optionalReturnValue != null) {
                    this.compileError("Method must not return a value");
                }
                Java.leaveStatements(this.enclosingScope, functionDeclarator, null);
                this.writeOpcode(-79);
                return false;
            }
            if (this.optionalReturnValue == null) {
                this.compileError("Method must return a value");
                return false;
            }
            IClass iClass2 = this.optionalReturnValue.compileGetValue();
            Java.assignmentConversion(this, iClass2, iClass, this.optionalReturnValue.getConstantValue());
            Java.leaveStatements(this.enclosingScope, functionDeclarator, iClass);
            this.writeOpcode(-84 + Java.ilfda(iClass));
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitReturnStatement(this);
        }
    }

    public static final class ThrowStatement
    extends Statement {
        final Rvalue expression;

        public ThrowStatement(Location location, Scope scope, Rvalue rvalue) {
            super(location, scope);
            this.expression = rvalue;
        }

        public boolean compile() throws CompileException {
            IClass iClass = this.expression.compileGetValue();
            Java.checkThrownException(this, iClass, this.enclosingScope);
            this.writeOpcode(-65);
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitThrowStatement(this);
        }
    }

    public static final class BreakStatement
    extends Statement {
        final String optionalLabel;

        public BreakStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.optionalLabel = string;
        }

        public boolean compile() throws CompileException {
            BreakableStatement breakableStatement = null;
            if (this.optionalLabel == null) {
                Scope scope = this.enclosingScope;
                while (scope instanceof Statement) {
                    if (scope instanceof BreakableStatement) {
                        breakableStatement = (BreakableStatement)scope;
                        break;
                    }
                    scope = scope.getEnclosingScope();
                }
                if (breakableStatement == null) {
                    this.compileError("\"break\" statement is not enclosed by a breakable statement");
                    return false;
                }
            } else {
                Scope scope = this.enclosingScope;
                while (scope instanceof Statement) {
                    if (scope instanceof LabeledStatement) {
                        LabeledStatement labeledStatement = (LabeledStatement)scope;
                        if (labeledStatement.label.equals(this.optionalLabel)) {
                            breakableStatement = labeledStatement;
                            break;
                        }
                    }
                    scope = scope.getEnclosingScope();
                }
                if (breakableStatement == null) {
                    this.compileError("Statement \"break " + this.optionalLabel + "\" is not enclosed by a breakable statement with label \"" + this.optionalLabel + "\"");
                    return false;
                }
            }
            Java.leaveStatements(this.enclosingScope, breakableStatement.enclosingScope, null);
            this.writeBranch(-89, breakableStatement.getWhereToBreak());
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitBreakStatement(this);
        }
    }

    public static final class ContinueStatement
    extends Statement {
        final String optionalLabel;

        public ContinueStatement(Location location, Scope scope, String string) {
            super(location, scope);
            this.optionalLabel = string;
        }

        public boolean compile() throws CompileException {
            ContinuableStatement continuableStatement = null;
            if (this.optionalLabel == null) {
                Scope scope = this.enclosingScope;
                while (scope instanceof Statement) {
                    if (scope instanceof ContinuableStatement) {
                        continuableStatement = (ContinuableStatement)scope;
                        break;
                    }
                    scope = scope.getEnclosingScope();
                }
                if (continuableStatement == null) {
                    this.compileError("\"continue\" statement is not enclosed by a continuable statement");
                    return false;
                }
            } else {
                Scope scope = this.enclosingScope;
                while (scope instanceof Statement) {
                    if (scope instanceof LabeledStatement) {
                        LabeledStatement labeledStatement = (LabeledStatement)scope;
                        if (labeledStatement.label.equals(this.optionalLabel)) {
                            Statement statement = labeledStatement.body;
                            while (statement instanceof LabeledStatement) {
                                statement = ((LabeledStatement)statement).body;
                            }
                            if (!(statement instanceof ContinuableStatement)) {
                                statement.compileError("Labeled statement is not continuable");
                                return false;
                            }
                            continuableStatement = (ContinuableStatement)statement;
                            break;
                        }
                    }
                    scope = scope.getEnclosingScope();
                }
                if (continuableStatement == null) {
                    this.compileError("Statement \"continue " + this.optionalLabel + "\" is not enclosed by a continuable statement with label \"" + this.optionalLabel + "\"");
                    return false;
                }
            }
            continuableStatement.bodyHasContinue = true;
            Java.leaveStatements(this.enclosingScope, continuableStatement.enclosingScope, null);
            this.writeBranch(-89, continuableStatement.whereToContinue);
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitContinueStatement(this);
        }
    }

    public static final class EmptyStatement
    extends Statement {
        public EmptyStatement(Location location, Scope scope) {
            super(location, scope);
        }

        public boolean compile() {
            return true;
        }

        public boolean generatesCode() {
            return false;
        }

        public final void visit(Visitor visitor) {
            visitor.visitEmptyStatement(this);
        }
    }

    public static abstract class Atom
    extends Located {
        public Atom(Location location) {
            super(location);
        }

        public abstract IClass getType() throws CompileException;

        public boolean isType() throws CompileException {
            return this instanceof Type;
        }

        public Lvalue toLvalue() {
            return null;
        }

        public final Lvalue toLvalueOrCE() throws CompileException {
            Lvalue lvalue = this.toLvalue();
            if (lvalue == null) {
                this.compileError("Expression \"" + this.toString() + "\" is not an lvalue");
                return new Lvalue(this, this.getLocation()){
                    private final /* synthetic */ Atom this$0;
                    {
                        this.this$0 = atom;
                    }

                    public IClass compileGet() {
                        return Java.getIClassLoader().OBJECT;
                    }

                    public void compileSet() {
                    }

                    public IClass getType() {
                        return Java.getIClassLoader().OBJECT;
                    }

                    public String toString() {
                        return this.this$0.toString();
                    }

                    public void visit(Visitor visitor) {
                    }
                };
            }
            return lvalue;
        }

        public final Lvalue toLvalueOrPE() throws Parser.ParseException {
            Lvalue lvalue = this.toLvalue();
            if (lvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an lvalue");
            }
            return lvalue;
        }

        public Rvalue toRvalue() {
            return null;
        }

        public final Rvalue toRvalueOrCE() throws CompileException {
            Rvalue rvalue = this.toRvalue();
            if (rvalue == null) {
                this.compileError("Expression \"" + this.toString() + "\" is not an rvalue");
                return new Rvalue(this, this.getLocation()){
                    private final /* synthetic */ Atom this$0;
                    {
                        this.this$0 = atom;
                    }

                    public IClass compileGet() {
                        return Java.getIClassLoader().OBJECT;
                    }

                    public IClass getType() {
                        return Java.getIClassLoader().OBJECT;
                    }

                    public String toString() {
                        return this.this$0.toString();
                    }

                    public void visit(Visitor visitor) {
                    }
                };
            }
            return rvalue;
        }

        public final Rvalue toRvalueOrPE() throws Parser.ParseException {
            Rvalue rvalue = this.toRvalue();
            if (rvalue == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not an rvalue");
            }
            return rvalue;
        }

        public abstract String toString();

        public Type toType() {
            return null;
        }

        public final Type toTypeOrCE() throws CompileException {
            Type type = this.toType();
            if (type == null) {
                this.compileError("Expression \"" + this.toString() + "\" is not a type");
                return new Type(this, this.getLocation()){
                    private final /* synthetic */ Atom this$0;
                    {
                        this.this$0 = atom;
                    }

                    public IClass getType() {
                        return Java.getIClassLoader().OBJECT;
                    }

                    public String toString() {
                        return this.this$0.toString();
                    }

                    public void visit(Visitor visitor) {
                    }
                };
            }
            return type;
        }

        public final Type toTypeOrPE() throws Parser.ParseException {
            Type type = this.toType();
            if (type == null) {
                this.throwParseException("Expression \"" + this.toString() + "\" is not a type");
            }
            return type;
        }

        public abstract void visit(Visitor var1);
    }

    public static abstract class Type
    extends Atom {
        protected Type(Location location) {
            super(location);
        }

        public Type toType() {
            return this;
        }
    }

    public static final class SimpleType
    extends Type {
        private final IClass iClass;

        public SimpleType(Location location, IClass iClass) {
            super(location);
            this.iClass = iClass;
        }

        public IClass getType() {
            return this.iClass;
        }

        public String toString() {
            return this.iClass.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitSimpleType(this);
        }
    }

    public static final class BasicType
    extends Type {
        public static final int VOID = 0;
        public static final int BYTE = 1;
        public static final int SHORT = 2;
        public static final int CHAR = 3;
        public static final int INT = 4;
        public static final int LONG = 5;
        public static final int FLOAT = 6;
        public static final int DOUBLE = 7;
        public static final int BOOLEAN = 8;
        private final int index;

        public BasicType(Location location, int n) {
            super(location);
            this.index = n;
        }

        public IClass getType() {
            switch (this.index) {
                case 0: {
                    return IClass.VOID;
                }
                case 1: {
                    return IClass.BYTE;
                }
                case 2: {
                    return IClass.SHORT;
                }
                case 3: {
                    return IClass.CHAR;
                }
                case 4: {
                    return IClass.INT;
                }
                case 5: {
                    return IClass.LONG;
                }
                case 6: {
                    return IClass.FLOAT;
                }
                case 7: {
                    return IClass.DOUBLE;
                }
                case 8: {
                    return IClass.BOOLEAN;
                }
            }
            throw new RuntimeException("Invalid index " + this.index);
        }

        public String toString() {
            switch (this.index) {
                case 0: {
                    return "void";
                }
                case 1: {
                    return "byte";
                }
                case 2: {
                    return "short";
                }
                case 3: {
                    return "char";
                }
                case 4: {
                    return "int";
                }
                case 5: {
                    return "long";
                }
                case 6: {
                    return "float";
                }
                case 7: {
                    return "double";
                }
                case 8: {
                    return "boolean";
                }
            }
            throw new RuntimeException("Invalid index " + this.index);
        }

        public final void visit(Visitor visitor) {
            visitor.visitBasicType(this);
        }
    }

    public static final class ReferenceType
    extends Type {
        private final String[] identifiers;
        private final Scope scope;

        public ReferenceType(Location location, Scope scope, String[] stringArray) {
            super(location);
            this.scope = scope;
            this.identifiers = stringArray;
        }

        public IClass getType() throws CompileException {
            TypeDeclaration typeDeclaration = null;
            Scope scope = this.scope;
            if (scope instanceof Statement) {
                scope = scope.getEnclosingScope();
                while (scope instanceof Statement) {
                    scope = scope.getEnclosingScope();
                }
            }
            if (scope instanceof FunctionDeclarator) {
                scope = scope.getEnclosingScope();
            }
            if (scope instanceof TypeDeclaration) {
                typeDeclaration = (TypeDeclaration)scope;
            }
            if (scope != null) {
                while (!(scope instanceof CompilationUnit)) {
                    scope = scope.getEnclosingScope();
                }
            }
            CompilationUnit compilationUnit = (CompilationUnit)scope;
            if (this.identifiers.length == 1) {
                Object object;
                IClass iClass;
                Scope scope2;
                String string = this.identifiers[0];
                Scope scope3 = this.scope;
                while (scope3 != null) {
                    if (scope3 instanceof Block && (scope2 = ((Block)scope3).getLocalClassDeclaration(string)) != null) {
                        return scope2;
                    }
                    scope3 = scope3.getEnclosingScope();
                }
                scope2 = typeDeclaration;
                while (scope2 != null) {
                    if (scope2 instanceof TypeDeclaration && (iClass = Java.findMemberType((IClass)((Object)scope2), string, this.getLocation())) != null) {
                        return iClass;
                    }
                    scope2 = scope2.getEnclosingScope();
                }
                if (compilationUnit != null) {
                    iClass = compilationUnit.importSingleType(string, this.getLocation());
                    if (iClass != null) {
                        return iClass;
                    }
                    object = compilationUnit.getPackageMemberTypeDeclaration(string);
                    if (object != null) {
                        return (IClass)object;
                    }
                }
                iClass = compilationUnit.optionalPackageDeclaration == null ? null : compilationUnit.optionalPackageDeclaration.getPackageName();
                object = Java.getIClassLoader();
                IClass iClass2 = ((IClassLoader)object).loadIClass(Descriptor.fromClassName(iClass == null ? string : String.valueOf(iClass) + "." + string));
                if (iClass2 != null) {
                    return iClass2;
                }
                IClass iClass3 = compilationUnit.importTypeOnDemand(string, this.getLocation());
                if (iClass3 != null) {
                    return iClass3;
                }
                this.compileError("Cannot determine simple type name \"" + string + "\"");
                return Java.getIClassLoader().OBJECT;
            }
            Atom atom = Java.reclassifyName(this.getLocation(), this.scope, this.identifiers, this.identifiers.length - 1);
            String string = atom instanceof Package ? Java.join(this.identifiers, ".") : String.valueOf(Descriptor.toClassName(atom.toTypeOrCE().getType().getDescriptor())) + '$' + this.identifiers[this.identifiers.length - 1];
            IClass iClass = Java.getIClassLoader().loadIClass(Descriptor.fromClassName(string));
            if (iClass != null) {
                return iClass;
            }
            this.compileError("Class \"" + string + "\" not found");
            return Java.getIClassLoader().OBJECT;
        }

        public String toString() {
            return Java.join(this.identifiers, ".");
        }

        public final void visit(Visitor visitor) {
            visitor.visitReferenceType(this);
        }
    }

    public static final class RvalueMemberType
    extends Type {
        private final Rvalue rvalue;
        private final String identifier;

        public RvalueMemberType(Location location, Rvalue rvalue, String string) {
            super(location);
            this.rvalue = rvalue;
            this.identifier = string;
        }

        public IClass getType() throws CompileException {
            IClass iClass = this.rvalue.getType();
            IClass iClass2 = Java.findMemberType(iClass, this.identifier, this.getLocation());
            if (iClass2 == null) {
                this.compileError("\"" + iClass + "\" has no member type \"" + this.identifier + "\"");
            }
            return iClass2;
        }

        public String toString() {
            return this.identifier;
        }

        public final void visit(Visitor visitor) {
            visitor.visitRvalueMemberType(this);
        }
    }

    public static final class ArrayType
    extends Type {
        final Type componentType;

        public ArrayType(Type type) {
            super(type.getLocation());
            this.componentType = type;
        }

        public Type getComponentType() {
            return this.componentType;
        }

        public IClass getType() throws CompileException {
            return Java.getArrayType(this.componentType.getType());
        }

        public String toString() {
            return String.valueOf(this.componentType.toString()) + "[]";
        }

        public final void visit(Visitor visitor) {
            visitor.visitArrayType(this);
        }
    }

    public static abstract class Rvalue
    extends Atom {
        private static final Object CONSTANT_VALUE_UNKNOWN = new Object();
        private Object constantValue = CONSTANT_VALUE_UNKNOWN;
        public static final Object CONSTANT_VALUE_NULL = new Throwable();
        public static final boolean JUMP_IF_TRUE = true;
        public static final boolean JUMP_IF_FALSE = false;

        protected Rvalue(Location location) {
            super(location);
        }

        public void compile() throws CompileException {
            Java.pop(this, this.compileGetValue());
        }

        public void compileBoolean(CodeContext.Offset offset, boolean bl) throws CompileException {
            Object object = this.getConstantValue();
            if (object instanceof Boolean) {
                if (!bl ^ (Boolean)object) {
                    this.writeBranch(-89, offset);
                }
                return;
            }
            if (this.compileGetValue() != IClass.BOOLEAN) {
                this.compileError("Not a boolean expression");
            }
            this.writeBranch(bl ? -102 : -103, offset);
        }

        public int compileContext() throws CompileException {
            return 0;
        }

        public abstract IClass compileGet() throws CompileException;

        public IClass compileGetValue() throws CompileException {
            Object object = this.getConstantValue();
            if (object != null) {
                Java.pushConstant(this, object);
                return this.getType();
            }
            this.compileContext();
            return this.compileGet();
        }

        public final Object getConstantValue() throws CompileException {
            if (this.constantValue == CONSTANT_VALUE_UNKNOWN) {
                this.constantValue = this.getConstantValue2();
            }
            return this.constantValue;
        }

        public Object getConstantValue2() throws CompileException {
            return null;
        }

        public Object getNegatedConstantValue() throws CompileException {
            return null;
        }

        public Rvalue toRvalue() {
            return this;
        }
    }

    public static abstract class BooleanRvalue
    extends Rvalue {
        protected BooleanRvalue(Location location) {
            super(location);
        }

        public IClass compileGet() throws CompileException {
            Object object = this.getConstantValue();
            if (object instanceof Boolean) {
                this.writeOpcode((Boolean)object != false ? 4 : 3);
                return IClass.BOOLEAN;
            }
            CodeContext.Offset offset = this.newUnsetOffset();
            this.compileBoolean(offset, true);
            this.writeOpcode(3);
            CodeContext.Offset offset2 = this.newUnsetOffset();
            this.writeBranch(-89, offset2);
            offset.set();
            this.writeOpcode(4);
            offset2.set();
            return IClass.BOOLEAN;
        }
    }

    public static abstract class Lvalue
    extends Rvalue {
        protected Lvalue(Location location) {
            super(location);
        }

        public abstract void compileSet() throws CompileException;

        public Lvalue toLvalue() {
            return this;
        }
    }

    public static final class AmbiguousName
    extends Lvalue {
        private Atom reclassified = null;
        private final Scope scope;
        private final String[] identifiers;
        private final int n;

        public AmbiguousName(Location location, Scope scope, String[] stringArray) {
            this(location, scope, stringArray, stringArray.length);
        }

        public AmbiguousName(Location location, Scope scope, String[] stringArray, int n) {
            super(location);
            this.scope = scope;
            this.identifiers = stringArray;
            this.n = n;
        }

        public int compileContext() throws CompileException {
            return this.reclassify().toRvalueOrCE().compileContext();
        }

        public IClass compileGet() throws CompileException {
            return this.reclassify().toRvalueOrCE().compileGet();
        }

        public void compileSet() throws CompileException {
            this.reclassify().toLvalueOrCE().compileSet();
        }

        public Object getConstantValue2() throws CompileException {
            return this.reclassify().toRvalueOrCE().getConstantValue();
        }

        public IClass getType() throws CompileException {
            return this.reclassify().getType();
        }

        public boolean isType() throws CompileException {
            return this.reclassify().isType();
        }

        Atom reclassify() throws CompileException {
            if (this.reclassified == null) {
                this.reclassified = Java.reclassifyName(this.getLocation(), this.scope, this.identifiers, this.n);
            }
            return this.reclassified;
        }

        public String toString() {
            return Java.join((Object[])this.identifiers, ".", 0, this.n);
        }

        public Type toType() {
            return new Type(this, this.getLocation()){
                private final /* synthetic */ AmbiguousName this$0;
                {
                    this.this$0 = ambiguousName;
                }

                public IClass getType() throws CompileException {
                    return this.this$0.reclassify().toTypeOrCE().getType();
                }

                public boolean isType() throws CompileException {
                    return this.this$0.reclassify().isType();
                }

                public String toString() {
                    return this.this$0.toString();
                }

                public final void visit(Visitor visitor) {
                    this.this$0.visit(visitor);
                }
            };
        }

        public final void visit(Visitor visitor) {
            visitor.visitAmbiguousName(this);
        }
    }

    static final class Package
    extends Atom {
        private final String name;

        public Package(Location location, String string) {
            super(location);
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public IClass getType() throws CompileException {
            this.compileError("Unknown variable or type \"" + this.name + "\"");
            return Java.getIClassLoader().OBJECT;
        }

        public String toString() {
            return this.name;
        }

        public final void visit(Visitor visitor) {
            visitor.visitPackage(this);
        }
    }

    static final class LocalVariableAccess
    extends Lvalue {
        LocalVariable localVariable;

        public LocalVariableAccess(Location location, LocalVariable localVariable) {
            super(location);
            this.localVariable = localVariable;
        }

        public IClass compileGet() throws CompileException {
            return Java.load(this, this.localVariable);
        }

        public void compileSet() throws CompileException {
            Java.store(this, this.localVariable.type, this.localVariable);
        }

        public IClass getType() {
            return this.localVariable.type;
        }

        public String toString() {
            return this.localVariable.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitLocalVariableAccess(this);
        }
    }

    static final class FieldAccess
    extends Lvalue {
        final Atom lhs;
        final IClass.IField field;

        public FieldAccess(Location location, Atom atom, IClass.IField iField) {
            super(location);
            this.lhs = atom;
            this.field = iField;
        }

        public int compileContext() throws CompileException {
            if (this.field.isStatic()) {
                this.lhs.toTypeOrCE().getType();
                return 0;
            }
            this.lhs.toRvalueOrCE().compileGetValue();
            return 1;
        }

        public IClass compileGet() throws CompileException {
            if (this.field.isStatic()) {
                this.writeOpcode(-78);
            } else {
                this.writeOpcode(-76);
            }
            this.writeConstantFieldrefInfo(this.field.getDeclaringIClass().getDescriptor(), this.field.getName(), this.field.getType().getDescriptor());
            return this.field.getType();
        }

        public void compileSet() throws CompileException {
            this.writeOpcode(this.field.isStatic() ? -77 : -75);
            this.writeConstantFieldrefInfo(this.field.getDeclaringIClass().getDescriptor(), this.field.getName(), this.field.getDescriptor());
        }

        public Object getConstantValue2() throws CompileException {
            return this.field.getConstantValue();
        }

        public IClass getType() throws CompileException {
            return this.field.getType();
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.field.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitFieldAccess(this);
        }
    }

    static final class ArrayLength
    extends Rvalue {
        final Rvalue lhs;

        public ArrayLength(Location location, Rvalue rvalue) {
            super(location);
            this.lhs = rvalue;
        }

        public int compileContext() throws CompileException {
            if (!this.lhs.compileGetValue().isArray()) {
                this.compileError("Cannot determine length of non-array type");
            }
            return 1;
        }

        public IClass compileGet() throws CompileException {
            this.writeOpcode(-66);
            return IClass.INT;
        }

        public IClass getType() throws CompileException {
            return IClass.INT;
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ".length";
        }

        public final void visit(Visitor visitor) {
            visitor.visitArrayLength(this);
        }
    }

    public static final class ThisReference
    extends Rvalue {
        private final Scope scope;
        private IClass iClass = null;

        public ThisReference(Location location, IClass iClass) {
            super(location);
            this.scope = null;
            this.iClass = iClass;
        }

        public ThisReference(Location location, Scope scope) {
            super(location);
            this.scope = scope;
        }

        public IClass compileGet() throws CompileException {
            Java.referenceThis(this);
            return this.getIClass();
        }

        private IClass getIClass() throws CompileException {
            if (this.iClass == null) {
                Scope scope = this.scope;
                while (scope instanceof Statement) {
                    scope = scope.getEnclosingScope();
                }
                if (scope instanceof FunctionDeclarator) {
                    FunctionDeclarator functionDeclarator = (FunctionDeclarator)scope;
                    if ((functionDeclarator.modifiers & 8) != 0) {
                        this.compileError("No current instance available in static method");
                    }
                }
                while (!(scope instanceof TypeDeclaration)) {
                    scope = scope.getEnclosingScope();
                }
                if (!(scope instanceof ClassDeclaration)) {
                    this.compileError("Only methods of classes can have a current instance");
                }
                this.iClass = (ClassDeclaration)scope;
            }
            return this.iClass;
        }

        public IClass getType() throws CompileException {
            return this.getIClass();
        }

        public String toString() {
            return "this";
        }

        public final void visit(Visitor visitor) {
            visitor.visitThisReference(this);
        }
    }

    public static final class QualifiedThisReference
    extends Rvalue {
        private final Scope scope;
        final Type qualification;
        private ClassDeclaration declaringClass = null;
        private TypeBodyDeclaration declaringTypeBodyDeclaration = null;
        private IClass targetIClass = null;

        public QualifiedThisReference(Location location, ClassDeclaration classDeclaration, FunctionDeclarator functionDeclarator, IClass iClass) {
            super(location);
            if (classDeclaration == null) {
                throw new NullPointerException();
            }
            if (iClass == null) {
                throw new NullPointerException();
            }
            this.scope = null;
            this.qualification = null;
            this.declaringClass = classDeclaration;
            this.declaringTypeBodyDeclaration = functionDeclarator;
            this.targetIClass = iClass;
        }

        public QualifiedThisReference(Location location, Scope scope, Type type) {
            super(location);
            if (scope == null) {
                throw new NullPointerException();
            }
            if (type == null) {
                throw new NullPointerException();
            }
            this.scope = scope;
            this.qualification = type;
        }

        public IClass compileGet() throws CompileException {
            Java.referenceThis(this, this.getDeclaringClass(), this.getDeclaringTypeBodyDeclaration(), this.getTargetIClass());
            return this.getTargetIClass();
        }

        private ClassDeclaration getDeclaringClass() throws CompileException {
            if (this.declaringClass == null) {
                this.getDeclaringTypeBodyDeclaration();
            }
            return this.declaringClass;
        }

        private TypeBodyDeclaration getDeclaringTypeBodyDeclaration() throws CompileException {
            if (this.declaringTypeBodyDeclaration == null) {
                Scope scope = this.scope;
                while (!(scope instanceof TypeBodyDeclaration)) {
                    scope = scope.getEnclosingScope();
                }
                this.declaringTypeBodyDeclaration = (TypeBodyDeclaration)scope;
                if (this.declaringTypeBodyDeclaration.isStatic()) {
                    this.compileError("No current instance available in static method");
                }
                this.declaringClass = (ClassDeclaration)this.declaringTypeBodyDeclaration.getDeclaringType();
            }
            return this.declaringTypeBodyDeclaration;
        }

        private IClass getTargetIClass() throws CompileException {
            if (this.targetIClass == null) {
                this.targetIClass = this.qualification.getType();
            }
            return this.targetIClass;
        }

        public IClass getType() throws CompileException {
            return this.getTargetIClass();
        }

        public String toString() {
            return String.valueOf(this.qualification.toString()) + ".this";
        }

        public final void visit(Visitor visitor) {
            visitor.visitQualifiedThisReference(this);
        }
    }

    public static final class ClassLiteral
    extends Rvalue {
        private final AbstractTypeDeclaration declaringType;
        final Type type;

        public ClassLiteral(Location location, Scope scope, Type type) {
            super(location);
            Scope scope2 = scope;
            while (!(scope2 instanceof AbstractTypeDeclaration)) {
                scope2 = scope2.getEnclosingScope();
            }
            this.declaringType = (AbstractTypeDeclaration)scope2;
            this.type = type;
        }

        static /* synthetic */ AbstractTypeDeclaration access$0(ClassLiteral classLiteral) {
            return classLiteral.declaringType;
        }

        public IClass compileGet() throws CompileException {
            Located located;
            Locatable locatable;
            Object object;
            Location location = this.getLocation();
            IClassLoader iClassLoader = Java.getIClassLoader();
            IClass iClass = this.type.getType();
            if (iClass.isPrimitive()) {
                String string;
                this.writeOpcode(-78);
                String string2 = iClass == IClass.VOID ? "Ljava/lang/Void;" : (iClass == IClass.BYTE ? "Ljava/lang/Byte;" : (iClass == IClass.CHAR ? "Ljava/lang/Character;" : (iClass == IClass.DOUBLE ? "Ljava/lang/Double;" : (iClass == IClass.FLOAT ? "Ljava/lang/Float;" : (iClass == IClass.INT ? "Ljava/lang/Integer;" : (iClass == IClass.LONG ? "Ljava/lang/Long;" : (iClass == IClass.SHORT ? "Ljava/lang/Short;" : (string = iClass == IClass.BOOLEAN ? "Ljava/lang/Boolean;" : null))))))));
                if (string == null) {
                    throw new RuntimeException();
                }
                this.writeConstantFieldrefInfo(string, "TYPE", "Ljava/lang/Class;");
                return iClassLoader.CLASS;
            }
            boolean bl = false;
            Iterator iterator = this.declaringType.declaredMethods.iterator();
            while (iterator.hasNext()) {
                object = (MethodDeclarator)iterator.next();
                if (!((FunctionDeclarator)object).getName().equals("class$")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.declareClassDollarMethod();
            }
            if (this.declaringType instanceof ClassDeclaration) {
                object = ((ClassDeclaration)this.declaringType).variableDeclaratorsAndInitializers;
            } else if (this.declaringType instanceof InterfaceDeclaration) {
                object = ((InterfaceDeclaration)this.declaringType).constantDeclarations;
            } else {
                throw new RuntimeException();
            }
            String string = Descriptor.toClassName(iClass.getDescriptor());
            String string3 = "class$" + string.replace('.', '$');
            boolean bl2 = false;
            Iterator iterator2 = object.iterator();
            block1: while (iterator2.hasNext()) {
                locatable = (TypeBodyDeclaration)iterator2.next();
                if (!locatable.isStatic() || !(locatable instanceof FieldDeclarator)) continue;
                located = (FieldDeclarator)locatable;
                IClass.IField[] iFieldArray = ((FieldDeclarator)located).getIFields();
                int n = 0;
                while (n < iFieldArray.length) {
                    if (iFieldArray[n].getName().equals(string3)) {
                        bl2 = true;
                        break block1;
                    }
                    ++n;
                }
            }
            if (!bl2) {
                locatable = new SimpleType(location, iClassLoader.CLASS);
                located = new FieldDeclarator(location, this.declaringType, 8, (Type)locatable);
                ((FieldDeclarator)located).setVariableDeclarators(new VariableDeclarator[]{new VariableDeclarator(location, string3, 0, null)});
                if (this.declaringType instanceof ClassDeclaration) {
                    ((ClassDeclaration)this.declaringType).addVariableDeclaratorOrInitializer((TypeBodyDeclaration)((Object)located));
                } else if (this.declaringType instanceof InterfaceDeclaration) {
                    ((InterfaceDeclaration)this.declaringType).addConstantDeclaration((FieldDeclarator)located);
                } else {
                    throw new RuntimeException();
                }
            }
            locatable = new SimpleType(location, this.declaringType);
            located = new Lvalue(string3, iClassLoader, this, location){
                private final /* synthetic */ IClassLoader val$icl;
                private final /* synthetic */ String val$classDollarFieldName;
                private final /* synthetic */ ClassLiteral this$0;
                {
                    this.val$classDollarFieldName = string;
                    this.val$icl = iClassLoader;
                    this.this$0 = classLiteral;
                }

                public IClass compileGet() throws CompileException {
                    this.writeOpcode(-78);
                    this.writeConstantFieldrefInfo(ClassLiteral.access$0(this.this$0).getDescriptor(), this.val$classDollarFieldName, this.val$icl.CLASS.getDescriptor());
                    return this.val$icl.CLASS;
                }

                public void compileSet() throws CompileException {
                    this.writeOpcode(-77);
                    this.writeConstantFieldrefInfo(ClassLiteral.access$0(this.this$0).getDescriptor(), this.val$classDollarFieldName, this.val$icl.CLASS.getDescriptor());
                }

                public IClass getType() throws CompileException {
                    return this.val$icl.CLASS;
                }

                public String toString() {
                    return "???";
                }

                public final void visit(Visitor visitor) {
                }
            };
            return new ConditionalExpression(location, new BinaryOperation(location, (Rvalue)located, "!=", new ConstantValue(location, null)), (Rvalue)located, new Assignment(location, (Lvalue)located, "=", new MethodInvocation(location, this.declaringType, (Atom)locatable, "class$", new Rvalue[]{new ConstantValue(location, string)}))).compileGet();
        }

        private void declareClassDollarMethod() {
            IClassLoader iClassLoader = Java.getIClassLoader();
            Location location = this.getLocation();
            SimpleType simpleType = new SimpleType(location, iClassLoader.STRING);
            SimpleType simpleType2 = new SimpleType(location, iClassLoader.CLASS);
            FormalParameter formalParameter = new FormalParameter(false, simpleType, "className");
            MethodDeclarator methodDeclarator = new MethodDeclarator(location, this.declaringType, 8, (Type)simpleType2, "class$", new FormalParameter[]{formalParameter}, new Type[0]);
            Block block = new Block(location, methodDeclarator);
            TryStatement tryStatement = new TryStatement(location, methodDeclarator);
            MethodInvocation methodInvocation = new MethodInvocation(location, tryStatement, simpleType2, "forName", new Rvalue[]{new AmbiguousName(location, tryStatement, new String[]{"className"})});
            tryStatement.setBody(new ReturnStatement(location, tryStatement, methodInvocation));
            IClass iClass = iClassLoader.loadIClass("Ljava/lang/ClassNotFoundException;");
            if (iClass == null) {
                throw new RuntimeException();
            }
            IClass iClass2 = iClassLoader.loadIClass("Ljava/lang/NoClassDefFoundError;");
            if (iClass2 == null) {
                throw new RuntimeException();
            }
            Block block2 = new Block(location, tryStatement);
            CatchClause catchClause = new CatchClause(new FormalParameter(true, new SimpleType(location, iClass), "ex"), block2);
            NewClassInstance newClassInstance = new NewClassInstance(location, (Scope)block2, null, new SimpleType(location, iClass2), new Rvalue[]{new MethodInvocation(location, block2, new AmbiguousName(location, block2, new String[]{"ex"}), "getMessage", new Rvalue[0])});
            block2.addStatement(new ThrowStatement(location, block2, newClassInstance));
            tryStatement.addCatchClause(catchClause);
            block.addStatement(tryStatement);
            methodDeclarator.setBody(block);
            this.declaringType.declaredMethods.add(methodDeclarator);
            this.declaringType.declaredIMethods = null;
        }

        public IClass getType() throws CompileException {
            return Java.getIClassLoader().CLASS;
        }

        public String toString() {
            return String.valueOf(this.type.toString()) + ".class";
        }

        public final void visit(Visitor visitor) {
            visitor.visitClassLiteral(this);
        }
    }

    public static final class Assignment
    extends Rvalue {
        final Lvalue lhs;
        final String operator;
        final Rvalue rhs;

        public Assignment(Location location, Lvalue lvalue, String string, Rvalue rvalue) {
            super(location);
            this.lhs = lvalue;
            this.operator = string;
            this.rhs = rvalue;
        }

        public void compile() throws CompileException {
            if (this.operator == "=") {
                this.lhs.compileContext();
                Java.assignmentConversion(this, this.rhs.compileGetValue(), this.lhs.getType(), this.rhs.getConstantValue());
                this.lhs.compileSet();
                return;
            }
            int n = this.lhs.compileContext();
            Java.dup(this, n);
            IClass iClass = this.lhs.compileGet();
            IClass iClass2 = Java.compileArithmeticBinaryOperation(this, iClass, this.operator.substring(0, this.operator.length() - 1).intern(), this.rhs);
            if (!Java.tryIdentityConversion(iClass2, iClass) && !Java.tryNarrowingPrimitiveConversion(this, iClass2, iClass)) {
                throw new RuntimeException();
            }
            this.lhs.compileSet();
        }

        public IClass compileGet() throws CompileException {
            if (this.operator == "=") {
                int n = this.lhs.compileContext();
                IClass iClass = this.rhs.compileGetValue();
                IClass iClass2 = this.lhs.getType();
                Object object = this.rhs.getConstantValue();
                Java.assignmentConversion(this, iClass, iClass2, object);
                Java.dupx(this, iClass2, n);
                this.lhs.compileSet();
                return iClass2;
            }
            int n = this.lhs.compileContext();
            Java.dup(this, n);
            IClass iClass = this.lhs.compileGet();
            IClass iClass3 = Java.compileArithmeticBinaryOperation(this, iClass, this.operator.substring(0, this.operator.length() - 1).intern(), this.rhs);
            if (!Java.tryIdentityConversion(iClass3, iClass) && !Java.tryNarrowingPrimitiveConversion(this, iClass3, iClass)) {
                throw new RuntimeException();
            }
            Java.dupx(this, iClass, n);
            this.lhs.compileSet();
            return iClass;
        }

        public IClass getType() throws CompileException {
            return this.lhs.getType();
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.operator + ' ' + this.rhs.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitAssignment(this);
        }
    }

    public static final class ConditionalExpression
    extends Rvalue {
        final Rvalue lhs;
        final Rvalue mhs;
        final Rvalue rhs;

        public ConditionalExpression(Location location, Rvalue rvalue, Rvalue rvalue2, Rvalue rvalue3) {
            super(location);
            this.lhs = rvalue;
            this.mhs = rvalue2;
            this.rhs = rvalue3;
        }

        /*
         * Enabled aggressive block sorting
         */
        public IClass compileGet() throws CompileException {
            Object object;
            IClass iClass;
            CodeContext.Inserter inserter;
            IClass iClass2;
            CodeContext.Offset offset = this.newUnsetOffset();
            Object object2 = this.lhs.getConstantValue();
            if (object2 instanceof Boolean) {
                if (((Boolean)object2).booleanValue()) {
                    iClass2 = this.mhs.compileGetValue();
                    inserter = this.newInserter();
                    iClass = this.rhs.getType();
                } else {
                    iClass2 = this.mhs.getType();
                    inserter = null;
                    iClass = this.rhs.compileGetValue();
                }
            } else {
                object = this.newUnsetOffset();
                this.lhs.compileBoolean((CodeContext.Offset)object, false);
                iClass2 = this.mhs.compileGetValue();
                inserter = this.newInserter();
                this.writeBranch(-89, offset);
                ((CodeContext.Offset)object).set();
                iClass = this.rhs.compileGetValue();
            }
            if (iClass2 == iClass) {
                object = iClass2;
            } else if (iClass2.isPrimitiveNumeric() && iClass.isPrimitiveNumeric()) {
                object = Java.binaryNumericPromotion(this, iClass2, inserter, iClass);
            } else if (this.mhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL && !iClass.isPrimitive()) {
                object = iClass;
            } else if (!iClass2.isPrimitive() && this.rhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL) {
                object = iClass2;
            } else if (!iClass2.isPrimitive() && !iClass.isPrimitive()) {
                if (iClass2.isAssignableFrom(iClass)) {
                    object = iClass2;
                } else {
                    if (!iClass.isAssignableFrom(iClass2)) {
                        this.compileError("Reference types \"" + iClass2 + "\" and \"" + iClass + "\" don't match");
                        return Java.getIClassLoader().OBJECT;
                    }
                    object = iClass;
                }
            } else {
                this.compileError("Incompatible expression types \"" + iClass2 + "\" and \"" + iClass + "\"");
                return Java.getIClassLoader().OBJECT;
            }
            offset.set();
            return object;
        }

        public IClass getType() throws CompileException {
            return this.mhs.getType();
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " ? " + this.mhs.toString() + " : " + this.rhs.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitConditionalExpression(this);
        }
    }

    public static final class Crement
    extends Rvalue {
        final boolean pre;
        final String operator;
        final Lvalue operand;

        public Crement(Location location, String string, Lvalue lvalue) {
            super(location);
            this.pre = true;
            this.operator = string;
            this.operand = lvalue;
        }

        public Crement(Location location, Lvalue lvalue, String string) {
            super(location);
            this.pre = false;
            this.operator = string;
            this.operand = lvalue;
        }

        public void compile() throws CompileException {
            LocalVariable localVariable = this.isIntLV();
            if (localVariable != null) {
                this.writeOpcode(-124);
                this.writeByte(localVariable.localVariableArrayIndex);
                this.writeByte(this.operator == "++" ? 1 : -1);
                return;
            }
            int n = this.operand.compileContext();
            Java.dup(this, n);
            IClass iClass = this.operand.compileGet();
            IClass iClass2 = Java.unaryNumericPromotion(this, iClass);
            this.writeOpcode(Java.ilfd(iClass2, 4, 10, 12, 15));
            if (this.operator == "++") {
                this.writeOpcode(96 + Java.ilfd(iClass2));
            } else if (this.operator == "--") {
                this.writeOpcode(100 + Java.ilfd(iClass2));
            } else {
                this.compileError("Unexpected operator \"" + this.operator + "\"");
            }
            if (!Java.tryIdentityConversion(iClass2, iClass) && !Java.tryNarrowingPrimitiveConversion(this, iClass2, iClass)) {
                throw new RuntimeException();
            }
            this.operand.compileSet();
        }

        public IClass compileGet() throws CompileException {
            LocalVariable localVariable = this.isIntLV();
            if (localVariable != null) {
                if (!this.pre) {
                    Java.load(this, localVariable);
                }
                this.writeOpcode(-124);
                this.writeByte(localVariable.localVariableArrayIndex);
                this.writeByte(this.operator == "++" ? 1 : -1);
                if (this.pre) {
                    Java.load(this, localVariable);
                }
                return localVariable.type;
            }
            int n = this.operand.compileContext();
            Java.dup(this, n);
            IClass iClass = this.operand.compileGet();
            if (!this.pre) {
                Java.dupx(this, iClass, n);
            }
            IClass iClass2 = Java.unaryNumericPromotion(this, iClass);
            this.writeOpcode(Java.ilfd(iClass2, 4, 10, 12, 15));
            if (this.operator == "++") {
                this.writeOpcode(96 + Java.ilfd(iClass2));
            } else if (this.operator == "--") {
                this.writeOpcode(100 + Java.ilfd(iClass2));
            } else {
                this.compileError("Unexpected operator \"" + this.operator + "\"");
            }
            if (!Java.tryIdentityConversion(iClass2, iClass) && !Java.tryNarrowingPrimitiveConversion(this, iClass2, iClass)) {
                throw new RuntimeException();
            }
            if (this.pre) {
                Java.dupx(this, iClass, n);
            }
            this.operand.compileSet();
            return iClass;
        }

        public IClass getType() throws CompileException {
            return this.operand.getType();
        }

        private LocalVariable isIntLV() throws CompileException {
            if (!(this.operand instanceof AmbiguousName)) {
                return null;
            }
            AmbiguousName ambiguousName = (AmbiguousName)this.operand;
            Atom atom = ambiguousName.reclassify();
            if (!(atom instanceof LocalVariableAccess)) {
                return null;
            }
            LocalVariableAccess localVariableAccess = (LocalVariableAccess)atom;
            LocalVariable localVariable = localVariableAccess.localVariable;
            if (localVariable.finaL) {
                localVariableAccess.compileError("Must not increment or decrement \"final\" local variable");
            }
            if (localVariable.type == IClass.BYTE || localVariable.type == IClass.SHORT || localVariable.type == IClass.INT || localVariable.type == IClass.CHAR) {
                return localVariable;
            }
            return null;
        }

        public String toString() {
            return this.pre ? String.valueOf(this.operator) + this.operand : String.valueOf(String.valueOf(this.operand)) + this.operator;
        }

        public final void visit(Visitor visitor) {
            visitor.visitCrement(this);
        }
    }

    public static final class ArrayAccessExpression
    extends Lvalue {
        final Rvalue lhs;
        final Rvalue index;

        public ArrayAccessExpression(Location location, Rvalue rvalue, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.index = rvalue2;
        }

        public int compileContext() throws CompileException {
            IClass iClass;
            IClass iClass2 = this.lhs.compileGetValue();
            if (!iClass2.isArray()) {
                this.compileError("Subscript not allowed on non-array type \"" + iClass2.toString() + "\"");
            }
            if (!Java.tryIdentityConversion(iClass = this.index.compileGetValue(), IClass.INT) && !Java.tryWideningPrimitiveConversion(this, iClass, IClass.INT)) {
                this.compileError("Index expression of type \"" + iClass + "\" cannot be widened to \"int\"");
            }
            return 2;
        }

        public IClass compileGet() throws CompileException {
            IClass iClass = this.getType();
            this.writeOpcode(46 + Java.ilfdabcs(iClass));
            return iClass;
        }

        public void compileSet() throws CompileException {
            this.writeOpcode(79 + Java.ilfdabcs(this.getType()));
        }

        public IClass getType() throws CompileException {
            return this.lhs.getType().getComponentType();
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '[' + this.index + ']';
        }

        public final void visit(Visitor visitor) {
            visitor.visitArrayAccessExpression(this);
        }
    }

    public static final class FieldAccessExpression
    extends Lvalue {
        final Atom lhs;
        final String fieldName;
        private Rvalue value = null;

        public FieldAccessExpression(Location location, Atom atom, String string) {
            super(location);
            this.lhs = atom;
            this.fieldName = string;
        }

        public int compileContext() throws CompileException {
            this.determineValue();
            return this.value.compileContext();
        }

        public IClass compileGet() throws CompileException {
            this.determineValue();
            return this.value.compileGet();
        }

        public void compileSet() throws CompileException {
            this.determineValue();
            this.value.toLvalueOrCE().compileSet();
        }

        private void determineValue() throws CompileException {
            if (this.value != null) {
                return;
            }
            IClass iClass = this.lhs.getType();
            if (this.fieldName.equals("length") && iClass.isArray()) {
                this.value = new ArrayLength(this.getLocation(), this.lhs.toRvalueOrCE());
            } else {
                IClass.IField iField = Java.findIField(iClass, this.fieldName, this.getLocation());
                if (iField == null) {
                    this.compileError("\"" + this.lhs.getType().toString() + "\" has no field \"" + this.fieldName + "\"");
                    this.value = new Rvalue(this.getLocation()){

                        public IClass compileGet() throws CompileException {
                            return Java.getIClassLoader().OBJECT;
                        }

                        public IClass getType() throws CompileException {
                            return Java.getIClassLoader().OBJECT;
                        }

                        public String toString() {
                            return "???";
                        }

                        public final void visit(Visitor visitor) {
                        }
                    };
                    return;
                }
                this.value = new FieldAccess(this.getLocation(), this.lhs, iField);
            }
        }

        public IClass getType() throws CompileException {
            this.determineValue();
            return this.value.getType();
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + '.' + this.fieldName;
        }

        public final void visit(Visitor visitor) {
            visitor.visitFieldAccessExpression(this);
        }
    }

    public static final class UnaryOperation
    extends BooleanRvalue {
        final String operator;
        final Rvalue operand;

        public UnaryOperation(Location location, String string, Rvalue rvalue) {
            super(location);
            this.operator = string;
            this.operand = rvalue;
        }

        public void compileBoolean(CodeContext.Offset offset, boolean bl) throws CompileException {
            if (this.operator == "!") {
                this.operand.compileBoolean(offset, bl ^ true);
                return;
            }
            this.compileError("Boolean expression expected");
        }

        public IClass compileGet() throws CompileException {
            if (this.operator == "!") {
                return super.compileGet();
            }
            if (this.operator == "+") {
                return this.operand.compileGetValue();
            }
            if (this.operator == "-") {
                IClass iClass = this.operand.compileGetValue();
                IClass iClass2 = Java.unaryNumericPromotion(this, iClass);
                this.writeOpcode(116 + Java.ilfd(iClass2));
                return iClass2;
            }
            if (this.operator == "~") {
                IClass iClass = this.operand.compileGetValue();
                IClass iClass3 = Java.unaryNumericPromotion(this, iClass);
                if (iClass3 == IClass.INT) {
                    this.writeOpcode(2);
                    this.writeOpcode(-126);
                    return IClass.INT;
                }
                if (iClass3 == IClass.LONG) {
                    this.writeOpcode(20);
                    this.writeConstantLongInfo(-1L);
                    this.writeOpcode(-125);
                    return IClass.LONG;
                }
                this.compileError("Operator \"~\" not applicable to type \"" + iClass3 + "\"");
            }
            this.compileError("Unexpected operator \"" + this.operator + "\"");
            return Java.getIClassLoader().OBJECT;
        }

        public Object getConstantValue2() throws CompileException {
            if (this.operator.equals("+")) {
                return this.operand.getConstantValue();
            }
            if (this.operator.equals("-")) {
                return this.operand.getNegatedConstantValue();
            }
            if (this.operator.equals("!")) {
                Object object = this.operand.getConstantValue();
                return object instanceof Boolean ? (((Boolean)object).booleanValue() ? Boolean.FALSE : Boolean.TRUE) : null;
            }
            return null;
        }

        public Object getNegatedConstantValue() throws CompileException {
            return this.operator.equals("+") ? this.operand.getNegatedConstantValue() : (this.operator.equals("-") ? this.operand.getConstantValue() : null);
        }

        public IClass getType() throws CompileException {
            if (this.operator == "!") {
                return IClass.BOOLEAN;
            }
            if (this.operator == "+") {
                return this.operand.getType();
            }
            if (this.operator == "-" || this.operator == "~") {
                return Java.unaryNumericPromotionType(this, this.operand.getType());
            }
            this.compileError("Unexpected operator \"" + this.operator + "\"");
            return IClass.BOOLEAN;
        }

        public String toString() {
            return String.valueOf(this.operator) + this.operand.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitUnaryOperation(this);
        }
    }

    public static final class Instanceof
    extends Rvalue {
        final Rvalue lhs;
        final Type rhs;

        public Instanceof(Location location, Rvalue rvalue, Type type) {
            super(location);
            this.lhs = rvalue;
            this.rhs = type;
        }

        public IClass compileGet() throws CompileException {
            IClass iClass = this.lhs.compileGetValue();
            IClass iClass2 = this.rhs.getType();
            if (iClass2.isAssignableFrom(iClass)) {
                Java.pop(this, iClass);
                this.writeOpcode(4);
            } else if (iClass.isInterface() || iClass2.isInterface() || iClass.isAssignableFrom(iClass2)) {
                this.writeOpcode(-63);
                this.writeConstantClassInfo(iClass2.getDescriptor());
            } else {
                this.compileError("\"" + iClass + "\" can never be an instance of \"" + iClass2 + "\"");
            }
            return IClass.BOOLEAN;
        }

        public IClass getType() throws CompileException {
            return IClass.BOOLEAN;
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + " instanceof " + this.rhs.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitInstanceof(this);
        }
    }

    public static final class BinaryOperation
    extends BooleanRvalue {
        final Rvalue lhs;
        final String op;
        final Rvalue rhs;

        public BinaryOperation(Location location, Rvalue rvalue, String string, Rvalue rvalue2) {
            super(location);
            this.lhs = rvalue;
            this.op = string;
            this.rhs = rvalue2;
        }

        public void compileBoolean(CodeContext.Offset offset, boolean bl) throws CompileException {
            Object object = this.getConstantValue();
            if (object instanceof Boolean) {
                if (!bl ^ (Boolean)object) {
                    this.writeBranch(-89, offset);
                }
                return;
            }
            if (this.op == "|" || this.op == "^" || this.op == "&") {
                super.compileBoolean(offset, bl);
                return;
            }
            if (this.op == "||" || this.op == "&&") {
                if (this.op == "||" ^ !bl) {
                    this.lhs.compileBoolean(offset, !bl ^ true);
                    this.rhs.compileBoolean(offset, !bl ^ true);
                } else {
                    CodeContext.Offset offset2 = this.newUnsetOffset();
                    this.lhs.compileBoolean(offset2, !bl);
                    this.rhs.compileBoolean(offset, !bl ^ true);
                    offset2.set();
                }
                return;
            }
            if (this.op == "==" || this.op == "!=" || this.op == "<=" || this.op == ">=" || this.op == "<" || this.op == ">") {
                boolean bl2;
                int n;
                int n2 = this.op == "==" ? 0 : (this.op == "!=" ? 1 : (this.op == "<" ? 2 : (this.op == ">=" ? 3 : (this.op == ">" ? 4 : (n = this.op == "<=" ? 5 : Integer.MIN_VALUE)))));
                if (!bl) {
                    n ^= 1;
                }
                boolean bl3 = this.lhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL;
                boolean bl4 = bl2 = this.rhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL;
                if (bl3 || bl2) {
                    IClass iClass;
                    if (this.op != "==" && this.op != "!=") {
                        this.compileError("Operator \"" + this.op + "\" not allowed on operand \"null\"");
                    }
                    if ((iClass = (bl3 ? this.rhs : this.lhs).compileGetValue()).isPrimitive()) {
                        this.compileError("Cannot compare \"null\" with primitive type \"" + iClass.toString() + "\"");
                    }
                    this.writeBranch(-58 + n, offset);
                    return;
                }
                IClass iClass = this.lhs.compileGetValue();
                CodeContext.Inserter inserter = this.newInserter();
                IClass iClass2 = this.rhs.compileGetValue();
                if (iClass.isPrimitiveNumeric() && iClass2.isPrimitiveNumeric()) {
                    IClass iClass3 = Java.binaryNumericPromotion(this, iClass, inserter, iClass2);
                    if (iClass3 == IClass.INT) {
                        this.writeBranch(-97 + n, offset);
                    } else if (iClass3 == IClass.LONG) {
                        this.writeOpcode(-108);
                        this.writeBranch(-103 + n, offset);
                    } else if (iClass3 == IClass.FLOAT) {
                        this.writeOpcode(-106);
                        this.writeBranch(-103 + n, offset);
                    } else if (iClass3 == IClass.DOUBLE) {
                        this.writeOpcode(-104);
                        this.writeBranch(-103 + n, offset);
                    } else {
                        throw new RuntimeException("Unexpected promoted type \"" + iClass3 + "\"");
                    }
                    return;
                }
                if (iClass == IClass.BOOLEAN && iClass2 == IClass.BOOLEAN) {
                    if (this.op != "==" && this.op != "!=") {
                        this.compileError("Operator \"" + this.op + "\" not allowed on boolean operands");
                    }
                    this.writeBranch(-97 + n, offset);
                    return;
                }
                if (!iClass.isPrimitive() && !iClass2.isPrimitive()) {
                    if (this.op != "==" && this.op != "!=") {
                        this.compileError("Operator \"" + this.op + "\" not allowed on reference operands");
                    }
                    this.writeBranch(-91 + n, offset);
                    return;
                }
                this.compileError("Cannot compare types \"" + iClass + "\" and \"" + iClass2 + "\"");
            }
            this.compileError("Boolean expression expected");
        }

        public IClass compileGet() throws CompileException {
            if (this.op == "||" || this.op == "&&" || this.op == "==" || this.op == "!=" || this.op == "<" || this.op == ">" || this.op == "<=" || this.op == ">=") {
                return super.compileGet();
            }
            return Java.compileArithmeticOperation(this, null, this.unrollLeftAssociation(), this.op);
        }

        public Object getConstantValue2() throws CompileException {
            if ((this.op == "==" || this.op == "!=") && this.lhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL && this.rhs.getConstantValue() == Rvalue.CONSTANT_VALUE_NULL) {
                return new Boolean(this.op == "==");
            }
            if (this.op == "|" || this.op == "^" || this.op == "&" || this.op == "*" || this.op == "/" || this.op == "%" || this.op == "+" || this.op == "-") {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Iterator iterator = this.unrollLeftAssociation();
                while (iterator.hasNext()) {
                    object = ((Rvalue)iterator.next()).getConstantValue();
                    if (object == null) {
                        return null;
                    }
                    arrayList.add(object);
                }
                object = arrayList.iterator();
                Object object2 = object.next();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (this.op == "+" && (object2 instanceof String || e instanceof String)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(object2.toString()).append(e.toString());
                        while (object.hasNext()) {
                            stringBuffer.append(object.next().toString());
                        }
                        return stringBuffer.toString();
                    }
                    if (!(object2 instanceof Number) || !(e instanceof Number)) {
                        return null;
                    }
                    if (object2 instanceof Double || e instanceof Double) {
                        double d = ((Number)object2).doubleValue();
                        double d2 = ((Number)e).doubleValue();
                        object2 = new Double(this.op == "|" ? -1.0 : (this.op == "^" ? -1.0 : (this.op == "&" ? -1.0 : (this.op == "*" ? d * d2 : (this.op == "/" ? d / d2 : (this.op == "%" ? d % d2 : (this.op == "+" ? d + d2 : (this.op == "-" ? d - d2 : -1.0))))))));
                        continue;
                    }
                    if (object2 instanceof Float || e instanceof Float) {
                        float f = ((Number)object2).floatValue();
                        float f2 = ((Number)e).floatValue();
                        object2 = new Float(this.op == "|" ? -1.0f : (this.op == "^" ? -1.0f : (this.op == "&" ? -1.0f : (this.op == "*" ? f * f2 : (this.op == "/" ? f / f2 : (this.op == "%" ? f % f2 : (this.op == "+" ? f + f2 : (this.op == "-" ? f - f2 : -1.0f))))))));
                        continue;
                    }
                    if (object2 instanceof Long || e instanceof Long) {
                        long l = ((Number)object2).longValue();
                        long l2 = ((Number)e).longValue();
                        object2 = new Long(this.op == "|" ? l | l2 : (this.op == "^" ? l ^ l2 : (this.op == "&" ? l & l2 : (this.op == "*" ? l * l2 : (this.op == "/" ? l / l2 : (this.op == "%" ? l % l2 : (this.op == "+" ? l + l2 : (this.op == "-" ? l - l2 : -1L))))))));
                        continue;
                    }
                    int n = ((Number)object2).intValue();
                    int n2 = ((Number)e).intValue();
                    object2 = new Integer(this.op == "|" ? n | n2 : (this.op == "^" ? n ^ n2 : (this.op == "&" ? n & n2 : (this.op == "*" ? n * n2 : (this.op == "/" ? n / n2 : (this.op == "%" ? n % n2 : (this.op == "+" ? n + n2 : (this.op == "-" ? n - n2 : -1))))))));
                }
                return object2;
            }
            if (this.op == "&&" || this.op == "||") {
                Object object = this.lhs.getConstantValue();
                Object object3 = this.rhs.getConstantValue();
                if (object instanceof Boolean) {
                    boolean bl = (Boolean)object;
                    return this.op == "&&" ? (bl ? object3 : Boolean.FALSE) : (bl ? Boolean.TRUE : object3);
                }
                if (object3 instanceof Boolean) {
                    boolean bl = (Boolean)object3;
                    return this.op == "&&" ? (bl ? object : Boolean.FALSE) : (bl ? Boolean.TRUE : object);
                }
            }
            return null;
        }

        public IClass getType() throws CompileException {
            if (this.op == "||" || this.op == "&&" || this.op == "==" || this.op == "!=" || this.op == "<" || this.op == ">" || this.op == "<=" || this.op == ">=") {
                return IClass.BOOLEAN;
            }
            if (this.op == "|" || this.op == "^" || this.op == "&") {
                return this.lhs.getType() == IClass.BOOLEAN ? IClass.BOOLEAN : Java.binaryNumericPromotionType(this, this.lhs.getType(), this.rhs.getType());
            }
            if (this.op == "*" || this.op == "/" || this.op == "%" || this.op == "+" || this.op == "-") {
                IClassLoader iClassLoader = Java.getIClassLoader();
                Iterator iterator = this.unrollLeftAssociation();
                IClass iClass = ((Rvalue)iterator.next()).getType();
                if (this.op == "+" && iClass == iClassLoader.STRING) {
                    return iClassLoader.STRING;
                }
                do {
                    IClass iClass2 = ((Rvalue)iterator.next()).getType();
                    if (this.op == "+" && iClass2 == iClassLoader.STRING) {
                        return iClassLoader.STRING;
                    }
                    iClass = Java.binaryNumericPromotionType(this, iClass, iClass2);
                } while (iterator.hasNext());
                return iClass;
            }
            if (this.op == "<<" || this.op == ">>" || this.op == ">>>") {
                IClass iClass = this.lhs.getType();
                return Java.unaryNumericPromotionType(this, iClass);
            }
            this.compileError("Unexpected operator \"" + this.op + "\"");
            return Java.getIClassLoader().OBJECT;
        }

        public String toString() {
            return String.valueOf(this.lhs.toString()) + ' ' + this.op + ' ' + this.rhs.toString();
        }

        public Iterator unrollLeftAssociation() {
            Rvalue rvalue;
            ArrayList<Rvalue> arrayList = new ArrayList<Rvalue>();
            BinaryOperation binaryOperation = this;
            while (true) {
                arrayList.add(binaryOperation.rhs);
                rvalue = binaryOperation.lhs;
                if (!(rvalue instanceof BinaryOperation) || ((BinaryOperation)rvalue).op != this.op) break;
                binaryOperation = (BinaryOperation)rvalue;
            }
            arrayList.add(rvalue);
            return new ReverseListIterator(arrayList.listIterator(arrayList.size()));
        }

        public final void visit(Visitor visitor) {
            visitor.visitBinaryOperation(this);
        }
    }

    public static final class Cast
    extends Rvalue {
        final Type targetType;
        final Rvalue value;

        public Cast(Location location, Type type, Rvalue rvalue) {
            super(location);
            this.targetType = type;
            this.value = rvalue;
        }

        public IClass compileGet() throws CompileException {
            IClass iClass = this.targetType.getType();
            IClass iClass2 = this.value.compileGetValue();
            if (!(Java.tryIdentityConversion(iClass2, iClass) || Java.tryWideningPrimitiveConversion(this, iClass2, iClass) || Java.tryNarrowingPrimitiveConversion(this, iClass2, iClass) || Java.isWideningReferenceConvertible(iClass2, iClass) || Java.tryNarrowingReferenceConversion(this, iClass2, iClass))) {
                this.compileError("Cannot cast \"" + iClass2 + "\" to \"" + iClass + "\"");
            }
            return iClass;
        }

        public Object getConstantValue2() throws CompileException {
            Object object = this.value.getConstantValue();
            if (object == null) {
                return null;
            }
            if (object instanceof Number) {
                IClass iClass = this.targetType.getType();
                if (iClass == IClass.BYTE) {
                    return new Byte(((Number)object).byteValue());
                }
                if (iClass == IClass.SHORT) {
                    return new Short(((Number)object).shortValue());
                }
                if (iClass == IClass.INT) {
                    return new Integer(((Number)object).intValue());
                }
                if (iClass == IClass.LONG) {
                    return new Long(((Number)object).longValue());
                }
                if (iClass == IClass.FLOAT) {
                    return new Float(((Number)object).floatValue());
                }
                if (iClass == IClass.DOUBLE) {
                    return new Double(((Number)object).doubleValue());
                }
            }
            return null;
        }

        public IClass getType() throws CompileException {
            return this.targetType.getType();
        }

        public String toString() {
            return String.valueOf('(') + this.targetType.toString() + ") " + this.value.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitCast(this);
        }
    }

    public static final class ParenthesizedExpression
    extends Lvalue {
        final Rvalue value;

        public ParenthesizedExpression(Location location, Rvalue rvalue) {
            super(location);
            this.value = rvalue;
        }

        public void compile() throws CompileException {
            this.value.compile();
        }

        public void compileBoolean(CodeContext.Offset offset, boolean bl) throws CompileException {
            this.value.compileBoolean(offset, bl);
        }

        public int compileContext() throws CompileException {
            return this.value.compileContext();
        }

        public IClass compileGet() throws CompileException {
            return this.value.compileGet();
        }

        public IClass compileGetValue() throws CompileException {
            return this.value.compileGetValue();
        }

        public void compileSet() throws CompileException {
            this.value.toLvalueOrCE().compileSet();
        }

        public Object getConstantValue2() throws CompileException {
            return this.value.getConstantValue();
        }

        public Object getNegatedConstantValue() throws CompileException {
            return this.value.getNegatedConstantValue();
        }

        public IClass getType() throws CompileException {
            return this.value.getType();
        }

        public String toString() {
            return String.valueOf('(') + this.value.toString() + ')';
        }

        public void visit(Visitor visitor) {
            visitor.visitParenthesizedExpression(this);
        }
    }

    public static abstract class ConstructorInvocation
    extends Atom {
        protected final ClassDeclaration declaringClass;
        protected final ConstructorDeclarator declaringConstructor;
        protected final Rvalue[] arguments;

        protected ConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue[] rvalueArray) {
            super(location);
            this.declaringClass = classDeclaration;
            this.declaringConstructor = constructorDeclarator;
            this.arguments = rvalueArray;
        }

        public abstract void compile() throws CompileException;

        public IClass getType() {
            throw new RuntimeException();
        }
    }

    public static final class AlternateConstructorInvocation
    extends ConstructorInvocation {
        public AlternateConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue[] rvalueArray) {
            super(location, classDeclaration, constructorDeclarator, rvalueArray);
        }

        public void compile() throws CompileException {
            this.writeOpcode(42);
            Java.invokeConstructor(this, this.declaringConstructor, null, this.declaringClass, this.arguments);
        }

        public String toString() {
            return "this()";
        }

        public void visit(Visitor visitor) {
            visitor.visitAlternateConstructorInvocation(this);
        }
    }

    public static final class SuperConstructorInvocation
    extends ConstructorInvocation {
        final Rvalue optionalQualification;

        public SuperConstructorInvocation(Location location, ClassDeclaration classDeclaration, ConstructorDeclarator constructorDeclarator, Rvalue rvalue, Rvalue[] rvalueArray) {
            super(location, classDeclaration, constructorDeclarator, rvalueArray);
            this.optionalQualification = rvalue;
        }

        public void compile() throws CompileException {
            IClass iClass;
            this.writeOpcode(42);
            IClass iClass2 = this.declaringClass.getSuperclass();
            Object object = this.optionalQualification != null ? this.optionalQualification : ((iClass = iClass2.getOuterIClass()) == null ? null : new QualifiedThisReference(this.getLocation(), this.declaringClass, this.declaringConstructor, iClass));
            Java.invokeConstructor(this, this.declaringConstructor, (Rvalue)object, iClass2, this.arguments);
        }

        public String toString() {
            return "super()";
        }

        public void visit(Visitor visitor) {
            visitor.visitSuperConstructorInvocation(this);
        }
    }

    public static final class MethodInvocation
    extends Invocation {
        final Atom optionalTarget;
        final String methodName;

        public MethodInvocation(Location location, Scope scope, Atom atom, String string, Rvalue[] rvalueArray) {
            super(location, scope, rvalueArray);
            this.optionalTarget = atom;
            this.methodName = string;
        }

        public IClass compileGet() throws CompileException {
            Locatable locatable;
            IClass.IMethod iMethod = this.findIMethod();
            if (this.optionalTarget == null) {
                Scope scope = this.scope;
                while (!(scope instanceof TypeBodyDeclaration)) {
                    scope = scope.getEnclosingScope();
                }
                locatable = (TypeBodyDeclaration)scope;
                if (!iMethod.isStatic()) {
                    if (locatable.isStatic()) {
                        this.compileError("Instance method \"" + this.methodName + "\" cannot be invoked in static context");
                    }
                    Java.referenceThis(this);
                }
            } else {
                boolean bl = this.optionalTarget.isType();
                if (!bl) {
                    locatable = this.optionalTarget.toRvalueOrCE();
                    if (((Atom)locatable).getType() != iMethod.getDeclaringIClass() && iMethod.getAccess() == 0) {
                        this.compileError("Invocation of private methods of enclosing or enclosed type NYI; please change the access of method \"" + iMethod.getName() + "()\" from \"private\" to \"/*private*/\"");
                    }
                    ((Rvalue)locatable).compileGetValue();
                }
                if (iMethod.isStatic()) {
                    if (!bl) {
                        Java.pop(this.optionalTarget, this.optionalTarget.getType());
                    }
                } else if (bl) {
                    this.compileError("Instance method \"" + this.methodName + "\" cannot be invoked in static context");
                }
            }
            IClass[] iClassArray = iMethod.getParameterTypes();
            int n = 0;
            while (n < this.arguments.length) {
                Java.assignmentConversion(this, this.arguments[n].compileGetValue(), iClassArray[n], this.arguments[n].getConstantValue());
                ++n;
            }
            if (iMethod.getDeclaringIClass().isInterface()) {
                this.writeOpcode(-71);
                this.writeConstantInterfaceMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
                IClass[] iClassArray2 = iMethod.getParameterTypes();
                int n2 = 1;
                int n3 = 0;
                while (n3 < iClassArray2.length) {
                    n2 += Descriptor.size(iClassArray2[n3].getDescriptor());
                    ++n3;
                }
                this.writeByte(n2);
                this.writeByte(0);
            } else {
                this.writeOpcode(iMethod.isStatic() ? -72 : (iMethod.getAccess() == 0 ? -73 : -74));
                this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), iMethod.getName(), iMethod.getDescriptor());
            }
            return iMethod.getReturnType();
        }

        private IClass.IMethod findIMethod() throws CompileException {
            Scope scope = this.scope;
            while (!(scope instanceof CompilationUnit)) {
                if (scope instanceof TypeDeclaration) {
                    TypeDeclaration typeDeclaration = (TypeDeclaration)scope;
                    IClass.IMethod iMethod = Java.findIMethod(this, this.optionalTarget == null ? (IClass)((Object)typeDeclaration) : this.optionalTarget.getType(), this.methodName, this.arguments);
                    IClass[] iClassArray = iMethod.getThrownExceptions();
                    int n = 0;
                    while (n < iClassArray.length) {
                        Java.checkThrownException(this, iClassArray[n], this.scope);
                        ++n;
                    }
                    return iMethod;
                }
                scope = scope.getEnclosingScope();
            }
            return null;
        }

        public IClass getType() throws CompileException {
            return this.findIMethod().getReturnType();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalTarget != null) {
                stringBuffer.append(this.optionalTarget.toString()).append('.');
            }
            stringBuffer.append(this.methodName).append('(');
            int n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.arguments[n].toString());
                ++n;
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitMethodInvocation(this);
        }
    }

    public static final class SuperclassMethodInvocation
    extends Invocation {
        final String methodName;

        public SuperclassMethodInvocation(Location location, Scope scope, String string, Rvalue[] rvalueArray) {
            super(location, scope, rvalueArray);
            this.methodName = string;
        }

        public IClass compileGet() throws CompileException {
            FunctionDeclarator functionDeclarator;
            IClass.IMethod iMethod = this.findIMethod();
            Scope scope = this.scope;
            while (scope instanceof Statement) {
                scope = scope.getEnclosingScope();
            }
            FunctionDeclarator functionDeclarator2 = functionDeclarator = scope instanceof FunctionDeclarator ? (FunctionDeclarator)scope : null;
            if (functionDeclarator == null) {
                this.compileError("Cannot invoke superclass method in non-method scope");
                return IClass.INT;
            }
            if ((functionDeclarator.modifiers & 8) != 0) {
                this.compileError("Cannot invoke superclass method in static context");
            }
            Java.load(this, (IClass)((Object)functionDeclarator.getDeclaringType()), 0);
            IClass[] iClassArray = iMethod.getParameterTypes();
            int n = 0;
            while (n < this.arguments.length) {
                Java.assignmentConversion(this, this.arguments[n].compileGetValue(), iClassArray[n], this.arguments[n].getConstantValue());
                ++n;
            }
            this.writeOpcode(-73);
            this.writeConstantMethodrefInfo(iMethod.getDeclaringIClass().getDescriptor(), this.methodName, iMethod.getDescriptor());
            return iMethod.getReturnType();
        }

        private IClass.IMethod findIMethod() throws CompileException {
            Scope scope = this.scope;
            while (true) {
                if (scope instanceof FunctionDeclarator) {
                    FunctionDeclarator functionDeclarator = (FunctionDeclarator)scope;
                    if ((functionDeclarator.modifiers & 8) != 0) {
                        this.compileError("Superclass method cannot be invoked in static context");
                    }
                }
                if (scope instanceof ClassDeclaration) break;
                scope = scope.getEnclosingScope();
            }
            ClassDeclaration classDeclaration = (ClassDeclaration)scope;
            return Java.findIMethod(this, classDeclaration.getSuperclass(), this.methodName, this.arguments);
        }

        public IClass getType() throws CompileException {
            return this.findIMethod().getReturnType();
        }

        public String toString() {
            return "super." + this.methodName + "()";
        }

        public final void visit(Visitor visitor) {
            visitor.visitSuperclassMethodInvocation(this);
        }
    }

    public static abstract class Invocation
    extends Rvalue {
        protected final Scope scope;
        protected final Rvalue[] arguments;

        protected Invocation(Location location, Scope scope, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.arguments = rvalueArray;
        }
    }

    public static final class NewClassInstance
    extends Rvalue {
        private final Scope scope;
        protected final Rvalue optionalQualification;
        protected final Type type;
        protected final Rvalue[] arguments;
        protected IClass iClass = null;

        public NewClassInstance(Location location, Scope scope, Rvalue rvalue, IClass iClass, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.type = null;
            this.arguments = rvalueArray;
            this.iClass = iClass;
        }

        public NewClassInstance(Location location, Scope scope, Rvalue rvalue, Type type, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.type = type;
            this.arguments = rvalueArray;
        }

        public IClass compileGet() throws CompileException {
            Rvalue rvalue;
            if (this.iClass == null) {
                this.iClass = this.type.getType();
            }
            this.writeOpcode(-69);
            this.writeConstantClassInfo(this.iClass.getDescriptor());
            this.writeOpcode(89);
            if (this.optionalQualification != null) {
                rvalue = this.optionalQualification;
            } else {
                Scope scope = this.scope;
                FunctionDeclarator functionDeclarator = null;
                while (!(scope instanceof TypeDeclaration)) {
                    if (scope instanceof FunctionDeclarator) {
                        functionDeclarator = (FunctionDeclarator)scope;
                        if ((functionDeclarator.modifiers & 8) != 0) break;
                    }
                    scope = scope.getEnclosingScope();
                }
                if (!(scope instanceof ClassDeclaration)) {
                    rvalue = null;
                } else {
                    IClass iClass = this.iClass.getDeclaringIClass();
                    if (iClass == null) {
                        rvalue = new ThisReference(this.getLocation(), this.scope);
                    } else {
                        ClassDeclaration classDeclaration = (ClassDeclaration)scope;
                        rvalue = new QualifiedThisReference(this.getLocation(), classDeclaration, functionDeclarator, iClass);
                    }
                }
            }
            Java.invokeConstructor(this, this.scope, rvalue, this.iClass, this.arguments);
            return this.iClass;
        }

        public IClass getType() throws CompileException {
            if (this.iClass == null) {
                this.iClass = this.type.getType();
            }
            return this.iClass;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ");
            if (this.type != null) {
                stringBuffer.append(this.type.toString());
            } else if (this.iClass != null) {
                stringBuffer.append(this.iClass.toString());
            } else {
                stringBuffer.append("???");
            }
            stringBuffer.append("()");
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitNewClassInstance(this);
        }
    }

    public static final class NewAnonymousClassInstance
    extends Rvalue {
        private final Scope scope;
        final Rvalue optionalQualification;
        final AnonymousClassDeclaration anonymousClassDeclaration;
        final Rvalue[] arguments;

        public NewAnonymousClassInstance(Location location, Scope scope, Rvalue rvalue, AnonymousClassDeclaration anonymousClassDeclaration, Rvalue[] rvalueArray) {
            super(location);
            this.scope = scope;
            this.optionalQualification = rvalue;
            this.anonymousClassDeclaration = anonymousClassDeclaration;
            this.arguments = rvalueArray;
        }

        public IClass compileGet() throws CompileException {
            Rvalue[] rvalueArray;
            AnonymousClassDeclaration anonymousClassDeclaration = this.anonymousClassDeclaration;
            IClass iClass = anonymousClassDeclaration.getSuperclass();
            IClass.IInvocable[] iInvocableArray = iClass.getDeclaredIConstructors();
            if (iInvocableArray.length == 0) {
                throw new RuntimeException();
            }
            IClass.IConstructor iConstructor = (IClass.IConstructor)Java.findMostSpecificIInvocable(this, iInvocableArray, this.arguments);
            IClass[] iClassArray = iConstructor.getParameterTypes();
            Location location = this.getLocation();
            ArrayList<FormalParameter> arrayList = new ArrayList<FormalParameter>();
            if (this.optionalQualification != null) {
                arrayList.add(new FormalParameter(true, new SimpleType(location, this.optionalQualification.getType()), "this$base"));
            }
            int n = 0;
            while (n < iClassArray.length) {
                arrayList.add(new FormalParameter(true, new SimpleType(location, iClassArray[n]), "p" + n));
                ++n;
            }
            FormalParameter[] formalParameterArray = arrayList.toArray(new FormalParameter[arrayList.size()]);
            IClass[] iClassArray2 = iConstructor.getThrownExceptions();
            Type[] typeArray = new Type[iClassArray2.length];
            int n2 = 0;
            while (n2 < iClassArray2.length) {
                typeArray[n2] = new SimpleType(location, iClassArray2[n2]);
                ++n2;
            }
            ConstructorDeclarator constructorDeclarator = new ConstructorDeclarator(location, anonymousClassDeclaration, 0, formalParameterArray, typeArray);
            ParameterAccess parameterAccess = this.optionalQualification == null ? null : new ParameterAccess(location, constructorDeclarator, "this$base");
            Rvalue[] rvalueArray2 = new Rvalue[iClassArray.length];
            int n3 = 0;
            while (n3 < iClassArray.length) {
                rvalueArray2[n3] = new ParameterAccess(location, constructorDeclarator, "p" + n3);
                ++n3;
            }
            constructorDeclarator.setExplicitConstructorInvocation(new SuperConstructorInvocation(location, anonymousClassDeclaration, constructorDeclarator, parameterAccess, rvalueArray2));
            constructorDeclarator.setBody(new Block(location, constructorDeclarator));
            anonymousClassDeclaration.addConstructor(constructorDeclarator);
            anonymousClassDeclaration.compile();
            this.writeOpcode(-69);
            this.writeConstantClassInfo(this.anonymousClassDeclaration.getDescriptor());
            this.writeOpcode(89);
            if (this.optionalQualification == null) {
                rvalueArray = this.arguments;
            } else {
                rvalueArray = new Rvalue[this.arguments.length + 1];
                rvalueArray[0] = this.optionalQualification;
                System.arraycopy(this.arguments, 0, rvalueArray, 1, this.arguments.length);
            }
            Java.invokeConstructor(this, this.scope, new ThisReference(location, this.scope), this.anonymousClassDeclaration, rvalueArray);
            return this.anonymousClassDeclaration;
        }

        public IClass getType() throws CompileException {
            return this.anonymousClassDeclaration;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.optionalQualification != null) {
                stringBuffer.append(this.optionalQualification.toString()).append('.');
            }
            stringBuffer.append("new ").append(this.anonymousClassDeclaration.toString()).append("() { ... }");
            return stringBuffer.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitNewAnonymousClassInstance(this);
        }
    }

    static final class ParameterAccess
    extends Rvalue {
        private final FunctionDeclarator declaringFunction;
        private final String name;

        public ParameterAccess(Location location, FunctionDeclarator functionDeclarator, String string) {
            super(location);
            this.declaringFunction = functionDeclarator;
            this.name = string;
        }

        public IClass compileGet() throws CompileException {
            LocalVariable localVariable = (LocalVariable)this.declaringFunction.parameters.get(this.name);
            Java.load(this, localVariable);
            return localVariable.type;
        }

        public IClass getType() throws CompileException {
            return ((LocalVariable)this.declaringFunction.parameters.get(this.name)).type;
        }

        public String toString() {
            return this.name;
        }

        public final void visit(Visitor visitor) {
            visitor.visitParameterAccess(this);
        }
    }

    public static final class NewArray
    extends Rvalue {
        final Type type;
        final Rvalue[] dimExprs;
        final int dims;

        public NewArray(Location location, Type type, Rvalue[] rvalueArray, int n) {
            super(location);
            this.type = type;
            this.dimExprs = rvalueArray;
            this.dims = n;
        }

        public IClass compileGet() throws CompileException {
            int n = 0;
            while (n < this.dimExprs.length) {
                IClass iClass = this.dimExprs[n].compileGetValue();
                if (iClass != IClass.INT && Java.unaryNumericPromotion(this, iClass) != IClass.INT) {
                    this.compileError("Invalid array size expression type");
                }
                ++n;
            }
            return Java.newArray(this, this.dimExprs.length, this.dims, this.type.getType());
        }

        public IClass getType() throws CompileException {
            IClass iClass = this.type.getType();
            return Java.getArrayType(iClass, this.dimExprs.length + this.dims);
        }

        public String toString() {
            return "new " + this.type.toString() + "[]...";
        }

        public final void visit(Visitor visitor) {
            visitor.visitNewArray(this);
        }
    }

    public static final class ArrayInitializer
    extends Rvalue {
        final ArrayType arrayType;
        final Rvalue[] values;

        public ArrayInitializer(Location location, ArrayType arrayType, Rvalue[] rvalueArray) {
            super(location);
            this.arrayType = arrayType;
            this.values = rvalueArray;
        }

        public IClass compileGet() throws CompileException {
            IClass iClass = this.arrayType.getType();
            IClass iClass2 = iClass.getComponentType();
            Java.pushConstant(this, new Integer(this.values.length));
            Java.newArray(this, 1, 0, iClass2);
            int n = 0;
            while (n < this.values.length) {
                Rvalue rvalue = this.values[n];
                this.writeOpcode(89);
                Java.pushConstant(this, new Integer(n));
                IClass iClass3 = rvalue.compileGetValue();
                Java.assignmentConversion(this, iClass3, iClass2, rvalue.getConstantValue());
                this.writeOpcode(79 + Java.ilfdabcs(iClass2));
                ++n;
            }
            return iClass;
        }

        public IClass getType() throws CompileException {
            return this.arrayType.getType();
        }

        public String toString() {
            return "{ ... }";
        }

        public final void visit(Visitor visitor) {
            visitor.visitArrayInitializer(this);
        }
    }

    public static final class Literal
    extends Rvalue {
        private final Object value;

        public Literal(Location location, Object object) {
            super(location);
            this.value = object;
        }

        public IClass compileGet() throws CompileException {
            if (this.value == Scanner.MAGIC_INTEGER || this.value == Scanner.MAGIC_LONG) {
                Java.compileError("This literal value may only appear in a negated context", this.getLocation());
            }
            return Java.pushConstant(this, this.value);
        }

        public Object getConstantValue2() throws CompileException {
            if (this.value == Scanner.MAGIC_INTEGER || this.value == Scanner.MAGIC_LONG) {
                Java.compileError("This literal value may only appear in a negated context", this.getLocation());
            }
            return this.value == null ? Rvalue.CONSTANT_VALUE_NULL : this.value;
        }

        public Object getNegatedConstantValue() throws CompileException {
            if (this.value instanceof Integer) {
                return new Integer(-((Integer)this.value).intValue());
            }
            if (this.value instanceof Long) {
                return new Long(-((Long)this.value).longValue());
            }
            if (this.value instanceof Float) {
                return new Float(-((Float)this.value).floatValue());
            }
            if (this.value instanceof Double) {
                return new Double(-((Double)this.value).doubleValue());
            }
            Java.compileError("Cannot negate this literal", this.getLocation());
            return null;
        }

        public IClass getType() throws CompileException {
            if (this.value instanceof Integer) {
                return IClass.INT;
            }
            if (this.value instanceof Long) {
                return IClass.LONG;
            }
            if (this.value instanceof Float) {
                return IClass.FLOAT;
            }
            if (this.value instanceof Double) {
                return IClass.DOUBLE;
            }
            if (this.value instanceof String) {
                return Java.getIClassLoader().STRING;
            }
            if (this.value instanceof Character) {
                return IClass.CHAR;
            }
            if (this.value instanceof Boolean) {
                return IClass.BOOLEAN;
            }
            if (this.value == null) {
                return IClass.VOID;
            }
            throw new RuntimeException();
        }

        public String toString() {
            return Scanner.literalValueToString(this.value);
        }

        public final void visit(Visitor visitor) {
            visitor.visitLiteral(this);
        }
    }

    public static final class ConstantValue
    extends Rvalue {
        private final Object constantValue;

        public ConstantValue(Location location, Object object) {
            super(location);
            this.constantValue = object == null ? Rvalue.CONSTANT_VALUE_NULL : object;
        }

        public IClass compileGet() {
            return Java.pushConstant(this, this.constantValue);
        }

        public Object getConstantValue2() throws CompileException {
            return this.constantValue;
        }

        public IClass getType() {
            IClass iClass;
            IClass iClass2 = this.constantValue instanceof Integer ? IClass.INT : (this.constantValue instanceof Long ? IClass.LONG : (this.constantValue instanceof Float ? IClass.FLOAT : (this.constantValue instanceof Double ? IClass.DOUBLE : (this.constantValue instanceof String ? Java.getIClassLoader().STRING : (this.constantValue instanceof Character ? IClass.CHAR : (this.constantValue instanceof Boolean ? IClass.BOOLEAN : (iClass = this.constantValue == Rvalue.CONSTANT_VALUE_NULL ? IClass.VOID : null)))))));
            if (iClass == null) {
                throw new RuntimeException();
            }
            return iClass;
        }

        public String toString() {
            return this.constantValue.toString();
        }

        public final void visit(Visitor visitor) {
            visitor.visitConstantValue(this);
        }
    }

    private static class LocalVariable {
        private final boolean finaL;
        private final IClass type;
        private final short localVariableArrayIndex;

        public LocalVariable(boolean bl, IClass iClass, short s) {
            this.finaL = bl;
            this.type = iClass;
            this.localVariableArrayIndex = s;
        }
    }

    public static class CompileException
    extends Scanner.LocatedException {
        public CompileException(String string, Location location) {
            super(string, location);
        }
    }

    public static interface ErrorHandler {
        public void handleError(String var1, Location var2) throws CompileException;
    }

    public static interface WarningHandler {
        public void handleWarning(String var1, String var2, Location var3);
    }
}

