/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.LaunchSelection;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.Main;
import com.sun.javaws.ui.DownloadWindow;
import com.sun.jnlp.JNLPClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.jnlp.ExtensionInstallerService;

public final class ExtensionInstallerServiceImpl
implements ExtensionInstallerService {
    private LocalApplicationProperties _lap;
    private DownloadWindow _window;
    private String _target;
    private String _installPath;
    private boolean _failedJREInstall = false;
    static ExtensionInstallerServiceImpl _sharedInstance = null;

    private ExtensionInstallerServiceImpl(String string, LocalApplicationProperties localApplicationProperties, DownloadWindow downloadWindow) {
        this._lap = localApplicationProperties;
        this._window = downloadWindow;
        this._installPath = string;
    }

    public static synchronized ExtensionInstallerServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static synchronized void initialize(String string, LocalApplicationProperties localApplicationProperties, DownloadWindow downloadWindow) {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtensionInstallerServiceImpl(string, localApplicationProperties, downloadWindow);
        }
    }

    public String getInstallPath() {
        return this._installPath;
    }

    public String getExtensionVersion() {
        return this._lap.getVersionId();
    }

    public URL getExtensionLocation() {
        return this._lap.getLocation();
    }

    public String getInstalledJRE(URL uRL, String string) {
        JREInfo jREInfo = LaunchSelection.selectJRE(uRL, string);
        return jREInfo != null ? jREInfo.getPath() : null;
    }

    public void setHeading(String string) {
        this._window.setStatus(string);
    }

    public void setStatus(String string) {
        this._window.setProgressText(string);
    }

    public void updateProgress(int n) {
        this._window.setProgressBarValue(n);
    }

    public void hideProgressBar() {
        this._window.setProgressBarVisible(false);
    }

    public void hideStatusWindow() {
        this._window.getFrame().setVisible(false);
    }

    public void setJREInfo(String string, String string2) {
        int n = JNLPClassLoader.getInstance().getDefaultSecurityModel();
        if (n != 1 && n != 2) {
            throw new SecurityException("Unsigned extension installer attempting to call setJREInfo.");
        }
        Trace.println((String)("setJREInfo: " + string2), (TraceLevel)TraceLevel.EXTENSIONS);
        if (string2 != null && new File(string2).exists()) {
            JREInfo.addJRE((JREInfo)new JREInfo(string, this.getExtensionVersion(), this.getExtensionLocation().toString(), string2, Config.getOSName(), Config.getOSArch(), true, false));
        } else {
            Trace.println((String)"jre install failed: jrePath invalid", (TraceLevel)TraceLevel.EXTENSIONS);
            this._failedJREInstall = true;
        }
    }

    public void setNativeLibraryInfo(String string) {
        Trace.println((String)("setNativeLibInfo: " + string), (TraceLevel)TraceLevel.EXTENSIONS);
        this._lap.setNativeLibDirectory(string);
    }

    public void installFailed() {
        Trace.println((String)"installFailed", (TraceLevel)TraceLevel.EXTENSIONS);
        Main.systemExit(1);
    }

    public void installSucceeded(boolean bl) {
        if (this._failedJREInstall) {
            return;
        }
        Trace.println((String)"installSucceded", (TraceLevel)TraceLevel.EXTENSIONS);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Config.store();
                return null;
            }
        });
        this._lap.setInstallDirectory(this._installPath);
        this._lap.setLastAccessed(new Date());
        if (bl) {
            this._lap.setRebootNeeded(true);
        } else {
            this._lap.setLocallyInstalled(true);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ExtensionInstallerServiceImpl.this._lap.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                LaunchErrorDialog.show(this._window.getFrame(), (IOException)privilegedActionException.getException(), false);
            }
            Trace.ignoredException((Exception)privilegedActionException.getException());
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Main.systemExit(0);
                return null;
            }
        });
    }
}

