/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_h;
import com.sun.crypto.provider.SunJCE_s;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Cipher
extends CipherSpi {
    private final SunJCE_h a;
    private final SunJCE_s b;

    public RC2Cipher() {
        SunJCE.a(this.getClass());
        this.b = new SunJCE_s();
        this.a = new SunJCE_h(this.b, 8);
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        this.a.a(string);
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        this.a.b(string);
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int n) {
        return this.a.a(n);
    }

    protected byte[] engineGetIV() {
        return this.a.a();
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.a.c("RC2");
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.b.a(0);
        this.a.a(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null && algorithmParameterSpec instanceof RC2ParameterSpec) {
            this.b.a(((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits());
        } else {
            this.b.a(0);
        }
        this.a.a(n, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters != null && algorithmParameters.getAlgorithm().equals("RC2")) {
            try {
                RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameters.getParameterSpec(RC2ParameterSpec.class);
                this.engineInit(n, key, rC2ParameterSpec, secureRandom);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: RC2 expected");
            }
        } else {
            this.b.a(0);
            this.a.a(n, key, algorithmParameters, secureRandom);
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.a.a(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.a.a(byArray, n, n2, byArray2, n3);
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.a.b(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.a.b(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] byArray = SunJCE_h.a(key);
        SunJCE_s.a(key.getAlgorithm(), byArray.length);
        return byArray.length << 3;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.a.b(key);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.a.a(byArray, string, n);
    }
}

