/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SunJCE;
import com.sun.crypto.provider.SunJCE_aa;
import com.sun.crypto.provider.SunJCE_ab;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class HmacPKCS12PBESHA1
extends MacSpi
implements Cloneable {
    private SunJCE_aa a = null;
    private static final int b = 64;

    public HmacPKCS12PBESHA1() throws NoSuchAlgorithmException {
        SunJCE.a(this.getClass());
        this.a = new SunJCE_aa(MessageDigest.getInstance("SHA1"), 64);
    }

    protected int engineGetMacLength() {
        return this.a.a();
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        char[] cArray;
        Object object;
        byte[] byArray = null;
        int n = 0;
        if (key instanceof PBEKey) {
            object = (PBEKey)key;
            cArray = object.getPassword();
            byArray = object.getSalt();
            n = object.getIterationCount();
        } else if (key instanceof SecretKey) {
            object = key.getEncoded();
            if (object == null || !key.getAlgorithm().regionMatches(true, 0, "PBE", 0, 3)) {
                throw new InvalidKeyException("Missing password");
            }
            cArray = new char[((Object)object).length];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(object[i] & 0x7F);
            }
        } else {
            throw new InvalidKeyException("SecretKey of PBE type required");
        }
        if (algorithmParameterSpec == null) {
            if (byArray == null) {
                byArray = new byte[20];
                SunJCE.g.nextBytes(byArray);
            }
            if (n == 0) {
                n = 100;
            }
        } else {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("PBEParameterSpec type required");
            }
            object = (PBEParameterSpec)algorithmParameterSpec;
            if (byArray != null) {
                if (!Arrays.equals(byArray, ((PBEParameterSpec)object).getSalt())) {
                    throw new InvalidAlgorithmParameterException("Inconsistent value of salt between key and params");
                }
            } else {
                byArray = ((PBEParameterSpec)object).getSalt();
            }
            if (n != 0) {
                if (n != ((PBEParameterSpec)object).getIterationCount()) {
                    throw new InvalidAlgorithmParameterException("Different iteration count between key and params");
                }
            } else {
                n = ((PBEParameterSpec)object).getIterationCount();
            }
        }
        if (byArray.length < 8) {
            throw new InvalidAlgorithmParameterException("Salt must be at least 8 bytes long");
        }
        if (n <= 0) {
            throw new InvalidAlgorithmParameterException("IterationCount must be a positive number");
        }
        object = SunJCE_ab.a(cArray, byArray, n, this.a.a(), 3);
        SecretKeySpec secretKeySpec = new SecretKeySpec((byte[])object, "HmacSHA1");
        this.a.a(secretKeySpec, null);
    }

    protected void engineUpdate(byte by) {
        this.a.a(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.a.a(byArray, n, n2);
    }

    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.a.a(byteBuffer);
    }

    protected byte[] engineDoFinal() {
        return this.a.b();
    }

    protected void engineReset() {
        this.a.c();
    }

    public Object clone() {
        HmacPKCS12PBESHA1 hmacPKCS12PBESHA1 = null;
        try {
            hmacPKCS12PBESHA1 = (HmacPKCS12PBESHA1)super.clone();
            hmacPKCS12PBESHA1.a = (SunJCE_aa)this.a.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return hmacPKCS12PBESHA1;
    }
}

