/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.skin;

import com.birosoft.liquid.skin.SkinElement;
import java.awt.Dimension;
import java.awt.Graphics;

public class Skin
extends SkinElement {
    private int nrImages;
    private int hsize;
    private int vsize;
    private int ulX;
    private int ulY;
    private int lrX;
    private int lrY;
    private boolean noBorder = false;

    public Skin(String fileName, int nrImages, int ulX, int ulY, int lrX, int lrY) {
        super(fileName, true);
        this.nrImages = nrImages;
        this.ulX = ulX;
        this.ulY = ulY;
        this.lrX = lrX;
        this.lrY = lrY;
        this.calculateSizes();
    }

    public Skin(String fileName, int nrImages, int roundedSize) {
        this(fileName, nrImages, roundedSize, roundedSize, roundedSize, roundedSize);
        if (roundedSize == 0) {
            this.noBorder = true;
        }
    }

    public void draw(Graphics g, int index, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        if (!this.noBorder) {
            g.drawImage(this.getImage(), 0, 0, this.ulX, this.ulY, offset + 0, 0, offset + this.ulX, this.ulY, null);
            g.drawImage(this.getImage(), this.ulX, 0, sizeX - this.lrX, this.ulY, offset + this.ulX, 0, offset + this.hsize - this.lrX, this.ulY, null);
            g.drawImage(this.getImage(), sizeX - this.lrX, 0, sizeX, this.ulY, offset + this.hsize - this.lrX, 0, offset + this.hsize, this.ulY, null);
            g.drawImage(this.getImage(), 0, this.ulY, this.ulX, sizeY - this.lrY, offset + 0, this.ulY, offset + this.ulX, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), sizeX - this.lrX, this.ulY, sizeX, sizeY - this.lrY, offset + this.hsize - this.lrX, this.ulY, offset + this.hsize, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), 0, sizeY - this.lrY, this.ulX, sizeY, offset + 0, this.vsize - this.lrY, offset + this.ulX, this.vsize, null);
            g.drawImage(this.getImage(), this.ulX, sizeY - this.lrY, sizeX - this.lrX, sizeY, offset + this.ulX, this.vsize - this.lrY, offset + this.hsize - this.lrX, this.vsize, null);
            g.drawImage(this.getImage(), sizeX - this.lrX, sizeY - this.lrY, sizeX, sizeY, offset + this.hsize - this.lrX, this.vsize - this.lrY, offset + this.hsize, this.vsize, null);
            g.drawImage(this.getImage(), this.ulX, this.ulY, sizeX - this.lrX, sizeY - this.lrY, offset + this.ulX, this.ulY, offset + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            g.drawImage(this.getImage(), 0, 0, sizeX, sizeY, offset, 0, offset + this.hsize, this.vsize, null);
        }
    }

    public void draw(Graphics g, int index, int x, int y, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        if (!this.noBorder) {
            g.drawImage(this.getImage(), x + 0, y + 0, x + this.ulX, y + this.ulY, offset + 0, 0, offset + this.ulX, this.ulY, null);
            g.drawImage(this.getImage(), x + this.ulX, y + 0, x + sizeX - this.lrX, y + this.ulY, offset + this.ulX, 0, offset + this.hsize - this.lrX, this.ulY, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + 0, x + sizeX, y + this.ulY, offset + this.hsize - this.lrX, 0, offset + this.hsize, this.ulY, null);
            g.drawImage(this.getImage(), x + 0, y + this.ulY, x + this.ulX, y + sizeY - this.lrY, offset + 0, this.ulY, offset + this.ulX, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + this.ulY, x + sizeX, y + sizeY - this.lrY, offset + this.hsize - this.lrX, this.ulY, offset + this.hsize, this.vsize - this.lrY, null);
            g.drawImage(this.getImage(), x + 0, y + sizeY - this.lrY, x + this.ulX, y + sizeY, offset + 0, this.vsize - this.lrY, offset + this.ulX, this.vsize, null);
            g.drawImage(this.getImage(), x + this.ulX, y + sizeY - this.lrY, x + sizeX - this.lrX, y + sizeY, offset + this.ulX, this.vsize - this.lrY, offset + this.hsize - this.lrX, this.vsize, null);
            g.drawImage(this.getImage(), x + sizeX - this.lrX, y + sizeY - this.lrY, x + sizeX, y + sizeY, offset + this.hsize - this.lrX, this.vsize - this.lrY, offset + this.hsize, this.vsize, null);
            g.drawImage(this.getImage(), x + this.ulX, y + this.ulY, x + sizeX - this.lrX, y + sizeY - this.lrY, offset + this.ulX, this.ulY, offset + this.hsize - this.lrX, this.vsize - this.lrY, null);
        } else {
            g.drawImage(this.getImage(), x, y, x + sizeX, y + sizeY, offset, 0, offset + this.hsize, this.vsize, null);
        }
    }

    public void drawCentered(Graphics g, int index, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        int w = this.getHsize();
        int h = this.getVsize();
        int sx = (sizeX - w) / 2;
        int sy = (sizeY - h) / 2;
        g.drawImage(this.getImage(), sx, sy, sx + w, sy + h, offset, 0, offset + w, h, null);
    }

    public void drawCentered(Graphics g, int index, int x, int y, int sizeX, int sizeY) {
        int offset = index * this.getHsize();
        int w = this.getHsize();
        int h = this.getVsize();
        int sx = (sizeX - w) / 2;
        int sy = (sizeY - h) / 2;
        g.drawImage(this.getImage(), x + sx, y + sy, x + sx + w, y + sy + h, offset, 0, offset + w, h, null);
    }

    public int getHsize() {
        return this.hsize;
    }

    public int getVsize() {
        return this.vsize;
    }

    public Dimension getSize() {
        return new Dimension(this.hsize, this.vsize);
    }

    protected void calculateSizes() {
        this.hsize = this.getImage().getWidth(null) / this.nrImages;
        this.vsize = this.getImage().getHeight(null);
    }
}

