/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.mail.MessagingException;
import javax.mail.internet.hdr;
import javax.mail.internet.matchEnum;

public class InternetHeaders {
    private Vector headers = new Vector();

    public InternetHeaders() {
        this.headers.addElement(new hdr("Return-Path", null));
        this.headers.addElement(new hdr("Received", null));
        this.headers.addElement(new hdr("Message-Id", null));
        this.headers.addElement(new hdr("Resent-Date", null));
        this.headers.addElement(new hdr("Date", null));
        this.headers.addElement(new hdr("Resent-From", null));
        this.headers.addElement(new hdr("From", null));
        this.headers.addElement(new hdr("Reply-To", null));
        this.headers.addElement(new hdr("Sender", null));
        this.headers.addElement(new hdr("To", null));
        this.headers.addElement(new hdr("Subject", null));
        this.headers.addElement(new hdr("Cc", null));
        this.headers.addElement(new hdr("In-Reply-To", null));
        this.headers.addElement(new hdr("Resent-Message-Id", null));
        this.headers.addElement(new hdr("Errors-To", null));
        this.headers.addElement(new hdr("Mime-Version", null));
        this.headers.addElement(new hdr("Content-Type", null));
        this.headers.addElement(new hdr("Content-Transfer-Encoding", null));
        this.headers.addElement(new hdr("Content-MD5", null));
        this.headers.addElement(new hdr(":", null));
        this.headers.addElement(new hdr("Content-Length", null));
        this.headers.addElement(new hdr("Status", null));
    }

    public InternetHeaders(InputStream inputStream) throws MessagingException {
        this.load(inputStream);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void load(InputStream inputStream) throws MessagingException {
        LineInputStream lineInputStream = new LineInputStream(inputStream);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            do {
                if ((string2 = lineInputStream.readLine()) != null && (string2.startsWith(" ") || string2.startsWith("\t"))) {
                    if (string != null) {
                        stringBuffer.append(string);
                        string = null;
                    }
                    stringBuffer.append("\r\n");
                    stringBuffer.append(string2);
                } else {
                    if (string != null) {
                        this.addHeaderLine(string);
                    } else if (stringBuffer.length() > 0) {
                        this.addHeaderLine(stringBuffer.toString());
                        stringBuffer.setLength(0);
                    }
                    string = string2;
                }
                if (string2 == null) return;
            } while (string2.length() > 0);
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("Error in input stream", iOException);
        }
    }

    public String[] getHeader(String string) {
        Object[] objectArray;
        Enumeration enumeration = this.headers.elements();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (!string.equalsIgnoreCase(objectArray.name) || objectArray.line == null) continue;
            vector.addElement(objectArray.getValue());
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String getHeader(String string, String string2) {
        String[] stringArray = this.getHeader(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 1 || string2 == null) {
            return stringArray[0];
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(string2);
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setHeader(String string, String string2) {
        boolean bl = false;
        int n = 0;
        while (n < this.headers.size()) {
            hdr hdr2 = (hdr)this.headers.elementAt(n);
            if (string.equalsIgnoreCase(hdr2.name)) {
                if (!bl) {
                    int n2;
                    hdr2.line = hdr2.line != null && (n2 = hdr2.line.indexOf(58)) >= 0 ? String.valueOf(hdr2.line.substring(0, n2 + 1)) + " " + string2 : String.valueOf(string) + ": " + string2;
                    bl = true;
                } else {
                    this.headers.removeElementAt(n);
                    --n;
                }
            }
            ++n;
        }
        if (!bl) {
            this.addHeader(string, string2);
        }
    }

    public void addHeader(String string, String string2) {
        int n = this.headers.size();
        boolean bl = string.equalsIgnoreCase("Received");
        if (bl) {
            n = 0;
        }
        int n2 = this.headers.size() - 1;
        while (n2 >= 0) {
            hdr hdr2 = (hdr)this.headers.elementAt(n2);
            if (string.equalsIgnoreCase(hdr2.name)) {
                if (bl) {
                    n = n2;
                } else {
                    this.headers.insertElementAt(new hdr(string, string2), n2 + 1);
                    return;
                }
            }
            if (hdr2.name.equals(":")) {
                n = n2;
            }
            --n2;
        }
        this.headers.insertElementAt(new hdr(string, string2), n);
    }

    public void removeHeader(String string) {
        int n = 0;
        while (n < this.headers.size()) {
            hdr hdr2 = (hdr)this.headers.elementAt(n);
            if (string.equalsIgnoreCase(hdr2.name)) {
                hdr2.line = null;
            }
            ++n;
        }
    }

    public Enumeration getAllHeaders() {
        return new matchEnum(this.headers, null, false, false);
    }

    public Enumeration getMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, false);
    }

    public Enumeration getNonMatchingHeaders(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, false);
    }

    public void addHeaderLine(String string) {
        try {
            char c = string.charAt(0);
            if (c == ' ' || c == '\t') {
                hdr hdr2 = (hdr)this.headers.lastElement();
                hdr2.line = String.valueOf(hdr2.line) + "\r\n" + string;
                return;
            }
            this.headers.addElement(new hdr(string));
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public Enumeration getAllHeaderLines() {
        return this.getNonMatchingHeaderLines(null);
    }

    public Enumeration getMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, true, true);
    }

    public Enumeration getNonMatchingHeaderLines(String[] stringArray) {
        return new matchEnum(this.headers, stringArray, false, true);
    }
}

