: Profile, The 1D Scientific Spreadsheet 
: by Gertjan L. Ouwerling, Electrical Materials Lab, Delft University
: -------------------------------------------------------------------
: Example 1: Generation of an impurity profile by expression evaluation
:
: Execute this example by typing:  prof example1.pro <enter>
: 
: NOTE: some steps may be slow without a co-processor!
:
: This profile program generates a doping profile as generated
: by making one or two implants in uniformly doped background
: material. (In this case, two implants is chosen).
: The plotted result is shown following this text.
:
: -------------------------------------------------------------------

pause

: Declare Profile data columns (types) and variableso

type x dope absdope logdope efield psi chandope vg $
var int ngrid $
var real nrp1 rp1 drp1 nrp2 rp2 drp2 dsub dgate dback
         wtot wsub wgate wsmooth
         ptype ntype imp1type imp2type gatetype subtype backtype
         gatepres imp1pres imp2pres subpres
         mu emax vmax eps
         $

: p-type dope is negative of sign, n-type positive
: a scaling factor mu gives the length in cm
: eps is set to the epsilon of Silicon

ptype = -1
ntype = 1
mu = 1E-04
eps = eps0*epssi

pause

: p-gate area if x < 0
: p-substrate area if x > wsub
: n-channel area in between
: use pos() and neg() function to distinguish

define isgate = neg(x)
define issub  = pos(x-wsub)
define ischan = pos(pos(x)+neg(x-wsub)-1.5)

pause

: formulas describing dopant concentration due to
: two implantations (fimp1 and fimp2), background
: channel doping (fback), gate doping (fgate) and
: substrate doping (fsub). A function fsmooth is
: used to smooth the transition between channel and
: substrate.

define fimp1 = imp1type*imp1pres*nrp1*exp(min(sqr(x-rp1)/(2*sqr(drp1))))
define fimp2 = imp2type*imp2pres*nrp2*exp(min(sqr(x-rp2)/(2*sqr(drp2))))
define fgate = gatetype*dgate
define fsub  = subtype *dsub
define fback = backtype*dback
define fsmooth = 1 - exp(min(sqr((x-wsub)/wsmooth)))

pause 

:
: ********** definition of variable values **********
:
: The values below decribe the exact properties of the
: doping profile that will be generated
:

ngrid = 100

imp1type=ntype
imp2type=ntype
backtype=ntype
gatetype=ptype
subtype =ptype

: Set parameters of the double implant by executing assignments
: that are collected in a separate file (subroutine like)

pause

exec example2.par

pause

: Definition of the xgrid:
: ngrid lines of data space are allocated and the
: x coordinate is filled according to the variable values.
: The default data type count [0..ndata-1] is used as a
: source for grid generation

alloc ngrid
x = (count/ndata)*wtot
x = x - (gatepres*wgate)

: the dope is computed using the predefined formulas

: THIS MAY TAKE A WHILE!

dope = fsmooth*((fgate*isgate)+(ischan*(fback+fimp1+fimp2))+(issub*fsub))

: for plotting purposes, the absolute value and the log of the dope
: are computed

absdope = abs(dope)
logdope = log(absdope+1e12)

pause

: the channel region is selected by setting gate and substrate
: dope to zero in the data type chandope. Double integration gives
: the electric field strength and the gate voltage for a fully
: depleted channel (according to Poisson's equation).

chandope = dope*pos(dope*backtype)
inte chandope x efield
efield = efield*(q/eps)
emax=efield
efield=efield-emax
efield = efield*pos(dope*backtype)
inte efield x psi
vmax=psi

: Print vmax by evaluating the simple expression "vmax"

vmax

pause

: A first impression of the result is gotten by viewing on the terminal
: in the channel (x>0.0) and the substrate (x=10 mu).
: 
: Give  <enter>  to leave the Profile picture!

xls = 0.01*mu
xrs = 10*mu
view x absdope | psi $

: Give  quit <enter>  to leave Profile!
: ===================================== 
