/**********************************************************/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/*
CAUTION: Compile using LARGE memory model!!!!!
*/
/*/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\*/
/**********************************************************/

#include <stdio.h>

#include "sb16io.h"

/**********************************************************/
/* basic block length (samples per block):
too sort ==> too much interrupts per second.
too long ==> too much record-to-playback delay.  */
/*#define N 400*/
#define N 4096  /* Shareware version only supports this */

/* sampling rate */
/*#define SRATE 8000*/
#define SRATE 7500  /* shareware version only supports this */

/**********************************************************/
/* callback function. whenever a new block (length N) is full,
this callback is called (at interrupt-time, so be carefull with
what you do!). */

void mifunc( void )
{
	UINT i;
	INT8 * v8;
	INT16 * v16;

	v8 = sb16io_get8(SB16IO_NOWAIT);  /* get SB 8 bits buffer */
	v16 = sb16io_get16(SB16IO_NOWAIT);  /* get SB 16 bits buffer */
	/* we have used NOWAIT mode, because we are at interrupt time!!
	moreover, this callback has been called because there is a new
	recorded buffer. */

	/* just copy from record (8 bits) to play (16 bits) buffer.
	We copy to the 8 msb of the 16 bit word. */
	for (i=0; i<N; i++)
		v16[i] = (((INT16)v8[i]) << 8);
}

/**********************************************************/

int main( void )
{
	int err;

	printf("Sample program to record & play concurrently using SB16.\n"
		"In this program, recording is done using 8 bit signed samples, the\n"
		"recorded buffer is promoted to 16 bit signed samples, and then it is\n"
		"played.  So you must hear just what you record (with a delay).\n"
		"Press ENTER to continue...");
	fgetc(stdin);

	/* prepare sb16 */
	err = sb16io_open(SB16IO_RECORD8,  /* 8 bit record & 16 bit playback */
			SRATE,    /* sampling rate (must be the same for 8 & 16 bits) */
			SB16IO_MONO8,  /* mono 8 bit (recording) */
			SB16IO_MONO16,  /* mono 16 bit (playback) */
			N,             /* basic block length */
			mifunc);      /* user callback to process basic blocks */

	if (err) {  /* sb16io_open() returns 0 if no error */
		printf("error initializing\n");
		return 1;
	}

	/* Set record-to-playback delay as sort as posible: 1 buffer.
	This is close to the limit!
	delay 0 produces clicks. If we use delay 1, we must generate a
	playback buffer in a sort time after recording one, and maybe
	we hear some clicks. delay 2 is safe: no clicks, but long delay.
	If sb16io_setdelay() is not called, the default 2 is used. */
	sb16io_setdelay(1);

	sb16io_start();  /* start record&play */

	/* now do whatever you want, sb is working in background */
	printf("press ENTER to stop...");
	fgetc(stdin);

	/* stop & free sb16 */
	sb16io_close();

	return 0;
}

/**********************************************************/

