; TESTDIV.ASM
;
; This file contains an external assembler subroutine to hook and unhook
; Int 15h, as well as the replacement handler itself.  For use with
; Testdiv.pas:
;
; {$L TESTDIV}
; procedure set_i15(
;   var sounddone:           (* true if sound I/O is complete *)
;     boolean;
;   hook:                    (* flag:  0 = hook Int 15h; 1 = unhook Int 15h *)
;     integer ); external;
;

CODE		SEGMENT	BYTE PUBLIC
		ASSUME	CS:CODE,DS:CODE
		PUBLIC	SET_I15
SET_I15		PROC	NEAR
		JMP	START
		;
		; Stack frame.
		;
STACKFRAME	STRUC	[BP]
OLDBP		DW	?
RETADDR		DW	?
HOOK		DW	?
FLAGPTR		DD	?
		ENDS
		;
		; Local data.
		;
SOUNDDONE	DD	0	; pointer to Sounddone flag in main program
INT15OLD	DD	0	; default vector for Int 15h
		;
		; Temporary Int 15h handler.
		;
INT15NEW:	CMP	AX,91FBh
		JE	>L0
		JMP	DWORD PTR CS:INT15OLD
L0:		PUSH	BX
		PUSH	DS
		LDS	BX,CS:SOUNDDONE
		MOV	BYTE PTR [BX],1
		POP	DS
		POP	BX
		IRET
		;
		; Body of the procedure.  DS addresses code segment.
		;
START:		PUSH	BP
		MOV	BP,SP
		PUSH	DS
		MOV	AX,CS
		MOV	DS,AX
		;
		; Check hook/unhook flag.
		;
		CMP	HOOK,1
		JE	UNHOOK
		;
		; We are hooking the interrupt.  Save the default Int 15h
		; vector.
		;
		MOV	AX,3515h
		INT	21h
		MOV	WORD PTR INT15OLD,BX
		MOV	WORD PTR INT15OLD+2,ES
		;
		; Save the address of the Sounddone flag.
		;
		LES	BX,FLAGPTR
		MOV	WORD PTR SOUNDDONE,BX
		MOV	WORD PTR SOUNDDONE+2,ES
		;
		; Use the new Int 15h handler now.
		;
		MOV	DX,OFFSET INT15NEW
		MOV	AX,2515h
		INT	21h
		JMP	EXIT
		;
		; We are unhooking the interrupt.  Restore the default Int
		; 15h vector.
		;
UNHOOK:		MOV	DX,WORD PTR INT15OLD
		MOV	DS,WORD PTR INT15OLD+2
		MOV	AX,2515h
		INT	21h
		;
		; Restore DS and BP and exit.
		;
EXIT:		POP	DS
		POP	BP
		RET	6	; discard parameters
SET_I15		ENDP
CODE		ENDS
		END
