#ifndef ANSI_CHK_H
#define ANSI_CHK_H

/*-----------------------------------DEFINE-----------------------------------*/
#define KKR_CONSOLE "CON"                 /* Screen in DOS, how about Unix? */
#define KKR_KEYBD "CON"                 /* Keyboard in DOS, how about Unix? */
#define KKR_SCREEN 3     /* 1=stdout (don't use),  2=stderr,  3=KKR_CONSOLE */
#define KKR_KEYBOARD 3   /* 1=stdin using getch(), 2=stdin     using fgets(),
                                                   3=KKR_KEYBD using fgets() */
/* Preferred definitions: KKR_SCREEN 3, KKR_KEYBOARD 3.
 * ANSI.COM vs. 1.3 does not work with KKR_KEYBOARD=3,
 * it does not see the redefinitions of ANSI.SYS via CON,
 * so in that case KKR_KEYBOARD should be set to 2 or even better 1.
 * (Key redefinitions by other programs are seen well via CON by ANSI.COM 1.3.)
 */
#define TESTSTR "#\r"  /* test string for test char and unique end signal */
#define TESTSTRLEN 5      /* adapt to length of TESTSTR, excl. '\0' */
#define RTNSTRLEN 12 /* fixed space for line(s) to read, longer lines are read
                      * partially in pieces; minimum: TESTSTRLEN+1 to read at
                      * least 1 byte at a time during the search for an unde-
                      * fined key.
                      */

                                 /* ANSI escape sequences */
#define CUU "\x1B[1A"            /* cursor up */
#define CUL "\x1B[132D"          /* cursor to Leftmost position */
#define EL  "\x1B[K"             /* erase to end-of-line */
#define ED  "\x1B[2J"            /* clear screen and go home */

#ifndef MAX
#define MAX(x,y) ((x)>(y)?(x):(y))
#endif /* MAX */
#ifndef MIN
#define MIN(x,y) ((x)<(y)?(x):(y))
#endif /* MIN */

/*----------------------------PROTOTYPE FUNCTIONS-----------------------------*/
int ChkAnsiKKR();

#endif /* ANSI_CHK_H */
