;---------------
; 
;  BASNOV 0.01 
; 
;  ASSEMBLE WITH MASM 5.1 
; 
;---------------
;
; Changes made by Scott McNay (1:395/11) July 26, 1992, to allow routine to be
; used with code compiled with BC's /Fs option.  (Most) changes marked with
; ;BCFS0726.  May have optimized some code also.  This is a plug-in replacement
; for the original code.

;BCFS0801: Standardized code format.  Made sure that DI, SI, BP, and DS are
;  saved to meet requirements of BC 7.x.

	Extrn	StringAddress:far					      ;BCFS0726

		.model	medium,basic
;---------------
		.code

Filename	db	128 dup (0)		; buffer for Filename

;---------------
; CheckNovell(Err%)
;
; return values for Err% :
;
;	 0	if Netware installed
;	-1	if Netware not installed
;
CheckNovell	proc	Err:word

		mov	ax,0B600h		; get station number
		int	21h
		or	al,al			; Netware loaded ?
		jz	Error

		xor	ax,ax			; return  0 if no error
		jmp	short Exit

Error:		mov	ax,-1			; return -1 if error

Exit:		mov	bx,[Err]		; set result to Err%
		mov	[bx],ax
		ret

CheckNovell	endp
;---------------
;  SetSharedAttr(Filename$, Err%)
;
;  return values for Err% :
;
;	 0	no error reported by DOS
;	-1	error reported by DOS
;
SetSharedAttr	proc	Filenam:ptr, Err:word
		push	ds						      ;BCFS0726
		push	es						      ;BCFS0801
		push	di						      ;BCFS0801
		push	si						      ;BCFS0801
		push	[Filenam]					      ;BCFS0726
		call	StringAddress					      ;BCFS0726
		mov	si,ax			; address of string	      ;BCFS0726
		mov	ds,dx			; segment of string	      ;BCFS0726

		mov	ax,cs			; ES:DI points to local buffer;BCFS0801
		mov	es,ax
		mov	di,offset Filename
		mov	dx,di			; copy offset into DX
		rep	movsb			; copy string contents
		xor	al,al			; make string ASCIIZ	      ;BCFS0801
		stosb

		mov	ax,cs			; make DS equal to CS	      ;BCFS0801
		mov	ds,ax

		mov	ax,04300h		; CHMOD, get attribute
		int	21h
		jc	Error			; check for error

		or	cl,80h			; set shared bit

		mov	ax,04301h		; CHMOD, set attribute
		int	21h
		jc	Error			; check for error

		xor	ax,ax			; set Err% to  0
		jmp	short Exit

Error:		mov	ax,-1			; set Err% to -1

Exit:		pop	si
		pop	di
		pop	es			; restore ES
		pop	ds			; restore DS
		mov	bx,[Err]		; offset of Err%
		mov	[bx],ax 		; store result
		ret				; return

SetSharedAttr	endp
;---------------
		end
