'***********************************************************************
'                             FINDFILE.BAS                             *
'  Two functions to be linked to programs compiled with BC version 7   *
'----------------------------------------------------------------------*
'    MAKNAME(<filespec>) [DECLARE FUNCTION MAKNAME$ (A$)] returns the  *
' <filename.ext> portion of <filespec>, where <filespec> can be either *
' a string variable or string literal.                                 *
'----------------------------------------------------------------------*
'    FINDFILE(<filespec>) [DECLARE FUNCTION FINDFILE$ (A$)] locates a  *
' file stored in the specified directory or in a directory on the PATH *
' environment string, using the "new" BASIC function DIR$ to test for  *
' existence of a file.  FINDFILE returns a string containing the full  *
' <filespec> (including the drive and directory path as required).  If *
' the input argument contains "wildcards," FINDFILE will return the    *
' expanded <filespec> of the first file found that meets the input     *
' specification.  If the requested file cannot be found after the      *
' PATH environment string search, FINDFILE returns a null string.      *
'----------------------------------------------------------------------*
'               Rewritten by M. L. Lesser, April 8, 1990               *
' Based on the BC version 4.0 subroutines in the module of the same    *
' name, written for the book "Advanced QuickBASIC 4.0," published by   *
' Bantam Books, 1988.                                                  *
'                Compiled with Microsoft BC version 7.1                *
'***********************************************************************

    DEFINT I-K
    DEFSTR F,M,P,T
        
FUNCTION MAKNAME(FILENAME) STATIC
    LET J = INSTR(FILENAME,"\")         'Separator in <filespec> "path"
    LET K = 0                           'Place mark
    WHILE J <> 0
        LET K = J                           'K will be location of
        LET J = INSTR(K+1,FILENAME,"\")     ' last "\" in FILENAME
    WEND
    IF K = 0 THEN LET K = INSTR(FILENAME,":")  'If no path, try drive
    IF K <> 0 THEN
        LET MAKNAME = MID$(FILENAME,K+1)
    ELSE
        LET MAKNAME = FILENAME
    END IF
END FUNCTION

FUNCTION FINDFILE(FILE) STATIC
    LET PATH = ENVIRON$("PATH") 'Get PATH environment string
' Capture any FPATH from input FILE in case hit on first directory:
    LET FPATH = UCASE$(LEFT$(FILE,INSTR(FILE,MAKNAME(FILE))-1))
    LET TEMP = FILE                     'Local variable
' Now find the file:
    WHILE LEN(DIR$(TEMP)) = 0           'As long as file not found
        LET I = INSTR(PATH,";")             'Separator in PATH string
        IF PATH = "" THEN                   'If no more directories
           LET FINDFILE = ""                    'Error signal and forced
           EXIT FUNCTION                        '  return from function
        END IF
        IF I <> 0 THEN                      'If more than one "path"
           LET FPATH = LEFT$(PATH,I-1)          'Try next one and
           LET PATH = MID$(PATH,I+1)            ' strip it off string
        ELSE                                'This is last one on string
           LET FPATH = PATH                     'So use it
           LET PATH = ""                        '  and set PATH at null
        END IF
        IF RIGHT$(FPATH,1) <> "\" THEN      'If not a root directory
           LET FPATH = FPATH + "\"              '  add trailing "\" 
        END IF
        LET TEMP = MAKNAME(TEMP)            'Delete old "path,"
        LET TEMP = FPATH + TEMP             '  insert new value,
    WEND                                  '  and try again
    LET FINDFILE = FPATH + DIR$(TEMP)
END FUNCTION
