/* 
 * Winvue header file
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 */

/*
 *  This little trick insures that the external variables are delcared
 *  in only one place, namely in the file where EXTERN is defined.
*/
#ifndef EXTERN
#define EXTERN extern
#endif

/* functions declarations which are shared among modules */
/* from winvue.c */
LONG FAR PASCAL MainWndProc(HWND,unsigned,WORD,LONG);
void NEAR DoGetMessage(void);
void NEAR DoPeekMessage(void);

/* from winvuent.c */
BOOL FAR InitProgram(HANDLE,HANDLE,LPSTR,int);
void WndCreate(HWND, LONG);

/* from winvuems.c */
int FAR PASCAL DlgFnOpen(HWND, unsigned, WORD, LONG);
BOOL FAR PASCAL AboutBoxProc(HWND,unsigned,WORD,LONG);

/* from winvuefn.c */
void NEAR MainWndPaint(HWND, LPPAINTSTRUCT);
void NEAR AdjustHeight(short width, short height);
void NEAR WndCommand(HWND hWnd, WORD wParam);
void NEAR ProcessFile(void);
void ShowMessage(HWND hWnd, char *mergestr, int msgnum, int style);
BOOL FAR DlgMergeStrings(char *szSrc, char *szMerge, char *szDst);
int FAR OpenTheFile(char *);

/* miscellaneous constraints */
#define	MAX_STR_LEN	256
#define MAX_FNAME_LEN   128
#define CBEXTMAX	6	/* Number of bytes in "\*.ext" */

/* dialog box manifest */
#define DT_ABOUT	1
#define DT_OPEN		2

/* dialog box controls */
#define IDD_EDIT	100
#define IDD_LISTBOX	101
#define IDD_PATH	102

/* string manifests */
#define IDS_APPNAME	100
#define IDS_WINTITLE	101
#define IDS_ICONSTRING	102
#define IDS_CANNOT_OPEN 103
#define IDS_IFN		104
#define IDS_CANCEL	105
#define IDS_DONE	106

/* menu items */
#define IDM_ABOUT	200
#define IDM_FILENAME	201
#define IDM_CANCEL	202
#define IDM_PAUSE	203
#define IDM_RESUME	204
#define IDM_SYSFONT	205
#define IDM_OEMFONT	206
#define IDM_MASK	207

/* global variables */
EXTERN struct TTYWND MWnd;    /* main window structure (defined in ttycls.h) */
EXTERN char szAppName[10];    /* application name */
EXTERN char szIconTitle[5];   /* icon string */
EXTERN char szWinTitle[30];   /* title for window */
EXTERN char szFileNameSave[MAX_FNAME_LEN];  /* file name buffer */
EXTERN int FontIndex;	      /* index to system or oem font */
EXTERN int hFile;	      /* handle to the file being viewed */
EXTERN HANDLE hAccel;	      /* menu accelerator table */
EXTERN OFSTRUCT fstruct;      /* file open structure */
EXTERN BYTE instr[MAX_STR_LEN];      /* data read buffer */
EXTERN BOOL Break;	      /* file display was cancelled */
EXTERN BOOL Pause;	      /* file display has been suspended */
EXTERN void (NEAR *DoMessage)(void);  /* pointer to message function */

