/*
 * PMAUX main module
 *
 * Written by Bill Hall
 * 3665  Benton Street, #66
 * Santa Clara, CA 95051
 *
 * See WPMAUX.DOC for usage information
 *
 */

#define INCL_PM
#include <os2.h>
#include <stddef.h>
#include <string.h>

#include <ttycls.h>
#define EXTERN			/* all globals are declared in this module */
#include "pmaux.h"

/* entry point for program */
int cdecl main(int argc, char *argv[])
{

    QMSG qmsg;

  /* call initialization */
    if (!InitProgram(argc, argv))
	return FALSE;

  /* fall into message loop */
    while (WinGetMsg(hAB, (PQMSG)&qmsg, (HWND)NULL, 0, 0))
        WinDispatchMsg( hAB, (PQMSG)&qmsg );

  /* program exit */
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmqMsgQ);
    WinTerminate(hAB);
}

/* main window message loop */
MRESULT FAR PASCAL MainWndProc(HWND hWnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{

    HPS hPS;		/* handle to PM display context */
    RECTL rect;

    switch (msg) {

	case WM_COMMAND:		/* process menu commands */
	    WndCommand(hWnd, LOUSHORT(mp1));
	    break;

	case WM_USER:		/* process message from calling window */
	    if (!WindowIsIconic(hWnd))
	        DispatchString(hWnd, mp1, mp2);
	    break;

	case WM_CREATE:		/* called when main window is created */
	    WndCreate(hWnd);
	    break;

	case WM_CLOSE:		/* called when main window is closed */
	    SetOS2Ini((HWND)NULL);
	    hPS = WinGetPS(hWnd);
	    GpiDeleteSetId(hPS, LCID_ALL);
	    WinReleasePS(hPS);
#if IBMVER
	    GpiUnloadFonts(hAB, "c:\\os2\\dll\\COURIER.FON");
#else
	    GpiLoadFonts(hAB, "FONTS");
#endif
            WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
            break;

   	case WM_PAINT:		/* called when window needs repainting */
	    hPS = WinBeginPaint(hWnd, (HPS)NULL, (PRECTL)&rect);
	    MainWndPaint(hWnd, hPS, (short)rect.yTop, (short)rect.yBottom);
	    WinEndPaint( hPS );
            break;

    	case WM_ERASEBACKGROUND:	/* have PM take care of background */
            return(TRUE);
            break;

    	default:		/* all other messages go here */
            return( WinDefWindowProc( hWnd, msg, mp1, mp2 ) );
            break;
    }
    return(0L);
}
