Code from "Converting a Turbo C Program to a TSR" by Michael J.
Young, PJ, Volume 6.2.  Copyright 1987 Michael J. Young

Listing 3

#include <stdio.h>
#include <process.h>
#include <conio.h>
#include <dos.h>
#include <mem.h>
#include <bios.h>
#include "tsr.h"

static void Test (void);                /* The TSR demo routine.            */
static void ScrSave (void);             /* Screen functions.                */
static void ScrRestore (void);
void ScrPutS (char *String,int Attr,int Row,int Col);

main ()
     {
     /* Install 'Test' as TSR function;  Ctrl-Left Shift is hotkey.         */
     switch (TsrInstall (Test,CONTROL | LEFTSHIFT,(VIFP)0x11111111))
          {
          case WRONGDOS:
               printf ("Cannot install TSR;  must have DOS version 2.0 "
                       "or higher.\n");
               exit (1);
          case INSTALLED:
               printf ("TSR already installed.\n");
               exit (1);
          case NOINT:
               printf ("Cannot install;  no free user interrupts.\n");
               exit (1);
          case ERROR:                   /* General error case.              */
          default:
               printf ("Error installing TSR function.\n");
               exit (1);
          }
     } /* end main */


static void Test (void)
/*
     This routine is called when the hotkey is pressed.  It displays a
     window and indicates whether DOS is currently active.
*/
     {
     int Row = 6;
     int Col = 24;

     ScrSave ();
     ScrPutS ("+-------------------------------+",0x0f,Row++,Col);
     ScrPutS ("|                               |",0x0f,Row++,Col);
     ScrPutS ("|        T S R   D E M O        |",0x0f,Row++,Col);
     ScrPutS ("|                               |",0x0f,Row++,Col);
     ScrPutS ("|   press any key to continue   |",0x0f,Row++,Col);
     ScrPutS ("|                               |",0x0f,Row++,Col);
     ScrPutS ("+-------------------------------+",0x0f,Row++,Col);

     if (TsrInDos ())
          ScrPutS ("Now in DOS",0x0f,9,35);
     else
          ScrPutS ("NOT in DOS",0x0f,9,35);
     bioskey (0);
     ScrRestore ();

     } /* end Test */

/*** screen functions *******************************************************/

static char SaveScr [4000];

static void ScrSave (void)
     {
/*
     This function saves the current contents of the screen in a buffer.
*/
     int VideoSeg;

     if (*(char far *)0x00400049 == 7)       /* Test video mode.            */
          VideoSeg = 0xb000;                 /* Monochrome video memory.    */
     else
          VideoSeg = 0xb800;                 /* Color video memory.         */
     movedata (VideoSeg,0,FP_SEG ((char far *)SaveScr),
               FP_OFF ((char far *)SaveScr),4000);

     } /* end ScrSave */


static void ScrRestore (void)
     {
/*
     This function restores the contents of a screen that was saved by ScrSave
*/     
     int VideoSeg;

     if (*(char far *)0x00400049 == 7)       /* Test video mode.            */
          VideoSeg = 0xb000;                 /* Monochrome video memory.    */
     else
          VideoSeg = 0xb800;                 /* Color video memory.         */
     movedata (FP_SEG ((char far *)SaveScr),FP_OFF ((char far *)SaveScr),
               VideoSeg,0,4000);

     } /* end ScrRestore */


void ScrPutS (char *String,int Attr,int Row,int Col)
/*
     This function displays null terminated 'String' with video attribute
     'Attr', beginning at the position given by 'Row' and 'Col'.
*/
     {
     register int A;                    /* Fast register storage for Attr.  */
     char far *Video;                   /* Far pointer to video memory.     */
     int VideoSeg,VideoOff;             /* Store video memory address.      */

     A = Attr;
     if (*(char far *)0x00400049 == 7)            /* Test video mode.       */
          VideoSeg = 0xb000;                      /* Monochrome segment.    */
     else
          VideoSeg = 0xb800;                      /* Color segment.         */

     VideoOff = Row * 160 + Col * 2;    /* Beginning video memory offset.   */
     Video = MK_FP (VideoSeg,VideoOff); /* Initialize video memory pointer. */

     while (*String)          /* Write characters from string until null.   */
          {
          *Video++ = *String++;
          *Video++ = A;
          }
     } /* end ScrPutS */


