{$R-}    {Range checking off}
{$B+}    {Boolean complete evaluation on}
{$S+}    {Stack checking on}
{$I+}    {I/O checking on}
{$N+,E+}    {numeric coprocessor - or emulation}
{$M 65500,16384,655360} {Turbo 3 default stack and heap}

PROGRAM Postscript;


{ASCII menu driven listing program that generates PostScript
commands to the Apple LaserWriter.  Allows selction of
bold and normal fonts, font size and line spacing.  Output
can go to a disk file (output.ps) or directly to the printer.

Limitations: Handling tabs is limited to move to an absolute location
on the line.  Program is not smart about the actual widths of
characters in different fonts... it just uses an average width per
character of fontsize/2.  Epson font change escapes ESC G for bold
and ESC H for normal are used.  Spacing for a tab is based on an
average of 8 nominal characters... as a result the tab spacing after
some text with capital letters may not be wide enough and the text
starting after the tab may overlap with previous text.  (On the other
hand, the worst case width of 8 widest characters is too large for
normal use).

Can be invoked with filename as a parameter: nlist filename

Free for non-commercial use only.

(C) Copywrite Nate Liskov 27 Jan 1986}

{ Version 1.0 - Original Version 
Version 1.1 - Fonts for LaserWriter Plus Added 
Version 1.2 - Landscape Format Option Added - Apr 1987 
version 1.21 - command line paramters -n= and -b= added to
                 preset normal and bold fonts
               - no headers, no lineffed and output to file are defaults
                 if command line file has .mem extension
version 1.22 - mar 1988
               - option for number of lines added
               - fix display of pages printed when page feed off
               - capability to print multiple files per invocation added
               - apr 88... fix spelling of avantgarde
version 1.23  - apr 1988
               - zeroize output.ps option added
version 2.00  - converted to turbo 4.0
version 2.02  - july 1988
 	       - minor bugs corrected
version 2.03  - 9 sept 1988
	       - correct bug in bold that inserted 2 spaces
version 2.04  - 22 sept 1988
	       - leave leading blanks in each line vs removing them
	           thus correcting spacing problems with courier font
	       - reduce min left hand margin  from 45/72 to 36/72 inch
	       - appears to handle mix of tabs, bold, normal on one line
	       - tab spacing is 8 times a number character width
	       	     note: for all fonts except courier number width =
                           twice space width
version 2.05  - change spacing for automatic centering
version 2.06  - cleanup of 2.05, display of pitch
version 2.07  - redirect output code changed, change mto to m
	       - conform to encapsulated postscript
version 2.08  - converted to turbo 5.0, uses turbo3 dropped
version 2.09  - account for actual space widths in breaking up long
	       - line into several lines
	       - 28 nov 1988 corrected bug with blank input lines
version 2.10  - 12 dec 1988
	       - help function added with ? or help command line parameters
	       - 6 dec 1989
	       - debugged encapsulated postscript input to wordperfect 5.0
version 2.11  - 24 dec 1988
	       - add helvetica-condensed fonts
	         (ti-omnilaser equivalent to helvetica narrow)
	       - 7 dec 1989
	       - debugged encapsulated postscript input to wordperfect
version 2.12   - better file handling if input file does not exist
}

Uses
  Crt,
  Dos,
  Printer;

TYPE 
  DateTimeStr = STRING[26];
  OnorOff     = ARRAY[1..2] OF STRING[3];
  pageform    = ARRAY[1..2] OF STRING[9];
  fonttype    = ARRAY[1..37] OF STRING[28];
  outfile     = ARRAY[1..2] OF STRING[21];
  msg         = STRING[127];
  maxspaces   = STRING[255];

VAR
    numberofcopies, linecount, n, m, page, linelength, entryline : integer;
    topspaces, bottomspaces, leftmargin, rightmargin, lm, rm : integer;
    option   : char;
    pagestr  : STRING[3];
    filename : STRING[45];
    temp, lineout     : STRING[255];
    right, left : maxspaces;
    source, sink   : text;
    linesize, header, automatic, maxline : integer;
    x,strng        : msg;
    hellfreezesover,autoexit: boolean;
    datetimestamp: datetimestr;
    yposition,linesperpage,linespacing,nfont,bfont,currentfont,
        nout,pagefeed,fontsize,pagetype : integer;
    fontsused:array[1..37]of boolean;
    formatsused:array[1..2]of boolean;

  CONST 
    onoff: onoroff = ('On ','Off');
    pageformat: pageform = ('Portrait ','Landscape');
    font: fonttype = ('Helvetica','Times-Roman','Courier',
                      'Helvetica-Oblique','Times-Italic','Courier-Oblique',
                      'Helvetica-Bold','Times-Bold','Courier-Bold',
                      'Helvetica-BoldOblique','Times-BoldItalic',
		      'Courier-BoldOblique','AvantGarde-Book',
		      'AvantGarde-BookOblique','AvantGarde-Demi',
		      'AvantGarde-DemiOblique','Bookman-Demi',
		      'Bookman-DemiItalic','Bookman-Light',
		      'Bookman-LightItalic','Helvetica-Narrow',
		      'Helvetica-Narrow-Bold',
		      'Helvetica-Narrow-Oblique',
		      'Helvetica-Narrow-BoldOblique',
		      'NewCenturySchlbk-Roman',
		      'NewCenturySchlbk-Bold','NewCenturySchlbk-Italic',
		      'NewCenturySchlbk-BoldItalic','Palatino-Roman',
		      'Palatino-Bold','Palatino-Italic','Palatino-BoldItalic',
		      'ZapfChancery-MediumItalic','Helvetica-Condensed',
		      'Helvetica-Condensed-Bold',
		      'Helvetica-Condensed-Oblique',
		      'Helvetica-Condensed-BoldObl');
    spacewidth: ARRAY [1..37] of real = (0.556,0.5,0.6,0.556,0.5,0.6,
                       0.556,0.5,0.6,0.556,0.5,0.6,
		       0.554,0.554,0.554,0.554,0.660,0.660,0.660,0.66,
		       0.456,0.456,0.456,0.456,0.556,0.556,0.556,0.556,
		       0.5,0.5,0.5,0.5,0.44,0.456,0.456,0.456,0.456);
		       {spacewidth is width of space for courier, else
		        spacewidth is twice width of space which is 
			same as the width of a number character}
    output: outfile = ('Printer','Disk File: Output.ps');

function upword(wrd:msg):msg;
var n:integer;
begin
  for n :=1 to length(wrd) do
  wrd[n]:=upcase(wrd[n]);
  upword := wrd;
end;

FUNCTION spaces(n:integer): maxspaces;

  VAR 
    tmp: STRING[255];
    m: integer;
  BEGIN
    tmp := '';
    FOR m :=1 TO n DO
      tmp := tmp + ' ';
    spaces := tmp;
  END;

procedure setlinesize;
begin
    IF pagetype = 1 THEN linesize := round(594/(fontsize*spacewidth[nfont]))
    ELSE linesize := round(774/(fontsize*spacewidth[nfont]));
    if nfont in [3,6,9,12] then 
          linesize:=linesize else
          linesize:=round(linesize*1.04);    {fudge factor}
end;

Procedure help;
var foo :char;
begin
  clrscr;
  writeln('                       PPS HELP');
  writeln;
  writeln('  Command Line Parameters');
  writeln;
  writeln('     ?, help       help on command line parameters');
  writeln('     -0=10         sets fontsize to 10');
  writeln('     -1=13         sets line spacing to 13');
  writeln('     -2            pagefeed commands are in input file (default for .mem file)');
  writeln('     -3=25         normal font is font 25');
  writeln('     -4=13         bold font is font 13');
  writeln('     -5=2          suppress header line (default for .mem file)');
  writeln('     -6            output to printer vs output.ps');
  writeln('     -7=5          topspaces = 5');
  writeln('     -8=7          bottomspaces = 7');
  writeln('     -9            automatic margins');
  writeln('     -G            go, then exit program');
  writeln('     -L=12         left margin is 12');
  writeln('     -N=7          normal font is font 7');
  writeln('     -P            landscape page format');
  writeln('     -R=12         right margin is 12');
  writeln('     -foobar       input file is foobar');
  halt;
end;

PROCEDURE Alarm;
BEGIN
  sound(1000);
  delay(500);
  nosound;
END;

PROCEDURE Testfile(filename:msg);
var
fileok:boolean;
BEGIN
  {$I-}
  Reset(source) {$I+};
  fileok := (IOResult=0);
  IF NOT fileok
    THEN BEGIN
           HighVideo;
           alarm;
           WriteLn('   -- Error! --   file ',filename,' not found');
	   HALT;
      END;
END;

PROCEDURE parameters;

VAR n,err : INTEGER;
BEGIN
  filename := '';
  for n := 1 to paramcount do begin
    strng := upword(paramstr(n));
    if (strng = '?') or (strng = 'HELP') then help;
    if pos('-0=',strng) <> 0 then begin
       delete(strng,1,3);
       val(strng,fontsize,err)
    end;
    if pos('-1=',strng) =1 then begin
       delete(strng,1,3);
       val(strng,linespacing,err)
    end;
    if pos('-3=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,nfont,err)
    end;
    if pos('-4=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,bfont,err)
    end;
    if pos('-7=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,topspaces,err)
    end;
    if pos('-8=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,bottomspaces,err)
    end;
    if pos('-L=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,leftmargin,err);
{       if err=0 then left := spaces(leftmargin);}
    end;
    if pos('-R=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,rightmargin,err);
       if err=0 then right := spaces(rightmargin);
    end;
    if pos('-N=',strng)=1 then begin
       delete(strng,1,3);
       val(strng,nfont,err)
    end;
    if strng='-2' then pagefeed:=2;
    if strng='-5' then header:=2;
    if strng='-6' then nout:=1;
    if strng='-9' then automatic:=1;
    if strng='-P' then pagetype:=2;
    if strng='-G' then autoexit:=true;
  end;
  for n := 1 to paramcount do begin
     strng := upword(paramstr(n));
    if pos('-',strng)=1 then strng:=strng else
       filename := paramstr(n);
  end;
  assign(source,filename);
  strng := upword(filename);
  if pos('.MEM',strng)<>0 then begin 
    nout :=2;
    pagefeed := 2;
    header := 2;
  end;
  setlinesize;
    IF pagetype = 1 THEN linesperpage := 792 DIV linespacing
    ELSE linesperpage := 612 DIV linespacing;
END;

function datetime:datetimestr;
TYPE
  monthname = ARRAY[1..12] OF STRING[3];
  daynames = ARRAY[1..7] OF STRING[3];
CONST
  mon: monthname = ('Jan','Feb','Mar','Apr','May','Jun',
                            'Jul','Aug','Sep','Oct','Nov','Dec');
  days: daynames = ('Sun','Mon','Tue','Wed','Thu','Fri','Sat');
VAR
  year,month,day,dayofweek,hour,min,sec,sec100:word;
  str1:string[1];
  daystr,hourstr,minstr,secstr:string[2];
  yearstr:string[4];
begin
    getdate(year,month,day,dayofweek);
    gettime(hour,min,sec,sec100);
    if day>9 then str(day,daystr) else begin
       str(day,str1); daystr:=' '+str1;end;
    if hour>9 then str(hour,hourstr) else begin
       str(hour,str1); hourstr:='0'+str1;end;
    if min>9 then str(min,minstr) else begin
       str(min,str1);minstr:='0'+str1;end;
    if sec>9 then str(sec,secstr) else begin
       str(sec,str1);secstr:='0'+str1;end;
    str(year,yearstr);
    datetime := days[1+dayofweek]+' '+daystr+' '+mon[month]+' '+yearstr
          +'   '+hourstr+':'+minstr+':'+secstr;
end;

PROCEDURE init;
  BEGIN
    autoexit:=false;
    nfont := 1 ;              {default normal font is helvetica}
    bfont := 7;               {default bold font is helvetica-bold}
    nout := 2;                {default output is to file}
    pagefeed := 1;            {default is to do page feed}
    pagetype := 1;            {default is portrait page format}
    fontsize := 12;
    linespacing := 12;
    setlinesize;
    linesperpage := 792 DIV linespacing;
    header   := 1;           {default is header line on}
    automatic := 2;          {default is zero margins}
    topspaces := 2;
    bottomspaces := 0;
    leftmargin := 0;
    rightmargin := 0;
    numberofcopies := 1;
    right := '';
    left := '';
    entryline := 23;
    filename := '';
    IF paramcount<>0 then parameters;
    for n:=1 to 34 do fontsused[n]:=false;
    for n:=1 to 2 do formatsused[n]:=false;
    if nout=2 then assign(sink,'output.ps') else assign(sink,'lpt1');
    rewrite(sink);
    hellfreezesover := false;
    writeln(sink,'%!PS-Adobe-2.0 EPSF-1.2');
    writeln(sink,'%%BeginDocument: PPS ASCII-to-Postscript Conversion');
    writeln(sink,'%%Title: PPS generated file');
    writeln(sink,'%%Creator: PPS version 2.13');
    writeln(sink,'%%BoundingBox: (atend)');
    writeln(sink,'%%DocumentFonts: (atend)');
    writeln(sink,'%%CreationDate: ',datetime);
    writeln(sink,'%%Pages: ',numberofcopies);
    writeln(sink,'%%EndComments');
    writeln(sink,'%%EndProlog');
   writeln(sink,'%Copywrite 1988 (C) by Nathan Liskov.  All Rights Reserved');
  END;

PROCEDURE optionline;
  BEGIN
    gotoxy(1,entryline);
    normvideo;
{! 5^. The effects of HighVideo,LowVideo,NormVideo are different in Turbo 4.0.}
    writeln('   Enter Option Choice                                                ');
    gotoxy(36,entryline);
  END;

PROCEDURE menu;  {gives main menu options}
  BEGIN
    clrscr;
    lowvideo;
{! 6^. The effects of HighVideo,LowVideo,NormVideo are different in Turbo 4.0.}
    writeln('Postscript File Listing Utility for Apple LaserWriter - Version 2.13');
    writeln('   ____________(C) 1986 Nathan Liskov_____________');
    writeln;
    writeln('   0 := Font Size                : ',fontsize,'   (pitch = ',72/(fontsize*spacewidth[nfont]):5:1,')    ');
    writeln('   1 := Line Spacing             : ',linespacing,'   (',linesperpage,
            ' lines per page)');
    writeln('   2 := Page Feed                : ',onoff[pagefeed]);
    writeln('   3 := Normal Font              : ',font[nfont]);
    writeln('   4 := Bold Font                : ',font[bfont]);
    writeln('   5 := Header Line              : ',onoff[header]);
    writeln('   6 := Output Goes To           : ',output[nout]);
    writeln('   7 := Extra Top Blank Lines    : ',topspaces);
    writeln('   8 := Extra Bottom Blank Lines : ',bottomspaces);
    writeln('   9 := Automatic L/R Margins    : ',onoff[automatic]);
    writeln('   L := Extra Left Margin        : ',leftmargin);
    writeln('   R := Extra Right Margin       : ',rightmargin);
    writeln('   P := Page Format              : ',pageformat[pagetype]);
    writeln('   N := Number of Copies         : ',numberofcopies);
    writeln;
    normvideo;
{! 7^. The effects of HighVideo,LowVideo,NormVideo are different in Turbo 4.0.}
    writeln('   F := File Name                : ',filename);
    writeln;
    writeln('   G := GO       ESC,Q := QUIT       Z := Zeroize Output.ps');
    writeln;
    optionline;
    page := 0;
  END;

PROCEDURE get_file;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter name of file to list: ');
    readln(filename);
    assign(source,filename);
    gotoxy(36,19);
    write(filename,'                                           ');
    optionline;
  END;

PROCEDURE settopmargin;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter number of extra top spaces: ');
    readln(topspaces);
    gotoxy(36,11);
    write(topspaces,'            ');
    optionline;
  END;

PROCEDURE setbottommargin;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter number of extra bottom spaces: ');
    readln(bottomspaces);
    gotoxy(36,12);
    write(bottomspaces,'            ');
    optionline;
  END;

PROCEDURE setleftmargin;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter number of extra left margin spaces: ');
    readln(leftmargin);
{    left := spaces(leftmargin);}
    gotoxy(36,14);
    write(leftmargin,'             ');
    optionline;
  END;

PROCEDURE setnumberofcopies;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter number of copies: ');
    readln(numberofcopies);
    gotoxy(36,17);
    write(numberofcopies,'             ');
    optionline;
END;

PROCEDURE setfontsize;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter new fontsize: ');
    readln(fontsize);
    setlinesize;
    gotoxy(36,4);
   write(fontsize,'   (pitch = ',72/(fontsize*spacewidth[nfont]):5:1,')    ');
{    write(fontsize,'             ');}
    optionline;
  END;

PROCEDURE setlinespacing;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter new linespacing: ');
    readln(linespacing);
    IF pagetype = 1 THEN linesperpage := 792 DIV linespacing
    ELSE linesperpage := 612 DIV linespacing;
    gotoxy(36,5);
    write(linespacing,'   (',linesperpage,' lines per page)    ');
    optionline;
  END;


PROCEDURE setrightmargin;
  BEGIN
    gotoxy(1,entryline);
    write('   Enter number of extra right margin spaces: ');
    readln(rightmargin);
    right := spaces(rightmargin);
    gotoxy(36,15);
    write(rightmargin,'             ');
    optionline;
  END;

PROCEDURE setpageformat;
  BEGIN
    IF pagetype = 1
    THEN pagetype := 2
    ELSE pagetype := 1;
    gotoxy(36,16);
    write(pageformat[pagetype],'           ');
    setlinesize;
    IF pagetype = 1 THEN linesperpage := 792 DIV linespacing
    ELSE linesperpage := 612 DIV linespacing;
    gotoxy(36,5);
    write(linespacing,'   (',linesperpage,' lines per page)    ');
    optionline;
  END;


PROCEDURE setfont(n:integer);

  BEGIN
    IF n=nfont then writeln(sink,'normalfont')
    ELSE writeln(sink,'boldfont');
    setlinesize;
{    gotoxy(36,4);
   write(fontsize,'   (pitch = ',72/(fontsize*spacewidth[nfont]):5:1,')    ');}
  END;

PROCEDURE page_feed;
  BEGIN
    writeln(sink,' showpage');
    writeln(sink,'saveobj2 restore');
    writeln(sink,'/saveobj2 save def');
    setfont(nfont);
    linecount := 1;
    page := page + 1;
  END;

PROCEDURE countlb(strng:msg;var leadingblanks:integer);
BEGIN
    leadingblanks := 0;
    WHILE pos(' ',strng) = 1 DO
      BEGIN
        leadingblanks := leadingblanks+1;
        strng := copy(strng,2,length(strng)-1);
      END;
END;

PROCEDURE output_line;

  TYPE 
      txt = STRING [255];

  VAR 
       restofline,textpiece : txt;
       ypos : STRING[4];
       xpos:real;
        startofpiece,leadingblanks : integer;
       locatetext: boolean;

PROCEDURE escape(ch :char ; VAR txtline : txt);
    {adds \ escape for postscript}

  VAR 
       lineout,restofline,remainder : txt;
       m : integer;
  BEGIN
    restofline := txtline;
    lineout := '';
    remainder := '';
    IF pos(ch,txtline) = 0
      THEN lineout := txtline;
    WHILE pos(ch,restofline) > 0 DO
      BEGIN
        m := pos(ch,restofline);
        lineout := lineout + copy(restofline,1,m-1) + '\' + ch;
        restofline := copy(restofline,m+1,length(restofline)-m);
        remainder := restofline;
      END;
      txtline := lineout + remainder;
  END;


PROCEDURE dosubpiece(VAR txtpiece : txt);
                {process text piece without tabs or font escapes}
  BEGIN
    escape('\',txtpiece);
    escape(')',txtpiece);
    escape('(',txtpiece);
    if locatetext then write(sink,xpos:5:1,' ',ypos,' m ');
writeln(sink,'('+txtpiece+')' + ' s ');
{if leadingblanks<length(txtpiece) then writeln(sink,'('+txtpiece+')' + ' s ')
    else writeln(sink,'');}
    locatetext:=false;
  END;

PROCEDURE dotextpiece(VAR textpiece : txt);  {process text that may have tabs}

  VAR 
      m,xposition,ofset : integer;
      txtpiece : txt;

  BEGIN
    ofset:= 18;
    IF pagetype = 1 THEN yposition := 792-linespacing*linecount
    ELSE yposition := 612-linespacing*linecount;
    str(yposition,ypos);
{    str((leadingblanks+startofpiece-1)*fontsize div 2  + ofset,xpos);
    str(round((startofpiece-1)*fontsize*0.6)  + ofset,xpos);}
    xpos:=(startofpiece-1)*fontsize*spacewidth[nfont] + ofset;
{    xpos:=xpos+leftmargin*fontsize*2*spacewidth[nfont];
if nfont in [3,6,9,12] then}
    xpos:=xpos+leftmargin*fontsize*spacewidth[nfont];
        if automatic=1 then xpos:=xpos-ofset;
    WHILE pos(chr(9),textpiece)>0 DO
      BEGIN   				   {tab processing}
        m := pos(chr(9),textpiece);
        txtpiece := copy(textpiece,1,m-1);
    if length(txtpiece)>0 then dosubpiece(txtpiece);{output piece before tab}
        locatetext:=true;
        xposition := startofpiece + m-1;
        xposition := ((xposition-1) DIV 8 + 1)*8;
        startofpiece := xposition+1;
        xpos := (xposition)*fontsize*spacewidth[nfont] + ofset;
        if automatic=1 then xpos:=xpos-ofset;
{this spaces a tab exactly equal to 8 spaces in courier font}
{        str(xposition,xpos);}
        textpiece := copy(textpiece,m+1,length(textpiece)-m);
        if nfont in [3,6,9,12] then nfont:=nfont else begin
	  countlb(textpiece,leadingblanks);
          xpos:=xpos+leadingblanks*fontsize*spacewidth[nfont]/2;
        end; 
{         xpos:=xpos+leftmargin*fontsize*2*spacewidth[nfont];
         if nfont in [3,6,9,12] then}
	 xpos:=xpos+leftmargin*fontsize*spacewidth[nfont];
      END;
    IF length(textpiece)>0 then dosubpiece(textpiece);
END;

  BEGIN     {output_line}
    IF pos(chr(12),temp)>0   {assume form feed is only character on a line}
      THEN BEGIN
             page_feed;
gotoxy(1,entryline+2);
                   clreol;
             write('Page ',page,' ');         {status info to screen}
             exit;
         END;
{compute number of leading blanks}
    locatetext := true;
    countlb(temp,leadingblanks);
{look for enable or disable bold}
    restofline := temp;
   WHILE (pos(chr(27)+'G',restofline)>0) OR (pos(chr(27)+'H',restofline)>0) DO
      BEGIN
        IF pos(chr(27)+'G',restofline)>0   {esc G enables bold}
          THEN BEGIN
                 m := pos(chr(27)+'G',restofline);
		 textpiece := copy(restofline,1,m-1);
                 startofpiece := length(temp)-length(restofline)+1;
                 restofline := copy(restofline,m+2,length(restofline));
{                 IF length(textpiece) <> 0
                   THEN} dotextpiece(textpiece);
                 delete(temp,m,2);
                 setfont(bfont);
                 currentfont := bfont;
            END;
        IF pos(chr(27)+'H',restofline)>0   {esc H disables bold}
          THEN BEGIN
                 m := pos(chr(27)+'H',restofline);
                 textpiece := copy(restofline,1,m-1);
                 startofpiece := length(temp)-length(restofline)+1;
                 restofline := copy(restofline,m+2,length(restofline));
{                 IF length(textpiece) <> 0
                   THEN} dotextpiece(textpiece);
                 setfont(nfont);
                 currentfont := nfont;
            END;
      END;
{    IF length(restofline)>0
      THEN} BEGIN
             startofpiece := length(temp)-length(restofline)+1;
             dotextpiece(restofline);
        END;
   locatetext:=false;
END;

PROCEDURE insertblankline;
  BEGIN
    temp := '';
    output_line;
    write('.');
    linecount := linecount + 1;
  END;

PROCEDURE inserttoplines;
  BEGIN
    FOR n := 1 TO topspaces DO
      insertblankline;
  END;

PROCEDURE title; {prints filename, datetime, and page number on each page}

  VAR 
      nspaces : integer;
  BEGIN
    nspaces := (linesize - 36- length(filename)) DIV 2;
    IF nfont IN [3,6,9,12]   {test for courier font}
      THEN     nspaces := (linesize - 36- length(filename)) DIV 4;
    temp := 'File: '+ filename + spaces(nspaces);
    temp := temp + datetimestamp + spaces(nspaces) + 'Page ';
    str(page:3,pagestr);
    temp := temp + pagestr;
    output_line;
    write('.');
    linecount := 2;
  END;

PROCEDURE automaticmargins;
VAR
  templine: string[255];
{sets margins so longest line in file is centered}
  BEGIN
    testfile(filename);
    reset(source);
    lm := leftmargin;
    rm := rightmargin;
    maxline := 0;
    REPEAT
      readln(source,temp);
      m := length(temp);
      IF m > maxline then maxline:=m;
{        THEN BEGIN
          maxline := m;
	  templine:=temp;
	  while pos(chr(9),templine)=1 do delete(templine,1,1);
	  while pos(chr(9),templine)<>0 do begin
	    if nfont in [3,6,9,12] then m:=m+7 else m:= m+15;
	    delete(templine,pos(chr(9),templine),1);
	    end;
        END;}
    UNTIL EOF(source);
    close(source);
(*    IF nfont IN [3,6,9,12]   {test for courier font}
      THEN leftmargin := (linesize-maxline) div 2
      ELSE     leftmargin := (linesize-maxline) div 4;*)
    leftmargin := (linesize-maxline) div 2;
    IF leftmargin < 0
      THEN leftmargin := 0;
      rightmargin := 0;
    right := spaces(rightmargin);
{    left := spaces(leftmargin);writeln(leftmargin);}
{writeln(linesize,' ',leftmargin);}
    END;

procedure doaline;
begin
          output_line;
          linecount := linecount + 1;
          write('.');
          IF (linecount > (9*linesperpage DIV 10) - bottomspaces) AND (pagefeed =1)
            THEN page_feed;
          IF linecount =1
            THEN BEGIN {do after page break}
gotoxy(1,entryline+2);
                   clreol;
                   write('Page ',page,' ');         {status info to screen}
                   IF (header = 1) and (pagefeed=1)
                     THEN title;
                   IF (topspaces >0) and (pagefeed=1)
                     THEN inserttoplines;
              END;
end;

PROCEDURE printfile;

  VAR 
       n,len,leadingblanks : integer;
       ypos : STRING[4];
       siz : STRING [3];
       templine:msg;

  BEGIN
    datetimestamp := datetime;
    IF automatic = 1
      THEN automaticmargins;
    testfile(filename);
    reset(source);
    str(fontsize,siz);
    writeln(sink,'save mark');
    writeln(sink,'/m {moveto} def');
    writeln(sink,'/s {show} def');
    formatsused[pagetype]:=true;
    fontsused[nfont]:=true;
    fontsused[bfont]:=true;
    writeln(sink,'/normalfont {/'+font[nfont]+' findfont '+siz+' '+ ' scalefont setfont} def');
    writeln(sink,'/boldfont {/'+font[bfont]+' findfont '+siz+' '+ ' scalefont setfont} def');
    writeln(sink,'/#copies ',numberofcopies,' def');
    writeln(sink,'clippath pathbbox');
    writeln(sink,'0.98 0.98 scale');
    IF pagetype = 2 THEN writeln(sink,'612 0 translate 90 rotate');
    writeln(sink,'/saveobj2 save def');
    setfont(nfont);
    page := 1;
    linecount := 1;
    linelength := linesize -rightmargin-leftmargin;
    IF linelength <= 0
      THEN BEGIN
             clrscr;
             writeln('ERROR...Illegal margin size');
             halt;
        END;
    writeln;
    REPEAT     {for every line in file}
      IF linecount =1
        THEN BEGIN
gotoxy(1,entryline+2);
               write('Page ',page,' ');              {status info to screen}
               IF (header = 1) and (pagefeed=1)
                  THEN  title;
               IF (topspaces >0) and (pagefeed=1)
                 THEN inserttoplines;
             END;
      readln(source,temp);                   {read in one line}
      templine:=temp;
      if temp='' then doaline else
      while length(templine)>0 do 
        BEGIN  {process piece of full line}
	  countlb(templine,leadingblanks);
          if nfont in [3,6,9,12] then 
	  begin
	     len:=linesize-leftmargin-rightmargin;
	     temp:=left+copy(templine,1,len)+right;
	     templine:=copy(templine,len+1,length(templine));
	  end else begin
	     len:=linesize-trunc((leadingblanks+leftmargin+rightmargin)*spacewidth[nfont]);
	     temp:=left+spaces(leadingblanks)+
	          copy(templine,leadingblanks+1,len)+right;
	     templine:=copy(templine,leadingblanks+len+1,length(templine));
	  end;
	  doaline;
        END;  {processing pieces of long line}
    UNTIL eof(source);     {done all lines}
            {final page feed to eject last page}
    writeln(sink,' showpage');
    writeln(sink,'saveobj2 restore');
    writeln(sink,1/0.98,' ',1/0.98,' scale');
    writeln(sink,'cleartomark restore');
    IF automatic = 1      {restore margin values}
      THEN BEGIN
             leftmargin := lm;
             left := spaces(leftmargin);
             rightmargin := rm;
             right := spaces(rightmargin);
        END;
    menu;
  END;

PROCEDURE quit;       {restores default conditions on printer}
  BEGIN
    writeln(sink,'%%Trailer');
    if formatsused[1] and formatsused[2] then
       writeln(sink,'%%BoundingBox: 0 0 792 792') else
    if pagetype = 1 then writeln(sink,'%%BoundingBox: 0 0 612 792')
       else writeln(sink,'%%BoundingBox:0 0 792 612');
    writeln(sink,'%%DocumentFonts:');
    for n:=1 to 34 do if fontsused[n] then writeln(sink,'%%+ ',font[n]);
    writeln(sink,'%%EOF');
    writeln(sink,'%%EndDocument');
    writeln(sink,chr(4));
    close(sink);
    lowvideo;
    clrscr;
    halt;
  END;

PROCEDURE zeroize;
  BEGIN
    close(sink);
    if nout=2 then assign(sink,'output.ps') else assign(sink,'lpt1');
    rewrite(sink);
  END;

PROCEDURE action;
  BEGIN
    CASE option OF
      '0': begin setfontsize;setlinesize;end;
      '1': setlinespacing;
      '2': BEGIN
             IF pagefeed = 1
               THEN pagefeed := 2
               ELSE pagefeed := 1;
             gotoxy(36,6);
             write(onoff[pagefeed],'      ');
             optionline;
           END;
      '3': BEGIN
             nfont := (nfont MOD 37 + 1) MOD 38;
             setlinesize;
             gotoxy(36,7);
             write(font[nfont],'                   ');
    gotoxy(36,4);
   write(fontsize,'   (pitch = ',72/(fontsize*spacewidth[nfont]):5:1,')    ');
             optionline;
           END;
      '4': BEGIN
             bfont := (bfont MOD 37 + 1) MOD 38;
             gotoxy(36,8);
             write(font[bfont],'                   ');
             optionline;
           END;
      '5': BEGIN
             IF header=1
               THEN header := 2
               ELSE header := 1;
             gotoxy(36,9);
             write(onoff[header],'      ');
             optionline;
           END;
      '6': BEGIN
             IF nout=1
               THEN nout := 2
               ELSE nout := 1;
             close(sink);
	     if nout=2 then assign(sink,'output.ps') else assign(sink,'lpt1');
	     rewrite(sink);
             gotoxy(36,10);
             write(output[nout],'                  ');
             optionline;
           END;
      '7': settopmargin;
      '8': setbottommargin;
      '9': BEGIN
             IF automatic=1
               THEN automatic := 2
               ELSE automatic := 1;
             gotoxy(36,13);
             write(onoff[automatic],'    ');
             optionline;
           END;
      'L': setleftmargin;
      'R': setrightmargin;
      'F': get_file;
      'G': IF filename <> ''
             THEN printfile;
      'Q': quit;
      #27: quit;
      'P': setpageformat;
      'N': setnumberofcopies;
      'Z': zeroize;
    END;
END;

BEGIN
  init;
  menu;
  if autoexit and (filename<>'')then begin
    printfile;
    quit;
    halt;
  end;
  REPEAT
    gotoxy (35,entryline);
    REPEAT
      option := readkey;
{! 8. USE TU^RBO3 unit for access to KBD, or instead USE CRT and ReadKey.}
      option := upcase(option)
    UNTIL option
               IN ['0','1','2','3','4','5','6','g','G','q','Q','7','8','F',
                    'R','L','9','P','N','Z',#27];
    action;
  UNTIL hellfreezesover = true;
END.
