EXTENDED = 1
include ppp.asi
include internet.asi
;
; packet driver info
;
; standard PPP
;
PPP_CLASS = 18
PPP_TYPE = 2
;
; mimick ethernet
;
ETHERNET_CLASS = 1
ETHERNET_TYPE = 0h	; oh well, they had better specify a zero!!!!
;
; version info
;
VERSION = 100h		; our driver
SPECVERSION = 110h	; packet driver spec
;
; extensions to packet driver interface
;
RECONNECT_EXTENSION = 196
;
; packet driver error codes
;
BAD_HANDLE = 1
NO_CLASS = 2
NO_TYPE = 3
NO_NUMBER = 4
BAD_TYPE = 5
NO_MULTICAST = 6
CANT_TERMINATE = 7
BAD_MODE = 8
NO_SPACE = 9
TYPE_INUSE = 10
BAD_COMMAND = 11
CANT_SEND = 12
CANT_SET = 13
BAD_ADDRESS = 14
CANT_RESET = 15

;
; upcall info for receive upcalls
;
ucdata struc
ddprot	dw	?		; the protocol to match
ddcb	dd	?		; the callback to call
ddflags	db	?		; misc flags
ucdata ends

DF_READY = 1

;
; config info
MAXHANDLES = 10		; maximum receive upcalls
MAXSIGCALLS = 10	; maximum signal upcalls
MAX_IOCBS = 40		; max ASYNC IOCBs

iocbs struc
ic_buf	dd	?
ic_length	dw	?
ic_flags db	?
ic_code db	?
ic_upcall dd	?
	dd	?
ic_private	dd	?,?
iocbs ends

IOCB_DONE = 1
IOCB_UPCALL = 2
;
; image of registers as pushed in the packet driver (offset cgroup:BP)
;
stackedwords struc
_BP	dw	?
_DI	dw	?
_SI	dw	?
_DX	dw	?
_CX	dw	?
_BX	dw	?
_AX	dw	?
_ES	dw	?
_DS	dw	?
	ends
;
; same, byte versions
;
stackedbytes struc
	dd	?
	dw	?
_DL	db	?
_DH	db	?
_CL	db	?
_CH	db	?
_BL	db	?
_BH	db	?
_AL	db	?
_AH	db	?
	ends
	extrn drivername : byte, unhookvects : PROC, termisr : PROC, freemem : PROC
	extrn authenticated : byte, lcpstate : byte, ClearAllBufs : PROC
	extrn interfaceup : proc, connect : proc
	extrn vjcompress : proc, StartXmit : PROC, clflags : word
	extrn isxmitdone : PROC, sendfirstbyte : PROC
	extrn packetflags : word, arp_handler : PROC, bootp_handler : PROC
	extrn arp_ouraddress : PROC, arp_copyaddress : PROC
	extrn startxmit : PROC, commport : word
	extrn ipcp_struc : statemachine, lcp_struc : statemachine
	extrn logrundown : PROC, hangup : PROC
	public pdmsg, packetint, listedprothandler, tlu, tld, pkt_init
	public stat_packrcvd, stat_packxmit
	public stat_bytercvd, stat_bytexmit
	public stat_errrcvd,stat_errxmit,stat_packlost
	public asyncbuf, asyncdrop, p_class

cgroup group tsr,config
assume	cs:cgroup
assume	ds:cgroup

tsr segment word public 'CODE'
; their stack for driver stack switch
;
;
; space for stack
;
	dw	96 DUP (0)
local_stack	label byte
;
; reentrancy count
;
; we ARE going to allow reentrancy but it is up to them not to overflow
; our stacks!!!!
;
reentrant	db	0
;
; class and type info
;
p_class db	0
p_type	db	0
p_addressize db	2
;
; receive mode
;
rcvmode	dw	3
;
; signal upcalls for layer up/down
;
sigtab	dd	MAXSIGCALLS DUP (0)
;
; statistics - keep these in order!!!!
;
stats	LABEL	DWORD
st_rcv_pack	dw	0,0
st_xmit_pack	dw	0,0
st_rcv_byte	dw	0,0
st_xmit_byte	dw	0,0
st_rcv_err	dw	0,0
st_xmit_err	dw	0,0
st_lostpack	dw	0,0
;
;
; get_params block - keep these in order!!!!
;
gpb	LABEL	BYTE
gp_majrev	db 	SPECVERSION / 100
gp_minrev	db	SPECVERSION mod 100
gp_length	db	14; structure length
gp_addr_len	db	?
gp_mtu		dw	MRU
gp_multi	dw	0
gp_rcvbufs	dw	MAXBUF-1
gp_xmitbufs	dw	1
gp_intnum	dw	0	; not supporting this

;
; callback data for registering protocols to receive data about
;
handletab	ucdata	MAXHANDLES DUP (<>)
;
; IOCB for high performance
;
IOCB	dd MAX_IOCBS DUP (?)
iocb_count	db	0	; number of IOCBs we are caching currently
;
; their stack for driver stack switch
;
their_stack	dd	?
;
; transmit working buffer
;
xmbuf	db	MRU DUP (0)
;
; functions to keep track of statistics
;
stat_packrcvd	PROC
	add	[st_rcv_pack],1
	adc	[st_rcv_pack+2],0
	ret
stat_packrcvd	ENDP
stat_packxmit	PROC
	add	[st_xmit_pack],1
	adc	[st_xmit_pack+2],0
	ret
stat_packxmit	ENDP
stat_bytercvd	PROC
	add	[st_rcv_byte],1
	adc	[st_rcv_byte+2],0
	ret
stat_bytercvd	ENDP
stat_bytexmit	PROC
	add	[st_xmit_byte],1
	adc	[st_xmit_byte+2],0
	ret
stat_bytexmit	ENDP
stat_errrcvd	PROC
	add	[st_rcv_err],1
	adc	[st_rcv_err+2],0
	ret
stat_errrcvd	ENDP
stat_errxmit	PROC
	add	[st_xmit_err],1
	adc	[st_xmit_err+2],0
	ret
stat_errxmit	ENDP
stat_packlost	PROC
	add	[st_lostpack],1
	adc	[st_lostpack+2],0
	ret
stat_packlost	ENDP
;
; routine to notify clients of up/down status of the LCP layer
;
tlu PROC
	mov	ax,2
	jmp	call_signal_handlers
tlu ENDP
tld PROC
	mov	ax,1
tld ENDP
call_signal_handlers PROC
	mov	cx,MAXSIGCALLS		; upcall count
	mov	si,offset cgroup:sigtab	; signal table
cshl:
	test	word ptr [si],-1	; se if anything there
	jnz	docall			; yes, do it
	test	word ptr [si+2],-1	; check some more
	jz	nocall			; no don't do it
docall:
	push	cx			; call their signal handler
	push	ax
	push	si
	push	ds
	call	dword ptr [si]
	pop	ds
	pop	si
	pop	ax
	pop	cx
nocall:
	add	si,4			; continue
	loop	cshl
	ret
call_signal_handlers ENDP
;
; count the open handles
;
count_handles PROC
	sub	ax,ax			; count in ax
	mov	cx,MAXHANDLES		; get max upcalls
	mov	bx,offset cgroup:handletab	; point to handletab
ch_l:
	test	[bx].ddflags,DF_READY	; being used?
	jz	ch_nothere		; no, not here
	inc	ax			; else inc count
ch_nothere:
	add	bx,size ucdata		; next callback struct
	loop	ch_l
	ret
count_handles ENDP
;
; look for whoever wants this type of packet
;
scan_for_type PROC
	mov	cx,MAXHANDLES		; max
	mov	bx,offset cgroup:handletab	; handle table
sft_l:
	test	[bx].ddflags,DF_READY	; being used
	jz	sft_nothere		; nope, not this one
	cmp	dx,[bx].ddprot		; match protocol?
	jz	sft_here		; yes exit
	test	dh,1			; compressed?
	jz	sft_nothere		; no, continue
	mov	al,byte ptr [bx].ddprot	; compress their request and compare
	add	al,byte ptr [bx].ddprot+1
	cmp	al,dh
	jz	sft_here		; exit if match
sft_nothere:
	add	bx,size ucdata		; next
	loop	sft_l
	stc
sft_here:
	ret
scan_for_type ENDP
;
; find a free handle
;
find_free_handle PROC
	mov	cx,MAXHANDLES		; up callse
	mov	bx,offset cgroup:handletab	; handle tab
it_l:
	test	[bx].ddflags,DF_READY	; anything here
	jz	it_here			; yes, go see
	add	bx,size ucdata		; else continue
	loop	it_l
	stc				; no free handles
	ret
it_here:
	or	[bx].ddflags,DF_READY	; mark used
	mov	[bx].ddprot,dx		; save protocol
	mov	ax,[bp]._ES		; save callback
	mov	word ptr [bx+2].ddcb,ax
	mov	ax,[bp]._DI
	mov	word ptr [bx].ddcb,ax
	ret
find_free_handle ENDP
;
; locate a handle
;
; handles are values from zero to maxhandles
;
find_handle PROC
	mov	bx,[bp]._BX		; get handle
	cmp	bx,offset handletab
	jc	rt_bad
	cmp	bx,offset handletab + MAXHANDLES * (size ucdata)
	jnc	rt_bad			; yep bad handle
	test	[bx].ddflags,DF_READY	; see if in use
	jz	rt_bad			; no, error
	clc
	ret
rt_bad:
	mov	al,BAD_HANDLE
	stc
rt_here:
	ret
find_handle ENDP
;
; insert a Ethernet MAC header
;
insertmacheader PROC
	push	ax
	push	cx
	push	si
	std
	add	si,cx			; insert space
	dec	si
	mov	di,si
	add	di,14
	rep	movsb
	cld
	pop	si
	call	arp_copyaddress		; get us a MAC address
	pop	cx	
	add	cx,14   		; add in size
	pop	ax
	cmp	ax,IP_PROTOCOL		; decide what the protocol should be
	jz	imh_ip
	mov	[si+12],ax
	ret
imh_ip:
	push	ax
	mov	ax,ELT_IP
	mov	word ptr [si+12],ax
	pop	ax
	ret
insertmacheader ENDP
;
; insert a PPP address bytes
;
insertpppheader proc
	push	ax
	push	cx
	push	si
	std
	add	si,cx			; insert space
	dec	si
	mov	di,si
	add	di,4
	rep	movsb
	cld
	pop	si
	pop	cx
	pop	ax
	add	cx,4
	mov	word ptr [si],03ffh	; address byte
	xchg	al,ah
	mov	[si+2],ax		; protocol
	xchg	al,ah
	ret
insertpppheader endp
;
; signal that the protocol was listed to whatever is listening
;
listedprothandler PROC
	mov	dx,ax			; DX = protocol
	push	ax
	push	cx
	call	scan_for_type		; find the listener
	pop	cx
	pop	ax
	jc	lphe			; discard it if none
	test	[clflags],E_OPTION
	jz	lph_ppp
	call	insertmacheader
	jmp	lph_join
lph_ppp:
	call	insertpppheader
lph_join:
	push	si			; save regs
	push	cx
	push	bx
	mov	dx,cx			; count in dx
	sub	ax,ax			; upcall to get buffer
	stc
	push	ax
	pushf
	call	cs:[bx].ddcb
	pop	bx
	or	bx,bx
	jz	lph_1
	add	sp,2
lph_1:
	pop	bx
	pop	cx
	pop	si			; note popping buffer into di
	mov	dx,es			; null pointer?
	or	dx,di
	jz	lphe			; yes, discard packet
;	cmp	ax,cx			; validate the length
;	ja	cok
;	mov	cx,ax			; else use their length if they
					; don't have a big enough buffer
cok:
	push	es			; save their buf
	push	di
	push	cx
	rep	movsb
	pop	cx
	pop	si			; move it to ds:si for the upcall
	pop	ds
	mov	ax,1     		; set up for second upcall
	clc	
	push ax
	pushf
	call	cs:[bx].ddcb		; and do it
	pop	bx
	cmp	bx,1
	jz	lph_2
	add	sp,2
lph_2:
	push	cs			; now restore our segment
	pop	ds
	push	cs
	pop	es
	clc
	ret

lphe:
	pushf
	call	stat_packlost		; couldn't upload packet, update
					; stats
	push	cs
	pop	es
	push	cs			; in case they were mean and killed it
	pop	ds
	popf
	ret
listedprothandler ENDP
;
; raw serial mode?
;
; note: not currently supported
;
israw	PROC
ifdef RAW
	cmp	[rcvmode],7
	jz	israwok
endif
	mov	al,BAD_MODE
	stc
israwok:	
	ret
israw	ENDP
;
; find a user signal handler
;
find_sigcall PROC
	mov	bx,offset cgroup:sigtab	; sigtab
	mov	cx,MAXSIGCALLS		; signal handler count
ful:
	cmp	[bx],ax			; check for it
	jnz	fu_nothere
	cmp	[bx+2],dx
	jz	fu_x
fu_nothere:
	loop	ful
	stc				; not found
fu_x:
	ret				; or found
find_sigcall ENDP
;
; we call this when they want to drop an async packet
;
dropas PROC
	mov	cl,[iocb_count]		; get count
	sub	ch,ch
	jcxz	nodrop			; exit if none
	mov	si,offset cgroup:IOCB
ephdl:
	cmp	word ptr [si],ax	; this the packet
	jnz	ephdnf
	cmp	word ptr [si+2],dx
	jz	dodropas		; yes, drop it
ephdnf:
	add	si,4			; else next
	loop	ephdl

nodrop:
	clc				; exit
	ret
dodropas:
	cmp	si,offset cgroup:IOCB		; see if first in list
	jnz	ddc
    	and	[packetflags],NOT PF_PKTASYNC ; if so we mark it already dropped
ddc:
	push	es			; located a packet, flag it done
	mov	es,dx
	mov	bx,ax
	or	es:[bx].ic_flags,IOCB_DONE
	pop	es
	jmp	findrop
dropas ENDP
;
; the transmit routines call this to drop a packet and notify the
; owner
;
asyncdrop PROC
	les	di,[iocb]		; use first IOCB
	or	es:[di].ic_flags,IOCB_DONE	; tell done
	test	es:[di].ic_flags,IOCB_UPCALL ; see if they have an upcall
	jz	noasupcall		; branch if no upcall
	push	ds
	push	es
	call	es:[di].ic_upcall	; else take upcall
	pop	es
	pop	ds
noasupcall:
	mov	si,offset cgroup:iocb		; use first IOCB
	mov	cl,[iocb_count]		; CX = count
	sub	ch,ch	
	; fall through
endp
;
; common routine to get rid of an async packet
;
findrop PROC
	push	cs
	pop	es
	dec	cx             		; one less
	mov	[iocb_count],cl		; save it
	mov	di,si			; move the rest down
	add	si,4
	add	cx,cx
	rep	movsw
	ret
findrop ENDP
;
; translates common ethernet MAC header types to PPP types
;
xlateEtype PROC
	cmp	dx,ELT_IP		; IP?
	jnz	xetx
	mov	dx,IP_PROTOCOL
	ret
xetx:
	ret
xlateEtype ENDP
;
; called to split the MAC or PPP header out of the packet
; and copy it to our buffer, with compression as needed
;
sendparams PROC
	test	cs:[clflags],E_OPTION	; playing at ethernet
	jz	normppp			; no, go strip PPP stuff
	mov	dx,[si+12]		; get the type from the MAC header
	add	si,14			; skip the MAC header
	sub	cx,14			;
	call	xlateEtype
	cmp	dx,ELT_ARP
	jnz	sxl
	jmp	arp_handler		; this will restore DS
normppp:
	cmp	word ptr [si],03ffh	; Has an address field?
	jnz	sp_noadrcomp
	lodsw
	sub	cx,2
sp_noadrcomp:
	lodsw
	mov	dx,ax		; dx = proto field
	xchg	dl,dh
	sub	cx,2		; cx = len
sxl:
	mov	di,offset cgroup:xmbuf		; copy the packet to our buff
	push	di
	push	cx
	rep	movsb
	pop	cx
	pop	si
	push	cs				; restore our ds
	pop	ds
	push	si
	call	bootp_handler
	pop	si
	jc	sp_nosend
	push	bp				; do compression
	call	vjcompress
	pop	bp
	mov	ax,dx
	clc
sp_nosend:
	ret
sendparams ENDP
;
; see if there are any async buffers to be sent
; called by transmit routines
;
asyncbuf PROC
	mov	cl,[iocb_count]		; any?
	sub	ch,ch
	jcxz	noab			; no exit
	lds	si,[iocb]
	mov	cx,[si].ic_length	; yes, do setup
	call	sendparams
	jnc	abx			; see if actually transmitting
    	call	asyncdrop		; no, was ARP or BOOTP, just drop
	jmp	asyncbuf		; it
noab:
	stc
abx:
	ret
asyncbuf ENDP
;
; packt driver interface functions
;
;
; return driver info
;
epb_driver_info	PROC
	mov	[bp]._BX,VERSION
	mov	ah,[p_class]
	sub	al,al
	mov	[bp]._CX,ax
	sub	ax,ax
	mov	al,[p_type]
	mov	[bp]._DX,ax
	mov	[bp]._AL,255		; Not installed
	mov	[bp]._DS,CS
	mov	[bp]._SI,offset cgroup:drivername
	call	interfaceup
	jc	notinstalled
ifdef EXTENDED
	mov	[bp]._AL,2	; basic and extended
else
	mov	[bp]._AL,1	; basic
endif
				; we don't actually support EVERYTHING!!!!
notinstalled:
	clc
	ret
endp
;
; open a channel to driver
;
epb_access_type	PROC
	mov	al,[p_class] 		; correct class?
	cmp	[bp]._AL,al
	jnz	ea_badclass		; no, error
	cmp	[bp]._BX,-1		; default type?
	jz	ea_oktype		; yes, continue
	mov	al,[p_type]		; match our type?
	sub	ah,ah
	cmp	[bp]._BX,ax
	jnz	ea_badtype		; no,error
	cmp	[bp]._DL,0		; default num?
	jnz	ea_badnum		; nope
	mov	al,[p_addressize]	; correct address size?
	sub	ah,ah
	cmp	[bp]._CX,ax
	jnz	ea_badppptype		; no, error
ea_oktype:
	push	es			; get the address
	mov	es,[bp]._DS
	mov	bx,[bp]._SI
	mov	dx,es:[bx]		; get PPP/MAC type field
	test	[clflags],E_OPTION	; ethernet type?
	jz	ea_ppp			; no, PPP type

	call	xlateEtype		; get the PPP type
ea_ppp:
	pop	es
	call	scan_for_type		; find it
	jnc	ea_typeinuse		; found, is being used
	call	find_free_handle	; else find a handle
	jc	ea_nospace		; none, no free space
	mov	[bp]._AX,BX		; save handle for them
	ret
ea_nospace:
	mov	al,NO_SPACE
	stc	
	ret

ea_typeinuse:
	mov	al,TYPE_INUSE
	stc
	ret
ea_badclass:
	mov	al,NO_CLASS
	stc
	ret
ea_badtype:
	mov	al,NO_TYPE
	stc
	ret
ea_badnum:
	mov	al,NO_NUMBER
	stc
	ret
ea_badppptype:
	mov	al,BAD_TYPE
	stc
	ret
endp
;
; close driver channel
;
epb_release_type	PROC
	call	find_handle 		; find the handle
	jc	norelease		; ignore this if not 
	mov	[bx].ddflags,0		; else mark as free
norelease:
	ret
endp
;
; synchronous packet send...
;
; well actually as soon as we move to an internal buffer we return
;
epb_send_pkt	PROC
	call	interfaceup		; bail with an error if not up
	jc	sp_cant
	mov	ds,[bp]._DS
	mov	si,[bp]._SI
	mov	cx,[bp]._CX
	call	sendparams		; set up the I/O
	jc	sp_x			; don't transmit if we handled
					; it as ARP or BOOTP
	call	StartXmit		; transfer to an internal buf
	  				; and send it out.
sp_x:
	clc
	ret
sp_cant:
	mov	al,CANT_SEND
	stc
	ret
endp

;
; terminate the driver
;
epb_terminate	PROC
;	call	count_handles		; can't terminate if they didn't close
;	or	ax,ax
;	jnz	noterm
;	call	logrundown
	call	hangup			; hang up the modem
	call	unhookvects		; unhook us
	call	termisr			; shut down the COMM port
	call	freemem			; clear out the memory
	clc
	ret
noterm:
	mov	al,CANT_TERMINATE
	stc
	ret
endp
;
;
epb_get_address	PROC
	mov	es,[bp]._ES		; get address buf
	mov	di,[bp]._DI
	test	[clflags],E_OPTION	; see if ethernet
	jz	ga_ppp
	cmp	[bp]._CX,6		; ethernet, did they leave enough space
	jc	ga_ns
	call	arp_ouraddress		; yes, get address
	mov	[bp]._CX,6		; return len
	clc
	ret
ga_ppp:
	cmp	[bp]._CX,1		; ppp, did they leave space?
	jc	ga_ns			; no error
	mov	[bp]._CX,1		; yes, length = 1
	mov	byte ptr es:[di],0ffh	; address is always ffh for PPP
	push	cs
	pop	es
	clc
	ret
ga_ns:
	mov	al,NO_SPACE
	stc
	ret
endp
;
; reinitialize
;
epb_reset_interface	PROC
;	call	count_handles		; can only have one handle open
;	cmp	ax,2
;	jnc	nores
	mov	[iocb_count],0		; kill iocbs
	call	ClearAllBufs
	mov	di,offset cgroup:sigtab	; kill off signal handlers
	mov	cx,MAXSIGCALLS*2
	sub	ax,ax
	rep	stosb
	clc
	ret
nores:
	mov	al,CANT_RESET
	stc
	ret
endp
;
; high performance - get params
;
eph_get_parameters 	PROC
	mov	[bp]._DI,offset cgroup:gpb	; just return a pointer
	mov	[bp]._ES,cs
	clc
	ret
endp
;
; old as_send_packet
;
eph_old_as_send_pkt	PROC
	mov	al,BAD_COMMAND		; we don't support this :)
	stc
	ret
endp
;
; asynchronous send
;
eph_as_send_pkt	PROC
	call	interfaceup		; interface up
	jc	as_nosend		; get out if not
	cmp	[iocb_count],MAX_IOCBS	; table full?
	jnc	as_nosend		; get out if so
	cli
	mov	bl,[iocb_count]		; fill next entry in table
	inc	[iocb_count]
	sub	bh,bh
	add	bx,bx
	add	bx,bx
	mov	ax,[bp]._DI
	mov	word ptr [iocb+bx],ax
	mov	ax,[bp]._ES
	mov	word ptr [iocb+bx+2],ax
	call	isxmitdone		; start a transmit if necessary
	jz	noresend
	call	sendfirstbyte
noresend:
	sti
	clc
	ret
as_nosend:
	mov	al,CANT_SEND
	stc
	ret
endp
;
; packet drop
;
eph_drop_pkt	PROC
	mov	ax,[bp]._DI	; get the packet addr
	mov	dx,[bp]._ES
	call	dropas		; go drop it
	clc
	ret
eph_drop_pkt ENDP
;
; bad commands come here
epb_bad_packettype PROC
	mov	al,BAD_COMMAND
	stc
	ret
epb_bad_packettype ENDP
;
; set receive mode for this handle
;

epe_set_rcv_mode	PROC
	call	find_handle
	jc	srm_nohand		; error if no handle
ifdef RAW
	mov	ax,[bp]._CX
	cmp	ax,8
	jnc	srmbadmode
	cmp	ax,2
	jc	srmbadmode
	mov	[rcvmode],ax
	ret
endif
srmbadmode:
	mov	al,BAD_MODE	; not supporting this function
	stc
srm_nohand:
	ret
endp
;
; return receive mode
epe_get_rcv_mode	PROC
	call	find_handle		; err if no handle
	jc	grm_nohand
	mov	ax,[rcvmode]
	mov	[bp]._AX,ax	; mode is always 3...
	clc
grm_nohand:
	ret
endp
;
; multicast, not supported
;
epe_set_multicast_list	PROC
endp
epe_get_multicast_list	PROC
	mov	al,NO_SPACE
	stc
	ret
endp
;
; get statistics
;
epe_get_statistics	PROC
	mov	[bp]._DS,ds
	mov	[bp]._SI,offset cgroup:stats
	clc
	ret
endp
;
; can't set our address
;
epe_set_address	PROC
	mov	al,CANT_SET
	stc
	ret
endp
;
; raw functions not supported
;

epe_send_raw_bytes	PROC
	call	israw
	jc	srbx

srbx:
	ret
endp

epe_flush_raw_bytes	PROC
	call	israw
	jc	frbx

frbx:
	ret
endp

epe_fetch_raw_bytes	PROC
	call	israw
	jc	ferbx

ferbx:
	ret
endp
;
; signal gatherer
;
epe_signal	PROC
	mov	al,[bp]._AL	; get type
	cmp	al,5		; only doing up and down types 1 & 2
	jnc	badsig
	or	al,al
	jz	badsig
	cmp	al,1
	jz	sru
	cmp	al,2
	jz	srd
	clc          		; ignoring types 3 & 4
				; bad siognal for the rest
	ret
sru:
	sub	ax,ax		; new signal, find free
	sub	dx,dx
	call	find_sigcall
	jc	es_nospace	; err if none
	mov	ax,[bp]._DI	; save their handler
	mov	[bx],ax
	mov	ax,[bp]._ES
	mov	[bx+2],ax
	ret
srd:
	mov	dx,[bp]._ES	; old sig, find it
	mov	ax,[bp]._DI
	call	find_sigcall
	jc	badupcall	; err if none
	mov	word ptr [bx],0	; clear it
	mov	word ptr [bx+2],0
	ret

badupcall:
badsig:
	mov	al,BAD_MODE
   	stc
	ret
es_nospace:
	mov	al,NO_SPACE
	stc
	ret
	
endp

epe_get_structure	PROC
endp
;
; packt driver function table;
;
functab	label	word     
;
; basic
;                          
	dw	epb_driver_info
	dw	epb_access_type
	dw	epb_release_type
	dw	epb_send_pkt
	dw	epb_terminate
	dw	epb_get_address
	dw	epb_reset_interface
	dw	epb_bad_packettype
	dw	epb_bad_packettype
;
; high performance
;
	dw	eph_get_parameters
	dw	eph_old_as_send_pkt
	dw	eph_as_send_pkt
	dw	eph_drop_pkt
	dw	epb_bad_packettype
	dw	epb_bad_packettype
	dw	epb_bad_packettype
	dw	epb_bad_packettype
	dw	epb_bad_packettype
	dw	epb_bad_packettype
ifdef EXTENDED
;
; everything after this is extended, might implement it some day :)
;
	dw	epe_set_rcv_mode
	dw	epe_get_rcv_mode
	dw	epe_set_multicast_list
	dw	epe_get_multicast_list
	dw	epe_get_statistics
	dw	epe_set_address
	dw	epe_send_raw_bytes
	dw	epe_flush_raw_bytes
	dw	epe_fetch_raw_bytes
	dw	epe_signal
	dw	epe_get_structure
endif
TOP_OF_FUNCTAB LABEL BYTE

;
; packet driver entry point (interrupt)
;
packetint	PROC
	jmp	short pktint2		; jump to the actual int
	nop
pdmsg:
	db	"PKT DRVR",0		; identify us
pktint2:
	test	cs:[reentrant],-1	; don't switch stacks if reentry
	jnz	nostacksw
	mov	word ptr cs:[their_stack+2],ss ; save their stack
	mov	word ptr cs:[their_stack],sp
	mov	sp,cs			; switch to ours
	mov	ss,sp
	mov	sp,offset cgroup:local_stack
nostacksw:
	inc	cs:[reentrant]		; update reentrancy count
	sti       			; ints enabled now
	push	ds			; push regs, PLEASE
	push	es			; keep the regs structures in sync!!!
	push	ax
	push	bx
	push	cx
	push	dx
	push	si
	push	di
	push	bp			; BP must be last
	mov	bp,sp			; point to stack frame
	mov	bx,cs			; now set to our seg regs
	mov	ds,bx
	mov	es,bx
	mov	bl,ah			; bx = function
	sub	bh,bh
	mov	al,BAD_COMMAND		; assume bad command
	dec	bx			; function zero not allowed
	stc
	js	pktenerr
	cmp	bx,(TOP_OF_FUNCTAB-functab)/2	; number of functions supported
	cmc
	jc	pktenerr
	mov	al,[bp]._AL		; valid function, reload AL
	shl	bx,1			; and call the function
	call	[functab+bx]
	jnc	pktx			; see if function return error
	jmp	doerr			; else have an error
pktenerr:
	cmp	bx,RECONNECT_EXTENSION-1; see if is reconnect
	jnz	doerr			; nope, do error
;
; this probably isn't clean enough but we will see...
;
      	call	connect			; connect
	jnc	pktx			; exit if no error
	mov	al,CANT_SET		; else error = CANT_SET
doerr:
	mov	[bp]._DH,al		; yes save it
	stc
pktx:
	pop	bp			; pop all regs
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	bx
	pop	ax
	pop	es
	pop	ds
	dec	cs:[reentrant]		; dec reentrancy (doesn't affect CARRY)
	jnz	noreswitch		; get out if was reentrant call
	cli				; clear interrupts for 8086 stack switch
	mov	ss,word ptr cs:[their_stack + 2]
	mov	sp,word ptr cs:[their_stack]	; restore their stack
	sti
noreswitch:
	retf    02			; return to caller
	
packetint	ENDP
TSR	ends
CONFIG segment byte public 'CODE'
;
; routine to init the packet driver
;
pkt_init PROC
	test	[clflags],E_OPTION
	jnz	ethernet
	mov	[p_class],PPP_CLASS
	mov	[p_type],PPP_TYPE
	mov	[gp_addr_len],1
	ret
ethernet:
	mov	[p_class],ETHERNET_CLASS
	mov	[p_type], ETHERNET_TYPE
	mov	[gp_addr_len],6
	ret
pkt_init ENDP
config ENDS
	end