
/*
Name:               track1.c
Processor:          Intel 80xxx
Platform:           IBM PC
Compiler:           BC v3
Compiler Directive: Autolink
Creation Date:      7 July 99
Author:             I Parker
Version:            1.04
Bugs:               none known
Description:        config/tracking encryption 
Usage:              track1 [-enc/-dec/-size] <file + extension> 
Status:             freeware use this code at your own risk I accept no liability
Revision History:   put in function to find file size
                    routine put in to stop data being encrypted by zero
                    changed offset and made it dynamicely change for every file used
Notes:              The principal is the program selects a number of bytes down your
                    file and uses them as an encryption key.  
                    This program is used to track who's distributing your software.                    files onto the end of your program.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define BUFSIZE 45

void encode(filename)
char *filename;

{

FILE *source;
int cnt_1,cnt_2,cnt_3;
char buf_key[BUFSIZE];
char buf_data[] = ".............................................";
char encrypt[BUFSIZE];
char chr,chr1,ch;
unsigned long int last;
unsigned long offset;

if((source = fopen(filename, "rb+"))==NULL)
   {
   fprintf(stderr,"\n Couldn't open file \"%s\".\n",filename);
   exit(1);
   }

printf("\nEnter your data no more than 45 characters\n:-");
gets(buf_data);                                             /* get data to encrypt */

for(cnt_1 = 0; cnt_1 <= BUFSIZE; cnt_1++)             /* pad date to BUFSIZE bytes */
   if(buf_data[cnt_1] == '\0')
   buf_data[cnt_1] = '.';            /* note this is the same as the fill buf_data */

buf_data[BUFSIZE] = '\0';

fseek(source,0L,SEEK_END);                  /* this calculates where the offset is */
last = ftell(source);
offset = last / 3 ;

fseek(source,offset,SEEK_SET);                      /* get key and terminate array */
fread(buf_key,(BUFSIZE),1,source);

for(cnt_3 = 0; cnt_3 <= BUFSIZE; cnt_3++) /* routine to stop data being encrypted by 0 */
    if(buf_key[cnt_3] == 0x00)
      {
      buf_key[cnt_3] = 0x24;
      }
buf_key[BUFSIZE] = '\0';

for(cnt_2 = 0; cnt_2 <= BUFSIZE; cnt_2++)                               /* encrypt */
   {
   chr = buf_data[cnt_2];
   ch = buf_key[cnt_2];
   encrypt[cnt_2] = chr ^ ch;
   }
encrypt[BUFSIZE] = '\0'; /* this puts an end of array chr on the end of encrypt array */

fseek(source,0L,SEEK_END);                        /* point to end of file and write */
fwrite(encrypt,BUFSIZE,1,source); 

fclose(source);
}


void decode(filename)
char *filename;
{
FILE *source;
int cnt_1,cnt_2,cnt_3;
char buf_key[BUFSIZE];
char buf_data[BUFSIZE];
char encrypt[BUFSIZE];
char chr,ch;
unsigned long last;
unsigned long offset;

if ((source = fopen(filename, "rb")) == NULL)
   {
   fprintf(stderr,"can't open file \"%s\".\n",filename);
   exit(2);
   }

fseek(source,-BUFSIZE,SEEK_END);                  /* set file pointer to end of file */
fread(buf_data,(BUFSIZE),1,source);
buf_data[BUFSIZE] = '\0'; /* this puts an end of array character in the last position */

fseek(source,0L,SEEK_END);                            /* routine to find key position */
last = ftell(source);
offset = (last - BUFSIZE) / 3;

fseek(source,offset,SEEK_SET);
fread(buf_key,(BUFSIZE),1,source);

for(cnt_3 = 0; cnt_3 <= BUFSIZE; cnt_3++)  /* routine to stop data being encrypted by 0 */
   if(buf_key[cnt_3] == 0x00)
      {
      buf_key[cnt_3] = 0x24;
      }
buf_key[BUFSIZE] = '\0';

for(cnt_2 = 0; cnt_2 <= BUFSIZE; cnt_2++)                  /* decrypt routine */ 
   {
   chr = buf_data[cnt_2];
   ch = buf_key[cnt_2];        
   encrypt[cnt_2] = chr ^ ch;
   encrypt[BUFSIZE] = '\0';                      /* puts a terminator at end of array */
   }
printf("\n %s",encrypt);

close(source);
}

void size(filename)
char *filename;
{
FILE *source;
unsigned long int last;
if((source = fopen(filename, "r"))==NULL)
   {
   fprintf(stderr,"\n Couln't open file \"%s\".\n",filename);
   exit(3);
   }
fseek(source,0L,SEEK_END);
last = ftell(source);
printf("\n filesize is %ld bytes\n", last);
fclose(source);
}

void prompt(void)
{
   printf ("\n\n\n track by I Parker V1.04");
   printf("\n\n\n Usage:-track [-dec/-enc/-size] <file name>");
   printf("\n\n\n  dec - decode \n  enc - encode \n file - name with extension");
   printf("\n size - size of file in bytes");
   exit(0);                                                /* stops program execution */
}

int main(int argc, char *argv[])
{

if (argc < 2)
prompt(); 
if (argc > 3)
prompt();  
if(strcmp(argv[1], "-enc") == 0)
   {
   encode(argv[2]);
   }
else if(strcmp(argv[1], "-dec") == 0)
   {
   decode(argv[2]);
   }
else if(strcmp(argv[1], "-size")==0)
   {
   size(argv[2]);
   }
else if (strcmp(argv[1], argv[1]) == 0)
prompt();
}


