#ifndef __dga_driver__
#define __dga_driver__

// By defining DGA_INTERNAL this driver can be linked with your program
#ifdef DGA_INTERNAL
#define detect      dga_detect
#define set_mode    dga_set_mode
#define blit        dga_blit
#define get_image   dga_get_image
#define deinit      dga_deinit
#define get_pointer dga_get_pointer
#define get_key     dga_get_key
#define set_pal     dga_set_pal
extern Driver dga_driver;
#endif

int   detect(void);
int   set_mode(char *, int, int, int);
void  blit(Image *, signed int x, signed int y);
void  get_image(Image *, signed int x, signed int y);
void  deinit(void);
char  get_pointer(int *x, int *y);
char  get_key(void);
void  set_pal(rgb *pal);

#endif
