
/* ---------------------------------------------------------------------*/
/*									*/
/*	MOUKEY v1.0 for C/C++						*/
/*	Mouse routines							*/
/*									*/
/*	MOUSE.H: header file						*/
/*									*/
/*	May 1997							*/
/*									*/
/*	Copyright (c) 1997 Tanescu A. Horatiu				*/
/*									*/
/* ---------------------------------------------------------------------*/

#if !defined (__MOUSE_H)
#define __MOUSE_H

/* Macros used to get mouse buttons pressed information
 */

#define mouseLPressed	(mouseButtons & 1)	// left button pressed
#define mouseRPressed	(mouseButtons & 2)	// right button pressed
#define mouseMPressed	(mouseButtons & 4)	// middle button pressed

/* Macros used to convert between virtual and text coordinates
 */

#define MAKE_FP(seg, off)	((void _seg *)(seg) + (void near *)(off))
#define memW(seg, off)		*((unsigned int  far*)MAKE_FP(seg, off))

#define textX(x)		(x/ (640/ memW(0x0040, 0x004A) ) + 1)
#define textY(y)		(y/ 8 + 1)
#define virtualX(x)		((x - 1) * (640/ memW(0x0040, 0x004A) ))
#define virtualY(y)		((y - 1) * 8)

/* Graphic cursor shape structure used by mouseSetGraphCursor
 */

typedef struct
{
  char gc_hotx;			/* hotspot X value		*/
  char gc_hoty;			/* hotspot Y value		*/
  int  gc_masks[2][16];		/* screen and cursor mask	*/
} graphcursor;

/* Large graphic cursor shape structure used by mouseLargeGraphCursor
 */

typedef struct
{
  char      lgc_width;		/* width (in words) of the masks	*/
  char      lgc_height;		/* rows in cursor			*/
  char      lgc_hotx;		/* hotspot X value			*/
  char      lgc_hoty;		/* hotspot Y value			*/
  void far* lgc_masks;		/* pointer to screen and cursor masks	*/
} largegraphcursor;

/* Mouse information structures
 */

typedef struct
{
  unsigned char majorver;	/* mouse driver major version		*/
  unsigned char minorver;	/* mouse driver minor version		*/
  unsigned char mousetype;	/* mouse type (bus, serial, etc.)	*/
  unsigned char IRQ;		/* mouse IRQ number			*/
  char far* inifile;		/* mouse initialization (.INI) file	*/
  char far* copyright;		/* mouse driver copyright string	*/
  char far* version;		/* mouse driver version string		*/
} mouse_info;

typedef union
{
  struct
  {
    unsigned notused       : 8;	/* not used				*/
    unsigned interruptrate : 4; /* interrupt rate			*/
    unsigned cursortype    : 2; /* cursor type (graphic, text, etc.)	*/
    unsigned newdrivertype : 1;	/* mouse driver type			*/
    unsigned devicedrv     : 1;	/* mouse driver type (device or TSR)	*/
  } info;
  unsigned int infoint;
} mouse_miscinfo;

/* Mouse handler type definition
 */

typedef void huge (*mousehandler)();

/* Variables */

extern int mouseInstalled;		/* mouse installed flag		*/
extern unsigned int mouseButtonCount;	/* number of mouse buttons	*/
extern int mouseX, mouseY;		/* mouse cursor coordinates	*/
extern int mouseButtons;		/* mouse buttons state		*/

/* Functions prototypes */

#ifdef __cplusplus
extern "C" {
#endif

int          mouseReset(void);
void         mouseShow(void);
void         mouseHide(void);
int          mouseRead(void);
void         mouseTo(int x, int y);
int          mouseGetDown(int button, int* lastx, int* lasty);
int          mouseGetUp(int button, int* lastx, int* lasty);
void         mouseSetXRange(int minc, int maxc);
void         mouseSetYRange(int minr, int maxr);
void         mouseSetGraphCursor(graphcursor *gc);
void         mouseSetTextCursor(int scrmask, int curmask);
void         mouseSetHardCursor(int firstln, int lastln);
void         mouseReadMove(int* xmoves, int* ymoves);
void         mouseSetHandler(int mask, mousehandler handler);
void         mouseLightPenEmulationOn(void);
void         mouseLightPenEmulationOff(void);
void         mouseSetMickeyRatio(int x, int y);
void         mouseSetUpdateRegion(int left, int top, int right, int bottom);
int          mouseLargeGraphCursor(largegraphcursor *lgc);
void         mouseSetThreshold(int threshold);
mousehandler mouseExchangeHandler(int mask, mousehandler handler, int* oldmask);
int	     mouseDriverStateSize(void);
void         mouseSaveDriverState(int bufsize, void* buf);
void         mouseRestoreDriverState(int bufsize, void* buf);
int          mouseSetAlternateHandler(int mask, mousehandler handler);
mousehandler mouseGetAlternateHandler(int mask);
void         mouseSetSensitivity(int horiz, int vert, int threshold);
void         mouseGetSensitivity(int *horiz, int *vert, int *threshold);
void         mouseSetInterruptRate(int rate);
void         mouseSetPage(int page);
int          mouseGetPage(void);
void far*    mouseDisable(void);
int          mouseEnable(void);
int          mouseSoftReset(void);
void         mouseSetLanguage(int language);
int          mouseGetLanguage(void);
unsigned     mouseGetInfo(mouse_info *info);
int          mouseMinX(void);
int          mouseMinY(void);
int          mouseMaxX(void);
int          mouseMaxY(void);
void         mouseGetMaxXY(int *minx, int *miny, int *maxx, int *maxy);
void         mouseGetHotSpot(int *hotspotx, int *hotspoty);
char         mouseState(void);

#ifdef __cplusplus
}
#endif

#endif // __MOUSE_H