/*
 * IDtag: making an .obj file
 * for putting messages into an executable module
 * (You can do the same thing with
 * #pragma comment (exestr, "string")
 * on MSC 5.1 or later)
 * Copyright (c) 1990 by Kenji Rikitake <kenji@ybbs.c.u-tokyo.ac.jp>
 * You can use this source code and the executable module for any purpose
 * provided retaining this notice within.
 *
 * Version 1.00 January 15, 1990
 */

/*
 * PD getopt.c from UUPC interim version
 */

#include <stdio.h>
#include <string.h>
#include "getopt.h"

#define FALSE 0
#define TRUE 1

#define PATHLEN 132

#define R_THEADR 0x80
#define R_COMENT 0x88
#define R_MODEND 0x8a

#define COMCLASS_LANGUAGE 0x00
/* Hmmmm, you can't find this in MS-DOS Encyclopedia */
#define COMCLASS_EXESTR 0xa4
#define COMAT_NOPURGE 0x80
#define COMAT_NOLIST 0x40

char modname[PATHLEN];
char objname[PATHLEN];
char srcname[PATHLEN];
FILE *srcfp, *objfp;

char version[] = "1.00";

void write_obj_record(char type, int len, char *body)
{
	int chksum;
	register int i, c;
	
	chksum = 0;

	putc(type, objfp);
	chksum += type;
	chksum &= 0x00ff;
	
	len++;
	
	c = len & 0x00ff;
	putc(c, objfp);
	chksum += c;
	chksum &= 0x00ff;
	
	c = (len >> 8) & 0x00ff;
	putc(c, objfp);
	chksum += c;
	chksum &= 0x00ff;
	
	len--;
	
	for (i = 0; i < len; i++) {
		c = *body++;
		putc(c, objfp);
		chksum += c;
		chksum &= 0x00ff;
		}
	
	c = 0x0100 - chksum;
	putc(c, objfp);

	return;
}

int main(int argc, char *argv[])
{
	int option;
	int nolist;
	char comment_attrib;
	int i;
	static char buf[BUFSIZ];
	
	nolist = TRUE;
	
	strcpy(modname, "IDtag_output");
	strcpy(objname, "idtagout.obj");
	
	while ((option = getopt(argc, argv, "lm:o:")) != EOF)
		switch (option) {
		case 'l':
			nolist = FALSE;
			break;
		case 'm':
			strcpy(modname, optarg);
			break;
		case 'o':
			strcpy(objname, optarg);
			break;
		case '?':
			printf("idtag Version %s by Kenji Rikitake\n", version);
			puts("Usage: idtag [-l] [-m module-name] [-o objfile-name] comment-file");
			return -1;
		default:
			puts("idtag: getopt error");
			return -2;
		}

	strcpy(srcname, argv[optind]);
	
	if (nolist) {
		comment_attrib = COMAT_NOPURGE | COMAT_NOLIST;
		}
	else {
		comment_attrib = COMAT_NOPURGE;
		}
	
	if ((objfp = fopen(objname, "wb")) == NULL) {
		fprintf(stderr, "idtag: can't open output file \"%s\"\n", objname);
		exit(-1);
		}
	
	i = strlen(modname);
	buf[0] = i & 0x00ff;
	strcpy((buf + 1), modname);
	write_obj_record(R_THEADR, strlen(buf), buf);
	
	buf[0] = COMAT_NOPURGE | COMAT_NOLIST;
	buf[1] = COMCLASS_LANGUAGE;
	sprintf((buf + 2), "This comment created by Kenji's IDtag %s", version);
	
	write_obj_record(R_COMENT, 2 + strlen(buf + 2), buf);
	
	if ((srcfp = fopen(srcname, "rb")) == NULL) {
		fprintf(stderr, "idtag: can't open source file \"%s\"\n", srcname);
		exit(-1);
		}
	
	buf[0] = comment_attrib;
	buf[1] = COMCLASS_EXESTR;
	
	for ( ; ; ) {
		if (fgets((buf + 2), (BUFSIZ - 2), srcfp) == (char *)NULL) {
			break;
			}
		write_obj_record(R_COMENT, 2 + strlen(buf + 2), buf);
		}
	
	fclose(srcfp);
	
	buf[0] = 0x00;
	write_obj_record(R_MODEND, 1, buf);
	
	fclose(objfp);
	exit(0);
	return;
}
