#open "graphics";;
#open "sorts";;

let random_array n =
  let v = make_vect n 0 in
  for i = 0 to n-1 do v.(i) <- random__int 10000 done;
  v
;;

let copy_array t =
  sub_vect t 0 (vect_length t)
;;

let run_sort name sort_fun array =
  print_string name; print_string "..."; print_newline();
  record__start name;
  sort_fun (copy_array array);
  record__stop()
;;

let delay =
  if vect_length sys__command_line < 2
  then 0
  else begin try int_of_string sys__command_line.(1) with _ -> 0 end
;;

print_string "Collecting the traces..."; print_newline();;

let t = random_array 100;;

run_sort "Insertion" insertion_sort t;
run_sort "Selection" selection_sort t;
run_sort "ShellSort" shell_sort t;
run_sort "MergeSort" merge_sort t;
run_sort "HeapSort" heap_sort t;
run_sort "QuickSort" quick_sort t;;

let names =
    ["Insertion";"Selection";"ShellSort";"MergeSort";"HeapSort";"QuickSort"];;

open_graph "";;

playback__play t names delay;;

do_list sys__remove names;;

sound 440 200; read_key(); close_graph();;

