; GRAVITY.ASM
;     Optimized by Andy Kurnia <akur@iname.com>
; To make .COM, use TASM >= 3.2 and TLINK >= 5.1:
;     tasm /m9 gravity
;     tlink /t/x gravity
; PS. I'd like to know the e-mail addresses of
;     P. Hsieh, T. C. Andersen and D. Deganchi.

JUMPS
MULTERRS
WARN

.MODEL TINY
.386
.CODE

        ORG     100H
PROG:   MOV     AX, 13H
        INT     10H
        MOV     DI, O_XS
        MOV     CX, N_RN
RAND:   ADC     AX, [DI]
        AAM     33
        SUB     AL, 16
        CBW
        STOSW
        LOOP    RAND
        MOV     ES, DI
MAIN:   MOV     SI, O_XP
        MOV     AX, SI
        MOV     DX, 318
DRAW:   IMUL    DI, [SI + D_YP], 320
        XCHG    BX, AX
        LODSW
        XCHG    BX, AX
        LEA     DI, [BX + DI + 32160]
        STOSB
        ADD     DI, DX
        STOSW
        STOSB
        ADD     DI, DX
        STOSB
        DEC     AH
        DEC     AL
        JNZ     DRAW
        MOV     AH, 86H
        CWD
        INT     15H
ERAS:   STOSB
        LOOP    ERAS
        MOV     CL, 12
        MOV     SI, O_XS
MOVE:   LODSW
        SAR     AX, 1
        ADD     [SI - D_XS - 2], AX
        LOOP    MOVE
        MOV     CL, 2
CALC:   MOV     BX, 10
CA_A:   MOV     AX, [BX + SI + D_XS]
        CWD
        MOV     BP, 12
CA_B:   CMP     [BX + SI], DX
        JL      CA_C
        JZ      CA_D
CA_E:   DEC     AX
        DEC     AX
CA_C:   INC     AX
        CMP     AL, 30
        JG      CA_E
        CMP     AL, -30
        JL      CA_C
CA_D:   DEC     BP
        DEC     BP
        MOV     DX, [BP + SI]
        JNS     CA_B
        MOV     [BX + SI + D_XS], AX
        DEC     BX
        DEC     BX
        JNS     CA_A
        MOV     SI, O_YP
        LOOP    CALC
        MOV     AH, 1
        INT     16H
        JZ      MAIN
        MOV     AX, 3
        INT     10H
        INT     16H
        RET

        ORG     0DEEH
XSPD    DW      6 DUP (?)
YSPD    DW      6 DUP (?)
XPOS    DW      6 DUP (?)
YPOS    DW      6 DUP (?)

O_XP    EQU     OFFSET XPOS
O_YP    EQU     OFFSET YPOS
O_XS    EQU     OFFSET XSPD
D_YP    EQU     O_YP - O_XP
D_XS    EQU     O_XS - O_XP
N_RN    EQU     4909H

        END     PROG
