{$A+,B-,D-,E-,F+,G-,I-,L-,N-,O+,R-,S-,V-,X-}

{*********************************************************}
{*                     i286.pas 1.00                     *}
{*            Written by: David J. N. Begley.            *}
{*            Released into the public domain            *}
{*********************************************************}

unit i286;
  {-Intelligently exit if an Intel 80286 or higher is not detected}

interface

  {==========================================================================}

implementation

const
  CConfig : String[21] = 'i286 config data 1.00';
  CErrLvl : Byte       = 1;
  CErrMsg : String[80] = 'An 80286 or higher processor is required.';

var
  AIs286 : Boolean;

begin
  asm
    xor    ah, ah
    pushf
    pop    bx
    and    bx, 00FFFh
    push   bx
    popf
    pushf
    pop    bx
    and    bx, 0F000h
    cmp    bx, 0F000h
    je     @@1
    inc    ah
  @@1:
    mov    [AIs286], ah
  end;
  if not AIs286 then
    begin
      WriteLn(CErrMsg);
      Halt(CErrLvl)
    end
end.   { i286 }
