/*
	keys.h -- Definitions for keys

  Poor Man's Packet (PMP)
  Copyright (c) 1991 by Andrew C. Payne    All Rights Reserved.

  Permission to use, copy, modify, and distribute this software and its
  documentation without fee for NON-COMMERCIAL AMATEUR RADIO USE ONLY is hereby
  granted, provided that the above copyright notice appear in all copies.
  The author makes no representations about the suitability of this software
  for any purpose.  It is provided "as is" without express or implied warranty.

*/
/* ----- Keyboard Stuff ----- */

#define getkey()	((KEY) bioskey(0))
#define keypressed()	((int) bioskey(1))
#define shiftstat()	((int) bioskey(2))

#define scancode(x)	((x >> 8) &0xFF)
#define asciicode(x)	(x & 0xFF)

/* ----- IBM Function Key Scan codes ----- */

#define F1      0x3B00
#define F2      0x3C00
#define F3      0x3D00
#define F4      0x3E00
#define F5      0x3F00
#define F6      0x4000
#define F7      0x4100
#define F8      0x4200
#define F9      0x4300
#define F10     0x4400
#define HOME    0x4700
#define UP      0x4800
#define PGUP    0x4900
#define LEFT    0x4B00
#define RIGHT   0x4D00
#define END     0x4F00
#define DOWN    0x5000
#define PGDN    0x5100
#define INS     0x5200
#define DEL     0x5300
#define ESC     0x011B
#define RET     0x1C0D
#define BKS     0x0E08
#define SPC	0x3920
#define	PLUS	0x4E2B		/* keypad "+" */
#define MINUS	0x4A2D		/* keypad "-" */

#define	ALTX	0x2d00		/* ALT- keypresses */
#define ALTB	0x3000
#define ALTC	0x2e00
#define ALTD	0x2000
#define ALTH	0x2300
#define ALTJ	0x2400
#define ALTL	0x2600
#define ALTN	0x3100
#define ALTP	0x1900
#define ALTQ	0x1000
#define ALTS	0x1f00
#define ALTU	0x1600
#define ALTW	0x1100
#define ALTZ	0x2c00
