TARGET=C:\NWLITE\NLCNTL\SCOM1\SPOOLER
LIST
    print "PCPSCOM1.PAT - NetWare Lite COM1 characters per second patch.\n"
    rem "1/31/92"
VERIFY
    if (*0=34) AND (*1=12) then
        va = (12 / (*3)) * ((100 * (*5)) + (*4))
        print "  NetWare Lite Server COM1 port is currently configured for "
        rem "convert the value to decimal"
        rem "10000's"
        print va / 2710
        va = va % 2710
        rem "1000's"
        print va / 3E8
        va = va % 3E8
        rem "100's"
        print va / 64
        va = va % 64
        rem "10's"
        print va / A
        va = va % A
        rem "1's"
        print va,"\n"
        print "  Characters per second.\n"
    else
        print "  This NetWare Lite Server does not seem to be configured for\n"
        print "  an COM1 port.\n"
        stop
    endif
APPLY
    print "  Applying patch PCPSCOM1.PAT to NetWare Lite COM1 port configuration...\n"
    if (*0=34) AND (*1=12) then
        print "\n"
        print "    Select the value for printer Characters per second.\n"
        print "      1. Characters per second:   747\n"
        print "      2. Characters per second:  4095\n"
        print "      3. Characters per second:  8190\n"
        print "      4. Characters per second: 16380\n"
        print "      5. Characters per second: 32760\n"
        print "      6. Characters per second: 65520\n"
        print "      7. No Change\n"
        print "    Type the number (1-7) corresponding to the value you want: "
        va = getkey
        print "\n"
        if ((va < '1') or (va > '7')) then
            print "    The number must be between 1 and 7.  Type a number: "
            va = getkey
            print "\n"
        endif
        if (va='1') then
            rem "747 Characters per second, 2 tic interval"
            patch 3 ( 02 53 00 checksum 55)
        endif
        if (va='2') then
            rem "4095 Characters per second, 2 tic interval"
            patch 3 ( 02 C7 01 checksum CA)
        endif
        if (va='3') then
            rem "8190 Characters per second, 1 tic interval"
            patch 3 ( 01 C7 01 checksum C9)
        endif
        if (va='4') then
            rem "16380 Characters per second, 1 tic interval"
            patch 3 ( 01 8E 03 checksum 92)
        endif
        if (va='5') then
            rem "32760 Characters per second, 1 tic interval"
            patch 3 ( 01 1C 07 checksum 24)
        endif
        if (va='6') then
            rem "65520 Characters per second, 1 tic interval"
            patch 3 ( 01 38 0E checksum 47)
        endif
        if ((va < '1') or (va > '6')) then
            print "  No change made to current configuration.\n"
            stop
        endif
        write
        print "  NetWare Lite COM1 port configuration now contains patch PCPSCOM1.PAT.\n"
        stop
    else
        print "  Could not find pattern indicating that this NetWare Lite Server\n"
        print "  is configured for an COM1 port.  Make sure you are using this\n"
        print "  patch with NetWare Lite v1.00 printer configuration\n"
        print "  files.\n"
        stop
    endif

