
/****************************************************************************
*   Function:   int socko(char *host, char *service, char *protocol,        *
*                         int port, int nbios)                              *
*   Operation:  to open a socket connection to the specified host           *
*   Returns:    the number of an open socket descriptor, else -1 for error  *
*   Parameters: host, the name or dotted-address of host system             *
*               service, the name of a specific service or NULL if port > 0 *
*               protocol, either "udp" or "tcp"                             *
*               port:                                                       *
*                 if = 0; nothing special, use port# of server              *
*                 if > 0; bind a local reserved port                        *
*                 if < 0; it's the port# of server                          *
*               nbios, non-blocking i/o status                              *
*                 0 means non-blocking is turned off (or BLOCK)             *
*                 1 means non-blocking is turned on  (or NONBLOCK)          *
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <io.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include "sock_tk.h"

extern int errno;

/* library globals; available to calling program, if desired */

struct sockaddr_in socko_srvr_addr;
struct servent socko_srvr_info;
struct hostent socko_host_info;

/* local globals; available only to this file */

static int zero = 0;	/* used by ioctl() -> blocking */
static int one = 1;	/* used by ioctl() -> non-blocking */

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

int socko(host, service, protocol, port, nbios)
  char *host, *service, *protocol;
  int port, nbios;
{
  char msg[81];
  static int fd = -1;
  int resvport, i, rc;
  unsigned long inaddr;
  struct servent *sp;
  struct hostent *hp;
  struct protoent *pp;

  bzero((char *) &socko_srvr_addr, sizeof(socko_srvr_addr));
  socko_srvr_addr.sin_family = AF_INET;

  if (service != NULL) {
    for (i = 0; i <= strlen(service); i++) {	/* remove newlines */
      if (service[i] == '\n')
	service[i] = 0;
    }
    for (i = 0; i <= strlen(protocol); i++) {	/* remove newlines */
      if (protocol[i] == '\n')
	protocol[i] = 0;
    }
    if ((sp = getservbyname(service, protocol)) == NULL) {
      sprintf(msg, "socko(): unknown service: %s/%s", service, protocol);
      socke(msg);
      return (-1);
    }
    socko_srvr_info = *sp;
    if (port > 0)
      socko_srvr_addr.sin_port = htons(port);
    else
      socko_srvr_addr.sin_port = sp->s_port;
  } else {
    if (port <= 0) {
      sprintf(msg, "socko(): must specify either service or port");
      socke(msg);
      return (-1);
    }
    socko_srvr_addr.sin_port = htons(port);
  }

  for (i = strlen(host) - 1; i >= 0; i--)	/* remove newlines */
    if (host[i] == '\n' || host[i] == '\r')
      host[i] = 0;
  if ((int) (inaddr = inet_addr(host)) != INADDR_NONE) {	/* check if dot'd */
    bcopy((char *) &inaddr, (char *) &socko_srvr_addr.sin_addr, sizeof(inaddr));
    socko_host_info.h_name = NULL;
  } else {
    if ((hp = gethostbyname(host)) == NULL) {
      sprintf(msg, "socko(): host name error: %s", host);
      socke(msg);
      return (-1);
    }
    socko_host_info = *hp;
    bcopy(hp->h_addr, (char *) &socko_srvr_addr.sin_addr, hp->h_length);
  }

  if (port >= 0) {
    pp = getprotobyname(protocol);
    if (protocol[0] == 't') {
      fd = socket(AF_INET, SOCK_STREAM, (int) pp->p_proto);
    } else {
      fd = socket(AF_INET, SOCK_DGRAM, (int) pp->p_proto);
    }
    if (fd < 0) {
      sprintf(msg, "sockoa(): can't create %s socket", protocol);
      socke(msg);
      return (-1);
    }
  } else {
    if (port < 0) {
      resvport = IPPORT_RESERVED - 1;
      if ((fd = rresvport(&resvport)) < 0) {
	sprintf(msg, "socko(): can't get a reserved port");
	socke(msg);
	return (-1);
      }
    }
  }

  if (nbios == 0)
    rc = ioctl(fd, FIONBIO, &zero);	/* blocking */
  else
    rc = ioctl(fd, FIONBIO, &one);	/* non-blocking */

  if (rc < 0) {
    sprintf(msg, "socko(): can't set socket non-blocking status");
    socke(msg);
    close(fd);
    return (-1);
  }
  if (connect(fd, (struct sockaddr *) & socko_srvr_addr,
	      sizeof(socko_srvr_addr)) < 0) {
	sprintf(msg, "socko(): can't connect to server");
	socke(msg);
	close(fd);
	return (-1);
  }
  return (fd);
}
