/*--------------------------------------------------------------------------*
 * Gregory Stevens                                                   7/1/93 *
 *                               NNTEST2.C                                  *
 *                                                                          *
 *   This is a test file to test the nn*.c series with back-propagation.    *
 * for this file, the following parameters in the following files should be *
 * set:                                                                     *
 *      NNPARAMS.C : INPUT_LAYER_SIZE   1                                   *
 *                   OUTPUT_LAYER_SIZE  1                                   *
 *                   NUM_HIDDEN_LAYERS  0                                   *
 *                                                                          *
 *      NNINPUTS.C : NUM_PATTERNS  10                                       *
 *                                                                          *
 *      NNSTRUCT.C : InitNet()  ...should set output nodes as logistic...   *
 *                                                                          *
 *      NNBKPROP.C : EPSILON 0.25  (recommended...this is what I used)      *
 *                                                                          *
 *  Everything else can be left unchanged.  The input files should each     *
 * consist of five real numbers, where they are in matching order of input  *
 * and desired output.  The output of this file simply lists the input,     *
 * weight, output, threshhold, desired output.  It pauses at each training  *
 * epoch.                                                                   *
 *                                                                          *
 * NOTE: LOGISTIC UNITS TAKE _MUCH_ LONGER THAN LINEAR TO CONVERGE!!!!!!!   *
 *--------------------------------------------------------------------------*/
#include "nnbkprop.c"                /* to chain it to the nn*.c utilities  */
#include <math.h>                    /* for the exp() for logistic units    */

#define NUM_ITS 2000                 /* iterations before it stops          */

/*  MAIN PROGRAM  */
void main()
{
  int Pattern;                         /* for looping through patterns   */
  int Layer;                           /* for looping through layers     */
  int LCV;                             /* for looping training sets      */
  NNETtype Net;
  PATTERNtype InPatterns, OutPattern;

  Net = InitNet( NUMNODES );            /* initializes the network        */
  InPatterns = InitInPatterns(0);       /* loads input patterns from file */
  OutPattern = InitOutPatterns();       /* loads output patterns from file*/

  for (LCV=0; (LCV < NUM_ITS); ++LCV)   /* loop through a training set    */
    {
      for (Pattern=0; (Pattern<NUM_PATTERNS); ++Pattern)
         {
            /* FORWARD PROPAGATION */
            Net = UpDateInputAct( InPatterns, Pattern, Net );
            for (Layer=1; (Layer<NUMLAYERS); ++Layer)
              {
                 Net = UpDateLayerAct( Net, Layer );
              }

            /* OUTPUT PRINTS */
            if (LCV>1990)
               {
                  printf( "Input: %4.2f  ", Net.unit[0][0].state );
                  printf( "Weight:%4.2f  ", Net.unit[1][0].weights[0]);
                  printf( "Output:%4.2f  ", Net.unit[1][0].state  );
                  printf( "Thresh:%4.2f  ", Net.unit[1][0].thresh );
                  printf( "Goal: %4.2f\n",  OutPattern.p[Pattern][0] );
               }

            /* BACKWARD PROPAGATION */
            Net = UpDateWeightandThresh( Net, OutPattern, Pattern );
         }

      if (LCV>1990)
        {
           getc(stdin);           /* pause inbetween training epochs */
           printf( "\n" );        /* skip a line  */
        }

    }
}
