PROCEDURE Showvals; 
   VAR Input_char: CHAR;
       Quit: BOOLEAN;
       Stim: STIMULUS;
       Stimulus_set: CHAR;
       Stimulus_number: INTEGER;
  
   PROCEDURE Write_box;
       BEGIN
       Clear_box;
       WRITELN ('Threshold       : ', Threshold: 8);
       WRITE   ('Current Stimulus: ');
       WRITELN (Stimulus_set:2, Stimulus_number:3);
       END;

   PROCEDURE Showvals_initialize;
       BEGIN
       Quit:= FALSE;
       Save_cursor;  
       Stim := F_set [1];   
       Stimulus_number := 1;  
       Stimulus_set := 'F';
       Write_box;
       END;
 
   PROCEDURE Display_stimulus;
	VAR I, Row_nr, Elements_per_line: INTEGER;
        Stim_interpretation: String;
	BEGIN
        Interpret (Threshold, Stim.Val, Stim_Interpretation);
        Write_box;
	WRITELN ('            Name: ', Stim.Name);
        WRITELN ('  Interpretation: ', Stim_interpretation);
        Clear_block; Scroll_block;
	Elements_per_line := 8;    {Single byte. Number of elements in a line.}
	FOR I:= 1 TO Dimensionality DO 
                BEGIN
                IF (I MOD Elements_per_line = 1) THEN
                         BEGIN
                         Row_nr:= 1 + I DIV Elements_per_line;
                         WRITE ( I:4);
                         WRITE (' ',Stim_interpretation [Row_nr], '  '); 
                         END;
                WRITE (Stim.Val [I]:8);
                IF (I MOD Elements_per_line = 0) 
                   THEN BEGIN WRITE ( I:4); WRITELN  END;
                END;
	END;

     PROCEDURE Choose_stimulus;
        BEGIN
        Write_box;
        REPEAT
          WRITE   ('New Stimulus    : ');
          READLN  (Stimulus_set, Stimulus_number);
        UNTIL ((Stimulus_set IN ['f','F','g','G','t','T'])
          AND (Stimulus_number IN [1..Maximum_set_size]) );
        Write_box;
        CASE Stimulus_set OF
             'F','f': Stim:= F_set [Stimulus_number];
             'G','g': Stim:= G_set [Stimulus_number];
             'T','t': Stim:= T_set [Stimulus_number];
             END;
        END; 

     PROCEDURE Choose_action;
         BEGIN
         Bottom_line;
         IF FG_mode THEN WRITE ('FG') ELSE WRITE ('TF');
   WRITE ( ' Shows Values. C)hoose. D)ispl. L)ist. M)ode. Q)uit. T)hresh. > ');
         READLN (Input_char);
         CASE Input_char OF 
              'C','c': Choose_stimulus;
              'D','d': Display_stimulus;
              'L','l': List_test_set;
              'M','m': FG_mode:= NOT FG_mode;
              'Q','q': Quit:= TRUE;
              'T','t': BEGIN 
                       Bottom_line;
                       WRITE ('New Threshold: '); READLN (Threshold);
                       Write_box END;
              END; 
         END;

BEGIN {Procedure Showvals.}
Showvals_initialize;
REPEAT Choose_action UNTIL Quit;
Restore_cursor;
END;  {Procedure Showvals.} 
