/*
                         SEND_DATA

  Function: This subroutine has deal with "Send_Data" verb.
            In case if resource associated with verb has been right defined
            and conversation is in SEND state verb processing will be
            proceeded.

            PS gets records from RM and HS. Actions which will be selected
            depend on received record type. Selected action affects state
            of FSM_ERROR_OR_FAILURE.

 Input: pointer to the structure "send_data".

 CopyRight 1995. Nicholas Poljakov all rights reserved.

 */
#include <stdio.h>
#include <sendat.h>
#include <state1.h>
#include <rcb.h>
#include <tcb.h>
#include <lucb.h>
#include <cma.h>
#include <psp.h>
#include <partner.h>
#include <string.h>

#define  no_suspend 200
int sk_r_wt(void *);
int SendBlock(void *, void *);
int setrc(void *, void *);
int sendhsf(void *);
int sendhs(void *);
int sendbm(void *, void *);
int rtsend(void *);
unsigned long rmfmh5(void *, void *);
int recwait(void *);
int rcvru(void *, void *);
int rcvhs(void *, void *, void *, void *);
int ralloc(void *, void *);
int psrm(int, void *, void *);
int ps_conv(int, void *);
int proterr(void *, unsigned long);
int preptrcv(void *, void *);
int post_rcb(void *);
struct repass *postopen(void *);
int phsrec(void *);
int pfmh5(void *);
int opndst(void *);
int obtsess(void *, unsigned char);
int Lrf_handler(void *);
int get_sess(void *, void *);
int get_attr(void *);
int fsm_error(unsigned char, void *);
int fsm_conv(unsigned char, unsigned char, void *);
int flush (void *);
int dcp(void *);
int dealloc(void *);
int crtp(void *);
int conv(void *);
int chkparm(void *, void *);
int check_end(unsigned int, void *);
struct rqb *call_appl(void *);
int buffmng(unsigned char, void *, void *, void *, unsigned, unsigned char, unsigned);
unsigned long attltck(void *);
unsigned long attacheck(void *);
char *cgetmem(int, int);
int sendhsf(void *);
int opndst(void *);
int alloc_rcb(void *, void *);
int allocate(void *);
int clsdst(void *);

sendat(pptr)
struct send_data *pptr;
{
extern struct psp psp_ini;
struct rcb *ptr_rcb;
struct tcb *ptr_tcb;
struct lucb *ptr_lucb;
struct pnlu *part;
struct cma ar;
unsigned int type;
char *p;

int  fsm_conv();
int  fsm_error();
unsigned short *m;
char s;
char r;
int code;
int state;

#if OS_TYPE == 1
/*********  Trace facility **********/
unsigned int rtype;   /* type of record */
unsigned int pnum;    /* point number */
char pname[8];        /* name of module */
char *drec;       /* record for dump */
int  lenr;            /* record length */

rtype = INPROC;
strcpy(pname, "sendta");
pnum = 1;
drec = pptr;
lenr = sizeof(struct send_data);
gtf(rtype, pname, pnum, drec, lenr);
/***********************************/
#endif

     s = 'S';
     r = 'R';

     if (chkparm(pptr, &ar) == -1) {
        return(0);
     }
     ptr_rcb = ar.p_rcb;
     ptr_tcb = ar.p_tcb;
#if OS_TYPE == 1 /* System V */
     pptr -> data_addr = (char *)pptr + sizeof(struct send_data);
#endif

     /* Check if the RCB is in wait queue */
     if (sk_r_wt(ptr_rcb) == 0) {
        pptr -> prim_rc = INCOMPLETE;
        return (0);
     }

    /*   place verb code into the RCB */
       ptr_rcb -> verb_code = Send_data;
       ptr_rcb -> verb_ptr = pptr;

       part = ptr_rcb -> p_partner;
       if (part -> lu_type == 0) {
	     SendBlock(pptr, ptr_rcb);
             return 0;
       }

       if ((state = fsm_conv(s,Send_data,ptr_rcb)) == -1)
            {
                pptr -> prim_rc = PORT_ABENDED;
                return;
            }
       if (state == 1)
            {
                pptr -> prim_rc = PORT_DISABLED;
                return;
            }
       else
           {
               switch (ptr_rcb->error_state)   {

                 case CONV_FAILURE_PROTOCOL_ERROR:
                      {
                        pptr->prim_rc = RESOURCE_FAILURE_NO_RETRY;
                        fsm_conv(r,RESOURCE_FAILURE_RC,ptr_rcb);
                        break;
                      }
                 case CONV_FAILURE_SON:
                      {
                         pptr->prim_rc=RESOURCE_FAILURE_RETRY;
                         fsm_conv(r,RESOURCE_FAILURE_RC,ptr_rcb);
                         break;
                      }
                 case ALLOCATE_FAILURE_RETRY:
                 case ALLOCATE_FAILURE_NO_RETRY:
                 case SYNC_LEVEL_NOT_SUPPORTED:
                      {
            pptr->prim_rc = ALLOCATION_ERROR;
            if(ptr_rcb->error_state == ALLOCATION_FAILURE_RETRY)
            pptr->sec_rc = ALLOCATION_FAILURE_RETRY;
            if(ptr_rcb->error_state == ALLOCATION_FAILURE_NO_RETRY)
               {
                  pptr->sec_rc = ALLOCATION_FAILURE_NO_RETRY;
               }
            else
               {
                  pptr->sec_rc = SYNC_LEVEL_NOT_SUPPORTED_BY_LU;
               }
            fsm_conv(r,ALLOCATION_ERROR_RC,ptr_rcb);
            break;
         }
                 case RCVD_ERROR:
                      {
			 p = &((*ptr_rcb).first_out);
                         type = PREP_TO_RCV_FLUSH;
			 buffmng('A', NULL, p, ptr_rcb, 0, 0, type);
                         sendhsf(ptr_rcb);
                      /* pwait(ptr_rcb,ll,0x7FFF); */
			 if ((ptr_rcb->error_state == CONV_FAILURE_SON)||
			     (ptr_rcb->error_state == CONV_FAILURE_PROTOCOL_ERROR))
                               {
				  if (ptr_rcb->error_state==CONV_FAILURE_SON)
                 {
                    pptr->prim_rc = RESOURCE_FAILURE_RETRY;
                 }
             else
                 {
                    pptr->prim_rc = RESOURCE_FAILURE_NO_RETRY;
                 }
				  fsm_conv(r,RESOURCE_FAILURE_RC,ptr_rcb);
                               }
                         else
                               {
                                  break;
                               }
                      }
                 case NO_RQS:
                      {

       /* Call SEND_DATA_BUFFER_MANAGEMENT */

          pptr->prim_rc = OK;
          sendbm(pptr, ptr_rcb);
          if (pptr->prim_rc != OK)
                 return(0); /* SENDBM sets the return code */

          if ((ptr_rcb->error_state == ALLOCATION_FAILURE_RETRY)||
              (ptr_rcb->error_state == ALLOCATION_FAILURE_NO_RETRY)||
              (ptr_rcb->error_state == SYNC_LEVEL_NOT_SUPPORTED))
                   {
          /*  Set the return_code to "allocate_error"
           *  and subcode to ether "allocation_return_retry",
           *  allocation_failure_no_retry, or sync_level_not_supported_by_lu
           */
       pptr->prim_rc = ALLOCATION_ERROR;
       if(ptr_rcb->error_state == ALLOCATION_FAILURE_RETRY)
       pptr->sec_rc = ALLOCATION_FAILURE_RETRY;
       if(ptr_rcb->error_state == ALLOCATION_FAILURE_NO_RETRY)
           {
              pptr->sec_rc = ALLOCATION_FAILURE_NO_RETRY;
           }
       else
           {
              pptr->sec_rc = SYNC_LEVEL_NOT_SUPPORTED_BY_LU;
           }
       fsm_conv(r,ALLOCATION_ERROR_RC,ptr_rcb);
  }
       else
           {
     /* Set the return_code to "OK" */
              pptr->prim_rc = OK;
           }
           }
           }

     }
         if ( ptr_rcb->rq_to_send_rcvd == YES )
             {
                pptr->rts = YES;
                ptr_rcb->rq_to_send_rcvd = No;
             }
}
